/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLOutboundChannel;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.SSLSecurityLevel;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WorkSpaceHelper;
import com.ibm.ws.ssl.channel.impl.SSLChannelConstants;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.impl.BaseChannelTypeValidator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class SSLChannelValidator
extends BaseChannelTypeValidator
implements SSLChannelConstants {
    private static final TraceComponent tc = Tr.register((Class)SSLChannelValidator.class, (String)"SSLChannel", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    public static final String KEY_FILE_FORMAT_JCEK = "JCEKS";
    public static final String KEY_FILE_FORMAT_PKCS12 = "PKCS12";
    public static final String KEY_FILE_FORMAT_JKS = "JKS";
    public static final String SECURITY_LEVEL_LOW = "LOW";
    public static final String SECURITY_LEVEL_MEDIUM = "MEDIUM";
    public static final String SECURITY_LEVEL_HIGH = "HIGH";

    public SSLChannelValidator(MOFValidator mOFValidator) {
        super(mOFValidator);
    }

    public void validate(TransportChannelFactory transportChannelFactory) throws ValidationException {
    }

    public void validate(TransportChannel transportChannel) throws ValidationException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        EList eList = null;
        String string = null;
        boolean bl = false;
        if (transportChannel instanceof SSLInboundChannel) {
            object = (SSLInboundChannel)transportChannel;
            eList = object.getProperties();
            string = object.getSslConfigAlias();
            bl = true;
        } else {
            object = (SSLOutboundChannel)transportChannel;
            eList = object.getProperties();
            string = object.getSslConfigAlias();
            bl = false;
        }
        if (string == null) {
            object = new HashMap();
            this.addPropertiesToMap(eList, (Map)object);
            this.validateProperties((Map)object, bl, transportChannel);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
    }

    public void crossValidate(TransportChannelFactory transportChannelFactory) throws ValidationException {
    }

    public void crossValidate(TransportChannel transportChannel) throws ValidationException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"crossValidate");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Channel name: " + transportChannel.getName()));
        }
        EList eList = null;
        String string = null;
        boolean bl = false;
        if (transportChannel instanceof SSLInboundChannel) {
            object = (SSLInboundChannel)transportChannel;
            eList = object.getProperties();
            string = object.getSslConfigAlias();
            bl = true;
        } else {
            object = (SSLOutboundChannel)transportChannel;
            eList = object.getProperties();
            string = object.getSslConfigAlias();
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("configAlias: " + string));
        }
        if (string == null) {
            object = new HashMap();
            this.addPropertiesToMap(eList, (Map)object);
            this.validateProperties((Map)object, bl, transportChannel);
        } else {
            object = new WorkSpaceHelper((MOFValidator)this);
            Security security = object.getCellSecurity();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            boolean bl2 = false;
            SSLConfig sSLConfig = null;
            for (int i = 0; i < security.getRepertoire().size(); ++i) {
                sSLConfig = (SSLConfig)security.getRepertoire().get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Considering security repertoire: " + sSLConfig.getAlias()));
                }
                if (!sSLConfig.getAlias().equals(string)) continue;
                if (sSLConfig.getType().equals(SSLType.SSSL_LITERAL)) {
                    this.addError("invalid.security.properties", new String[]{"SSLConfig type:" + sSLConfig.getType()}, transportChannel);
                }
                SecureSocketLayer secureSocketLayer = ((SSLConfig)security.getRepertoire().get(i)).getSetting();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found repertoire to match alias, ssl=" + secureSocketLayer));
                }
                if (secureSocketLayer != null) {
                    CryptoHardwareToken cryptoHardwareToken;
                    if (secureSocketLayer.getKeyFileName() != null) {
                        hashMap.put("com.ibm.ssl.keyStore", secureSocketLayer.getKeyFileName());
                    }
                    if (secureSocketLayer.getTrustFileName() != null) {
                        hashMap.put("com.ibm.ssl.trustStore", secureSocketLayer.getTrustFileName());
                    }
                    if (secureSocketLayer.getTrustFilePassword() != null) {
                        hashMap.put("com.ibm.ssl.trustStorePassword", secureSocketLayer.getTrustFilePassword());
                    }
                    if (secureSocketLayer.getKeyFilePassword() != null) {
                        hashMap.put("com.ibm.ssl.keyStorePassword", secureSocketLayer.getKeyFilePassword());
                    }
                    if (secureSocketLayer.getKeyFileFormat() != null) {
                        hashMap.put("com.ibm.ssl.keyStoreType", SSLChannelValidator.getKeyStoreType(secureSocketLayer.getKeyFileFormat()));
                    }
                    if (secureSocketLayer.getTrustFileFormat() != null) {
                        hashMap.put("com.ibm.ssl.trustStoreType", SSLChannelValidator.getKeyStoreType(secureSocketLayer.getTrustFileFormat()));
                    }
                    hashMap.put("com.ibm.ssl.clientAuthentication", new Boolean(secureSocketLayer.isClientAuthentication()));
                    hashMap.put("com.ibm.ssl.securityLevel", SSLChannelValidator.getSecurityLevel(secureSocketLayer.getSecurityLevel()));
                    if (secureSocketLayer.isEnableCryptoHardwareSupport()) {
                        cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
                        hashMap.put("com.ibm.ssl.tokenType", cryptoHardwareToken.getTokenType());
                        hashMap.put("com.ibm.ssl.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
                        hashMap.put("com.ibm.ssl.tokenPassword", cryptoHardwareToken.getPassword());
                    }
                    cryptoHardwareToken = null;
                    for (int j = 0; j < secureSocketLayer.getProperties().size(); ++j) {
                        cryptoHardwareToken = (Property)secureSocketLayer.getProperties().get(j);
                        if (cryptoHardwareToken == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding property to map, " + cryptoHardwareToken.getName()));
                        }
                        hashMap.put(cryptoHardwareToken.getName(), cryptoHardwareToken.getValue());
                    }
                }
                bl2 = true;
                break;
            }
            if (bl2) {
                if (eList != null) {
                    this.addPropertiesToMap(eList, hashMap);
                }
                this.validateProperties(hashMap, bl, transportChannel);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to find repertoire: " + string));
                }
                this.addError("security.repertoire.not.found", new String[]{string}, transportChannel);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"crossValidate");
        }
    }

    protected String getLocalBundleID() {
        return "com.ibm.ws.ssl.channel.resources.sslchannelmessages";
    }

    protected String getLocalTraceName() {
        return "SSL Channel Validator";
    }

    private void addPropertiesToMap(EList eList, Map map) {
        Property property = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < eList.size(); ++i) {
            property = (Property)eList.get(i);
            string = property.getName();
            string2 = property.getValue();
            map.put(string, string2);
        }
    }

    private void validateProperties(Map map, boolean bl, TransportChannel transportChannel) {
        SSLChannelData sSLChannelData = new SSLChannelData(map, bl);
        try {
            sSLChannelData.readProperties();
        }
        catch (ChannelException channelException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error validating SSL channel config: " + channelException.getMessage()));
            }
            this.addError("invalid.security.properties", new String[]{sSLChannelData.getErrors()}, transportChannel);
        }
    }

    public static String getKeyStoreType(KeyFileFormatKind keyFileFormatKind) {
        String string = null;
        switch (keyFileFormatKind.getValue()) {
            case 2: {
                string = KEY_FILE_FORMAT_JCEK;
                break;
            }
            case 1: {
                string = KEY_FILE_FORMAT_PKCS12;
                break;
            }
            default: {
                string = KEY_FILE_FORMAT_JKS;
            }
        }
        return string;
    }

    public static String getSecurityLevel(SSLSecurityLevel sSLSecurityLevel) {
        int n = sSLSecurityLevel.getValue();
        String string = null;
        switch (n) {
            case 2: {
                string = SECURITY_LEVEL_LOW;
                break;
            }
            case 1: {
                string = SECURITY_LEVEL_MEDIUM;
                break;
            }
            default: {
                string = SECURITY_LEVEL_HIGH;
            }
        }
        return string;
    }
}

