/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.channel.impl.SSLChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class SSLChannelData {
    protected static final TraceComponent tc = Tr.register((Class)SSLChannelData.class, (String)"SSLChannel", (String)"com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    public static final String ENCRYPT_BUFFERS_DIRECT = "encryptBuffersDirect";
    public static final String DECRYPT_BUFFERS_DIRECT = "decryptBuffersDirect";
    public static final String PROTOCOL = "com.ibm.ssl.protocol";
    public static final String SSL_TYPE = "com.ibm.ssl.sslType";
    public static final String KEY_MANAGER = "com.ibm.ssl.keyManager";
    public static final String KEY_STORE_TYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEY_STORE_PROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEY_FILE_NAME = "com.ibm.ssl.keyStore";
    public static final String KEY_FILE_PASSWORD = "com.ibm.ssl.keyStorePassword";
    public static final String TRUST_MANAGER = "com.ibm.ssl.trustManager";
    public static final String TRUST_STORE_TYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUST_STORE_PROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUST_FILE_NAME = "com.ibm.ssl.trustStore";
    public static final String TRUST_FILE_PASSWORD = "com.ibm.ssl.trustStorePassword";
    public static final String ENABLED_CIPHER_SUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENT_AUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SECURITY_LEVEL = "com.ibm.ssl.securityLevel";
    public static final String TOKEN_TYPE = "com.ibm.ssl.tokenType";
    public static final String TOKEN_SLOT = "com.ibm.ssl.tokenSlot";
    public static final String TOKEN_LIBRARY_FILE = "com.ibm.ssl.tokenLibraryFile";
    public static final String TOKEN_PASSWORD = "com.ibm.ssl.tokenPassword";
    public static final String CONTEXT_PROVIDER = "com.ibm.ssl.contextProvider";
    public static final String CLIENT_KEY_ALIAS = "com.ibm.ssl.keyStoreClientAlias";
    public static final String SERVER_KEY_ALIAS = "com.ibm.ssl.keyStoreServerAlias";
    public static final String CRYPTO_ENABLED = "cryptoenabled";
    public static final String SSLSESSION_CACHE_SIZE = "SSLSessionCacheSize";
    public static final String SSLSESSION_TIMEOUT = "SSLSessionTimeout";
    public static final String STATS_ENABLED = "StatsEnabled";
    public static final String JAVAX_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String JAVAX_KEY_FILE_NAME = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEY_FILE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String JAVAX_TRUST_FILE_NAME = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUST_FILE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_TOKEN_TYPE = "javax.net.ssl.tokenType";
    public static final String JAVAX_TOKEN_LIBRARY_FILE = "javax.net.ssl.tokenLibraryFile";
    public static final String JAVAX_TOKEN_PASSWORD = "javax.net.ssl.tokenPassword";
    public static final String DEFAULT_KEY_MANAGER = SSLChannelData.getKeyManagerFactoryAlgorithm();
    public static final String DEFAULT_KEY_STORE_TYPE = KeyStore.getDefaultType();
    public static final String DEFAULT_KEY_STORE_PROVIDER = "IBMJCE";
    public static final String DEFAULT_KEY_FILE_NAME = null;
    public static final String DEFAULT_KEY_FILE_PASSWORD = null;
    public static final String DEFAULT_TRUST_MANAGER = SSLChannelData.getTrustManagerFactoryAlgorithm();
    public static final String DEFAULT_TRUST_STORE_PROVIDER = "IBMJCE";
    public static final String DEFAULT_TRUST_FILE_NAME = null;
    public static final String DEFAULT_TRUST_FILE_PASSWORD = null;
    public static final String DEFAULT_PROTOCOL = "SSL_TLS";
    public static final String DEFAULT_JSSE_PROVIDER = "IBMJSSE2";
    public static final String DEFAULT_JCE_FIPS_PROVIDER = "IBMJCEFIPS";
    public static final String DEFAULT_CLIENT_KEY_ALIAS = null;
    public static final String DEFAULT_SERVER_KEY_ALIAS = null;
    public static final String DEFAULT_TOKEN_SLOT = "0";
    public static final String DEFAULT_TOKEN_LIBRARY_FILE = null;
    public static final String DEFAULT_SECURITY_LEVEL = null;
    public static final int DEFAULT_SSLSESSION_CACHE_SIZE = 100;
    public static final int DEFAULT_SSLSESSION_TIMEOUT = 86400;
    private static final String DEFAULT_ENCRYPT_BUFFERS_DIRECT = "true";
    private static final String DEFAULT_DECRYPT_BUFFERS_DIRECT = "false";
    private static final String DEFAULT_CRYPTO_ENABLED = "false";
    public static final String[] HIGH_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA"};
    public static final String[] MEDIUM_CIPHER_SUITES = new String[]{"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    public static final String[] LOW_SERVER_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] FIPS_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] LOW_CLIENT_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    public static final String[] CONFIDENTIALITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    public static final String[] INTEGRITY_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    public static final String[] AUTHENTICITY_CIPHER_SUITES = new String[]{"SSL_NULL_WITH_NULL_NULL"};
    public static final String ALIAS_KEY = "alias";
    StringBuffer errors = null;
    private ChannelFramework framework = null;
    private String name = null;
    private String externalName = null;
    private boolean encryptBuffersDirect;
    private boolean decryptBuffersDirect;
    private boolean cryptoEnabled;
    private String keyManager = null;
    private String trustManager = null;
    private String protocol = null;
    private String keyStore = null;
    private String keyStorePassword = null;
    private String keyStoreType = null;
    private String keyStoreProvider = null;
    private String tokenType = null;
    private String tokenSlot = null;
    private String tokenLibraryFile = null;
    private String tokenPassword = null;
    private String keyStoreClientAlias = null;
    private String keyStoreServerAlias = null;
    private String contextProvider = null;
    private String trustStoreType = null;
    private String trustStore = null;
    private String trustStorePassword = null;
    private String trustStoreProvider = null;
    private String[] enabledCipherSuites = null;
    private String securityLevel = null;
    private int weight;
    private boolean isInbound;
    private boolean clientAuthentication;
    private Map properties;
    private boolean fipsRequested;
    private static String isFipsEnabled = null;
    protected static boolean fipsInitialized = false;
    private int sslSessionCacheSize = 0;
    private int sslSessionTimeout = 0;
    private boolean statsEnabled = false;
    private static String keyManagerFactoryAlgorithm = null;
    private static String trustManagerFactoryAlgorithm = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SSLChannelData: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n\tencryptBuffersDirect = ");
        stringBuffer.append(this.encryptBuffersDirect);
        stringBuffer.append("\n\tdecryptBuffersDirect = ");
        stringBuffer.append(this.decryptBuffersDirect);
        stringBuffer.append("\n\tcryptoEnabled = ");
        stringBuffer.append(this.cryptoEnabled);
        stringBuffer.append("\n\tkeyManager = ");
        stringBuffer.append(this.keyManager);
        stringBuffer.append("\n\ttrustManager = ");
        stringBuffer.append(this.trustManager);
        stringBuffer.append("\n\tkeyStore = ");
        stringBuffer.append(this.keyStore);
        stringBuffer.append("\n\tkeyStorePassword = ");
        stringBuffer.append(this.keyStorePassword);
        stringBuffer.append("\n\tkeyStoreType = ");
        stringBuffer.append(this.keyStoreType);
        stringBuffer.append("\n\tkeyStoreProvider = ");
        stringBuffer.append(this.keyStoreProvider);
        stringBuffer.append("\n\ttokenType = ");
        stringBuffer.append(this.tokenType);
        stringBuffer.append("\n\ttokenSlot = ");
        stringBuffer.append(this.tokenSlot);
        stringBuffer.append("\n\ttokenLibraryFile = ");
        stringBuffer.append(this.tokenLibraryFile);
        stringBuffer.append("\n\ttokenPassword = ");
        stringBuffer.append(this.tokenPassword);
        stringBuffer.append("\n\tkeyStoreClientAlias = ");
        stringBuffer.append(this.keyStoreClientAlias);
        stringBuffer.append("\n\tkeyStoreServerAlias = ");
        stringBuffer.append(this.keyStoreServerAlias);
        stringBuffer.append("\n\tcontextProvider = ");
        stringBuffer.append(this.contextProvider);
        stringBuffer.append("\n\ttrustStore = ");
        stringBuffer.append(this.trustStore);
        stringBuffer.append("\n\ttrustStoreType = ");
        stringBuffer.append(this.trustStoreType);
        stringBuffer.append("\n\ttrustStorePassword = ");
        stringBuffer.append(this.trustStorePassword);
        stringBuffer.append("\n\ttrustStoreProvider = ");
        stringBuffer.append(this.trustStoreProvider);
        stringBuffer.append("\n\tsecurityLevel = ");
        stringBuffer.append(this.securityLevel);
        stringBuffer.append("\n\tenabledCipherSuites = ");
        for (int i = 0; i < this.enabledCipherSuites.length; ++i) {
            stringBuffer.append("\n\t\t");
            stringBuffer.append(this.enabledCipherSuites[i]);
        }
        stringBuffer.append("\n\tweight = ");
        stringBuffer.append(this.weight);
        stringBuffer.append("\n\tisInbound = ");
        stringBuffer.append(this.isInbound);
        stringBuffer.append("\n\tclientAuthentication = ");
        stringBuffer.append(this.clientAuthentication);
        stringBuffer.append("\n\tfipsRequested = ");
        stringBuffer.append(this.fipsRequested);
        stringBuffer.append("\n\tProviders in Security:");
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            stringBuffer.append("\n\t\t");
            stringBuffer.append(providerArray[i].getName());
        }
        stringBuffer.append("\n\tsession cache size = ");
        stringBuffer.append(this.getSSLSessionCacheSize());
        stringBuffer.append("\n\tsession timeout = ");
        stringBuffer.append(this.getSSLSessionTimeout());
        stringBuffer.append("\n\tstats enabled = ");
        stringBuffer.append(this.areStatsEnabled());
        return stringBuffer.toString();
    }

    public SSLChannelData(ChannelData channelData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor: SSLChannelData");
        }
        this.framework = channelData.getChannelFramework();
        this.name = channelData.getName();
        this.externalName = channelData.getExternalName();
        this.weight = channelData.getDiscriminatorWeight();
        this.isInbound = channelData.isInbound();
        this.properties = new HashMap();
        Map map = channelData.getPropertyBag();
        Iterator iterator = map.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.properties.put(string, map.get(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor: SSLChannelData");
        }
    }

    public SSLChannelData(Map map, boolean bl) {
        this.properties = map;
        this.isInbound = bl;
    }

    public ChannelFramework getChannelFramework() {
        return this.framework;
    }

    public String getErrors() {
        return this.errors.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public boolean getEncryptBuffersDirect() {
        return this.encryptBuffersDirect;
    }

    public boolean getDecryptBuffersDirect() {
        return this.decryptBuffersDirect;
    }

    public boolean getCryptoEnabled() {
        return this.cryptoEnabled;
    }

    public void setEncryptBuffersDirect(boolean bl) {
        this.encryptBuffersDirect = bl;
    }

    public void setDecryptBuffersDirect(boolean bl) {
        this.decryptBuffersDirect = bl;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isInbound() {
        return this.isInbound;
    }

    public String getKeyManager() {
        return this.keyManager;
    }

    public String getTrustManager() {
        return this.trustManager;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public boolean getClientAuthentication() {
        return this.clientAuthentication;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getTokenSlot() {
        return this.tokenSlot;
    }

    public String getTokenLibraryFile() {
        return this.tokenLibraryFile;
    }

    public String getTokenPassword() {
        return this.tokenPassword;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String getContextProvider() {
        return this.contextProvider;
    }

    public void setContextProvider(String string) {
        this.contextProvider = string;
    }

    public String getKeyStoreClientAlias() {
        return this.keyStoreClientAlias;
    }

    public String getKeyStoreServerAlias() {
        return this.keyStoreServerAlias;
    }

    public int getSSLSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    public int getSSLSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public boolean areStatsEnabled() {
        return this.statsEnabled;
    }

    public boolean isFIPSRequested() {
        return this.fipsRequested;
    }

    public void readProperties() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readProperties");
        }
        this.errors = new StringBuffer();
        SSLChannelFactory.loadPrivateProps(this.properties, this.name);
        this.contextProvider = this.getStringProperty(CONTEXT_PROVIDER, null, true, DEFAULT_JSSE_PROVIDER, this.errors);
        if (SSLChannelData.isFipsEnabled() || this.contextProvider != null && this.contextProvider.equals("IBMJSSEFIPS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FIPS is enabled.");
            }
            SSLChannelData.initializeFips();
            this.fipsRequested = true;
        }
        this.contextProvider = DEFAULT_JSSE_PROVIDER;
        this.encryptBuffersDirect = this.getBooleanProperty(ENCRYPT_BUFFERS_DIRECT, DEFAULT_ENCRYPT_BUFFERS_DIRECT, this.errors);
        this.decryptBuffersDirect = this.getBooleanProperty(DECRYPT_BUFFERS_DIRECT, "false", this.errors);
        this.cryptoEnabled = this.getBooleanProperty(CRYPTO_ENABLED, "false", this.errors);
        this.keyManager = this.getStringProperty(KEY_MANAGER, null, true, DEFAULT_KEY_MANAGER, this.errors);
        this.keyStoreType = this.getStringProperty(KEY_STORE_TYPE, JAVAX_KEY_STORE_TYPE, true, DEFAULT_KEY_STORE_TYPE, this.errors);
        this.keyStoreProvider = this.getStringProperty(KEY_STORE_PROVIDER, null, true, "IBMJCE", this.errors);
        this.keyStore = this.getStringProperty(KEY_FILE_NAME, JAVAX_KEY_FILE_NAME, true, DEFAULT_KEY_FILE_NAME, this.errors);
        this.keyStorePassword = this.getStringProperty(KEY_FILE_PASSWORD, JAVAX_KEY_FILE_PASSWORD, true, DEFAULT_KEY_FILE_PASSWORD, this.errors);
        this.trustManager = this.getStringProperty(TRUST_MANAGER, null, true, DEFAULT_TRUST_MANAGER, this.errors);
        this.trustStoreType = this.getStringProperty(TRUST_STORE_TYPE, JAVAX_TRUST_STORE_TYPE, true, this.keyStoreType, this.errors);
        this.trustStore = this.getStringProperty(TRUST_FILE_NAME, JAVAX_TRUST_FILE_NAME, true, DEFAULT_TRUST_FILE_NAME, this.errors);
        this.trustStorePassword = this.getStringProperty(TRUST_FILE_PASSWORD, JAVAX_TRUST_FILE_PASSWORD, true, DEFAULT_TRUST_FILE_PASSWORD, this.errors);
        this.trustStoreProvider = this.getStringProperty(TRUST_STORE_PROVIDER, null, true, "IBMJCE", this.errors);
        this.protocol = this.getStringProperty(PROTOCOL, null, true, DEFAULT_PROTOCOL, this.errors);
        if (this.fipsRequested) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FIPS was requested.  Setting protocol to TLS");
            }
            this.protocol = "TLS";
        }
        this.keyStoreClientAlias = this.getStringProperty(CLIENT_KEY_ALIAS, null, true, DEFAULT_CLIENT_KEY_ALIAS, this.errors);
        this.keyStoreServerAlias = this.getStringProperty(SERVER_KEY_ALIAS, null, true, DEFAULT_SERVER_KEY_ALIAS, this.errors);
        this.tokenLibraryFile = this.getStringProperty(TOKEN_LIBRARY_FILE, null, true, DEFAULT_TOKEN_LIBRARY_FILE, this.errors);
        if (this.tokenLibraryFile == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Hardware crypto is not enabled.");
            }
            if (this.isInbound && this.clientAuthentication) {
                if (this.trustStore == null) {
                    this.errors.append(TRUST_FILE_NAME);
                    this.errors.append(":null \n");
                }
                if (this.trustStorePassword == null) {
                    this.errors.append(TRUST_FILE_PASSWORD);
                    this.errors.append(":null \n");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Hardware crypto is enabled.");
            }
            this.tokenType = this.getStringProperty(TOKEN_TYPE, JAVAX_TOKEN_TYPE, false, null, this.errors);
            this.tokenSlot = this.getStringProperty(TOKEN_SLOT, null, true, DEFAULT_TOKEN_SLOT, this.errors);
            this.tokenPassword = this.getStringProperty(TOKEN_PASSWORD, JAVAX_TOKEN_PASSWORD, false, null, this.errors);
        }
        if (this.isInbound) {
            this.clientAuthentication = this.getBooleanProperty(CLIENT_AUTH, null, this.errors);
        }
        this.enabledCipherSuites = this.getStringArrayProperty(ENABLED_CIPHER_SUITES, null);
        if (this.enabledCipherSuites == null) {
            this.securityLevel = this.getStringProperty(SECURITY_LEVEL, null, true, DEFAULT_SECURITY_LEVEL, this.errors);
            this.determineEnabledCipherSuites();
        }
        this.sslSessionCacheSize = this.getIntProperty(SSLSESSION_CACHE_SIZE, true, 100, this.errors);
        this.sslSessionTimeout = this.getIntProperty(SSLSESSION_TIMEOUT, true, 86400, this.errors);
        this.statsEnabled = this.getBooleanProperty(STATS_ENABLED, "false", this.errors);
        if (this.errors.length() != 0) {
            Tr.error((TraceComponent)tc, (String)"invalid.security.properties", (Object)this.errors.toString());
            throw new ChannelException("Invalid property values found:\n" + this.errors.toString());
        }
        this.handlePrivateProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readProperties");
        }
    }

    private void handlePrivateProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handlePrivateProperties");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object v = null;
        v = this.properties.remove(TRUST_FILE_PASSWORD);
        if (v != null) {
            hashMap.put(TRUST_FILE_PASSWORD, v);
        }
        if ((v = (Object)this.properties.remove(KEY_FILE_PASSWORD)) != null) {
            hashMap.put(KEY_FILE_PASSWORD, v);
        }
        if ((v = (Object)this.properties.remove(TOKEN_PASSWORD)) != null) {
            hashMap.put(TOKEN_PASSWORD, v);
        }
        SSLChannelFactory.savePrivateProperties(hashMap, this.name);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handlePrivateProperties");
        }
    }

    private void determineEnabledCipherSuites() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Use default set of Cipher Suites of level " + this.securityLevel));
        }
        if (this.securityLevel == null || this.fipsRequested || this.securityLevel.equalsIgnoreCase("high") || this.securityLevel.equalsIgnoreCase("confidentiality")) {
            this.enabledCipherSuites = this.fipsRequested ? FIPS_CIPHER_SUITES : HIGH_CIPHER_SUITES;
        } else if (this.securityLevel.equalsIgnoreCase("medium")) {
            this.enabledCipherSuites = MEDIUM_CIPHER_SUITES;
        } else if (this.securityLevel.equalsIgnoreCase("low")) {
            this.enabledCipherSuites = this.isInbound ? LOW_SERVER_CIPHER_SUITES : LOW_CLIENT_CIPHER_SUITES;
        } else if (this.securityLevel.equalsIgnoreCase("integrity")) {
            this.enabledCipherSuites = INTEGRITY_CIPHER_SUITES;
        } else if (this.securityLevel.equalsIgnoreCase("authenticity")) {
            this.enabledCipherSuites = AUTHENTICITY_CIPHER_SUITES;
        } else {
            Tr.warning((TraceComponent)tc, (String)"invalid.security.level", (Object)this.securityLevel);
            this.enabledCipherSuites = HIGH_CIPHER_SUITES;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"enabledCipherSuites\n ");
            for (int i = 0; i < this.enabledCipherSuites.length; ++i) {
                Tr.debug((TraceComponent)tc, (String)("\t" + this.enabledCipherSuites[i] + "\n"));
            }
        }
    }

    protected void setSupportedCipherSuitesFromSocketFactory(String[] stringArray) {
        if (this.getStringArrayProperty(ENABLED_CIPHER_SUITES, null) == null && (this.securityLevel == null || this.fipsRequested || this.securityLevel.equalsIgnoreCase("high") || this.securityLevel.equalsIgnoreCase("confidentiality"))) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(MEDIUM_CIPHER_SUITES));
            ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(LOW_SERVER_CIPHER_SUITES));
            arrayList.removeAll(arrayList2);
            arrayList.removeAll(arrayList3);
            this.enabledCipherSuites = arrayList.toArray(new String[arrayList.size()]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"enabledCipherSuites\n ");
                for (int i = 0; i < this.enabledCipherSuites.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("\t" + this.enabledCipherSuites[i] + "\n"));
                }
            }
        }
    }

    public void updateChannelData(com.ibm.websphere.channel.framework.ChannelData channelData) {
    }

    private boolean getBooleanProperty(String string, String string2, StringBuffer stringBuffer) {
        boolean bl = false;
        String string3 = null;
        boolean bl2 = false;
        Object v = this.properties.get(string);
        if (v != null) {
            if (v instanceof Boolean) {
                bl = (Boolean)v;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to " + bl));
                }
                return bl;
            }
            if (v instanceof String) {
                string3 = (String)v;
            }
        } else if (string2 != null) {
            string3 = string2;
        } else {
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string3);
            stringBuffer.append(" \n");
            return false;
        }
        if (string3 != null) {
            if (string3.equals(DEFAULT_ENCRYPT_BUFFERS_DIRECT)) {
                bl = true;
                bl2 = true;
            } else if (string3.equals("false")) {
                bl = false;
                bl2 = true;
            }
        }
        if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to " + bl));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " has invalid value " + string3));
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string3);
            stringBuffer.append(" \n");
        }
        return bl;
    }

    private String getStringProperty(String string, String string2, boolean bl, String string3, StringBuffer stringBuffer) {
        String string4 = (String)this.properties.get(string);
        if (string4 != null) {
            if (tc.isDebugEnabled()) {
                String string5 = string4;
                if (string.equals(TRUST_FILE_PASSWORD) || string.equals(KEY_FILE_PASSWORD) || string.equals(TOKEN_PASSWORD)) {
                    string5 = "*******";
                }
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to " + string5));
            }
        } else if (string2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " not found.  Checking available system property " + string2));
            }
            if ((string4 = System.getProperty(string2)) == null) {
                if (bl) {
                    string4 = string3;
                    if (tc.isDebugEnabled()) {
                        String string6 = string4;
                        if (string.equals(TRUST_FILE_PASSWORD) || string.equals(KEY_FILE_PASSWORD) || string.equals(TOKEN_PASSWORD)) {
                            string6 = "*******";
                        }
                        Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to " + string6));
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Property " + string2 + " not found.  Error being tallied."));
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(":null \n");
                    stringBuffer.append(string2);
                    stringBuffer.append(":null \n");
                }
            }
        } else if (bl) {
            string4 = string3;
            if (tc.isDebugEnabled()) {
                String string7 = string4;
                if (string.equals(TRUST_FILE_PASSWORD) || string.equals(KEY_FILE_PASSWORD) || string.equals(TOKEN_PASSWORD)) {
                    string7 = "*******";
                }
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to " + string7));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " has invalid value of null and no default system key or default specified"));
            }
            stringBuffer.append(string);
            stringBuffer.append(":null \n");
        }
        return string4;
    }

    private String[] getStringArrayProperty(String string, String[] stringArray) {
        Object v = this.properties.get(string);
        if (v != null) {
            String[] stringArray2 = null;
            if (v instanceof String[]) {
                stringArray2 = (String[])v;
            } else {
                String string2 = (String)v;
                if (-1 == string2.indexOf(" ")) {
                    stringArray2 = new String[]{(String)v};
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    stringArray2 = new String[stringTokenizer.countTokens()];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray2[i] = stringTokenizer.nextToken();
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to ...\n"));
                for (int i = 0; i < stringArray2.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("\t" + stringArray2[i]));
                }
            }
            return stringArray2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property " + string + " not found in map, defaulted to " + stringArray));
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("\t" + stringArray[i] + "\n"));
                }
            }
        }
        return stringArray;
    }

    private int getIntProperty(String string, boolean bl, int n, StringBuffer stringBuffer) {
        block7: {
            String string2 = (String)this.properties.get(string);
            if (null != string2) {
                try {
                    int n2 = Integer.parseInt(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Property " + string + " set to " + n2));
                    }
                    return n2;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("Property " + string + ", format error in [" + string2 + "]"));
                }
            }
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Property " + string + " not found.  Error being tallied."));
            }
            stringBuffer.append(string);
            stringBuffer.append(":null \n");
            return -1;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property " + string + " using default " + n));
        }
        return n;
    }

    public SSLChannelData(Map map) {
        this.properties = map;
    }

    public static String getKeyManagerFactoryAlgorithm() {
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.KeyManagerFactory.algorithm");
                }
            });
        }
        return keyManagerFactoryAlgorithm;
    }

    public static String getTrustManagerFactoryAlgorithm() {
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        return trustManagerFactoryAlgorithm;
    }

    public static boolean isFipsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isFipsEnabled");
        }
        if (isFipsEnabled == null) {
            isFipsEnabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("com.ibm.jsse2.JSSEFIPS");
                    if (string == null) {
                        string = System.getProperty("com.ibm.security.useFIPS");
                    }
                    if (string == null) {
                        string = Security.getProperty("USEFIPS_ENABLED");
                    }
                    return string;
                }
            });
        }
        if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase(DEFAULT_ENCRYPT_BUFFERS_DIRECT)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isFipsEnabled -> true");
            }
            return true;
        }
        isFipsEnabled = "false";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isFipsEnabled -> false");
        }
        return false;
    }

    public static void initializeFips() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeFips");
        }
        if (!fipsInitialized) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    block10: {
                        Provider[] providerArray = null;
                        Object object = null;
                        try {
                            int n;
                            System.setProperty("com.ibm.jsse2.JSSEFIPS", SSLChannelData.DEFAULT_ENCRYPT_BUFFERS_DIRECT);
                            providerArray = Security.getProviders();
                            for (n = 0; n < providerArray.length; ++n) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Provider[" + n + "]: " + providerArray[n].getName()));
                                }
                                if (providerArray[n].getName().equals("IBMJCE")) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug((TraceComponent)tc, (String)("IBMJCE provider at position " + n));
                                    continue;
                                }
                                if (!providerArray[n].getName().equals(SSLChannelData.DEFAULT_JCE_FIPS_PROVIDER)) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("IBMJCEFIPS provider at position " + n));
                                }
                                object = providerArray[n];
                            }
                            if (object == null) {
                                providerArray = Security.getProviders();
                                object = new IBMJCEFIPS();
                                n = Security.insertProviderAt((Provider)object, 0);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("IBMJCEFIPS provider added at " + n));
                                }
                                for (int i = 0; i < providerArray.length; ++i) {
                                    Security.removeProvider(providerArray[i].getName());
                                    Security.addProvider(providerArray[i]);
                                }
                            }
                            providerArray = Security.getProviders();
                            for (n = 0; n < providerArray.length; ++n) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Provider[" + n + "]: " + providerArray[n].getName() + ", info: " + providerArray[n].getInfo()));
                            }
                            Security.setProperty("ssl.SocketFactory.provider", "com.ibm.jsse2.SSLSocketFactoryImpl");
                            Security.setProperty("ssl.ServerSocketFactory.provider", "com.ibm.jsse2.SSLServerSocketFactoryImpl");
                            fipsInitialized = true;
                        }
                        catch (Exception exception) {
                            Tr.warning((TraceComponent)tc, (String)"security.addprovider.error", (Object)new Object[]{exception});
                            if (!tc.isDebugEnabled()) break block10;
                            Tr.debug((TraceComponent)tc, (String)"Exception caught adding IBMJCEFIPS provider.", (Object)new Object[]{exception});
                        }
                    }
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeFips");
        }
    }
}

