/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public final class ServerIdentityHelper {
    private static final TraceComponent tc = Tr.register((Class)ServerIdentityHelper.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private WSLoginLocalOSExtension _extension;
    private boolean _appSyncEnabled;
    private static final ServerIdentityHelper helper = new ServerIdentityHelper();

    public static ServerIdentityHelper getServerIdentityHelper() {
        return helper;
    }

    private ServerIdentityHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        try {
            this._extension = (WSLoginLocalOSExtension)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (ContextManagerFactory.getInstance().isServerSecurityEnabled()) {
                        return WSLoginLocalOSExtensionFactory.getInstance();
                    }
                    return null;
                }
            });
            this._appSyncEnabled = this._extension != null ? this._extension.isApplicationSyncToOSThreadEnabled() : false;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.util.ServerIdentityHelper.<init>", (String)"92", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to acquire local OS extension helper", (Object)privilegedActionException);
            }
            this._appSyncEnabled = false;
            this._extension = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public synchronized Object push() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"push");
        }
        Object object = null;
        if (this.isApplicationSyncEnabled()) {
            try {
                object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Subject subject = ServerIdentityHelper.this._extension.getLocalOSOwnSubject();
                        return ServerIdentityHelper.this._extension.setAppLocalOSThreadID(subject);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Unable to associate server subject with OS thread");
                securityException.initCause(securityException.getCause());
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.security.util.ServerIdentityHelper.push", (String)"130", (Object)this);
                throw securityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"push", (Object)object);
        }
        return object;
    }

    public synchronized void pop(final Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"pop", (Object)object);
        }
        if (object != null) {
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ServerIdentityHelper.this._extension.restoreAppLocalOSThreadID(object);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Unable to disassociate server subject from the OS thread");
                securityException.initCause(securityException.getCause());
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.security.util.ServerIdentityHelper.pop", (String)"164", (Object)this);
                throw securityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pop");
        }
    }

    private boolean isApplicationSyncEnabled() {
        boolean bl;
        boolean bl2 = bl = this._appSyncEnabled && this._extension.isThreadLocalApplicationSyncEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Application sync enabled: " + bl));
        }
        return bl;
    }
}

