/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.websphere.models.config.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class MergeSecurityConfig {
    private static TraceComponent tc = Tr.register((Class)MergeSecurityConfig.class, null, (String)"com.ibm.ejs.resources.security");
    private static String DIST = "windows";
    private static String ZOS1 = "os390";
    private static String ZOS2 = "os400";

    public static Security merge(Security security2, Security security3, String string) throws Exception {
        return MergeSecurityConfig.merge(security2, security3, string, DIST, DIST);
    }

    public static Security merge(Security security2, Security security3, String string, String string2, String string3) throws Exception {
        StringBuffer stringBuffer;
        Object object;
        Object object2;
        Object object3;
        Resource resource;
        JAASConfigurationEntry jAASConfigurationEntry;
        int n;
        ArrayList<Object> arrayList;
        JAASConfigurationEntry jAASConfigurationEntry2;
        Object object4;
        Object object5;
        Object object6;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge " + string2 + string3));
        }
        if (security2 == null) {
            throw new Exception("Null cell level security object provided");
        }
        if (security3 == null) {
            throw new Exception("Null server level security object provided");
        }
        if (string == null) {
            throw new Exception("Null nodeName provided");
        }
        string = "_" + string + "_";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Node name is " + string));
        }
        if (security3.getApplicationLoginConfig() != null && security3.getApplicationLoginConfig().getEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting JAAS configuration.");
            }
            object6 = security2.getApplicationLoginConfig().getEntries();
            object5 = null;
            if (object6 != null && object6.size() > 0) {
                object5 = new ArrayList(object6.size());
                object4 = object6.iterator();
                while (object4.hasNext()) {
                    jAASConfigurationEntry2 = (JAASConfigurationEntry)object4.next();
                    object5.add(jAASConfigurationEntry2.getAlias());
                }
            }
            object4 = security3.getApplicationLoginConfig().getEntries();
            jAASConfigurationEntry2 = object4.iterator();
            arrayList = new ArrayList(object4.size());
            while (jAASConfigurationEntry2.hasNext()) {
                JAASConfigurationEntry jAASConfigurationEntry3 = (JAASConfigurationEntry)jAASConfigurationEntry2.next();
                if (object5 == null || !object5.contains(jAASConfigurationEntry3.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding JAAS alias: " + jAASConfigurationEntry3.getAlias() + " to cell."));
                    }
                    arrayList.add(jAASConfigurationEntry3);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Not Adding JAAS alias: " + jAASConfigurationEntry3.getAlias() + " to cell."));
                }
                Tr.info((TraceComponent)tc, (String)"security.merge.notadded", (Object)new Object[]{jAASConfigurationEntry3.getAlias()});
            }
            for (n = 0; n < arrayList.size(); ++n) {
                jAASConfigurationEntry = (JAASConfigurationEntry)arrayList.get(n);
                resource = jAASConfigurationEntry.eResource();
                object3 = null;
                if (resource instanceof XMIResource) {
                    object3 = ((XMIResource)resource).getID((EObject)jAASConfigurationEntry);
                }
                StringBuffer stringBuffer2 = null;
                if (object3 != null) {
                    int n2 = ((String)object3).indexOf(95);
                    StringBuffer stringBuffer3 = new StringBuffer((String)object3);
                    if (n2 != -1) {
                        stringBuffer2 = stringBuffer3.replace(n2, n2 + 1, string);
                        ((XMIResource)resource).setID((EObject)jAASConfigurationEntry, stringBuffer2.toString());
                    } else {
                        stringBuffer2 = stringBuffer3.append(string);
                        ((XMIResource)resource).setID((EObject)jAASConfigurationEntry, stringBuffer2.toString());
                    }
                }
                object2 = jAASConfigurationEntry.getLoginModules();
                for (int i = 0; i < object2.size(); ++i) {
                    object = (JAASLoginModule)object2.get(i);
                    EList eList = object.getOptions();
                    resource = object.eResource();
                    if (resource instanceof XMIResource) {
                        object3 = ((XMIResource)resource).getID((EObject)object);
                    }
                    if (object3 != null) {
                        int n3 = ((String)object3).indexOf(95);
                        stringBuffer = new StringBuffer((String)object3);
                        stringBuffer2 = null;
                        if (n3 != -1) {
                            stringBuffer2 = stringBuffer.replace(n3, n3 + 1, string);
                            ((XMIResource)resource).setID((EObject)object, stringBuffer2.toString());
                        } else {
                            stringBuffer2 = stringBuffer.append(string);
                            ((XMIResource)resource).setID((EObject)object, stringBuffer2.toString());
                        }
                    }
                    if (eList == null) continue;
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer = (Property)iterator.next();
                        resource = stringBuffer.eResource();
                        object3 = null;
                        if (resource instanceof XMIResource) {
                            object3 = ((XMIResource)resource).getID((EObject)stringBuffer);
                        }
                        if (object3 == null) continue;
                        StringBuffer stringBuffer4 = new StringBuffer((String)object3);
                        int n4 = ((String)object3).indexOf(95);
                        if (n4 != -1) {
                            stringBuffer2 = stringBuffer4.replace(n4, n4 + 1, string);
                            ((XMIResource)resource).setID((EObject)stringBuffer, stringBuffer2.toString());
                            continue;
                        }
                        stringBuffer2 = stringBuffer4.append(string);
                        ((XMIResource)resource).setID((EObject)stringBuffer, stringBuffer2.toString());
                    }
                }
                security2.getApplicationLoginConfig().getEntries().add(arrayList.get(n));
            }
        }
        if (security3.getAuthDataEntries() != null && security3.getAuthDataEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting J2C configuration.");
            }
            object6 = security2.getAuthDataEntries();
            object5 = null;
            if (object6 != null && object6.size() > 0) {
                object5 = new ArrayList(object6.size());
                object4 = object6.iterator();
                while (object4.hasNext()) {
                    jAASConfigurationEntry2 = (JAASAuthData)object4.next();
                    object5.add(jAASConfigurationEntry2.getAlias());
                }
            }
            object4 = security3.getAuthDataEntries();
            jAASConfigurationEntry2 = new ArrayList(object4.size());
            arrayList = object4.iterator();
            while (arrayList.hasNext()) {
                JAASAuthData jAASAuthData = (JAASAuthData)arrayList.next();
                if (object5 == null || !object5.contains(jAASAuthData.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding J2C alias: " + jAASAuthData.getAlias() + " to cell."));
                    }
                    jAASConfigurationEntry2.add(jAASAuthData);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Not Adding J2C alias: " + jAASAuthData.getAlias() + " to cell."));
                }
                Tr.info((TraceComponent)tc, (String)"security.merge.notadded", (Object)new Object[]{jAASAuthData.getAlias()});
            }
            for (n = 0; n < jAASConfigurationEntry2.size(); ++n) {
                jAASConfigurationEntry = (JAASAuthData)jAASConfigurationEntry2.get(n);
                resource = jAASConfigurationEntry.eResource();
                object3 = null;
                if (resource instanceof XMIResource) {
                    object3 = ((XMIResource)resource).getID((EObject)jAASConfigurationEntry);
                }
                if (object3 != null) {
                    int n5 = ((String)object3).indexOf(95);
                    object2 = new StringBuffer((String)object3);
                    StringBuffer stringBuffer5 = null;
                    if (n5 != -1) {
                        stringBuffer5 = ((StringBuffer)object2).replace(n5, n5 + 1, string);
                        ((XMIResource)resource).setID((EObject)jAASConfigurationEntry, stringBuffer5.toString());
                    } else {
                        stringBuffer5 = ((StringBuffer)object2).append(string);
                        ((XMIResource)resource).setID((EObject)jAASConfigurationEntry, stringBuffer5.toString());
                    }
                }
                security2.getAuthDataEntries().add(jAASConfigurationEntry2.get(n));
            }
        }
        if (security3.getRepertoire() != null && security3.getRepertoire().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting SSL configuration.");
            }
            object6 = security2.getRepertoire();
            object5 = null;
            if (object6 != null && object6.size() > 0) {
                object5 = new ArrayList(object6.size());
                object4 = object6.iterator();
                while (object4.hasNext()) {
                    jAASConfigurationEntry2 = (SSLConfig)object4.next();
                    object5.add(jAASConfigurationEntry2.getAlias());
                }
            }
            object4 = security3.getRepertoire();
            jAASConfigurationEntry2 = object4.iterator();
            arrayList = new ArrayList<Object>(object4.size());
            while (jAASConfigurationEntry2.hasNext()) {
                SSLConfig sSLConfig = (SSLConfig)jAASConfigurationEntry2.next();
                if (object5 == null || !object5.contains(sSLConfig.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding SSL alias: " + sSLConfig.getAlias() + " to cell."));
                    }
                    arrayList.add(sSLConfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Not Adding SSL alias: " + sSLConfig.getAlias() + " to cell."));
                }
                Tr.info((TraceComponent)tc, (String)"security.merge.notadded", (Object)new Object[]{sSLConfig.getAlias()});
            }
            for (n = 0; n < arrayList.size(); ++n) {
                StringBuffer stringBuffer6;
                jAASConfigurationEntry = (SSLConfig)arrayList.get(n);
                resource = jAASConfigurationEntry.getSetting();
                object3 = resource.getCryptoHardware();
                EList eList = resource.getProperties();
                object2 = null;
                Resource resource2 = jAASConfigurationEntry.eResource();
                object = null;
                if (resource2 instanceof XMIResource) {
                    object = ((XMIResource)resource2).getID((EObject)jAASConfigurationEntry);
                }
                if (object != null) {
                    int n6 = ((String)object).indexOf(95);
                    stringBuffer6 = new StringBuffer((String)object);
                    if (n6 != -1) {
                        object2 = stringBuffer6.replace(n6, n6 + 1, string);
                        ((XMIResource)resource2).setID((EObject)jAASConfigurationEntry, ((StringBuffer)object2).toString());
                    } else {
                        object2 = stringBuffer6.append(string);
                        ((XMIResource)resource2).setID((EObject)jAASConfigurationEntry, ((StringBuffer)object2).toString());
                    }
                }
                if (resource != null) {
                    resource2 = resource.eResource();
                    object = null;
                    if (resource2 instanceof XMIResource) {
                        object = ((XMIResource)resource2).getID((EObject)resource);
                    }
                    if (object != null) {
                        int n7 = ((String)object).indexOf(95);
                        stringBuffer6 = new StringBuffer((String)object);
                        if (n7 != -1) {
                            object2 = stringBuffer6.replace(n7, n7 + 1, string);
                            ((XMIResource)resource2).setID((EObject)resource, ((StringBuffer)object2).toString());
                        } else {
                            object2 = stringBuffer6.append(string);
                            ((XMIResource)resource2).setID((EObject)resource, ((StringBuffer)object2).toString());
                        }
                    }
                }
                if (object3 != null) {
                    resource2 = object3.eResource();
                    object = null;
                    if (resource2 instanceof XMIResource) {
                        object = ((XMIResource)resource2).getID((EObject)object3);
                    }
                    if (object != null) {
                        int n8 = ((String)object).indexOf(95);
                        stringBuffer6 = new StringBuffer((String)object);
                        if (n8 != -1) {
                            object2 = stringBuffer6.replace(n8, n8 + 1, string);
                            ((XMIResource)resource2).setID((EObject)object3, ((StringBuffer)object2).toString());
                        } else {
                            object2 = stringBuffer6.append(string);
                            ((XMIResource)resource2).setID((EObject)object3, ((StringBuffer)object2).toString());
                        }
                    }
                }
                if (eList != null) {
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer6 = (Property)iterator.next();
                        resource2 = stringBuffer6.eResource();
                        object = null;
                        if (resource2 instanceof XMIResource) {
                            object = ((XMIResource)resource2).getID((EObject)stringBuffer6);
                        }
                        if (object == null) continue;
                        stringBuffer = new StringBuffer((String)object);
                        int n9 = ((String)object).indexOf(95);
                        if (n9 != -1) {
                            object2 = stringBuffer.replace(n9, n9 + 1, string);
                            ((XMIResource)resource2).setID((EObject)stringBuffer6, ((StringBuffer)object2).toString());
                            continue;
                        }
                        object2 = stringBuffer.append(string);
                        ((XMIResource)resource2).setID((EObject)stringBuffer6, ((StringBuffer)object2).toString());
                    }
                }
                security2.getRepertoire().add(arrayList.get(n));
            }
        }
        if (string2.equals(ZOS1) || string2.equals(ZOS2) || string3.equals(ZOS1) || string3.equals(ZOS2)) {
            if (!MergeSecurityConfig.iiopPropExists(security2)) {
                object6 = null;
                object5 = null;
                object4 = null;
                object4 = string2.equals(ZOS1) || string2.equals(ZOS2) ? security2 : security3;
                object6 = MergeSecurityConfig.getIIOPClaimSSLAlias((Security)object4);
                object5 = MergeSecurityConfig.getIIOPPerformSSLAlias((Security)object4);
                if (string2.equals(ZOS1) || string3.equals(ZOS1)) {
                    MergeSecurityConfig.createZOSProperties(security2, (String)object6, (String)object5);
                }
            }
            if (string2.equals(ZOS1)) {
                MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3);
                object6 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object6)) {
                    object5 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                    MergeSecurityConfig.setIIOPClaimSSLAlias(security2, (String)object5);
                }
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)(object5 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2)))) {
                    object4 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                    MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object4);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"merging custom properties");
        }
        object6 = security2.getProperties();
        object5 = security3.getProperties();
        for (int i = 0; i < object5.size(); ++i) {
            jAASConfigurationEntry2 = (Property)object5.get(i);
            boolean bl = false;
            for (n = 0; n < object6.size(); ++n) {
                jAASConfigurationEntry = (Property)object6.get(n);
                if (!jAASConfigurationEntry.getName().equals(jAASConfigurationEntry2.getName())) continue;
                bl = true;
            }
            if (!bl) {
                MergeSecurityConfig.modifyProp((Property)jAASConfigurationEntry2, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding " + jAASConfigurationEntry2.getName() + "=" + jAASConfigurationEntry2.getValue() + "to cell"));
                }
                object6.add(jAASConfigurationEntry2);
                continue;
            }
            Tr.info((TraceComponent)tc, (String)"security.merge.notadded", (Object)new Object[]{jAASConfigurationEntry2.getName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge");
        }
        return security2;
    }

    private static boolean isJSSETypeFromCellRepertoire(Security security2, String string) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isJSSETypeFromCellRepertoire");
        }
        if ((eList = security2.getRepertoire()) != null && eList.size() > 0) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SSLConfig sSLConfig = (SSLConfig)iterator.next();
                if (!sSLConfig.getAlias().equals(string)) continue;
                SSLType sSLType = sSLConfig.getType();
                if (sSLType.getValue() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"isJSSETypeFromCellRepertoire: true");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"isJSSETypeFromCellRepertoire: false (type is SSSL)");
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isJSSETypeFromCellRepertoire: false (entry not found)");
        }
        return false;
    }

    private static void mergeIBMProtocolToCell(Security security2, Security security3) {
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getIBM();
        if (iIOPSecurityProtocol != null) {
            return;
        }
        IIOPSecurityProtocol iIOPSecurityProtocol2 = security3.getIBM();
        if (iIOPSecurityProtocol2 != null) {
            security2.setIBM(iIOPSecurityProtocol2);
        }
    }

    private static void modifyProp(Property property, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("modifyProp " + property + " " + string));
        }
        Resource resource = property.eResource();
        String string2 = null;
        StringBuffer stringBuffer = null;
        if (resource instanceof XMIResource) {
            string2 = ((XMIResource)resource).getID((EObject)property);
        }
        if (string2 != null) {
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            int n = string2.indexOf(95);
            if (n != -1) {
                stringBuffer = stringBuffer2.replace(n, n + 1, string);
                ((XMIResource)resource).setID((EObject)property, stringBuffer.toString());
            } else {
                stringBuffer = stringBuffer2.append(string);
                ((XMIResource)resource).setID((EObject)property, stringBuffer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("modifyProp " + property));
        }
    }

    private static void createZOSProperties(Security security2, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createZOSProperties " + string + " " + string2));
        }
        PropertiesPackage propertiesPackage = PropertiesPackage.eINSTANCE;
        PropertiesFactory propertiesFactory = propertiesPackage.getPropertiesFactory();
        Property property = propertiesFactory.createProperty();
        Property property2 = propertiesFactory.createProperty();
        property.setName("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig");
        property2.setName("was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig");
        property.setValue(string);
        property2.setValue(string2);
        EList eList = security2.getProperties();
        eList.add(property);
        eList.add(property2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createZOSProperties");
        }
    }

    private static boolean iiopPropExists(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("iiopPropExists " + security2));
        }
        boolean bl = false;
        EList eList = security2.getProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (!property.getName().equals("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig")) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("iiopPropExists " + bl));
        }
        return bl;
    }

    private static String getIIOPClaimSSLAlias(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIIOPClaimSSLAlias " + security2));
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
        EList eList = commonSecureInterop.getLayers();
        Object var4_4 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var4_4 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var4_4;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        String string = iIOPTransport.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIIOPClaimSSLAlias " + string));
        }
        return string;
    }

    private static void setIIOPClaimSSLAlias(Security security2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setIIOPClaimSSLAlias with alias: " + string + ", into cell security.xml: " + security2));
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
        EList eList = commonSecureInterop.getLayers();
        Object var5_5 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var5_5 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var5_5;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        iIOPTransport.setSslConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setIIOPClaimSSLAlias");
        }
    }

    private static String getIIOPPerformSSLAlias(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIIOPPerformSSLAlias " + security2));
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms();
        EList eList = commonSecureInterop.getLayers();
        Object var4_4 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var4_4 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var4_4;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        String string = iIOPTransport.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIIOPPerformSSLAlias " + string));
        }
        return string;
    }

    private static void setIIOPPerformSSLAlias(Security security2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setIIOPPerformSSLAlias with alias: " + string + ", into cell security.xml: " + security2));
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms();
        EList eList = commonSecureInterop.getLayers();
        Object var5_5 = null;
        TransportLayer transportLayer = eList.iterator();
        while (transportLayer.hasNext() && !((var5_5 = transportLayer.next()) instanceof TransportLayer)) {
        }
        transportLayer = var5_5;
        IIOPTransport iIOPTransport = transportLayer.getServerAuthentication();
        iIOPTransport.setSslConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIIOPPerformSSLAlias");
        }
    }
}

