/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class DurationDV
extends AbstractDateTimeDV {
    private static final int[][] DATETIMES = new int[][]{{1696, 9, 1, 0, 0, 0, 0, 90}, {1697, 2, 1, 0, 0, 0, 0, 90}, {1903, 3, 1, 0, 0, 0, 0, 90}, {1903, 7, 1, 0, 0, 0, 0, 90}};

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new AbstractDateTimeDV.DateTimeData(this.parse(string), this);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "duration"});
        }
    }

    protected int[] parse(String string) throws SchemaDateTimeException {
        int n;
        char c;
        int n2 = string.length();
        int[] nArray = new int[8];
        int n3 = 0;
        if ((c = string.charAt(n3++)) != 'P' && c != '-') {
            throw new SchemaDateTimeException();
        }
        int n4 = nArray[7] = c == '-' ? 45 : 0;
        if (c == '-' && string.charAt(n3++) != 'P') {
            throw new SchemaDateTimeException();
        }
        int n5 = 1;
        if (nArray[7] == 45) {
            n5 = -1;
        }
        boolean bl = false;
        int n6 = this.indexOf(string, n3, n2, 'T');
        if (n6 == -1) {
            n6 = n2;
        }
        if ((n = this.indexOf(string, n3, n6, 'Y')) != -1) {
            nArray[0] = n5 * this.parseInt(string, n3, n);
            n3 = n + 1;
            bl = true;
        }
        if ((n = this.indexOf(string, n3, n6, 'M')) != -1) {
            nArray[1] = n5 * this.parseInt(string, n3, n);
            n3 = n + 1;
            bl = true;
        }
        if ((n = this.indexOf(string, n3, n6, 'D')) != -1) {
            nArray[2] = n5 * this.parseInt(string, n3, n);
            n3 = n + 1;
            bl = true;
        }
        if (n2 == n6 && n3 != n2) {
            throw new SchemaDateTimeException();
        }
        if (n2 != n6) {
            if ((n = this.indexOf(string, ++n3, n2, 'H')) != -1) {
                nArray[3] = n5 * this.parseInt(string, n3, n);
                n3 = n + 1;
                bl = true;
            }
            if ((n = this.indexOf(string, n3, n2, 'M')) != -1) {
                nArray[4] = n5 * this.parseInt(string, n3, n);
                n3 = n + 1;
                bl = true;
            }
            if ((n = this.indexOf(string, n3, n2, 'S')) != -1) {
                int n7 = this.indexOf(string, n3, n, '.');
                if (n7 > 0) {
                    nArray[5] = n5 * this.parseInt(string, n3, n7);
                    nArray[6] = n5 * this.parseInt(string, n7 + 1, n);
                } else {
                    nArray[5] = n5 * this.parseInt(string, n3, n);
                }
                n3 = n + 1;
                bl = true;
            }
            if (n3 != n2 || string.charAt(--n3) == 'T') {
                throw new SchemaDateTimeException();
            }
        }
        if (!bl) {
            throw new SchemaDateTimeException();
        }
        return nArray;
    }

    protected short compareDates(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3;
        short s = 2;
        short s2 = this.compareOrder(nArray, nArray2);
        if (s2 == 0) {
            return 0;
        }
        int[][] nArray4 = new int[2][8];
        int[] nArray5 = this.addDuration(nArray, DATETIMES[0], nArray4[0]);
        s2 = this.compareOrder(nArray5, nArray3 = this.addDuration(nArray2, DATETIMES[0], nArray4[1]));
        if (s2 == 2) {
            return 2;
        }
        nArray5 = this.addDuration(nArray, DATETIMES[1], nArray4[0]);
        s = this.compareOrder(nArray5, nArray3 = this.addDuration(nArray2, DATETIMES[1], nArray4[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray5 = this.addDuration(nArray, DATETIMES[2], nArray4[0]);
        s = this.compareOrder(nArray5, nArray3 = this.addDuration(nArray2, DATETIMES[2], nArray4[1]));
        if ((s2 = this.compareResults(s2, s, bl)) == 2) {
            return 2;
        }
        nArray5 = this.addDuration(nArray, DATETIMES[3], nArray4[0]);
        nArray3 = this.addDuration(nArray2, DATETIMES[3], nArray4[1]);
        s = this.compareOrder(nArray5, nArray3);
        s2 = this.compareResults(s2, s, bl);
        return s2;
    }

    private short compareResults(short s, short s2, boolean bl) {
        if (s2 == 2) {
            return 2;
        }
        if (s != s2 && bl) {
            return 2;
        }
        if (s != s2 && !bl) {
            if (s != 0 && s2 != 0) {
                return 2;
            }
            return s != 0 ? s : s2;
        }
        return s;
    }

    private int[] addDuration(int[] nArray, int[] nArray2, int[] nArray3) {
        this.resetDateObj(nArray3);
        int n = nArray2[1] + nArray[1];
        nArray3[1] = this.modulo(n, 1, 13);
        int n2 = this.fQuotient(n, 1, 13);
        nArray3[0] = nArray2[0] + nArray[0] + n2;
        n = nArray2[5] + nArray[5];
        n2 = this.fQuotient(n, 60);
        nArray3[5] = this.mod(n, 60, n2);
        n = nArray2[4] + nArray[4] + n2;
        n2 = this.fQuotient(n, 60);
        nArray3[4] = this.mod(n, 60, n2);
        n = nArray2[3] + nArray[3] + n2;
        n2 = this.fQuotient(n, 24);
        nArray3[3] = this.mod(n, 24, n2);
        nArray3[2] = nArray2[2] + nArray[2] + n2;
        while (true) {
            n = this.maxDayInMonthFor(nArray3[0], nArray3[1]);
            if (nArray3[2] < 1) {
                nArray3[2] = nArray3[2] + this.maxDayInMonthFor(nArray3[0], nArray3[1] - 1);
                n2 = -1;
            } else {
                if (nArray3[2] <= n) break;
                nArray3[2] = nArray3[2] - n;
                n2 = 1;
            }
            n = nArray3[1] + n2;
            nArray3[1] = this.modulo(n, 1, 13);
            nArray3[0] = nArray3[0] + this.fQuotient(n, 1, 13);
        }
        nArray3[7] = 90;
        return nArray3;
    }

    protected String dateToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0 || nArray[3] < 0 || nArray[4] < 0 || nArray[5] < 0 || nArray[6] < 0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        stringBuffer.append((nArray[0] < 0 ? -1 : 1) * nArray[0]);
        stringBuffer.append('Y');
        stringBuffer.append((nArray[1] < 0 ? -1 : 1) * nArray[1]);
        stringBuffer.append('M');
        stringBuffer.append((nArray[2] < 0 ? -1 : 1) * nArray[2]);
        stringBuffer.append('D');
        stringBuffer.append('T');
        stringBuffer.append((nArray[3] < 0 ? -1 : 1) * nArray[3]);
        stringBuffer.append('H');
        stringBuffer.append((nArray[4] < 0 ? -1 : 1) * nArray[4]);
        stringBuffer.append('M');
        stringBuffer.append((nArray[5] < 0 ? -1 : 1) * nArray[5]);
        stringBuffer.append('.');
        stringBuffer.append((nArray[6] < 0 ? -1 : 1) * nArray[6]);
        stringBuffer.append('S');
        return stringBuffer.toString();
    }
}

