/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan;

import com.ibm.xml.b2b.scan.DocumentEntityState;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;

public abstract class DocumentScannerSupport
extends DocumentEntityState {
    public static final short CHARACTERS = 0;
    public static final short CHARACTER_REF = 1;
    public static final short PRE_ENTITY_REF = 2;
    public static final short ENTITY_REF = 3;
    public static final short CDATA = 4;
    public int attrCount;
    public QName[] attrNames;
    public String[] attTypes;
    public XMLString[] attValues;
    public boolean[] attValueNormalized;
    public String nsDeclPrefix;
    public int firstMapping;
    public int lastMapping;
    public String[] prefixes;
    public String[] namespaceURIs;
    public int[] nsHandles;
    public String[] nsDeclQNames;
    public int singleCh;
    public short chOrigin;
    public SymbolTable fSymbolTable;
    private XMLStringBuffer fStringBuffer;
    private QName[] fElementTypeStack;
    protected String fNamespaceDeclPrefix;
    private int fSpecifiedAttrCount;
    private boolean fSaveAttValue;
    private int fAttValueOffset;
    private int fFreeQNameCount;
    private QName[] fFreeQNames;
    protected String fDefaultPrefix;
    protected int fCurrentScope;
    private int[] fMappingScopes;

    public DocumentScannerSupport(SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer) {
        this.fSymbolTable = symbolTable;
        this.fStringBuffer = xMLStringBuffer;
        this.attrNames = new QName[32];
        this.attTypes = new String[32];
        this.attValues = new XMLString[32];
        this.attValueNormalized = new boolean[32];
        this.fElementTypeStack = new QName[32];
        this.fFreeQNames = new QName[32];
        this.fSpecifiedAttrCount = -1;
        this.initNamespaces();
        this.resetNamespaces();
    }

    public void reset(boolean bl) {
        super.reset(bl);
        if (!bl) {
            int n = 0;
            while (n < this.fElementTypeStack.length) {
                if (this.fElementTypeStack[n] == null) break;
                this.fElementTypeStack[n] = null;
                ++n;
            }
            n = 0;
            while (n < this.attrNames.length) {
                if (this.attrNames[n] == null) break;
                this.attrNames[n] = null;
                this.attValues[n] = null;
                ++n;
            }
        }
        this.resetNamespaces();
    }

    public void createQNameSymbols(QName qName) {
        if (qName.handle == -1) {
            if (qName.sepOffset == -1) {
                this.fSymbolTable.addSymbol(qName);
                qName.prefix = XMLString.EMPTY_STRING;
                qName.prefixHandle = 0;
                qName.localPart = qName.str;
                qName.localHandle = qName.handle;
            } else {
                this.fSymbolTable.addQNameSymbols(qName);
            }
        }
    }

    public void processElementType() {
        if (this.fSpecifiedAttrCount >= 0) {
            int n = this.fSpecifiedAttrCount;
            while (n < this.attrCount) {
                this.attrNames[n] = null;
                ++n;
            }
            this.fSpecifiedAttrCount = -1;
        }
        this.startNamespacesScope();
        this.attrCount = 0;
        this.fSaveAttValue = false;
        this.currentElement = this.elementType;
    }

    public void processAttributeName(QName qName, boolean bl) {
        if (this.fSaveAttValue) {
            this.saveSpecifiedAttValue();
        }
        String string = qName.prefix;
        String string2 = qName.localPart;
        this.fNamespaceDeclPrefix = string != this.nsDeclPrefix ? (string != XMLString.EMPTY_STRING || string2 != this.nsDeclPrefix ? null : XMLString.EMPTY_STRING) : string2;
        this.currentAttribute = qName;
        if (this.attrCount == this.attrNames.length) {
            this.growAttributes();
        }
        if (bl) {
            this.attributeName = this.attrNames[this.attrCount];
            if (this.attributeName == null) {
                this.attributeName = this.getFreeQName();
            }
            this.attrNames[this.attrCount] = this.currentAttribute;
        } else {
            qName = this.attrNames[this.attrCount];
            this.attrNames[this.attrCount] = this.currentAttribute;
            if (this.fSpecifiedAttrCount == -1) {
                this.fSpecifiedAttrCount = this.attrCount;
            }
            if (qName != null) {
                this.saveFreeQName(qName);
            }
        }
        this.attTypes[this.attrCount] = XMLString.EMPTY_STRING;
        if (this.attValues[this.attrCount] == null) {
            this.attValues[this.attrCount] = new XMLString();
        } else {
            this.attValues[this.attrCount].clear();
            this.attValues[this.attrCount].offset = 0;
        }
        this.attValueNormalized[this.attrCount] = bl;
        this.fAttValueOffset = -1;
        this.fSaveAttValue = true;
        ++this.attrCount;
    }

    public void endOfSpecifiedAttributes() {
        if (this.fSaveAttValue) {
            this.saveSpecifiedAttValue();
            this.fSaveAttValue = false;
        }
    }

    public void storeAttValue() {
        if (this.fSaveAttValue) {
            this.saveSpecifiedAttValue();
            this.fSaveAttValue = false;
        }
    }

    private void saveSpecifiedAttValue() {
        int n = this.attrCount - 1;
        XMLString xMLString = this.attValues[n];
        if (this.fAttValueOffset != -1) {
            this.fStringBuffer.setStringValues(this.fAttValueOffset, this.fStringBuffer.getOffset(), xMLString);
        } else if (xMLString.offset == 0) {
            this.fStringBuffer.setStringValues(0, 0, xMLString);
        }
        if (this.fNamespaceDeclPrefix != null) {
            this.fSymbolTable.addSymbol(xMLString);
            this.createPrefixMapping(this.fNamespaceDeclPrefix, xMLString.handle, this.attrNames[n].str);
            --this.attrCount;
        }
    }

    public void resolveNamespaceURIs() {
        int n = 0;
        while (n < this.attrCount) {
            QName qName = this.attrNames[n];
            String string = qName.prefix;
            if (string != XMLString.EMPTY_STRING && string != this.nsDeclPrefix) {
                this.setNamespaceURI(qName);
            }
            ++n;
        }
        this.setNamespaceURI(this.currentElement);
    }

    public void attributeValueCharacters(XMLString xMLString, boolean bl) {
        if (xMLString.offset == xMLString.endOffset) {
            return;
        }
        if (this.fAttValueOffset == -1) {
            if (this.attValues[this.attrCount - 1].offset == 0) {
                if (bl) {
                    this.attValues[this.attrCount - 1].setValues(xMLString);
                    return;
                }
                this.fAttValueOffset = this.fStringBuffer.getOffset();
            } else {
                this.fAttValueOffset = this.fStringBuffer.getOffset();
                this.fStringBuffer.append(this.attValues[this.attrCount - 1]);
            }
        }
        this.fStringBuffer.normalizedAppend(xMLString);
    }

    public void attributeValueCharacter(int n, boolean bl) {
        if (this.fAttValueOffset == -1) {
            this.fAttValueOffset = this.fStringBuffer.getOffset();
            if (this.attValues[this.attrCount - 1].offset > 0) {
                this.fStringBuffer.append(this.attValues[this.attrCount - 1]);
            }
        }
        this.fStringBuffer.append(n);
    }

    public void normalizeAttributeValue(int n) {
        this.fStringBuffer.normalizeTextValue(this.attValues[n], null);
        this.attValueNormalized[n] = true;
    }

    public void addDefaultAttribute(QName qName, String string, XMLString xMLString) {
        this.processAttributeName(qName, false);
        if (this.fNamespaceDeclPrefix == null) {
            this.attTypes[this.attrCount - 1] = string;
            this.attValues[this.attrCount - 1].setValues(xMLString);
        } else {
            this.fSymbolTable.addSymbol(xMLString);
            this.createPrefixMapping(this.fNamespaceDeclPrefix, xMLString.handle, qName.str);
            --this.attrCount;
        }
    }

    public void undeclaredEntityInContent(XMLName xMLName) {
        this.entityNotDeclared(xMLName);
    }

    public void undeclaredEntityInAttValue(XMLName xMLName) {
        this.entityNotDeclared(xMLName);
    }

    protected void entityNotDeclared(XMLName xMLName) {
    }

    public void pushElement() {
        if (this.elementDepth == this.fElementTypeStack.length) {
            this.growElements();
        }
        this.elementType = this.fElementTypeStack[this.elementDepth];
        if (this.elementType == null) {
            this.elementType = new QName();
        }
        this.fElementTypeStack[this.elementDepth++] = this.currentElement;
    }

    public QName popElement() {
        this.currentElement = this.fElementTypeStack[--this.elementDepth];
        return this.currentElement;
    }

    private QName getFreeQName() {
        QName qName;
        if (this.fFreeQNameCount > 0) {
            qName = this.fFreeQNames[--this.fFreeQNameCount];
            this.fFreeQNames[this.fFreeQNameCount] = null;
        } else {
            qName = new QName();
        }
        return qName;
    }

    private void saveFreeQName(QName qName) {
        if (this.fFreeQNameCount == this.fFreeQNames.length) {
            QName[] qNameArray = new QName[this.fFreeQNameCount << 1];
            System.arraycopy(this.fFreeQNames, 0, qNameArray, 0, this.fFreeQNameCount);
            this.fFreeQNames = qNameArray;
        }
        this.fFreeQNames[this.fFreeQNameCount++] = qName;
    }

    private void growElements() {
        QName[] qNameArray = new QName[this.elementDepth << 1];
        System.arraycopy(this.fElementTypeStack, 0, qNameArray, 0, this.elementDepth);
        this.fElementTypeStack = qNameArray;
    }

    private void growAttributes() {
        QName[] qNameArray = new QName[this.attrCount << 1];
        System.arraycopy(this.attrNames, 0, qNameArray, 0, this.attrCount);
        this.attrNames = qNameArray;
        String[] stringArray = new String[this.attrCount << 1];
        System.arraycopy(this.attTypes, 0, stringArray, 0, this.attrCount);
        this.attTypes = stringArray;
        XMLString[] xMLStringArray = new XMLString[this.attrCount << 1];
        System.arraycopy(this.attValues, 0, xMLStringArray, 0, this.attrCount);
        this.attValues = xMLStringArray;
        boolean[] blArray = new boolean[this.attrCount << 1];
        System.arraycopy(this.attValueNormalized, 0, blArray, 0, this.attrCount);
        this.attValueNormalized = blArray;
    }

    private void initNamespaces() {
        this.prefixes = new String[8];
        this.namespaceURIs = new String[8];
        this.nsHandles = new int[8];
        this.nsDeclQNames = new String[8];
        this.fMappingScopes = new int[8];
    }

    private String internString(String string) {
        int n = this.fSymbolTable.addSymbol(string);
        return this.fSymbolTable.toString(n);
    }

    private void resetNamespaces() {
        this.nsDeclPrefix = this.internString("xmlns");
        this.prefixes[0] = this.fDefaultPrefix = this.internString("xml");
        this.nsHandles[0] = this.fSymbolTable.addSymbol("http://www.w3.org/XML/1998/namespace");
        this.namespaceURIs[0] = this.fSymbolTable.toString(this.nsHandles[0]);
        this.firstMapping = 1;
        this.lastMapping = 1;
        this.fCurrentScope = 1;
        this.fMappingScopes[0] = 0;
        this.fMappingScopes[1] = 1;
    }

    protected void createPrefixMapping(String string, int n, String string2) {
        if (this.lastMapping == this.prefixes.length) {
            String[] stringArray = new String[this.lastMapping << 1];
            System.arraycopy(this.prefixes, 0, stringArray, 0, this.lastMapping);
            this.prefixes = stringArray;
            stringArray = new String[this.lastMapping << 1];
            System.arraycopy(this.namespaceURIs, 0, stringArray, 0, this.lastMapping);
            this.namespaceURIs = stringArray;
            int[] nArray = new int[this.lastMapping << 1];
            System.arraycopy(this.nsHandles, 0, nArray, 0, this.lastMapping);
            this.nsHandles = nArray;
            stringArray = new String[this.lastMapping << 1];
            System.arraycopy(this.nsDeclQNames, 0, stringArray, 0, this.lastMapping);
            this.nsDeclQNames = stringArray;
        }
        this.prefixes[this.lastMapping] = string;
        this.nsHandles[this.lastMapping] = n;
        this.namespaceURIs[this.lastMapping] = this.fSymbolTable.toString(n);
        this.nsDeclQNames[this.lastMapping] = string2;
        this.fMappingScopes[this.fCurrentScope] = ++this.lastMapping;
    }

    protected boolean setNamespaceURI(QName qName) {
        String string = qName.prefix;
        int n = this.lastMapping - 1;
        while (n >= 0) {
            if (this.prefixes[n] == string) {
                qName.nsHandle = this.nsHandles[n];
                qName.namespaceURI = this.namespaceURIs[n];
                return true;
            }
            --n;
        }
        qName.nsHandle = 0;
        qName.namespaceURI = XMLString.EMPTY_STRING;
        return string == XMLString.EMPTY_STRING;
    }

    private void startNamespacesScope() {
        ++this.fCurrentScope;
        this.firstMapping = this.lastMapping;
        if (this.fCurrentScope == this.fMappingScopes.length) {
            int[] nArray = new int[this.fCurrentScope << 1];
            System.arraycopy(this.fMappingScopes, 0, nArray, 0, this.fCurrentScope);
            this.fMappingScopes = nArray;
        }
        this.fMappingScopes[this.fCurrentScope] = this.lastMapping;
    }

    public void endNamespacesScope() {
        --this.fCurrentScope;
        this.lastMapping = this.fMappingScopes[this.fCurrentScope];
        this.firstMapping = this.fMappingScopes[this.fCurrentScope - 1];
    }
}

