/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LongRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.LongRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.TYPE";
    private long maximum = 0L;
    private boolean maximumSet = false;
    private long minimum = 0L;
    private boolean minimumSet = false;
    private boolean transientValue = false;

    public LongRangeValidator() {
    }

    public LongRangeValidator(long maximum) {
        this.setMaximum(maximum);
    }

    public LongRangeValidator(long maximum, long minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public long getMaximum() {
        return this.maximum;
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
        this.maximumSet = true;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
        this.minimumSet = true;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            try {
                long converted = this.longValue(value);
                if (this.maximumSet && converted > this.maximum) {
                    if (this.minimumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(context, "javax.faces.validator.NOT_IN_RANGE", new Object[]{new Long(this.minimum), new Long(this.maximum)}));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, new Object[]{new Long(this.maximum)}));
                }
                if (this.minimumSet && converted < this.minimum) {
                    if (this.maximumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(context, "javax.faces.validator.NOT_IN_RANGE", new Object[]{new Double(this.minimum), new Double(this.maximum)}));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, new Object[]{new Long(this.minimum)}));
                }
            }
            catch (NumberFormatException e) {
                throw new ValidatorException(MessageFactory.getMessage(context, TYPE_MESSAGE_ID));
            }
        }
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof LongRangeValidator)) {
            return false;
        }
        LongRangeValidator other = (LongRangeValidator)otherObj;
        return this.maximum == other.maximum && this.minimum == other.minimum && this.maximumSet == other.maximumSet && this.minimumSet == other.minimumSet;
    }

    private long longValue(Object attributeValue) throws NumberFormatException {
        if (attributeValue instanceof Number) {
            return ((Number)attributeValue).longValue();
        }
        return Long.parseLong(attributeValue.toString());
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{new Long(this.maximum), this.maximumSet ? Boolean.TRUE : Boolean.FALSE, new Long(this.minimum), this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Long)values[0];
        this.maximumSet = (Boolean)values[1];
        this.minimum = (Long)values[2];
        this.minimumSet = (Boolean)values[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

