/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class NumberConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Number";
    private String currencyCode = null;
    private String currencySymbol = null;
    private boolean groupingUsed = true;
    private boolean integerOnly = false;
    private int maxFractionDigits = 0;
    private boolean maxFractionDigitsSpecified = false;
    private int maxIntegerDigits = 0;
    private boolean maxIntegerDigitsSpecified = false;
    private int minFractionDigits = 0;
    private boolean minFractionDigitsSpecified = false;
    private int minIntegerDigits = 0;
    private boolean minIntegerDigitsSpecified = false;
    private Locale locale = null;
    private String pattern = null;
    private String type = "number";
    private static Class currencyClass;
    private static final Class[] GET_INSTANCE_PARAM_TYPES;
    private boolean transientFlag = false;
    static /* synthetic */ Class class$java$lang$String;

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this.groupingUsed = groupingUsed;
    }

    public boolean isIntegerOnly() {
        return this.integerOnly;
    }

    public void setIntegerOnly(boolean integerOnly) {
        this.integerOnly = integerOnly;
    }

    public int getMaxFractionDigits() {
        return this.maxFractionDigits;
    }

    public void setMaxFractionDigits(int maxFractionDigits) {
        this.maxFractionDigits = maxFractionDigits;
        this.maxFractionDigitsSpecified = true;
    }

    public int getMaxIntegerDigits() {
        return this.maxIntegerDigits;
    }

    public void setMaxIntegerDigits(int maxIntegerDigits) {
        this.maxIntegerDigits = maxIntegerDigits;
        this.maxIntegerDigitsSpecified = true;
    }

    public int getMinFractionDigits() {
        return this.minFractionDigits;
    }

    public void setMinFractionDigits(int minFractionDigits) {
        this.minFractionDigits = minFractionDigits;
        this.minFractionDigitsSpecified = true;
    }

    public int getMinIntegerDigits() {
        return this.minIntegerDigits;
    }

    public void setMinIntegerDigits(int minIntegerDigits) {
        this.minIntegerDigits = minIntegerDigits;
        this.minIntegerDigitsSpecified = true;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        try {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(context);
            NumberFormat parser = this.getNumberFormat(locale);
            parser.setParseIntegerOnly(this.isIntegerOnly());
            if (this.pattern != null && !this.pattern.equals("") || "currency".equals(this.type)) {
                this.configureCurrency(parser);
            }
            return parser.parse(value);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new ConverterException("Error parsing '" + value + "'");
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        try {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Locale locale = this.getLocale(context);
            NumberFormat formatter = this.getNumberFormat(locale);
            if (this.pattern != null && !this.pattern.equals("") || "currency".equals(this.type)) {
                this.configureCurrency(formatter);
            }
            this.configureFormatter(formatter);
            return formatter.format(value);
        }
        catch (ConverterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }

    private void configureCurrency(NumberFormat formatter) throws Exception {
        String code = null;
        String symbol = null;
        if (this.currencyCode == null && this.currencySymbol == null) {
            return;
        }
        if (this.currencyCode != null && this.currencySymbol != null) {
            if (currencyClass != null) {
                code = this.currencyCode;
            } else {
                symbol = this.currencySymbol;
            }
        } else if (this.currencyCode == null) {
            symbol = this.currencySymbol;
        } else if (currencyClass != null) {
            code = this.currencyCode;
        } else {
            symbol = this.currencyCode;
        }
        if (code != null) {
            Object[] methodArgs = new Object[1];
            Method m = currencyClass.getMethod("getInstance", GET_INSTANCE_PARAM_TYPES);
            methodArgs[0] = code;
            Object currency = m.invoke(null, methodArgs);
            Class[] paramTypes = new Class[]{currencyClass};
            Class<?> numberFormatClass = Class.forName("java.text.NumberFormat");
            m = numberFormatClass.getMethod("setCurrency", paramTypes);
            methodArgs[0] = currency;
            m.invoke((Object)formatter, methodArgs);
        } else {
            DecimalFormat df = (DecimalFormat)formatter;
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setCurrencySymbol(symbol);
            df.setDecimalFormatSymbols(dfs);
        }
    }

    private void configureFormatter(NumberFormat formatter) {
        formatter.setGroupingUsed(this.groupingUsed);
        if (this.maxIntegerDigitsSpecified) {
            formatter.setMaximumIntegerDigits(this.maxIntegerDigits);
        }
        if (this.minIntegerDigitsSpecified) {
            formatter.setMinimumIntegerDigits(this.minIntegerDigits);
        }
        if (this.maxFractionDigitsSpecified) {
            formatter.setMaximumFractionDigits(this.maxFractionDigits);
        }
        if (this.minFractionDigitsSpecified) {
            formatter.setMinimumFractionDigits(this.minFractionDigits);
        }
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private NumberFormat getNumberFormat(Locale locale) {
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (this.pattern != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(this.pattern, symbols);
        }
        if (this.type.equals("currency")) {
            return NumberFormat.getCurrencyInstance(locale);
        }
        if (this.type.equals("number")) {
            return NumberFormat.getNumberInstance(locale);
        }
        if (this.type.equals("percent")) {
            return NumberFormat.getPercentInstance(locale);
        }
        throw new ConverterException(new IllegalArgumentException(this.type));
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.currencyCode, this.currencySymbol, this.isGroupingUsed() ? Boolean.TRUE : Boolean.FALSE, this.isIntegerOnly() ? Boolean.TRUE : Boolean.FALSE, new Integer(this.maxFractionDigits), this.maxFractionDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, new Integer(this.maxIntegerDigits), this.maxIntegerDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, new Integer(this.minFractionDigits), this.minFractionDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, new Integer(this.minIntegerDigits), this.minIntegerDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, this.locale, this.pattern, this.type};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.currencyCode = (String)values[0];
        this.currencySymbol = (String)values[1];
        this.groupingUsed = (Boolean)values[2];
        this.integerOnly = (Boolean)values[3];
        this.maxFractionDigits = (Integer)values[4];
        this.maxFractionDigitsSpecified = (Boolean)values[5];
        this.maxIntegerDigits = (Integer)values[6];
        this.maxIntegerDigitsSpecified = (Boolean)values[7];
        this.minFractionDigits = (Integer)values[8];
        this.minFractionDigitsSpecified = (Boolean)values[9];
        this.minIntegerDigits = (Integer)values[10];
        this.minIntegerDigitsSpecified = (Boolean)values[11];
        this.locale = (Locale)values[12];
        this.pattern = (String)values[13];
        this.type = (String)values[14];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            currencyClass = Class.forName("java.util.Currency");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_INSTANCE_PARAM_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NumberConverter.class$("java.lang.String")) : class$java$lang$String};
    }
}

