/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.MessageFactory;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    private Object submittedValue = null;
    private boolean localValueSet;
    private boolean required = false;
    private boolean requiredSet = false;
    private boolean valid = true;
    private boolean immediate = false;
    private boolean immediateSet = false;
    private MethodBinding validatorBinding = null;
    private MethodBinding valueChangeMethod = null;
    List validators = null;
    static /* synthetic */ Class class$javax$faces$event$ValueChangeListener;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public UIInput() {
        this.setRendererType("javax.faces.Text");
    }

    public String getFamily() {
        return "javax.faces.Input";
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.localValueSet = localValueSet;
    }

    public boolean isRequired() {
        if (this.requiredSet) {
            return this.required;
        }
        ValueBinding vb = this.getValueBinding("required");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.required;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setRequired(boolean required) {
        this.required = required;
        this.requiredSet = true;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        if (immediate != this.immediate) {
            this.immediate = immediate;
        }
        this.immediateSet = true;
    }

    public MethodBinding getValidator() {
        return this.validatorBinding;
    }

    public void setValidator(MethodBinding validatorBinding) {
        this.validatorBinding = validatorBinding;
    }

    public MethodBinding getValueChangeListener() {
        return this.valueChangeMethod;
    }

    public void setValueChangeListener(MethodBinding valueChangeMethod) {
        this.valueChangeMethod = valueChangeMethod;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding method;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (method = this.getValueChangeListener()) != null) {
            FacesContext context = this.getFacesContext();
            method.invoke(context, new Object[]{event});
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            try {
                vb.setValue(context, this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
                return;
            }
            catch (FacesException e) {
                FacesMessage message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
            catch (Exception e) {
                FacesMessage message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID);
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), message);
                this.setValid(false);
            }
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        Object newValue = null;
        try {
            Converter converter;
            newValue = renderer != null ? renderer.getConvertedValue(context, this, submittedValue) : (submittedValue instanceof String ? ((converter = this.getConverterWithType(context)) != null ? converter.getAsObject(context, this, (String)submittedValue) : submittedValue) : submittedValue);
        }
        catch (ConverterException ce) {
            this.addConversionErrorMessage(context, ce, submittedValue);
            this.setValid(false);
        }
        if (this.isValid() && this.isRequired() && this.isEmpty(newValue)) {
            FacesMessage message = MessageFactory.getMessage(context, REQUIRED_MESSAGE_ID);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && !this.isEmpty(newValue)) {
            if (this.validators != null) {
                Iterator validators = this.validators.iterator();
                while (validators.hasNext()) {
                    Validator validator = (Validator)validators.next();
                    try {
                        validator.validate(context, this, newValue);
                    }
                    catch (ValidatorException ve) {
                        this.setValid(false);
                        FacesMessage message = ve.getFacesMessage();
                        if (message == null) continue;
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                        context.addMessage(this.getClientId(context), message);
                    }
                }
            }
            if (this.validatorBinding != null) {
                try {
                    this.validatorBinding.invoke(context, new Object[]{context, this, newValue});
                }
                catch (EvaluationException ee) {
                    if (ee.getCause() instanceof ValidatorException) {
                        ValidatorException ve = (ValidatorException)ee.getCause();
                        this.setValid(false);
                        FacesMessage message = ve.getFacesMessage();
                        if (message != null) {
                            message.setSeverity(FacesMessage.SEVERITY_ERROR);
                            context.addMessage(this.getClientId(context), message);
                        }
                    }
                    throw ee;
                }
            }
        }
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent(new ValueChangeEvent(this, previous, newValue));
            }
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null) {
            return value != null;
        }
        if (value == null) {
            return true;
        }
        return !previous.equals(value);
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && ((String)value).length() < 1) {
            return true;
        }
        return value.getClass().isArray() ? 0 == Array.getLength(value) : value instanceof List && 0 == ((List)value).size();
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public Validator[] getValidators() {
        if (this.validators == null) {
            return new Validator[0];
        }
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener(listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        ValueChangeListener[] vcl = (ValueChangeListener[])this.getFacesListeners(class$javax$faces$event$ValueChangeListener == null ? (class$javax$faces$event$ValueChangeListener = UIInput.class$("javax.faces.event.ValueChangeListener")) : class$javax$faces$event$ValueChangeListener);
        return vcl;
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.localValueSet ? Boolean.TRUE : Boolean.FALSE, this.required ? Boolean.TRUE : Boolean.FALSE, this.requiredSet ? Boolean.TRUE : Boolean.FALSE, this.valid ? Boolean.TRUE : Boolean.FALSE, this.immediate ? Boolean.TRUE : Boolean.FALSE, this.immediateSet ? Boolean.TRUE : Boolean.FALSE, UIInput.saveAttachedState(context, this.validators), UIInput.saveAttachedState(context, this.validatorBinding), UIInput.saveAttachedState(context, this.valueChangeMethod)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.localValueSet = (Boolean)values[1];
        this.required = (Boolean)values[2];
        this.requiredSet = (Boolean)values[3];
        this.valid = (Boolean)values[4];
        this.immediate = (Boolean)values[5];
        this.immediateSet = (Boolean)values[6];
        List restoredValidators = null;
        Iterator iter = null;
        restoredValidators = (List)UIInput.restoreAttachedState(context, values[7]);
        if (null != restoredValidators) {
            if (null != this.validators) {
                iter = restoredValidators.iterator();
                while (iter.hasNext()) {
                    this.validators.add(iter.next());
                }
            } else {
                this.validators = restoredValidators;
            }
        }
        this.validatorBinding = (MethodBinding)UIInput.restoreAttachedState(context, values[8]);
        this.valueChangeMethod = (MethodBinding)UIInput.restoreAttachedState(context, values[9]);
    }

    private Converter getConverterWithType(FacesContext context) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding valueBinding = this.getValueBinding("value");
        if (valueBinding == null) {
            return null;
        }
        Class converterType = valueBinding.getType(context);
        if (converterType == null || converterType == (class$java$lang$String == null ? (class$java$lang$String = UIInput.class$("java.lang.String")) : class$java$lang$String) || converterType == (class$java$lang$Object == null ? (class$java$lang$Object = UIInput.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addConversionErrorMessage(FacesContext context, ConverterException ce, Object value) {
        FacesMessage message = ce.getFacesMessage();
        if (message == null && (message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID)).getDetail() == null) {
            message.setDetail(ce.getMessage());
        }
        message.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage(this.getClientId(context), message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

