/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPOutboundChannel;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.tcp.channel.impl.TCPOutboundChannelDefinition;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSTCPChannelFactory
extends TCPChannelFactory
implements WSChannelFactory {
    private ChannelFrameworkService cfService = null;
    private static final TraceComponent tc = Tr.register((Class)WSTCPChannelFactory.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public WSTCPChannelFactory() throws InvalidChannelFactoryException {
        isZOS = AdminHelper.getPlatformHelper().isZOS();
        boolean bl = isZOS_CR = isZOS && AdminHelper.getPlatformHelper().isControlJvm();
        if (TCPChannelFactory.isZOS && TCPChannelFactory.isZOS_CR) {
            try {
                xMemCRBridgeClass = Class.forName("com.ibm.xmem.ws390.XMemCRBridge");
                xMemSetupThread = xMemCRBridgeClass.getMethod("setupThreadStub", Object.class);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught exception", (Object)exception);
                }
                throw new InvalidChannelFactoryException((Throwable)exception);
            }
        }
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        Property property;
        EList eList;
        String string;
        this.cfService = channelFrameworkService;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ThreadPool threadPool = null;
        String string2 = null;
        TCPInboundChannel tCPInboundChannel = null;
        TCPOutboundChannel tCPOutboundChannel = null;
        EList eList2 = null;
        ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)channelFrameworkService.lookupService(ThreadPoolMgr.class);
        if (transportChannel instanceof TCPInboundChannel) {
            Object[] objectArray;
            EndPointMgr.NodeEndPoints nodeEndPoints;
            tCPInboundChannel = (TCPInboundChannel)transportChannel;
            string2 = tCPInboundChannel.getName();
            threadPool = tCPInboundChannel.getThreadPool();
            string = (Server)channelFrameworkService.lookupService(Server.class);
            eList = (EndPointMgr)channelFrameworkService.lookupService(EndPointMgr.class);
            if (string == null) {
                throw new ConfigurationError("TCP channel factory could not determine its parent server");
            }
            if (eList == null) {
                throw new ConfigurationError("TCP channel factory could not locate the EndPointMgr");
            }
            try {
                nodeEndPoints = eList.getNodeEndPoints(string.getNodeName());
                objectArray = nodeEndPoints.getServerEndPoints(string.getName());
                property = objectArray.getEndPoint(tCPInboundChannel.getEndPointName());
                hashMap.put("hostname", property.getHost());
                hashMap.put("port", String.valueOf(property.getPort()));
            }
            catch (Exception exception) {
                throw new ConfigurationError("endPointName \"" + tCPInboundChannel.getEndPointName() + "\" could not be resolved; please check serverindex.xml", (Throwable)exception);
            }
            hashMap.put("inactivityTimeout", String.valueOf(tCPInboundChannel.getInactivityTimeout()));
            hashMap.put("maxOpenConnections", String.valueOf(tCPInboundChannel.getMaxOpenConnections()));
            nodeEndPoints = tCPInboundChannel.getAddressExcludeList();
            if (nodeEndPoints != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("addressExcludeList", objectArray);
            }
            if ((nodeEndPoints = tCPInboundChannel.getAddressIncludeList()) != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("addressIncludeList", objectArray);
            }
            if ((nodeEndPoints = tCPInboundChannel.getHostNameExcludeList()) != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("hostNameExcludeList", objectArray);
            }
            if ((nodeEndPoints = tCPInboundChannel.getHostNameIncludeList()) != null && nodeEndPoints.size() > 0) {
                objectArray = new String[nodeEndPoints.size()];
                objectArray = (String[])nodeEndPoints.toArray(objectArray);
                hashMap.put("hostNameIncludeList", objectArray);
            }
            eList2 = transportChannel.getProperties();
        } else if (transportChannel instanceof TCPOutboundChannel) {
            tCPOutboundChannel = (TCPOutboundChannel)transportChannel;
            string2 = tCPOutboundChannel.getName();
            threadPool = tCPOutboundChannel.getThreadPool();
            hashMap.put("inactivityTimeout", String.valueOf(tCPOutboundChannel.getInactivityTimeout()));
            eList2 = transportChannel.getProperties();
        }
        if (threadPool != null) {
            string = threadPoolMgr.getThreadPoolName(threadPool);
            hashMap.put("threadPoolName", string);
            eList = threadPool.getCustomProperties();
            boolean bl = true;
            if (eList != null) {
                for (int i = 0; i < eList.size(); ++i) {
                    property = (Property)eList.get(i);
                    if (!property.getName().equals("com.ibm.websphere.threadpool.requestBufferSize")) continue;
                    bl = false;
                }
            }
            if (bl) {
                threadPoolMgr.setRequestBufferSize(string, 1000);
            }
        }
        if (eList2 != null) {
            for (int i = 0; i < eList2.size(); ++i) {
                eList = (Property)eList2.get(i);
                if (tCPInboundChannel != null) {
                    if (eList.getName().equals("acceptThread")) {
                        hashMap.put("acceptThread", eList.getValue());
                        continue;
                    }
                    if (eList.getName().equals("listenBacklog")) {
                        hashMap.put("listenBacklog", eList.getValue());
                        continue;
                    }
                    if (eList.getName().equals("allocateBuffersDirect")) {
                        hashMap.put("allocateBuffersDirect", eList.getValue());
                        continue;
                    }
                    if (eList.getName().equals("newConnectionBufferSize")) {
                        hashMap.put("newConnectionBufferSize", eList.getValue());
                        continue;
                    }
                } else if (eList.getName().equals("soReuseAddr")) {
                    hashMap.put("soReuseAddr", eList.getValue());
                }
                if (eList.getName().equals("tcpNoDelay")) {
                    hashMap.put("tcpNoDelay", eList.getValue());
                    continue;
                }
                if (eList.getName().equals("soLinger")) {
                    hashMap.put("soLinger", eList.getValue());
                    continue;
                }
                if (eList.getName().equals("keepAlive")) {
                    hashMap.put("keepAlive", eList.getValue());
                    continue;
                }
                if (eList.getName().equals("receiveBufferSize")) {
                    hashMap.put("receiveBufferSize", eList.getValue());
                    continue;
                }
                if (eList.getName().equals("sendBufferSize")) {
                    hashMap.put("sendBufferSize", eList.getValue());
                    continue;
                }
                if (eList.getName().equals("pureNonblocking")) {
                    hashMap.put("pureNonblocking", eList.getValue());
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"UNRECOGNIZED_CUSTOM_PROPERTY", (Object)new Object[]{string2, eList.getName()});
            }
        }
        return hashMap;
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        AdminService adminService;
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EList eList = transportChannelFactory.getProperties();
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                string = (Property)eList.get(i);
                if (string.getName().equals("maxKeysPerSelector")) {
                    hashMap.put("maxKeysPerSelector", string.getValue());
                    continue;
                }
                if (string.getName().equals("channelSelectorIdleTimeout")) {
                    hashMap.put("channelSelectorIdleTimeout", string.getValue());
                    continue;
                }
                if (string.getName().equals("channelSelectorWaitToTerminate")) {
                    hashMap.put("channelSelectorWaitToTerminate", string.getValue());
                    continue;
                }
                if (string.getName().equals("selectorYield")) {
                    hashMap.put("selectorYield", string.getValue());
                    continue;
                }
                if (string.getName().equals("maxRunnableSelectorThreads")) {
                    hashMap.put("maxRunnableSelectorThreads", string.getValue());
                    continue;
                }
                if (string.getName().equals("newSelectorConnectionThreshold")) {
                    hashMap.put("newSelectorConnectionThreshold", string.getValue());
                    continue;
                }
                if (string.getName().equals("selectorWakeup")) {
                    hashMap.put("selectorWakeup", string.getValue());
                    continue;
                }
                if (string.getName().equals("cancelKeyOnClose")) {
                    hashMap.put("cancelKeyOnClose", string.getValue());
                    continue;
                }
                if (string.getName().equals("combineSelectors")) {
                    hashMap.put("combineSelectors", string.getValue());
                    continue;
                }
                if (string.getName().equals("inboundReadSelectorsToStart")) {
                    hashMap.put("inboundReadSelectorsToStart", string.getValue());
                    continue;
                }
                if (string.getName().equals("maxRunnableSelectorThreads")) {
                    hashMap.put("maxRunnableSelectorThreads", string.getValue());
                    continue;
                }
                if (string.getName().equals("newSelectorConnectionThreshold")) {
                    hashMap.put("newSelectorConnectionThreshold", string.getValue());
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"UNRECOGNIZED_CUSTOM_PROPERTY", (Object)new Object[]{string.getName(), "TCP Factory"});
            }
        }
        if ((string = (adminService = AdminServiceFactory.getAdminService()).getProcessType()).equals("DeploymentManager") || string.equals("NodeAgent")) {
            hashMap.put("combineSelectors", "1");
        }
        return hashMap;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new TCPOutboundChannelDefinition();
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

