/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class TCPWriteRequestContextImpl
extends TCPBaseRequestContext
implements TCPWriteRequestContext {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl";
    private static final int SYNC_WRITE = 0;
    private static final int ASYNC_WRITE = 1;
    private TCPWriteCompletedCallback callback;
    private static final TraceComponent tc = Tr.register((Class)TCPWriteRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected TCPWriteRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
        this.setRequestTypeRead(false);
    }

    public long write(long l, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("write(" + l + "," + n + ")"));
        }
        long l2 = 0L;
        this.checkForErrors(l, 0, n);
        if (n == -2) {
            this.immediateTimeout();
            return 0L;
        }
        if (this.config.getBlockingChannel() == 1) {
            long l3 = this.writeRegularSocket(l, n);
            return l3;
        }
        if (l != 0L) {
            if (!this.config.isDispatchWorkToThreads()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Can't perform write. Dispatch to Worker threads = false");
                }
                throw new IOException("Can't perform write. Dispatch to Worker threads = false");
            }
            if (this.blockWait == null) {
                this.blockWait = new SimpleSync();
            }
            this.blockingIOError = null;
            VirtualConnection virtualConnection = null;
            this.blockedThread = true;
            virtualConnection = this.write(l, null, false, n, false);
            while (virtualConnection == null) {
                this.blockWait.simpleWait();
                if (this.blockingIOError != null) break;
                virtualConnection = this.oTCPConnLink.getWorkQueueManager().processWork(this, 1);
            }
            this.blockedThread = false;
            if (this.blockingIOError != null) {
                throw this.blockingIOError;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getIOCompleteAmount() -->" + String.valueOf(this.getIOCompleteAmount())));
            }
            l2 = this.getIOCompleteAmount();
        } else {
            this.oTCPConnLink.incrementNumWrites();
            this.channel = this.oTCPConnLink.getSocketIOChannel();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Write requested for local: " + this.channel.getSocket().getLocalSocketAddress() + " remote: " + this.channel.getSocket().getRemoteSocketAddress()));
            }
            long l4 = 0L;
            WsByteBuffer[] wsByteBufferArray = this.getBuffers();
            l4 = wsByteBufferArray.length == 1 ? (long)this.channel.write(wsByteBufferArray[0].getWrappedByteBuffer()) : this.channel.write(this.getByteBufferArray());
            l2 = l4;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("blocking write returned " + String.valueOf(l2)));
        }
        return l2;
    }

    public VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n) {
        return this.write(l, tCPWriteCompletedCallback, bl, n, true);
    }

    private VirtualConnection write(long l, TCPWriteCompletedCallback tCPWriteCompletedCallback, boolean bl, int n, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("write(" + l + ",..," + bl + "," + n + "," + bl2 + ")"));
        }
        if (bl2) {
            this.checkForErrors(l, 1, n);
        }
        if (n == -2) {
            this.immediateTimeout();
            return null;
        }
        this.setIOAmount(l);
        this.oTCPConnLink.incrementNumWrites();
        this.channel = this.oTCPConnLink.getSocketIOChannel();
        this.setWriteCompletedCallback(tCPWriteCompletedCallback);
        this.setForceQueue(bl);
        this.setTimeoutTime(n);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("writeAsynch requested for local: " + this.channel.getSocket().getLocalSocketAddress() + " remote: " + this.channel.getSocket().getRemoteSocketAddress()));
        }
        VirtualConnection virtualConnection = this.oTCPConnLink.getWorkQueueManager().processWork(this, 0);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
        return virtualConnection;
    }

    private long writeRegularSocket(long l, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeRegularSocket(" + l + ")"));
        }
        long l2 = 0L;
        int n2 = 0;
        this.oTCPConnLink.incrementNumWrites();
        this.channel = this.oTCPConnLink.getSocketIOChannel();
        this.setIOAmount(l);
        this.channel.getSocket().setSoTimeout(n);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Write requested for local: " + this.channel.getSocket().getLocalSocketAddress() + " remote: " + this.channel.getSocket().getRemoteSocketAddress()));
        }
        if ((n2 = this.channel.attemptWriteToSocket(this)) == -1) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Throwing IOException, Connection closed: Write failed");
            }
            IOException iOException = new IOException("Connection closed: Write failed");
            throw iOException;
        }
        l2 = this.getIODoneAmount();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("writeRegularSocket returning " + String.valueOf(l2)));
        }
        return l2;
    }

    private void checkForErrors(long l, int n, int n2) {
        WsByteBuffer[] wsByteBufferArray;
        String string = null;
        if (this.config.getBlockingChannel() == 1) {
            if (n == 1) {
                string = "Async writes are not valid on blocking (regular socket) channels";
            } else if (n2 == -2) {
                string = "A cancel write,  an immediate timeout of the previous write, can not be done on blocking (regular socket) channels";
            }
        }
        if (n2 == -2) {
            return;
        }
        if (l > maxWriteSize) {
            string = "Number of bytes to requested to write: " + l + " exceeds the maximum allowed for one write";
        }
        if (this.getBuffers() == null || this.getBuffers().length == 0) {
            string = "No buffer(s) provided for writing data from";
        } else if (l < -1L || l == 0L && n == 1) {
            string = "Number of bytes requested to write: " + l + " is not valid";
        } else {
            wsByteBufferArray = this.getBuffers();
            long l2 = 0L;
            for (int i = 0; i < this.getBuffers().length && wsByteBufferArray[i] != null; ++i) {
                l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
            }
            if (l > l2) {
                string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
            }
        }
        if (string != null) {
            wsByteBufferArray = new IllegalArgumentException(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)string);
            }
            FFDCFilter.processException((Throwable)wsByteBufferArray, (String)CLASS_NAME, (String)"100", (Object)this, (Object[])this.buildDumpList());
            throw wsByteBufferArray;
        }
    }

    protected void setWriteCompletedCallback(TCPWriteCompletedCallback tCPWriteCompletedCallback) {
        this.callback = tCPWriteCompletedCallback;
    }

    protected TCPWriteCompletedCallback getWriteCompletedCallback() {
        return this.callback;
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("TCPWriteRequestContextImpl FFDC Data");
        String string = super.getFFDCDumpData();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

