/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class TCPReadRequestContextImpl
extends TCPBaseRequestContext
implements TCPReadRequestContext {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl";
    private static final int SYNC_READ = 0;
    private static final int ASYNC_READ = 1;
    public static IOException readException = null;
    public static IOException readException2 = null;
    private int jITAllocateSize = 0;
    private boolean jITAllocateAction = false;
    private TCPReadCompletedCallback callback;
    private static final TraceComponent tc = Tr.register((Class)TCPReadRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPReadRequestContextImpl(TCPConnLink tCPConnLink) {
        super(tCPConnLink);
        this.setRequestTypeRead(true);
    }

    public long read(long l, int n) throws IOException {
        WsByteBuffer[] wsByteBufferArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("read(" + l + "," + n + ")"));
        }
        this.checkForErrors(l, 0, n);
        if (n == -2) {
            this.immediateTimeout();
            return 0L;
        }
        if (this.config.getBlockingChannel() == 1) {
            long l2 = this.readRegularSocket(l, n);
            return l2;
        }
        if (l != 0L) {
            if (!this.config.isDispatchWorkToThreads()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Can't perform read. Dispatch to Worker threads = false");
                }
                throw new IOException("Can't perform read. Dispatch to Worker threads = false");
            }
            if (this.blockWait == null) {
                this.blockWait = new SimpleSync();
            }
            this.blockingIOError = null;
            VirtualConnection virtualConnection = null;
            this.blockedThread = true;
            virtualConnection = this.read(l, null, false, n, false);
            while (virtualConnection == null) {
                this.blockWait.simpleWait();
                if (this.blockingIOError != null) break;
                virtualConnection = this.oTCPConnLink.getWorkQueueManager().processWork(this, 1);
            }
            this.blockedThread = false;
            if (this.blockingIOError != null) {
                throw this.blockingIOError;
            }
            return this.getIOCompleteAmount();
        }
        this.jITAllocateAction = false;
        this.oTCPConnLink.incrementNumReads();
        this.channel = this.oTCPConnLink.getSocketIOChannel();
        long l3 = 0L;
        if (this.jITAllocateSize > 0 && this.getBuffers() == null) {
            if (this.config.getAllocateBuffersDirect() == 1) {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocateDirect(this.jITAllocateSize));
            } else {
                this.setBuffer(this.oTCPConnLink.getTCPChannel().getWsByteBufferManager().allocate(this.jITAllocateSize));
            }
            this.jITAllocateAction = true;
        }
        if ((l3 = (wsByteBufferArray = this.getBuffers()).length == 1 ? (long)this.channel.read(wsByteBufferArray[0].getWrappedByteBuffer()) : this.channel.read(this.getByteBufferArray())) < 0L) {
            if (this.jITAllocateAction) {
                this.getBuffer().release();
                this.jITAllocateAction = false;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Throwing IOException");
            }
            if (readException == null) {
                readException = new IOException("Read failed.  End of data reached.");
            }
            throw readException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read ");
        }
        return l3;
    }

    public VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n) {
        return this.read(l, tCPReadCompletedCallback, bl, n, true);
    }

    private VirtualConnection read(long l, TCPReadCompletedCallback tCPReadCompletedCallback, boolean bl, int n, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("read(" + l + ",..," + bl + "," + n + "," + bl2 + ")"));
        }
        if (bl2) {
            this.checkForErrors(l, 1, n);
        }
        if (n == -2) {
            this.immediateTimeout();
            return null;
        }
        this.oTCPConnLink.incrementNumReads();
        this.channel = this.oTCPConnLink.getSocketIOChannel();
        this.setIOAmount(l);
        this.setReadCompletedCallback(tCPReadCompletedCallback);
        this.setForceQueue(bl);
        this.setTimeoutTime(n);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("readAsynch requested for local: " + this.channel.getSocket().getLocalSocketAddress() + " remote: " + this.channel.getSocket().getRemoteSocketAddress()));
        }
        VirtualConnection virtualConnection = this.oTCPConnLink.getWorkQueueManager().processWork(this, 0);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read");
        }
        return virtualConnection;
    }

    private long readRegularSocket(long l, int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readRegularSocket(" + l + ")"));
        }
        this.oTCPConnLink.incrementNumReads();
        this.jITAllocateAction = false;
        this.setIOAmount(l);
        long l2 = 0L;
        this.channel = this.oTCPConnLink.getSocketIOChannel();
        this.channel.getSocket().setSoTimeout(n);
        int n2 = 0;
        n2 = this.channel.attemptReadFromSocket(this, false);
        if (n2 == -1) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Throwing IOException");
            }
            if (readException2 == null) {
                readException2 = new IOException("Read (Blocking) failed.  End of data reached.");
            }
            throw readException2;
        }
        l2 = this.getIODoneAmount();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readRegularSocket returning " + String.valueOf(l2)));
        }
        return l2;
    }

    private void checkForErrors(long l, int n, int n2) {
        WsByteBuffer[] wsByteBufferArray;
        String string = null;
        if (this.config.getBlockingChannel() == 1) {
            if (n == 1) {
                string = "Async reads are not valid on blocking (regular socket) channels";
            } else if (n2 == -2) {
                string = "A cancel read, an immediate timeout of the previous read, can not be done on blocking (regular socket) channels";
            }
        }
        if (n2 == -2) {
            return;
        }
        if (l > maxReadSize) {
            string = "Number of bytes requested to read: " + l + " exceeds the maximum allowed for one read";
        } else if (l < 0L && n == 0 || l < 1L && n == 1) {
            string = "Number of bytes requested to read: " + l + " is less than minimum allowed (0 for sync, 1 for asynch)";
        } else if (this.jITAllocateSize > 0 && this.getBuffers() == null) {
            if (l > (long)this.jITAllocateSize) {
                string = "Number of bytes requested: " + l + " exceeds JIT allocated buffer size: " + this.jITAllocateSize;
            }
        } else if (this.getBuffers() == null || this.getBuffers().length == 0) {
            string = "No buffer(s) provided for reading data into";
        } else {
            wsByteBufferArray = this.getBuffers();
            long l2 = 0L;
            for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
                l2 += (long)(wsByteBufferArray[i].limit() - wsByteBufferArray[i].position());
            }
            if (l > l2) {
                string = "Number of bytes requested: " + l + " exceeds space remaining in the buffers provided: " + l2;
            }
        }
        if (string != null) {
            wsByteBufferArray = new IllegalArgumentException(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)string);
            }
            FFDCFilter.processException((Throwable)wsByteBufferArray, (String)CLASS_NAME, (String)"100", (Object)this, (Object[])this.buildDumpList());
            throw wsByteBufferArray;
        }
    }

    public void setJITAllocateSize(int n) {
        this.jITAllocateSize = n;
    }

    protected int getJITAllocateSize() {
        return this.jITAllocateSize;
    }

    public boolean getJITAllocateAction() {
        return this.jITAllocateAction;
    }

    protected void setJITAllocateAction(boolean bl) {
        this.jITAllocateAction = bl;
    }

    protected void setReadCompletedCallback(TCPReadCompletedCallback tCPReadCompletedCallback) {
        this.callback = tCPReadCompletedCallback;
    }

    protected TCPReadCompletedCallback getReadCompletedCallback() {
        return this.callback;
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("TCPReadRequestContextImpl FFDC Data");
        stringBuffer.append("jITAllocateSize: " + this.jITAllocateSize);
        stringBuffer.append("jITAllocateAction: " + this.jITAllocateAction);
        String string = super.getFFDCDumpData();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

