/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.NewConnectionInitialReadCallback;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.InboundVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPPort {
    private TCPChannel ioChannel = null;
    private ServerSocket serverSocket = null;
    private InboundVirtualConnectionFactory vcf = null;
    private DiscriminationProcess bdp = null;
    private TCPReadCompletedCallback cc = null;
    private int listenPort = 0;
    private static final TraceComponent tc = Tr.register((Class)TCPPort.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected TCPPort(TCPChannel tCPChannel, VirtualConnectionFactory virtualConnectionFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPPort");
        }
        this.ioChannel = tCPChannel;
        this.vcf = (InboundVirtualConnectionFactory)virtualConnectionFactory;
        this.bdp = this.ioChannel.getDiscriminationProcess();
        this.cc = new NewConnectionInitialReadCallback(this.ioChannel);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPPort");
        }
    }

    protected synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected synchronized ServerSocket initServerSocket() throws IOException, RetryableChannelException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ServerSocket called, new ServerSocket needs to be created");
        }
        TCPChannelConfiguration tCPChannelConfiguration = this.ioChannel.getConfig();
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = tCPChannelConfiguration.getHostname() == null ? new InetSocketAddress((InetAddress)null, tCPChannelConfiguration.getPort()) : new InetSocketAddress(tCPChannelConfiguration.getHostname(), tCPChannelConfiguration.getPort());
        ServerSocketChannel serverSocketChannel = null;
        if (!inetSocketAddress.isUnresolved()) {
            serverSocketChannel = ServerSocketChannel.open();
            this.serverSocket = serverSocketChannel.socket();
            this.serverSocket.setReuseAddress(false);
            if (tCPChannelConfiguration.getReceiveBufferSize() >= 4 && tCPChannelConfiguration.getReceiveBufferSize() <= 0x1000000) {
                this.serverSocket.setReceiveBufferSize(tCPChannelConfiguration.getReceiveBufferSize());
            }
            IOException iOException = null;
            try {
                this.serverSocket.bind(inetSocketAddress, tCPChannelConfiguration.getListenBacklog());
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                try {
                    String string = tCPChannelConfiguration.getHostname();
                    if (string == null) {
                        string = "localhost";
                    }
                    InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, tCPChannelConfiguration.getPort());
                    SocketChannel socketChannel = SocketChannel.open(inetSocketAddress2);
                    socketChannel.close();
                }
                catch (IOException iOException3) {
                    try {
                        this.serverSocket.setReuseAddress(true);
                        this.serverSocket.bind(inetSocketAddress, tCPChannelConfiguration.getListenBacklog());
                        iOException = null;
                    }
                    catch (IOException iOException4) {
                        iOException = iOException4;
                    }
                }
            }
            if (iOException != null) {
                String string = tCPChannelConfiguration.getHostname();
                if (string == null) {
                    string = "*";
                }
                Tr.error((TraceComponent)tc, (String)"BIND_ERROR", (Object)new Object[]{tCPChannelConfiguration.getChannelData().getExternalName(), string, String.valueOf(tCPChannelConfiguration.getPort())});
                throw new RetryableChannelException(iOException.getMessage());
            }
        } else {
            String string = tCPChannelConfiguration.getHostname();
            if (string == null) {
                string = "*";
            }
            Tr.error((TraceComponent)tc, (String)"LOCAL_HOST_UNRESOLVED", (Object)new Object[]{tCPChannelConfiguration.getChannelData().getExternalName(), string, String.valueOf(tCPChannelConfiguration.getPort())});
            throw new IOException("local address unresolved");
        }
        this.listenPort = this.serverSocket.getLocalPort();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new ServerSocket successfully created");
        }
        return this.serverSocket;
    }

    protected synchronized void destroyServerSocket() {
        block3: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ServerSocket being closed for port " + this.listenPort));
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("IOExeption on ServerSocket.close " + iOException.getMessage()));
            }
        }
        this.serverSocket = null;
    }

    protected TCPChannel getTCPChannel() {
        return this.ioChannel;
    }

    protected void processNewConnection(SocketIOChannel socketIOChannel) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processNewConnection");
        }
        VirtualConnection virtualConnection = this.vcf.createConnection();
        TCPConnLink tCPConnLink = (TCPConnLink)this.ioChannel.getConnectionLink(virtualConnection);
        TCPReadRequestContextImpl tCPReadRequestContextImpl = tCPConnLink.getTCPReadConnLink();
        tCPConnLink.setSocketIOChannel(socketIOChannel);
        tCPReadRequestContextImpl.setJITAllocateSize(tCPConnLink.getConfig().getNewConnectionBufferSize());
        int n = tCPConnLink.getConfig().getInactivityTimeout();
        if (n == ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) {
            n = -1;
        }
        tCPReadRequestContextImpl.read(1L, this.cc, true, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processNewConnection");
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }
}

