/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.impl.BaseChannelFactoryTypeValidator;
import org.eclipse.emf.common.util.EList;

public class TCPFactoryValidator
extends BaseChannelFactoryTypeValidator
implements TCPChannelMessageConstants {
    private static final TraceComponent tc = Tr.register((Class)TCPFactoryValidator.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPFactoryValidator(MOFValidator mOFValidator) {
        super(mOFValidator);
    }

    public void validate(TransportChannelFactory transportChannelFactory) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate", (Object)transportChannelFactory);
        }
        String string = "*";
        EList eList = transportChannelFactory.getProperties();
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                int n;
                Property property = (Property)eList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("validating property " + property.getName()));
                }
                if (property.getName().equals("maxKeysPerSelector")) {
                    n = ValidateUtils.testKeysPerSelector(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.KEYS_PER_SELECTOR_MIN, "" + ValidateUtils.KEYS_PER_SELECTOR_MAX}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("channelSelectorIdleTimeout")) {
                    n = ValidateUtils.testChannelSelectorIdleTimeout(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN, "" + ValidateUtils.CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("channelSelectorWaitToTerminate")) {
                    n = ValidateUtils.testChannelSelectorWaitToTerminate(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.CHANNEL_SELECTOR_IDLE_TIMEOUT_MIN, "" + ValidateUtils.CHANNEL_SELECTOR_IDLE_TIMEOUT_MAX}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("selectorWakeup")) {
                    n = ValidateUtils.testChannelSelectorWakeupOption(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.SELECTOR_WAKEUP_OPTION_MIN, "" + ValidateUtils.SELECTOR_WAKEUP_OPTION_MAX}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("selectorYield")) {
                    n = ValidateUtils.testBooleanFormat2(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("cancelKeyOnClose")) {
                    n = ValidateUtils.testBooleanFormat2(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("combineSelectors")) {
                    n = ValidateUtils.testBooleanFormat2(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("inboundReadSelectorsToStart")) {
                    n = ValidateUtils.testInboundReadSelectorsToStart(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.MIN_INBOUND_READ_SELECTORS_TO_START, "" + ValidateUtils.MAX_INBOUND_READ_SELECTORS_TO_START}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("maxRunnableSelectorThreads")) {
                    n = ValidateUtils.testMaxSelectorThreads(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.MIN_SELECTOR_THREADS, "" + ValidateUtils.MAX_SELECTOR_THREADS}, transportChannelFactory);
                    continue;
                }
                if (property.getName().equals("newSelectorConnectionThreshold")) {
                    n = ValidateUtils.testConnectionThreshold(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.MIN_CONNECTION_THRESHOLD, "" + ValidateUtils.MAX_CONNECTION_THRESHOLD}, transportChannelFactory);
                    continue;
                }
                this.addWarning("UNRECOGNIZED_CUSTOM_PROPERTY", new String[]{string, property.getName()}, transportChannelFactory);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
    }

    protected String getLocalBundleID() {
        return "com.ibm.ws.tcp.channel.resources.tcpchannelmessages";
    }

    protected String getLocalTraceName() {
        return "TCP Channel Validator";
    }
}

