/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPOutboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.impl.BaseChannelTypeValidator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class TCPChannelValidator
extends BaseChannelTypeValidator
implements TCPChannelMessageConstants {
    private static final TraceComponent tc = Tr.register((Class)TCPChannelValidator.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPChannelValidator(MOFValidator mOFValidator) {
        super(mOFValidator);
    }

    public void validate(TransportChannel transportChannel) throws ValidationException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate", (Object)transportChannel);
        }
        List list = null;
        String string = null;
        TCPInboundChannel tCPInboundChannel = null;
        TCPOutboundChannel tCPOutboundChannel = null;
        if (transportChannel instanceof TCPInboundChannel) {
            String[] stringArray;
            EList eList;
            tCPInboundChannel = (TCPInboundChannel)transportChannel;
            if (tCPInboundChannel.getEndPointName() == null) {
                this.addError("NO_ENDPOINT_NAME", new String[]{tCPInboundChannel.getName()}, transportChannel);
            }
            if ((n = ValidateUtils.testMaxConnections(tCPInboundChannel.getMaxOpenConnections())) == ValidateUtils.VALIDATE_ERROR) {
                this.addError("MAX_OPEN_CONNECTIONS_INVALID", new String[]{"" + tCPInboundChannel.getMaxOpenConnections(), "1", "20000"}, transportChannel);
            }
            if (tCPInboundChannel.getAddressExcludeList() != null && (eList = tCPInboundChannel.getAddressExcludeList()) != null && eList.size() > 0) {
                stringArray = new String[eList.size()];
                n = ValidateUtils.testIsStringIPAddressesValid(stringArray = eList.toArray(stringArray));
                if (n == ValidateUtils.VALIDATE_ERROR) {
                    this.addError("ADDRESS_EXCLUDE_LIST_INVALID", new String[]{tCPInboundChannel.getName()}, transportChannel);
                }
            }
            if (tCPInboundChannel.getAddressIncludeList() != null && (eList = tCPInboundChannel.getAddressIncludeList()) != null && eList.size() > 0) {
                stringArray = new String[eList.size()];
                n = ValidateUtils.testIsStringIPAddressesValid(stringArray = eList.toArray(stringArray));
                if (n == ValidateUtils.VALIDATE_ERROR) {
                    this.addError("ADDRESS_INCLUDE_LIST_INVALID", new String[]{tCPInboundChannel.getName()}, transportChannel);
                }
            }
            if ((n = ValidateUtils.testInactivityTimeout(tCPInboundChannel.getInactivityTimeout())) == ValidateUtils.VALIDATE_ERROR) {
                this.addError("INACTIVITY_TIMEOUT_INVALID", new String[]{"" + tCPInboundChannel.getInactivityTimeout(), "0", "3600"}, transportChannel);
            }
            list = tCPInboundChannel.getProperties();
            string = tCPInboundChannel.getName();
        } else if (transportChannel instanceof TCPOutboundChannel) {
            tCPOutboundChannel = (TCPOutboundChannel)transportChannel;
            n = ValidateUtils.testInactivityTimeout(tCPOutboundChannel.getInactivityTimeout());
            if (n == ValidateUtils.VALIDATE_ERROR) {
                this.addError("INACTIVITY_TIMEOUT_INVALID", new String[]{String.valueOf(tCPOutboundChannel.getInactivityTimeout()), String.valueOf(0), String.valueOf(3600)}, transportChannel);
            }
            list = tCPOutboundChannel.getProperties();
            string = tCPOutboundChannel.getName();
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl = false;
                Property property = (Property)list.get(i);
                if (tCPInboundChannel != null) {
                    if (property.getName().equals("acceptThread")) {
                        bl = true;
                        n = ValidateUtils.testAcceptThread(property.getValue());
                        if (n == ValidateUtils.VALIDATE_ERROR) {
                            this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.ACCEPT_THREAD_MIN, "" + ValidateUtils.ACCEPT_THREAD_MAX}, transportChannel);
                        }
                    } else if (property.getName().equals("newConnectionBufferSize")) {
                        bl = true;
                        n = ValidateUtils.testNewBuffSize(property.getValue());
                        if (n == ValidateUtils.VALIDATE_ERROR) {
                            this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.NEW_BUFF_SIZE_MIN, "" + ValidateUtils.NEW_BUFF_SIZE_MAX}, transportChannel);
                        }
                    } else if (property.getName().equals("allocateBuffersDirect")) {
                        bl = true;
                        n = ValidateUtils.testBooleanFormat2(property.getValue());
                        if (n == ValidateUtils.VALIDATE_ERROR) {
                            this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannel);
                        }
                    } else if (property.getName().equals("listenBacklog")) {
                        bl = true;
                        n = ValidateUtils.testListenBacklog(property.getValue());
                        if (n == ValidateUtils.VALIDATE_ERROR) {
                            this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.LISTEN_BACKLOG_MIN, "" + ValidateUtils.LISTEN_BACKLOG_MAX}, transportChannel);
                        }
                    }
                } else if (property.getName().equals("soReuseAddr") && (n = ValidateUtils.testBooleanFormat2(property.getValue())) == ValidateUtils.VALIDATE_ERROR) {
                    this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannel);
                }
                if (property.getName().equals("tcpNoDelay")) {
                    n = ValidateUtils.testBooleanFormat2(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannel);
                    continue;
                }
                if (property.getName().equals("soLinger")) {
                    n = ValidateUtils.testLinger(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "" + ValidateUtils.LINGER_MIN, "" + ValidateUtils.LINGER_MAX}, transportChannel);
                    continue;
                }
                if (property.getName().equals("keepAlive")) {
                    n = ValidateUtils.testBooleanFormat2(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_BOOLEAN2", new String[]{string, property.getName(), property.getValue()}, transportChannel);
                    continue;
                }
                if (property.getName().equals("receiveBufferSize")) {
                    n = ValidateUtils.testReceiveBufferSize(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "4", "16777216"}, transportChannel);
                    continue;
                }
                if (property.getName().equals("sendBufferSize")) {
                    n = ValidateUtils.testSendBufferSize(property.getValue());
                    if (n != ValidateUtils.VALIDATE_ERROR) continue;
                    this.addError("CONFIG_VALUE_NOT_VALID_INT", new String[]{string, property.getName(), property.getValue(), "4", "16777216"}, transportChannel);
                    continue;
                }
                if (bl) continue;
                this.addWarning("UNRECOGNIZED_CUSTOM_PROPERTY", new String[]{string, property.getName()}, transportChannel);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
    }

    protected String getLocalBundleID() {
        return "com.ibm.ws.tcp.channel.resources.tcpchannelmessages";
    }

    protected String getLocalTraceName() {
        return "TCP Channel Validator";
    }
}

