/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.tcp.channel.impl.NBAccept;
import com.ibm.ws.tcp.channel.impl.SyncWorkQueueManager;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.base.ConnectorChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.ws390.CrossRegionSharable;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class TCPChannelFactory
extends ConnectorChannelFactory
implements CrossRegionSharable {
    private WorkQueueManager workQueueMgr = null;
    private WorkQueueManager syncWorkQueueMgr = null;
    private ChannelFramework cf = null;
    private NBAccept acceptReqProcessor = null;
    private WsByteBufferPoolManager wsByteBufferManager = null;
    private Class appSideClass = TCPConnectionContext.class;
    private static TCPChannelFactory thisRef = null;
    protected static boolean isZOS = false;
    protected static boolean isZOS_CR = false;
    protected static Class xMemCRBridgeClass = null;
    protected static Method xMemSetupThread = null;
    static final TraceComponent tc = Tr.register((Class)TCPChannelFactory.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public boolean isSharable(Map map) {
        return false;
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        thisRef = this;
        TCPChannelDiagnosticModule.instance();
        TCPFactoryConfiguration tCPFactoryConfiguration = new TCPFactoryConfiguration(channelFactoryData.getProperties());
        if (tc.isDebugEnabled()) {
            tCPFactoryConfiguration.outputConfigToTrace();
        }
        this.wsByteBufferManager = WsByteBufferPoolManagerImpl.getRef();
        this.cf = channelFactoryData.getChannelFramework();
    }

    public void updateProperties(Map map) {
        this.commonProperties = map;
        try {
            TCPFactoryConfiguration tCPFactoryConfiguration = new TCPFactoryConfiguration(map);
        }
        catch (ChannelFactoryException channelFactoryException) {
            Tr.debug((TraceComponent)tc, (String)"Unable to consume property updates");
        }
    }

    protected static TCPChannelFactory getRef() {
        return thisRef;
    }

    private TCPChannelConfiguration checkPreReqs(TCPChannelConfiguration tCPChannelConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPreReqs");
        }
        if (tCPChannelConfiguration.isInbound() && this.acceptReqProcessor == null) {
            this.acceptReqProcessor = new NBAccept(tCPChannelConfiguration);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPreReqs");
        }
        return tCPChannelConfiguration;
    }

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createChannel");
        }
        TCPChannelConfiguration tCPChannelConfiguration = new TCPChannelConfiguration(channelData);
        if (tc.isDebugEnabled()) {
            tCPChannelConfiguration.outputConfigToTrace();
        }
        this.checkPreReqs(tCPChannelConfiguration);
        TCPChannel tCPChannel = null;
        if (tCPChannelConfiguration.isDispatchWorkToThreads()) {
            if (this.workQueueMgr == null && tCPChannelConfiguration.getBlockingChannel() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Creating TCPChannel with WORKER WorkQueueManager");
                }
                try {
                    this.workQueueMgr = new WorkQueueManager();
                }
                catch (IOException iOException) {
                    ChannelException channelException = new ChannelException("Unable to start the TCP Channel", (Throwable)iOException);
                    throw channelException;
                }
            }
            tCPChannel = new TCPChannel(channelData, this.acceptReqProcessor, this.workQueueMgr, tCPChannelConfiguration, this.wsByteBufferManager);
        } else {
            if (this.syncWorkQueueMgr == null && tCPChannelConfiguration.getBlockingChannel() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Creating TCPChannel with NON-WORKER WorkQueueManager");
                }
                try {
                    this.syncWorkQueueMgr = new SyncWorkQueueManager(TCPFactoryConfiguration.getMaxSelectorThreads(), TCPFactoryConfiguration.getNewSelectorConnectionThreshold(), this);
                }
                catch (IOException iOException) {
                    ChannelException channelException = new ChannelException("Unable to start the TCP Channel", (Throwable)iOException);
                    throw channelException;
                }
            }
            tCPChannel = new TCPChannel(channelData, this.acceptReqProcessor, this.syncWorkQueueMgr, tCPChannelConfiguration, this.wsByteBufferManager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createChannel");
        }
        return tCPChannel;
    }

    public Class getApplicationInterface() {
        return this.appSideClass;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (this.workQueueMgr != null) {
            this.workQueueMgr.shutdown();
        }
        if (this.syncWorkQueueMgr != null) {
            this.syncWorkQueueMgr.shutdown();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    protected ThreadPool createNewThreadPool(String string, int n) {
        ThreadPool threadPool = new ThreadPool(string, n, n);
        if (isZOS_CR) {
            threadPool.setDecoratedZOS();
        }
        return threadPool;
    }
}

