/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TCPChannelConfiguration
implements TCPConfigConstants {
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration";
    protected static final String NEW_BUFF_SIZE = "newConnectionBufferSize";
    protected static final String LINGER = "soLinger";
    protected static final String NO_DELAY = "tcpNoDelay";
    protected static final String REUSE_ADDR = "soReuseAddr";
    protected static final String KEEP_ALIVE = "keepAlive";
    protected static final String BLOCKING_CHANNEL = "blockingChannel";
    protected static final String BACKLOG = "listenBacklog";
    protected static final String DIRECT_BUFFS = "allocateBuffersDirect";
    protected static final String ACCEPT_THREAD = "acceptThread";
    private static final TraceComponent tc = Tr.register((Class)TCPChannelConfiguration.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private ChannelData channelData = null;
    private Map channelProperties = null;
    private int maxOpenConnections = 20000;
    private String threadPoolName = null;
    private int listenBacklog = 511;
    private int newConnectionBufferSize = 8192;
    private int port = 80;
    private String hostname = "*";
    private int inactivityTimeout = 60000;
    private String[] addressExcludeList = null;
    private String[] hostNameExcludeList = null;
    private String[] addressIncludeList = null;
    private String[] hostNameIncludeList = null;
    private int allocateBuffersDirect = 1;
    private int tcpNoDelay = 1;
    private int soLinger = -1;
    private int soReuseAddress = 1;
    private int keepAlive = 1;
    private int blockingChannel = 0;
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private int acceptThread = 0;
    private boolean inbound;
    private String externalName = null;
    private boolean dispatchWorkToThreads = true;

    protected TCPChannelConfiguration(ChannelData channelData) throws ChannelException {
        this.channelData = channelData;
        this.inbound = this.channelData.isInbound();
        this.channelProperties = this.channelData.getPropertyBag();
        this.externalName = this.channelData.getExternalName();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPChannelConfiguration");
        }
        if (this.channelProperties == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"TCPChannelConfiguration object constructed with null properties");
            }
            throw new ChannelException("TCPChannelConfiguration constructed with null properties");
        }
        this.setValues();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPChannelConfiguration");
        }
    }

    private void setValues() throws ChannelException {
        Set set = this.channelProperties.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        int n = ValidateUtils.VALIDATE_OK;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ChannelException channelException = null;
        while (iterator.hasNext() && n == ValidateUtils.VALIDATE_OK) {
            string = (String)iterator.next();
            try {
                String string2;
                if (this.inbound) {
                    if (string.equalsIgnoreCase("hostname")) {
                        n4 = 1;
                        this.hostname = (String)this.channelProperties.get(string);
                        if (this.hostname != null) continue;
                        n = ValidateUtils.VALIDATE_ERROR;
                        continue;
                    }
                    if (string.equalsIgnoreCase("port")) {
                        n4 = 0;
                        n2 = 0;
                        n3 = 65535;
                        this.port = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testPort(this.port);
                        continue;
                    }
                    if (string.equalsIgnoreCase("maxOpenConnections")) {
                        n4 = 0;
                        n2 = 1;
                        n3 = 20000;
                        this.maxOpenConnections = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testMaxConnections(this.maxOpenConnections);
                        continue;
                    }
                    if (string.equalsIgnoreCase(NEW_BUFF_SIZE)) {
                        n4 = 0;
                        n2 = ValidateUtils.NEW_BUFF_SIZE_MIN;
                        n3 = ValidateUtils.NEW_BUFF_SIZE_MAX;
                        this.newConnectionBufferSize = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testNewBuffSize(this.newConnectionBufferSize);
                        continue;
                    }
                    if (string.equalsIgnoreCase(BACKLOG)) {
                        n4 = 0;
                        n2 = ValidateUtils.LISTEN_BACKLOG_MIN;
                        n3 = ValidateUtils.LISTEN_BACKLOG_MAX;
                        this.listenBacklog = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testListenBacklog(this.listenBacklog);
                        continue;
                    }
                    if (string.equalsIgnoreCase("addressExcludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        this.addressExcludeList = string2 instanceof String ? this.convertToArray(string2) : (String[])string2;
                        n = ValidateUtils.testIsStringIPAddressesValid(this.addressExcludeList);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_EXCLUDE_LIST_INVALID", (Object)new Object[]{this.externalName});
                        channelException = new ChannelException("An entry in the address exclude list for a TCP Channel was not valid.  Valid values consist of a valid String. Channel Name: " + this.externalName);
                        break;
                    }
                    if (string.equalsIgnoreCase("addressIncludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        this.addressIncludeList = string2 instanceof String ? this.convertToArray(string2) : (String[])string2;
                        n = ValidateUtils.testIsStringIPAddressesValid(this.addressIncludeList);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_INCLUDE_LIST_INVALID", (Object)new Object[]{this.externalName});
                        channelException = new ChannelException("An entry in the address include list for a TCP Channel was not valid.  Valid values consist of a valid String. Channel Name: " + this.externalName);
                        break;
                    }
                    if (string.equalsIgnoreCase("hostNameExcludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        if (string2 instanceof String) {
                            this.hostNameExcludeList = this.convertToArray(string2);
                            continue;
                        }
                        this.hostNameExcludeList = (String[])string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("hostNameIncludeList")) {
                        n4 = 3;
                        string2 = this.channelProperties.get(string);
                        if (string2 instanceof String) {
                            this.hostNameIncludeList = this.convertToArray(string2);
                            continue;
                        }
                        this.hostNameIncludeList = (String[])string2;
                        continue;
                    }
                    if (string.equalsIgnoreCase(ACCEPT_THREAD)) {
                        n4 = 0;
                        n2 = ValidateUtils.ACCEPT_THREAD_MIN;
                        n3 = ValidateUtils.ACCEPT_THREAD_MAX;
                        this.acceptThread = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testAcceptThread(this.acceptThread);
                        continue;
                    }
                    if (string.equalsIgnoreCase(DIRECT_BUFFS)) {
                        n4 = 2;
                        this.allocateBuffersDirect = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testBooleanFormat2(this.allocateBuffersDirect);
                        continue;
                    }
                } else if (string.equalsIgnoreCase(REUSE_ADDR)) {
                    n4 = 2;
                    this.soReuseAddress = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.soReuseAddress);
                    continue;
                }
                if (string.equalsIgnoreCase("pureNonblocking")) {
                    string2 = (String)this.channelProperties.get(string);
                    if (!Boolean.toString(true).equalsIgnoreCase(string2) && !Boolean.toString(false).equalsIgnoreCase(string2)) {
                        n = ValidateUtils.VALIDATE_ERROR;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Error with dispatch work to threads value = " + string2));
                        }
                    } else {
                        boolean bl = Boolean.valueOf(string2);
                        this.dispatchWorkToThreads = !bl;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Dispatch work to threads = " + this.dispatchWorkToThreads));
                    continue;
                }
                if (string.equalsIgnoreCase(NO_DELAY)) {
                    n4 = 2;
                    this.tcpNoDelay = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.tcpNoDelay);
                    continue;
                }
                if (string.equalsIgnoreCase(LINGER)) {
                    n4 = 0;
                    n2 = ValidateUtils.LINGER_MIN;
                    n3 = ValidateUtils.LINGER_MAX;
                    this.soLinger = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testLinger(this.soLinger);
                    if (n != ValidateUtils.VALIDATE_OK || this.soLinger <= 0) continue;
                    this.soLinger *= 1000;
                    continue;
                }
                if (string.equalsIgnoreCase(KEEP_ALIVE)) {
                    n4 = 2;
                    this.keepAlive = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.keepAlive);
                    continue;
                }
                if (string.equalsIgnoreCase(BLOCKING_CHANNEL)) {
                    n4 = 2;
                    this.blockingChannel = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testBooleanFormat2(this.blockingChannel);
                    continue;
                }
                if (string.equalsIgnoreCase("receiveBufferSize")) {
                    n4 = 0;
                    n2 = 4;
                    n3 = 0x1000000;
                    this.receiveBufferSize = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testReceiveBufferSize(this.receiveBufferSize);
                    continue;
                }
                if (string.equalsIgnoreCase("sendBufferSize")) {
                    n4 = 0;
                    n2 = 4;
                    n3 = 0x1000000;
                    this.sendBufferSize = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testSendBufferSize(this.sendBufferSize);
                    continue;
                }
                if (string.equalsIgnoreCase("threadPoolName")) {
                    n4 = 1;
                    this.threadPoolName = (String)this.channelProperties.get(string);
                    continue;
                }
                if (string.equalsIgnoreCase("inactivityTimeout")) {
                    n4 = 0;
                    n2 = 0;
                    n3 = 3600;
                    this.inactivityTimeout = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testInactivityTimeout(this.inactivityTimeout);
                    if (n != ValidateUtils.VALIDATE_OK || this.inactivityTimeout == ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) continue;
                    this.inactivityTimeout *= 1000;
                    continue;
                }
                string2 = this.channelProperties.get(string);
                if (string2 instanceof String) {
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object)new Object[]{this.externalName, string, string2});
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object)new Object[]{this.externalName, string, ""});
            }
            catch (NumberFormatException numberFormatException) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object)new Object[]{this.externalName, string, (String)this.channelProperties.get(string)});
                channelException = new ChannelException("TCP Channel Caught a NumberFormatException processing property, Channel Name: " + this.externalName + " Property name: " + string + " value: " + (String)this.channelProperties.get(string), (Throwable)numberFormatException);
                FFDCFilter.processException((Throwable)channelException, (String)CLASS_NAME, (String)"101", (Object)this);
                throw channelException;
            }
        }
        if (n != ValidateUtils.VALIDATE_OK) {
            if (n4 == 0) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_INT", (Object)new Object[]{this.externalName, string, (String)this.channelProperties.get(string), "" + n2, "" + n3});
                channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: " + (String)this.channelProperties.get(string) + "minimum Value: " + n2 + "maximum Value: " + n3);
            } else if (n4 == 2) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_BOOLEAN2", (Object)new Object[]{this.externalName, string, (String)this.channelProperties.get(string)});
                channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: " + (String)this.channelProperties.get(string) + " Valid Range: 0 - False, 1 - True");
            } else if (n4 == 1) {
                if ((String)this.channelProperties.get(string) == null) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_NULL_STRING", (Object)new Object[]{this.externalName, string});
                    channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: null");
                } else {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_STRING", (Object)new Object[]{this.externalName, string, (String)this.channelProperties.get(string)});
                    channelException = new ChannelException("A TCP Channel has been constructed with incorrect configuration property value, Channel Name: " + this.externalName + " name: " + string + " value: " + (String)this.channelProperties.get(string));
                }
            }
            if (channelException != null) {
                FFDCFilter.processException(channelException, (String)CLASS_NAME, (String)"102", (Object)this);
                throw channelException;
            }
        }
    }

    protected boolean checkAndSetValues(ChannelData channelData) {
        ChannelData channelData2 = channelData;
        boolean bl = channelData2.isInbound();
        Map map = this.channelData.getPropertyBag();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        int n = ValidateUtils.VALIDATE_OK;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string2 = null;
        String string3 = null;
        boolean bl2 = true;
        int n7 = this.maxOpenConnections;
        int n8 = this.inactivityTimeout;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        while (iterator.hasNext() && n == ValidateUtils.VALIDATE_OK) {
            string = (String)iterator.next();
            try {
                Object object;
                if (bl) {
                    if (string.equalsIgnoreCase("hostname")) {
                        n4 = 1;
                        string2 = this.hostname;
                        if (((String)this.channelProperties.get(string)).equals(this.hostname)) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase("port")) {
                        n4 = 0;
                        n5 = this.port;
                        if (new Integer((String)this.channelProperties.get(string)) == this.port) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase("maxOpenConnections")) {
                        n4 = 0;
                        n2 = 1;
                        n3 = 20000;
                        n7 = new Integer((String)this.channelProperties.get(string));
                        n = ValidateUtils.testMaxConnections(n7);
                        continue;
                    }
                    if (string.equalsIgnoreCase(NEW_BUFF_SIZE)) {
                        n4 = 0;
                        n5 = this.newConnectionBufferSize;
                        if (new Integer((String)this.channelProperties.get(string)) == this.newConnectionBufferSize) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase(BACKLOG)) {
                        n4 = 0;
                        n5 = this.listenBacklog;
                        if (new Integer((String)this.channelProperties.get(string)) == this.listenBacklog) continue;
                        n = ValidateUtils.VALIDATE_NOT_EQUAL;
                        continue;
                    }
                    if (string.equalsIgnoreCase("addressExcludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        stringArray = object instanceof String ? this.convertToArray((String)object) : (String[])object;
                        n = ValidateUtils.testIsStringIPAddressesValid(stringArray);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_EXCLUDE_LIST_INVALID", (Object)new Object[]{this.externalName});
                        break;
                    }
                    if (string.equalsIgnoreCase("addressIncludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        stringArray2 = object instanceof String ? this.convertToArray((String)object) : (String[])object;
                        n = ValidateUtils.testIsStringIPAddressesValid(stringArray);
                        if (n == ValidateUtils.VALIDATE_OK) continue;
                        Tr.error((TraceComponent)tc, (String)"ADDRESS_INCLUDE_LIST_INVALID", (Object)new Object[]{this.externalName});
                        break;
                    }
                    if (string.equalsIgnoreCase("hostNameExcludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        if (object instanceof String) {
                            stringArray3 = this.convertToArray((String)object);
                            continue;
                        }
                        stringArray3 = (String[])object;
                        continue;
                    }
                    if (string.equalsIgnoreCase("hostNameIncludeList")) {
                        n4 = 3;
                        object = this.channelProperties.get(string);
                        if (object instanceof String) {
                            stringArray4 = this.convertToArray((String)object);
                            continue;
                        }
                        stringArray4 = (String[])object;
                        continue;
                    }
                } else if (string.equalsIgnoreCase(REUSE_ADDR)) {
                    n4 = 2;
                    n5 = this.soReuseAddress;
                    if (new Integer((String)this.channelProperties.get(string)) == this.soReuseAddress) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(NO_DELAY)) {
                    n4 = 2;
                    n5 = this.tcpNoDelay;
                    if (new Integer((String)this.channelProperties.get(string)) == this.tcpNoDelay) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(LINGER)) {
                    n4 = 0;
                    n5 = this.soLinger;
                    if (new Integer((String)this.channelProperties.get(string)) == this.soLinger) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(ACCEPT_THREAD)) {
                    n4 = 0;
                    n5 = this.acceptThread;
                    if (new Integer((String)this.channelProperties.get(string)) == this.acceptThread) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(DIRECT_BUFFS)) {
                    n4 = 2;
                    n5 = this.allocateBuffersDirect;
                    if (new Integer((String)this.channelProperties.get(string)) == this.allocateBuffersDirect) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(KEEP_ALIVE)) {
                    n4 = 2;
                    n5 = this.keepAlive;
                    if (new Integer((String)this.channelProperties.get(string)) == this.keepAlive) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase(BLOCKING_CHANNEL)) {
                    n4 = 2;
                    n5 = this.blockingChannel;
                    if (new Integer((String)this.channelProperties.get(string)) == this.blockingChannel) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("receiveBufferSize")) {
                    n4 = 0;
                    n5 = this.receiveBufferSize;
                    if (new Integer((String)this.channelProperties.get(string)) == this.receiveBufferSize) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("sendBufferSize")) {
                    n4 = 0;
                    n5 = this.sendBufferSize;
                    if (new Integer((String)this.channelProperties.get(string)) == this.sendBufferSize) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("threadPoolName")) {
                    n4 = 1;
                    string2 = this.threadPoolName;
                    if (((String)this.channelProperties.get(string)).equals(this.threadPoolName)) continue;
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                if (string.equalsIgnoreCase("inactivityTimeout")) {
                    n4 = 0;
                    n8 = new Integer((String)this.channelProperties.get(string));
                    n = ValidateUtils.testInactivityTimeout(n8);
                    if (n != ValidateUtils.VALIDATE_OK || n8 == ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) continue;
                    n8 *= 1000;
                    continue;
                }
                if (string.equalsIgnoreCase("pureNonblocking")) {
                    object = (String)this.channelProperties.get(string);
                    if (Boolean.toString(!this.dispatchWorkToThreads).equalsIgnoreCase((String)object)) {
                        n = ValidateUtils.VALIDATE_OK;
                        continue;
                    }
                    n = ValidateUtils.VALIDATE_NOT_EQUAL;
                    continue;
                }
                object = this.channelProperties.get(string);
                if (object instanceof String) {
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object)new Object[]{this.externalName, string, object});
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"CONFIG_KEY_NOT_VALID", (Object)new Object[]{this.externalName, string, ""});
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NUMBER_EXCEPTION", (Object)new Object[]{this.externalName, string, this.channelProperties.get(string)});
            }
        }
        if (n == ValidateUtils.VALIDATE_ERROR) {
            bl2 = false;
            if (n4 == 0) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_INT", (Object)new Object[]{this.externalName, string, this.channelProperties.get(string), "" + n2, "" + n3});
            } else if (n4 == 2) {
                Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_BOOLEAN2", (Object)new Object[]{this.externalName, string, this.channelProperties.get(string)});
            } else if (n4 == 1) {
                if (this.channelProperties.get(string) == null) {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_NULL_STRING", (Object)new Object[]{this.externalName, string});
                } else {
                    Tr.error((TraceComponent)tc, (String)"CONFIG_VALUE_NOT_VALID_STRING", (Object)new Object[]{this.externalName, string});
                }
            }
            Tr.error((TraceComponent)tc, (String)"UPDATED_CONFIG_NOT_IMPLEMENTED", (Object)new Object[]{this.externalName});
        }
        if (n == ValidateUtils.VALIDATE_NOT_EQUAL) {
            bl2 = false;
            if (n4 == 0 || n4 == 2) {
                n6 = new Integer((String)this.channelProperties.get(string));
                Tr.error((TraceComponent)tc, (String)"NEW_CONFIG_VALUE_NOT_EQUAL", (Object)new Object[]{this.externalName, string, "" + n5, "" + n6});
            } else if (n4 == 1) {
                string3 = (String)this.channelProperties.get(string);
                Tr.error((TraceComponent)tc, (String)"NEW_CONFIG_VALUE_NOT_EQUAL", (Object)new Object[]{this.externalName, string, string2, string3});
            }
            Tr.error((TraceComponent)tc, (String)"UPDATED_CONFIG_NOT_IMPLEMENTED", (Object)new Object[]{this.externalName});
        }
        if (bl2) {
            this.maxOpenConnections = n7;
            this.inactivityTimeout = n8;
            this.addressExcludeList = stringArray;
            this.addressIncludeList = stringArray2;
            this.hostNameExcludeList = stringArray3;
            this.hostNameIncludeList = stringArray4;
        }
        return bl2;
    }

    private String[] convertToArray(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n != n3) {
            n2 = string.indexOf(",", n);
            if (n2 > n) {
                string2 = string.substring(n, n2);
                string2 = string2.trim();
                arrayList.add(string2);
            } else if (n2 != n) {
                string2 = string.substring(n);
                string2 = string2.trim();
                arrayList.add(string2);
            }
            if (n2 == -1) break;
            n = n2 + 1;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected ChannelData getChannelData() {
        return this.channelData;
    }

    protected int getMaxOpenConnections() {
        return this.maxOpenConnections;
    }

    protected String getThreadPoolName() {
        return this.threadPoolName;
    }

    protected int getListenBacklog() {
        return this.listenBacklog;
    }

    protected int getNewConnectionBufferSize() {
        return this.newConnectionBufferSize;
    }

    protected int getAllocateBuffersDirect() {
        return this.allocateBuffersDirect;
    }

    protected int getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    protected int getSoReuseAddress() {
        return this.soReuseAddress;
    }

    protected int getKeepAlive() {
        return this.keepAlive;
    }

    protected int getBlockingChannel() {
        return this.blockingChannel;
    }

    protected String getHostname() {
        if (this.hostname.equals("*")) {
            return null;
        }
        return this.hostname;
    }

    protected int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    protected String getChannelId() {
        return "TCPChannel";
    }

    protected String[] getAddressExcludeList() {
        return this.addressExcludeList;
    }

    protected String[] getHostNameExcludeList() {
        return this.hostNameExcludeList;
    }

    protected String[] getAddressIncludeList() {
        return this.addressIncludeList;
    }

    protected String[] getHostNameIncludeList() {
        return this.hostNameIncludeList;
    }

    protected int getPort() {
        return this.port;
    }

    protected void outputConfigToTrace() {
        Tr.debug((TraceComponent)tc, (String)("Config parameters for TCP Channel: " + this.getChannelData().getExternalName()));
        if (this.isInbound()) {
            Tr.debug((TraceComponent)tc, (String)("hostname: " + this.getHostname()));
            Tr.debug((TraceComponent)tc, (String)("port: " + this.getPort()));
            Tr.debug((TraceComponent)tc, (String)("maxOpenConnections: " + this.getMaxOpenConnections()));
            Tr.debug((TraceComponent)tc, (String)("addressExcludeList: " + this.getAddressExcludeList()));
            Tr.debug((TraceComponent)tc, (String)("hostNameExcludeList: " + this.getHostNameExcludeList()));
            Tr.debug((TraceComponent)tc, (String)("addressIncludeList: " + this.getAddressIncludeList()));
            Tr.debug((TraceComponent)tc, (String)("hostNameIncludeList: " + this.getHostNameIncludeList()));
            Tr.debug((TraceComponent)tc, (String)("listenBacklog: " + this.getListenBacklog()));
            Tr.debug((TraceComponent)tc, (String)("newConnectionBufferSize: " + this.getNewConnectionBufferSize()));
        } else {
            Tr.debug((TraceComponent)tc, (String)("soReuseAddr: " + this.getSoReuseAddress()));
        }
        Tr.debug((TraceComponent)tc, (String)("inactivityTimeout: " + this.getInactivityTimeout()));
        Tr.debug((TraceComponent)tc, (String)("threadPoolName: " + this.getThreadPoolName()));
        Tr.debug((TraceComponent)tc, (String)("allocateBuffersDirect: " + this.getAllocateBuffersDirect()));
        Tr.debug((TraceComponent)tc, (String)("tcpNoDelay: " + this.getTcpNoDelay()));
        Tr.debug((TraceComponent)tc, (String)("receiveBufferSize: " + this.getReceiveBufferSize()));
        Tr.debug((TraceComponent)tc, (String)("sendBufferSize: " + this.getSendBufferSize()));
        Tr.debug((TraceComponent)tc, (String)("pureNonblocking: " + Boolean.toString(!this.isDispatchWorkToThreads())));
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        if (this.isInbound()) {
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("hostname", this.hostname, stringBuffer2);
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("port", String.valueOf(this.port), stringBuffer2);
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("maxOpenConnections", String.valueOf(this.maxOpenConnections), stringBuffer2);
            if (this.addressExcludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("addressExcludeList", this.addressExcludeList.toString(), stringBuffer2);
            }
            if (this.hostNameExcludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("hostNameExcludeList", this.hostNameExcludeList.toString(), stringBuffer2);
            }
            if (this.addressIncludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("addressIncludeList", this.addressIncludeList.toString(), stringBuffer2);
            }
            if (this.hostNameIncludeList != null) {
                stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("hostNameIncludeList", this.hostNameIncludeList.toString(), stringBuffer2);
            }
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(BACKLOG, String.valueOf(this.listenBacklog), stringBuffer2);
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(NEW_BUFF_SIZE, String.valueOf(this.newConnectionBufferSize), stringBuffer2);
        } else {
            stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(REUSE_ADDR, String.valueOf(this.soReuseAddress), stringBuffer2);
        }
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("inactivityTimeout", String.valueOf(this.inactivityTimeout), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("threadPoolName", this.threadPoolName, stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(DIRECT_BUFFS, String.valueOf(this.allocateBuffersDirect), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString(NO_DELAY, String.valueOf(this.tcpNoDelay), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("receiveBufferSize", String.valueOf(this.receiveBufferSize), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("sendBufferSize", String.valueOf(this.sendBufferSize), stringBuffer2);
        return stringBuffer2.toString();
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    protected boolean isInbound() {
        return this.inbound;
    }

    protected int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    protected int getSendBufferSize() {
        return this.sendBufferSize;
    }

    protected int getSoLinger() {
        return this.soLinger;
    }

    protected int getAcceptThread() {
        return this.acceptThread;
    }

    protected boolean isDispatchWorkToThreads() {
        return this.dispatchWorkToThreads;
    }
}

