/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.FilterList;
import com.ibm.ws.tcp.channel.impl.FilterListFastStr;
import com.ibm.ws.tcp.channel.impl.FilterListSlowStr;
import com.ibm.ws.tcp.channel.impl.FilterListStr;
import com.ibm.ws.tcp.channel.impl.NBAccept;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.net.Inet6Address;

public class TCPChannel
implements InboundChannel,
OutboundChannel,
TCPChannelMessageConstants {
    private static final Class appSideClass = TCPConnectionContext.class;
    private String channelName = null;
    private String externalName = null;
    private ChannelData channelData;
    private TCPChannelConfiguration config;
    private WorkQueueManager wqm = null;
    private ConnectionManager connMgr = null;
    private NBAccept acceptReqProcessor = null;
    private WsByteBufferPoolManager wsByteBufferManager = null;
    private VirtualConnectionFactory vcFactory = null;
    private TCPPort endPoint = null;
    private DiscriminationProcess discriminationProcess = null;
    private ThreadPool oThreadPool;
    private long lastConnExceededTime = 0L;
    private long lastThreadPoolErrorTime = 0L;
    private AccessLists alists;
    private TCPChannelLinkedList inUse = new TCPChannelLinkedList();
    private boolean stopFlag = true;
    private boolean preparingToStop = false;
    private String displayableHostName = null;
    private static final TraceComponent tc = Tr.register((Class)TCPChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private ChannelFramework oChannelFramework;
    int connectionCount = 0;
    Object connectionCountSync = new Object();

    TCPChannel(ChannelData channelData, NBAccept nBAccept, WorkQueueManager workQueueManager, TCPChannelConfiguration tCPChannelConfiguration, WsByteBufferPoolManager wsByteBufferPoolManager) throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TCPChannel");
        }
        this.channelData = channelData;
        this.channelName = this.channelData.getName();
        this.externalName = this.channelData.getExternalName();
        this.acceptReqProcessor = nBAccept;
        this.config = tCPChannelConfiguration;
        this.wsByteBufferManager = wsByteBufferPoolManager;
        this.oChannelFramework = this.channelData.getChannelFramework();
        this.vcFactory = this.oChannelFramework.getInboundVCFactory();
        this.fillAccess();
        this.wqm = workQueueManager;
        if (workQueueManager != null) {
            this.wqm.startSelectors(this.config.isInbound());
        }
        if (!this.config.isInbound()) {
            this.connMgr = new ConnectionManager(this, this.wqm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TCPChannel");
        }
    }

    protected void fillAccess() {
        boolean bl = false;
        String[] stringArray = this.config.getAddressExcludeList();
        FilterList filterList = new FilterList();
        if (stringArray != null) {
            filterList.buildData(stringArray, false);
            filterList.setActive(true);
            bl = true;
        }
        stringArray = this.config.getHostNameExcludeList();
        FilterListStr filterListStr = new FilterListFastStr();
        if (stringArray != null) {
            if (!filterListStr.buildData(stringArray)) {
                filterListStr = new FilterListSlowStr();
                filterListStr.buildData(stringArray);
            }
            filterListStr.setActive(true);
            bl = true;
        }
        String[] stringArray2 = this.config.getAddressIncludeList();
        FilterList filterList2 = new FilterList();
        if (stringArray2 != null && !stringArray2.equals("")) {
            filterList2.buildData(stringArray2, false);
            filterList2.setActive(true);
            bl = true;
        }
        stringArray2 = this.config.getHostNameIncludeList();
        FilterListStr filterListStr2 = new FilterListFastStr();
        if (stringArray2 != null && !stringArray2.equals("")) {
            if (!filterListStr2.buildData(stringArray2)) {
                filterListStr2 = new FilterListSlowStr();
                filterListStr2.buildData(stringArray2);
            }
            filterListStr2.setActive(true);
            bl = true;
        }
        this.alists = bl ? new AccessLists(filterList, filterList2, filterListStr, filterListStr2) : null;
    }

    protected AccessLists getAccessLists() {
        return this.alists;
    }

    protected boolean getStopFlag() {
        return this.stopFlag;
    }

    protected String getDisplayableHostName() {
        return this.displayableHostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementConnectionCount() {
        if (this.config.isInbound()) {
            Object object = this.connectionCountSync;
            synchronized (object) {
                --this.connectionCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementConnectionCount() {
        if (this.config.isInbound()) {
            Object object = this.connectionCountSync;
            synchronized (object) {
                ++this.connectionCount;
            }
        }
    }

    protected int getInboundConnectionCount() {
        return this.connectionCount;
    }

    public Class getDiscriminatoryType() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDiscriminatoryType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDiscriminatoryType");
        }
        return WsByteBuffer.class;
    }

    public TCPChannelConfiguration getConfig() {
        return this.config;
    }

    protected ConnectionManager getConnMgr() {
        return this.connMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnectionLink");
        }
        TCPConnLink tCPConnLink = new TCPConnLink(this.wqm, virtualConnection, this, this.config, this.oThreadPool);
        TCPChannelLinkedList tCPChannelLinkedList = this.inUse;
        synchronized (tCPChannelLinkedList) {
            this.inUse.add(tCPConnLink);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("obtained connlink: " + tCPConnLink.toString()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnectionLink");
        }
        virtualConnection.getStateMap().put("TCP_THREADPOOL_NAME", this.config.getThreadPoolName());
        return tCPConnLink;
    }

    public void start() throws ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        if (this.stopFlag) {
            this.stopFlag = false;
            if (this.config.isInbound()) {
                try {
                    String string = "IPv4";
                    this.acceptReqProcessor.registerPort(this.endPoint);
                    this.preparingToStop = false;
                    if (this.endPoint.getServerSocket().getInetAddress() instanceof Inet6Address) {
                        string = "IPv6";
                    }
                    this.displayableHostName = this.config.getHostname() == null ? "*  (" + string + ")" : this.endPoint.getServerSocket().getInetAddress().getHostName() + "  (" + string + ": " + this.endPoint.getServerSocket().getInetAddress().getHostAddress() + ")";
                    Tr.audit((TraceComponent)tc, (String)"TCP_CHANNEL_STARTED", (Object)new Object[]{this.config.getChannelData().getExternalName(), this.displayableHostName, String.valueOf(this.endPoint.getListenPort())});
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.tcp.channel.impl.TCPChannel", (String)"100", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.externalName + "- Problem occurred while starting TCP Channel: " + iOException.getMessage()));
                    }
                    ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + "- Problem occurred while starting channel: " + iOException.getMessage());
                    this.stopFlag = true;
                    throw channelException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void init() throws ChannelException {
        String string = this.config.getThreadPoolName();
        if (string != null) {
            this.oThreadPool = this.oChannelFramework.getThreadPool(string);
            if (this.oThreadPool == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.externalName + " - Could not obtain named thread pool from the Channel Framework, thread pool name: " + string));
                }
                ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + " - Could not obtain named thread pool from the Channel Framework, thread pool name: " + string);
                throw channelException;
            }
        } else {
            this.oThreadPool = this.oChannelFramework.getDefaultThreadPool();
            if (this.oThreadPool == null) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.externalName + " - Could not obtain default thread pool from the Channel Framework"));
                }
                ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + " - Could not obtain default thread pool from the Channel Framework");
                throw channelException;
            }
        }
        if (this.config.isInbound()) {
            this.endPoint = new TCPPort(this, this.vcFactory);
            try {
                this.endPoint.initServerSocket();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.tcp.channel.impl.TCPChannel", (String)"319", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.externalName + "- Problem occurred while initializing TCP Channel: " + iOException.getMessage()));
                }
                ChannelException channelException = new ChannelException("TCP Channel: " + this.externalName + "- Problem occurred while starting channel: " + iOException.getMessage());
                throw channelException;
            }
            catch (RetryableChannelException retryableChannelException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("TCP Channel: " + this.externalName + "- Problem occurred while starting TCP Channel: " + retryableChannelException.getMessage()));
                }
                throw retryableChannelException;
            }
            this.channelData.getPropertyBag().put("listeningPort", String.valueOf(this.endPoint.getListenPort()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TCP Channel: " + this.externalName + " using thread pool " + this.oThreadPool.getName() + " min: " + this.oThreadPool.getMinimumPoolSize() + " max: " + this.oThreadPool.getMaximumPoolSize() + " buffer size: " + this.oThreadPool.getRequestBufferSize()));
            if (this.endPoint != null) {
                Tr.debug((TraceComponent)tc, (String)(" listening port: " + String.valueOf(this.endPoint.getListenPort())));
            } else {
                Tr.debug((TraceComponent)tc, (String)(" listening port: " + String.valueOf(this.config.getPort())));
            }
        }
    }

    public void destroy() {
        if (this.endPoint != null) {
            this.endPoint.destroyServerSocket();
        }
    }

    public Discriminator getDiscriminator() {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"getDiscriminator called erroneously on TCPChannel");
        }
        return null;
    }

    public void stop(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stop " + l));
        }
        if (!this.preparingToStop && this.acceptReqProcessor != null && this.config.isInbound()) {
            this.acceptReqProcessor.removePort(this.endPoint);
            Tr.audit((TraceComponent)tc, (String)"TCP_CHANNEL_STOPPED", (Object)new Object[]{this.externalName, this.displayableHostName, String.valueOf(this.endPoint.getListenPort())});
            this.preparingToStop = true;
        }
        if (l == 0L) {
            this.preparingToStop = false;
            this.stopFlag = true;
            this.destroyConnLinks();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public String getName() {
        return this.channelName;
    }

    public Class getApplicationInterface() {
        return appSideClass;
    }

    public Class getDeviceInterface() {
        return null;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discriminationProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess discriminationProcess) {
        this.discriminationProcess = discriminationProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ChannelData channelData) {
        TCPChannel tCPChannel = this;
        synchronized (tCPChannel) {
            boolean bl = false;
            bl = this.config.checkAndSetValues(channelData);
            if (bl) {
                this.fillAccess();
            }
        }
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("TCP Channel: ", this.externalName, stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("**Configuration", "as follows:", stringBuffer2);
        return this.config.getFFDCDumpData(stringBuffer2);
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    public Class getDeviceAddress() {
        throw new IllegalStateException("Not implemented and should not be");
    }

    public Class[] getApplicationAddress() {
        Class[] classArray = new Class[]{TCPConnectRequestContext.class};
        return classArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyConnLinks() {
        TCPConnLink tCPConnLink = null;
        TCPChannelLinkedList tCPChannelLinkedList = this.inUse;
        synchronized (tCPChannelLinkedList) {
            int n = this.inUse.size();
            for (int i = 0; i < n; ++i) {
                tCPConnLink = (TCPConnLink)this.inUse.removeFirst();
                tCPConnLink.close(tCPConnLink.getVirtualConnection(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnectionLink(TCPConnLink tCPConnLink) {
        TCPChannelLinkedList tCPChannelLinkedList = this.inUse;
        synchronized (tCPChannelLinkedList) {
            this.inUse.remove(tCPConnLink);
        }
    }

    protected VirtualConnectionFactory getVcFactory() {
        return this.vcFactory;
    }

    protected WsByteBufferPoolManager getWsByteBufferManager() {
        return this.wsByteBufferManager;
    }

    protected String getExternalName() {
        return this.externalName;
    }

    protected long getLastConnExceededTime() {
        return this.lastConnExceededTime;
    }

    protected long getLastThreadPoolErrorTime() {
        return this.lastThreadPoolErrorTime;
    }

    protected void setLastConnExceededTime(long l) {
        this.lastConnExceededTime = l;
    }

    protected void setLastThreadPoolErrorTime(long l) {
        this.lastThreadPoolErrorTime = l;
    }

    protected class AccessLists {
        FilterList excludeAccess = null;
        FilterList includeAccess = null;
        FilterListStr excludeAccessNames = null;
        FilterListStr includeAccessNames = null;

        protected AccessLists(FilterList filterList, FilterList filterList2, FilterListStr filterListStr, FilterListStr filterListStr2) {
            this.excludeAccess = filterList;
            this.includeAccess = filterList2;
            this.excludeAccessNames = filterListStr;
            this.includeAccessNames = filterListStr2;
        }
    }
}

