/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TCPBaseRequestContext {
    private boolean requestTypeRead;
    protected boolean blockedThread = false;
    protected SimpleSync blockWait = null;
    protected IOException blockingIOError = null;
    private boolean waitingForIO = false;
    private int currentReadQueue = -1;
    private int currentWriteQueue = -1;
    private WsByteBuffer[] buffers;
    private boolean forceQueue = false;
    protected SocketIOChannel channel = null;
    private long ioAmount;
    private long ioDoneAmt = 0L;
    private long lastIOAmt = 0L;
    private long ioCompleteAmt = 0L;
    public static long maxReadSize = Integer.MAX_VALUE;
    public static long maxWriteSize = Integer.MAX_VALUE;
    private static final TraceComponent tc = Tr.register((Class)TCPBaseRequestContext.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected TCPConnLink oTCPConnLink;
    protected TCPChannelConfiguration config;
    private long timeoutTime;
    private WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private ByteBuffer[] byteBufferArrayOf2 = null;
    private ByteBuffer[] byteBufferArrayOf3 = null;
    private ByteBuffer[] byteBufferArrayOf4 = null;
    private ByteBuffer[] byteBufferArrayOf1Direct = null;
    private ByteBuffer[] byteBufferArrayOf2Direct = null;
    private ByteBuffer[] byteBufferArrayOf3Direct = null;
    private ByteBuffer[] byteBufferArrayOf4Direct = null;

    protected TCPBaseRequestContext(TCPConnLink tCPConnLink) {
        this.oTCPConnLink = tCPConnLink;
        this.config = this.oTCPConnLink.getConfig();
    }

    protected TCPConnLink getTCPConnLink() {
        return this.oTCPConnLink;
    }

    public TCPConnectionContext getInterface() {
        return this.oTCPConnLink;
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void setBuffers(WsByteBuffer[] wsByteBufferArray) {
        this.buffers = wsByteBufferArray;
        if (this.buffers != null) {
            int n;
            for (n = 0; n < this.buffers.length && this.buffers[n] != null; ++n) {
            }
            if (n == 1) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
            } else if (n == 2) {
                if (this.byteBufferArrayOf2 == null) {
                    this.byteBufferArrayOf2 = new ByteBuffer[2];
                }
                this.byteBufferArray = this.byteBufferArrayOf2;
            } else if (n == 3) {
                if (this.byteBufferArrayOf3 == null) {
                    this.byteBufferArrayOf3 = new ByteBuffer[3];
                }
                this.byteBufferArray = this.byteBufferArrayOf3;
            } else if (n == 4) {
                if (this.byteBufferArrayOf4 == null) {
                    this.byteBufferArrayOf4 = new ByteBuffer[4];
                }
                this.byteBufferArray = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArray = new ByteBuffer[n];
            }
            for (int i = 0; i < n; ++i) {
                this.byteBufferArray[i] = this.buffers[i].getWrappedByteBuffer();
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    protected void setBuffersToDirect(WsByteBuffer[] wsByteBufferArray) {
        this.buffers = wsByteBufferArray;
        if (this.buffers != null) {
            int n;
            for (n = 0; n < this.buffers.length && this.buffers[n] != null; ++n) {
            }
            if (n == 1) {
                if (this.byteBufferArrayOf1Direct == null) {
                    this.byteBufferArrayOf1Direct = new ByteBuffer[1];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf1Direct;
            } else if (n == 2) {
                if (this.byteBufferArrayOf2Direct == null) {
                    this.byteBufferArrayOf2Direct = new ByteBuffer[2];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf2Direct;
            } else if (n == 3) {
                if (this.byteBufferArrayOf3Direct == null) {
                    this.byteBufferArrayOf3Direct = new ByteBuffer[3];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf3;
            } else if (n == 4) {
                if (this.byteBufferArrayOf4Direct == null) {
                    this.byteBufferArrayOf4Direct = new ByteBuffer[4];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArrayDirect = new ByteBuffer[n];
            }
            for (int i = 0; i < n; ++i) {
                this.byteBufferArrayDirect[i] = ((WsByteBufferImpl)this.buffers[i]).oWsBBDirect;
            }
        } else {
            this.byteBufferArrayDirect = null;
        }
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffer(WsByteBuffer wsByteBuffer) {
        if (wsByteBuffer != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = wsByteBuffer;
            if (this.byteBufferArrayOf1 == null) {
                this.byteBufferArrayOf1 = new ByteBuffer[1];
            }
            this.byteBufferArray = this.byteBufferArrayOf1;
            this.byteBufferArray[0] = wsByteBuffer.getWrappedByteBuffer();
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    public void clearBuffers() {
        WsByteBufferUtils.clearBufferArray(this.buffers);
    }

    protected void setForceQueue(boolean bl) {
        this.forceQueue = bl;
    }

    protected boolean isForceQueue() {
        return this.forceQueue;
    }

    protected long getIOAmount() {
        return this.ioAmount;
    }

    protected long getIODoneAmount() {
        return this.ioDoneAmt;
    }

    protected long getLastIOAmt() {
        return this.lastIOAmt;
    }

    protected void setLastIOAmt(long l) {
        this.lastIOAmt = l;
    }

    protected void setIOAmount(long l) {
        this.ioAmount = l;
    }

    protected void setIODoneAmount(long l) {
        this.ioDoneAmt = l;
    }

    protected void setIOCompleteAmount(long l) {
        this.ioCompleteAmt = l;
    }

    protected long getIOCompleteAmount() {
        return this.ioCompleteAmt;
    }

    protected long getTimeoutTime() {
        return this.timeoutTime;
    }

    protected void setTimeoutTime(int n) {
        if (n == -1) {
            this.timeoutTime = -1L;
        } else {
            if (n == 0) {
                n = this.config.getInactivityTimeout();
            }
            this.timeoutTime = n != ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT ? System.currentTimeMillis() + (long)n : -1L;
        }
    }

    protected boolean hasTimeout() {
        return this.timeoutTime != -1L;
    }

    protected int getCurrentReadQueue() {
        return this.currentReadQueue;
    }

    protected void setCurrentReadQueue(int n) {
        this.currentReadQueue = n;
    }

    protected int getCurrentWriteQueue() {
        return this.currentWriteQueue;
    }

    protected void setCurrentWriteQueue(int n) {
        this.currentWriteQueue = n;
    }

    protected String getFFDCDumpData() {
        return "";
    }

    protected boolean isRequestTypeRead() {
        return this.requestTypeRead;
    }

    protected void setRequestTypeRead(boolean bl) {
        this.requestTypeRead = bl;
    }

    protected ByteBuffer[] getByteBufferArray() {
        return this.byteBufferArray;
    }

    protected ByteBuffer[] getByteBufferArrayDirect() {
        return this.byteBufferArrayDirect;
    }

    protected boolean isWaitingForIO() {
        return this.waitingForIO;
    }

    protected void setWaitingForIO(boolean bl) {
        this.waitingForIO = bl;
    }

    protected void immediateTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"immediateTimeout");
        }
        this.timeoutTime = System.currentTimeMillis() - 2000L;
        if (this.requestTypeRead) {
            this.getTCPConnLink().getSocketIOChannel().getChannelSelectorRead().resetTimeout(this.timeoutTime);
        } else {
            this.getTCPConnLink().getSocketIOChannel().getChannelSelectorWrite().resetTimeout(this.timeoutTime);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"immediateTimeout");
        }
    }

    protected Object[] buildDumpList() {
        Object[] objectArray = new Object[]{this.getTCPConnLink(), this.getTCPConnLink().getTCPChannel(), this.getTCPConnLink().getSocketIOChannel(), this.getTCPConnLink().getTCPReadConnLink(), this.getTCPConnLink().getTCPWriteConnLink()};
        return objectArray;
    }
}

