/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.ConnectChannelSelector;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.SocketRWChannelSelector;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPChannelFactory;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;

public class SyncWorkQueueManager
extends WorkQueueManager {
    protected static final String inboundReadTPName = "InboundReadSelectWorker";
    protected static final String outboundReadTPName = "OutboundReadSelectWorker";
    protected static final String inboundWriteTPName = "InboundWriteSelectWorker";
    protected static final String outboundWriteTPName = "OutboundWriteSelectWorker";
    protected static final String connectTPName = "ConnectSelectWorker";
    private static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.SyncWorkQueueManager";
    private static final TraceComponent tc = Tr.register((Class)SyncWorkQueueManager.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private int readInboundSprayer = 0;
    private int readOutboundSprayer = 0;
    private int writeInboundSprayer = 0;
    private int writeOutboundSprayer = 0;
    private int connectSprayer = 0;
    private ThreadPool inboundReadSelectorThreadPool = null;
    private ThreadPool outboundReadSelectorThreadPool = null;
    private ThreadPool outboundWriteSelectorThreadPool = null;
    private ThreadPool inboundWriteSelectorThreadPool = null;
    private ThreadPool connectSelectorThreadPool = null;

    protected SyncWorkQueueManager(int n, int n2, TCPChannelFactory tCPChannelFactory) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SyncWorkQueueManager", (Object)new Object[]{new Integer(n), new Integer(n2)});
        }
        this.inboundReadSelectorThreadPool = tCPChannelFactory.createNewThreadPool(inboundReadTPName, n);
        this.outboundReadSelectorThreadPool = tCPChannelFactory.createNewThreadPool(outboundReadTPName, n);
        this.inboundWriteSelectorThreadPool = tCPChannelFactory.createNewThreadPool(inboundWriteTPName, n);
        this.outboundWriteSelectorThreadPool = tCPChannelFactory.createNewThreadPool(outboundWriteTPName, n);
        this.connectSelectorThreadPool = tCPChannelFactory.createNewThreadPool(connectTPName, n);
        this.maxKeysPerSelector = n2;
        this.maxChannelSelectorsPerFlow = n;
        this.readInboundSelectorsToStart = TCPFactoryConfiguration.getInboundReadSelectorsToStart();
        if (this.readInboundSelectorsToStart > this.maxChannelSelectorsPerFlow) {
            this.readInboundSelectorsToStart = this.maxChannelSelectorsPerFlow;
        }
        this.selectorYield = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SyncWorkQueueManager", (Object)this);
        }
    }

    protected boolean dispatcher(TCPBaseRequestContext tCPBaseRequestContext, IOException iOException) {
        if (tCPBaseRequestContext.blockedThread) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dispatcher notifying waiting synch request ");
            }
            if (iOException != null) {
                tCPBaseRequestContext.blockingIOError = iOException;
            }
            tCPBaseRequestContext.blockWait.simpleNotify();
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dispatcher handing off asynch work to thread pool");
            }
            try {
                this.workerRun(tCPBaseRequestContext, iOException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.tcp.channel.impl.SyncWorkQueueManager.dispatcher", (String)"119", (Object)this, (Object[])new Object[]{tCPBaseRequestContext, iOException});
            }
        }
        return true;
    }

    protected void updateSprayer(int n, int n2) {
        if (n2 == 0) {
            this.readInboundSprayer = n;
        } else if (n2 == 1) {
            this.readOutboundSprayer = n;
        } else if (n2 == 2) {
            this.writeInboundSprayer = n;
        } else if (n2 == 3) {
            this.writeOutboundSprayer = n;
        } else if (n2 == 4) {
            this.connectSprayer = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveIntoPosition(int[] nArray, ChannelSelector[] channelSelectorArray, Object object, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 1;
        if (n == 0) {
            n5 = this.readInboundSprayer;
            n6 = this.readInboundSelectorsToStart;
        } else if (n == 1) {
            n5 = this.readOutboundSprayer;
        } else if (n == 2) {
            n5 = this.writeInboundSprayer;
        } else if (n == 3) {
            n5 = this.writeOutboundSprayer;
        } else if (n == 4) {
            n5 = this.connectSprayer;
        }
        if (n5 >= this.maxChannelSelectorsPerFlow) {
            n5 = 0;
            this.updateSprayer(n5, n);
        }
        if (nArray[n5] >= CS_OK && nArray[n5] < this.maxKeysPerSelector) {
            int n7;
            channelSelectorArray[n5].addWork(object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("(1) Put request into selector index: " + n5));
            }
            for (n7 = ++n5; n7 < this.maxChannelSelectorsPerFlow; ++n7) {
                if (nArray[n7] < CS_OK) continue;
                this.updateSprayer(n7, n);
                break;
            }
            if (n7 >= this.maxChannelSelectorsPerFlow) {
                this.updateSprayer(0, n);
            }
            return;
        }
        for (n4 = 0; n4 < this.maxChannelSelectorsPerFlow; ++n4) {
            int n8;
            if (nArray[n4] < CS_OK || nArray[n4] >= this.maxKeysPerSelector) continue;
            channelSelectorArray[n4].addWork(object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("(2) Put request into selector index: " + n4));
            }
            for (n8 = n4; n8 < this.maxChannelSelectorsPerFlow; ++n8) {
                if (nArray[n8] < CS_OK) continue;
                this.updateSprayer(n8, n);
                break;
            }
            if (n8 >= this.maxChannelSelectorsPerFlow) {
                this.updateSprayer(0, n);
            }
            return;
        }
        n4 = 0;
        Object object2 = this.findOpenIndexSync;
        synchronized (object2) {
            for (n4 = 0; n4 < this.maxChannelSelectorsPerFlow && nArray[n4] != CS_NULL; ++n4) {
            }
            if (n4 < this.maxChannelSelectorsPerFlow) {
                try {
                    channelSelectorArray[n4] = n == 4 ? new ConnectChannelSelector(this.selectorYield, this, n4, 4) : new SocketRWChannelSelector(this.selectorYield, this.wakeupOption, this, n4, n, this.checkCancel, n6);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)CLASS_NAME, (String)"120", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Caught IOException...throwing RuntimeException");
                    }
                    throw new RuntimeException(iOException);
                }
                this.createNewThread(channelSelectorArray[n4], n, n4 + 1);
                nArray[n4] = CS_OK;
                channelSelectorArray[n4].addWork(object);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("(3) Put request into selector index: " + n4));
                    Tr.debug((TraceComponent)tc, (String)("New Selector thread started. Selector thread # " + n4));
                }
                return;
            }
        }
        for (n3 = n5; n3 < this.maxChannelSelectorsPerFlow; ++n3) {
            if (nArray[n3] < CS_OK) continue;
            channelSelectorArray[n3].addWork(object);
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("(4) Put request into selector index: " + n3));
            break;
        }
        if (n3 >= this.maxChannelSelectorsPerFlow && nArray[0] >= CS_OK) {
            channelSelectorArray[0].addWork(object);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(5) Put request into selector index: 0");
            }
            n3 = 0;
        }
        for (n2 = n3 + 1; n2 < this.maxChannelSelectorsPerFlow; ++n2) {
            if (nArray[n2] < CS_OK) continue;
            this.updateSprayer(n2, n);
            break;
        }
        if (n2 >= this.maxChannelSelectorsPerFlow) {
            this.updateSprayer(0, n);
        }
    }

    protected void createNewThread(ChannelSelector channelSelector, int n, int n2) {
        try {
            if (n == 0) {
                this.inboundReadSelectorThreadPool.execute((Runnable)channelSelector);
            } else if (n == 1) {
                this.outboundReadSelectorThreadPool.execute((Runnable)channelSelector);
            } else if (n == 2) {
                this.inboundWriteSelectorThreadPool.execute((Runnable)channelSelector);
            } else if (n == 3) {
                this.outboundWriteSelectorThreadPool.execute((Runnable)channelSelector);
            } else if (n == 4) {
                this.connectSelectorThreadPool.execute((Runnable)channelSelector);
            }
        }
        catch (InterruptedException interruptedException) {
            Tr.debug((TraceComponent)tc, (String)(n + " thread number " + n2 + "caught InterruptedException " + interruptedException.getMessage()));
        }
    }

    protected void connectDispatcher(ConnectionManager.ConnectInfo connectInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectDispatcher");
        }
        if (connectInfo.getSyncObject() != null) {
            connectInfo.getSyncObject().simpleNotify();
        } else {
            try {
                this.workerRun(connectInfo);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.tcp.channel.impl.SyncWorkQueueManager.connectDispatcher", (String)"267", (Object)this, (Object[])new Object[]{connectInfo});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectDispatcher");
        }
    }
}

