/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.CancelRequest;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.TCPBaseRequestContext;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class SocketIOChannel {
    private static final TraceComponent tc = Tr.register((Class)SocketIOChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    private Socket socket;
    private SocketChannel channel = null;
    private OutputStream output = null;
    private InputStream input = null;
    private boolean closed = false;
    private boolean processClose = true;
    private TCPChannel tcpChannel = null;
    private TCPChannelConfiguration cc = null;
    private ChannelSelector channelSelectorRead = null;
    private ChannelSelector channelSelectorWrite = null;
    private Selector selectorRead = null;
    private Selector selectorWrite = null;
    private boolean checkCancel = false;
    private boolean blockingChannel = false;
    protected static final int ATTEMPT_COMPLETE = 1;
    protected static final int ATTEMPT_NOT_COMPLETE = 0;
    protected static final int ATTEMPT_FAILED_IO_LESS_THAN_ZERO = -1;

    private SocketIOChannel(Socket socket, TCPChannel tCPChannel) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SocketIOChannel");
        }
        this.socket = socket;
        this.tcpChannel = tCPChannel;
        this.cc = this.tcpChannel.getConfig();
        this.checkCancel = TCPFactoryConfiguration.getCancelKeyOnClose() != 0;
        if (this.cc.getBlockingChannel() == 0) {
            this.channel = socket.getChannel();
            this.blockingChannel = false;
        } else {
            this.blockingChannel = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SocketIOChannel");
        }
    }

    protected void initStreams() throws IOException {
        this.output = this.socket.getOutputStream();
        this.input = this.socket.getInputStream();
    }

    protected static SocketIOChannel createIOChannel(Socket socket, TCPChannel tCPChannel) throws IOException {
        SocketIOChannel socketIOChannel = new SocketIOChannel(socket, tCPChannel);
        tCPChannel.incrementConnectionCount();
        return socketIOChannel;
    }

    protected int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    protected long read(ByteBuffer[] byteBufferArray) throws IOException {
        return this.channel.read(byteBufferArray);
    }

    protected int write(ByteBuffer byteBuffer) throws IOException {
        return this.channel.write(byteBuffer);
    }

    protected long write(ByteBuffer[] byteBufferArray) throws IOException {
        return this.channel.write(byteBufferArray);
    }

    protected SelectionKey keyFor(Selector selector) {
        return this.channel.keyFor(selector);
    }

    protected int writeStream(ByteBuffer[] byteBufferArray, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = true;
        int n5 = 0;
        int n6 = 256;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0x100000;
        for (int i = 0; i < byteBufferArray.length; ++i) {
            bl2 = byteBufferArray[i].hasArray();
            n5 = byteBufferArray[i].remaining();
            if ((bl && !bl2 || bl2 && n5 <= n6) && n4 + n5 < n9) {
                if (n4 == 0) {
                    n2 = i;
                }
                n3 = i;
                n4 += n5;
                if (bl2) {
                    bl = false;
                }
                if (i != byteBufferArray.length - 1) continue;
                n7 = this.writeGroup(byteBufferArray, n2, n3, n4, bl);
                n8 += n7;
                n4 = 0;
                bl = true;
                continue;
            }
            if (n4 > 0) {
                n7 = this.writeGroup(byteBufferArray, n2, n3, n4, bl);
                n8 += n7;
                n4 = 0;
                bl = true;
            }
            if (i == byteBufferArray.length - 1 || bl2 && n5 > n6 || n5 >= n9) {
                n7 = this.writeGroup(byteBufferArray, i, i, n5, !bl2);
                n8 += n7;
                continue;
            }
            n2 = i;
            n3 = i;
            n4 = n5;
            if (!bl2) continue;
            bl = false;
        }
        return n8;
    }

    protected int writeGroup(ByteBuffer[] byteBufferArray, int n, int n2, int n3, boolean bl) throws IOException {
        int n4;
        int n5;
        byte[] byArray = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n == n2) {
            return this.writeStream(byteBufferArray[n], n3);
        }
        byArray = new byte[n3];
        for (n5 = n; n5 <= n2; ++n5) {
            n8 = byteBufferArray[n5].remaining();
            if (n7 + n8 > n3) {
                n8 = n3 - n7;
            }
            n6 = byteBufferArray[n5].position();
            if (byteBufferArray[n5].hasArray()) {
                n4 = n6 + byteBufferArray[n5].arrayOffset();
                System.arraycopy(byteBufferArray[n5].array(), n4, byArray, n7, n8);
            } else {
                byteBufferArray[n5].get(byArray, n7, n8);
            }
            byteBufferArray[n5].position(n6);
            n7 += n8;
        }
        n5 = this.writeStream(byArray, 0, n3);
        for (n4 = n; n4 <= n2; ++n4) {
            byteBufferArray[n4].position(byteBufferArray[n4].limit());
        }
        return n5;
    }

    protected int writeStream(ByteBuffer byteBuffer, int n) throws IOException {
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = byteBuffer.position();
        n4 = byteBuffer.limit();
        int n5 = n4 - n2;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n3 = byteBuffer.arrayOffset() + n2;
        } else {
            byArray = new byte[n5];
            byteBuffer.get(byArray, 0, n5);
            byteBuffer.position(n2);
            n3 = 0;
        }
        int n6 = this.writeStream(byArray, n3, n5);
        byteBuffer.position(n4);
        return n6;
    }

    protected int writeStream(byte[] byArray, int n, int n2) throws IOException {
        if (this.output == null) {
            throw new IOException("no output stream found for this socket");
        }
        this.output.write(byArray, n, n2);
        return n2;
    }

    protected int readStream(ByteBuffer[] byteBufferArray, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = true;
        int n5 = 0;
        int n6 = 256;
        int n7 = n;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0x100000;
        if (n == 0 && (n = this.input.available()) == 0) {
            return 0;
        }
        for (int i = 0; i < byteBufferArray.length && n7 > 0; ++i) {
            bl2 = byteBufferArray[i].hasArray();
            n5 = byteBufferArray[i].remaining();
            if ((bl && !bl2 || bl2 && n5 <= n6) && n4 + n5 < n11) {
                if (n4 == 0) {
                    n2 = i;
                }
                n3 = i;
                n4 += n5;
                if (bl2) {
                    bl = false;
                }
                if (i != byteBufferArray.length - 1 && n4 + n9 < n) continue;
                n10 = n7 < n4 ? n7 : n4;
                n8 = this.readGroup(byteBufferArray, n2, n3, n10, n4, bl);
                n7 -= n8;
                n9 += n8;
                n4 = 0;
                bl = true;
                continue;
            }
            if (n4 > 0) {
                n10 = n7 < n4 ? n7 : n4;
                n8 = this.readGroup(byteBufferArray, n2, n3, n10, n4, bl);
                n7 -= n8;
                n9 += n8;
                n4 = 0;
                bl = true;
            }
            if (i == byteBufferArray.length - 1 || n5 + n9 >= n || bl2 && n5 > n6 || n5 > n11) {
                n10 = n7 < n5 ? n7 : n5;
                n8 = this.readGroup(byteBufferArray, i, i, n10, n5, !bl2);
                n7 -= n8;
                n9 += n8;
                continue;
            }
            n2 = i;
            n3 = i;
            n4 = n5;
            if (!bl2) continue;
            bl = false;
        }
        return n9;
    }

    protected int readGroup(ByteBuffer[] byteBufferArray, int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n == n2) {
            return this.readStream(byteBufferArray[n], n3);
        }
        byArray = new byte[n4];
        n7 = this.readStream(byArray, 0, n3, n4);
        for (int i = n; i <= n2; ++i) {
            n6 = byteBufferArray[i].remaining();
            if (n5 + n6 > n7) {
                n6 = n7 - n5;
            }
            if (byteBufferArray[i].hasArray()) {
                int n8 = byteBufferArray[i].position() + byteBufferArray[i].arrayOffset();
                System.arraycopy(byArray, n5, byteBufferArray[i].array(), n8, n6);
            } else {
                byteBufferArray[i].put(byArray, n5, n6);
            }
            if ((n5 += n6) == n7) break;
        }
        return n7;
    }

    protected int readStream(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        byte[] byArray = null;
        int n3 = 0;
        boolean bl = true;
        int n4 = 0;
        if (n == 0 && this.input.available() == 0) {
            return 0;
        }
        n4 = byteBuffer.limit() - byteBuffer.position();
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n3 = byteBuffer.position();
            n2 = byteBuffer.arrayOffset() + n3;
        } else {
            bl = false;
            n2 = 0;
            byArray = new byte[n4];
        }
        int n5 = this.readStream(byArray, n2, n, n4);
        if (bl) {
            byteBuffer.position(n3 + n5);
        } else {
            byteBuffer.put(byArray, 0, n5);
        }
        return n5;
    }

    protected int readStream(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        if (this.input == null) {
            throw new IOException("no input stream found for this socket");
        }
        n5 = this.input.read(byArray, n, n3);
        if (n5 >= n2) {
            return n5;
        }
        n4 = n5;
        do {
            if (n4 != -1) continue;
            throw new IOException("End of input stream reached.");
        } while ((n5 += (n4 = this.input.read(byArray, n + n5, n3 - n5))) < n2);
        return n5;
    }

    protected SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        return this.channel.register(selector, n, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int attemptReadFromSocket(TCPBaseRequestContext tCPBaseRequestContext, boolean bl) throws IOException {
        long l;
        TCPConnLink tCPConnLink;
        TCPReadRequestContextImpl tCPReadRequestContextImpl;
        int n;
        block34: {
            WsByteBuffer[] wsByteBufferArray;
            block35: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"attemptReadFromSocket");
                }
                n = 0;
                tCPReadRequestContextImpl = (TCPReadRequestContextImpl)tCPBaseRequestContext;
                tCPConnLink = tCPReadRequestContextImpl.getTCPConnLink();
                l = 0L;
                if (tCPReadRequestContextImpl.getJITAllocateSize() > 0 && tCPReadRequestContextImpl.getBuffers() == null) {
                    if (tCPConnLink.getConfig().getAllocateBuffersDirect() == 1) {
                        tCPReadRequestContextImpl.setBuffer(tCPConnLink.getTCPChannel().getWsByteBufferManager().allocateDirect(tCPReadRequestContextImpl.getJITAllocateSize()));
                    } else {
                        tCPReadRequestContextImpl.setBuffer(tCPConnLink.getTCPChannel().getWsByteBufferManager().allocate(tCPReadRequestContextImpl.getJITAllocateSize()));
                    }
                    tCPReadRequestContextImpl.setJITAllocateAction(true);
                }
                if ((wsByteBufferArray = tCPReadRequestContextImpl.getBuffers()).length != 1) break block35;
                if (tCPConnLink.getConfig().getBlockingChannel() == 0) {
                    if (!wsByteBufferArray[0].isDirect() && wsByteBufferArray[0].hasArray()) {
                        try {
                            WsByteBufferImpl wsByteBufferImpl = (WsByteBufferImpl)wsByteBufferArray[0];
                            wsByteBufferImpl.setParmsToDirectBuffer();
                            l = this.read(wsByteBufferImpl.oWsBBDirect);
                            wsByteBufferImpl.copyFromDirectBuffer((int)l);
                        }
                        catch (ClassCastException classCastException) {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Reading with a Buffer which is not a WsByteBufferImpl, may hurt performance");
                            }
                            l = this.read(wsByteBufferArray[0].getWrappedByteBuffer());
                        }
                        break block34;
                    } else {
                        l = this.read(wsByteBufferArray[0].getWrappedByteBuffer());
                    }
                    break block34;
                } else {
                    l = this.readStream(wsByteBufferArray[0].getWrappedByteBuffer(), (int)tCPReadRequestContextImpl.getIOAmount());
                }
                break block34;
            }
            if (tCPConnLink.getConfig().getBlockingChannel() != 0) {
                l = this.readStream(tCPReadRequestContextImpl.getByteBufferArray(), (int)tCPReadRequestContextImpl.getIOAmount());
            } else {
                boolean bl2 = false;
                for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
                    if (wsByteBufferArray[i].isDirect() || !wsByteBufferArray[i].hasArray()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    l = this.read(tCPReadRequestContextImpl.getByteBufferArray());
                } else {
                    try {
                        int n2;
                        int n3;
                        for (n3 = 0; n3 < wsByteBufferArray.length && wsByteBufferArray[n3] != null; ++n3) {
                            ((WsByteBufferImpl)wsByteBufferArray[n3]).setParmsToDirectBuffer();
                        }
                        tCPReadRequestContextImpl.setBuffersToDirect(wsByteBufferArray);
                        long l2 = l = this.read(tCPReadRequestContextImpl.getByteBufferArrayDirect());
                        for (n3 = 0; n3 < wsByteBufferArray.length && wsByteBufferArray[n3] != null; l2 -= (long)n2, ++n3) {
                            n2 = wsByteBufferArray[n3].remaining();
                            if (!wsByteBufferArray[n3].isDirect()) {
                                if ((long)n2 < l2) {
                                    ((WsByteBufferImpl)wsByteBufferArray[n3]).copyFromDirectBuffer(n2);
                                    continue;
                                }
                                ((WsByteBufferImpl)wsByteBufferArray[n3]).copyFromDirectBuffer((int)l2);
                            } else if ((long)n2 < l2) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Reading with Buffers which are not WsByteBufferImpl, may hurt performance");
                        }
                        l = this.read(tCPReadRequestContextImpl.getByteBufferArray());
                    }
                }
            }
        }
        tCPReadRequestContextImpl.setLastIOAmt(l);
        tCPReadRequestContextImpl.setIODoneAmount(tCPReadRequestContextImpl.getIODoneAmount() + l);
        if (tCPReadRequestContextImpl.getIODoneAmount() >= tCPReadRequestContextImpl.getIOAmount()) {
            n = 1;
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Read " + l + "(" + tCPReadRequestContextImpl.getIODoneAmount() + ")" + " bytes, " + tCPReadRequestContextImpl.getIOAmount() + " requested on local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress()));
        }
        if (tCPReadRequestContextImpl.getLastIOAmt() < 0L) {
            if (tc.isEventEnabled() && !tCPConnLink.getConfig().isInbound()) {
                Tr.event((TraceComponent)tc, (String)("Empty read on outbound.  Close connection. local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress()));
            }
            if (tCPReadRequestContextImpl.getJITAllocateAction()) {
                tCPReadRequestContextImpl.getBuffer().release();
                tCPReadRequestContextImpl.setBuffer(null);
                tCPReadRequestContextImpl.setJITAllocateAction(false);
            }
            return -1;
        }
        if (n == 1) {
            tCPReadRequestContextImpl.setIOCompleteAmount(tCPReadRequestContextImpl.getIODoneAmount());
            tCPReadRequestContextImpl.setIODoneAmount(0L);
        } else if (n == 0 && !bl && tCPReadRequestContextImpl.getJITAllocateAction() && tCPReadRequestContextImpl.getLastIOAmt() == 0L) {
            tCPReadRequestContextImpl.getBuffer().release();
            tCPReadRequestContextImpl.setBuffers(null);
            tCPReadRequestContextImpl.setJITAllocateAction(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"attemptReadFromSocket");
        }
        return n;
    }

    protected int attemptWriteToSocket(TCPBaseRequestContext tCPBaseRequestContext) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"attemptWriteToSocket");
        }
        int n = 0;
        TCPConnLink tCPConnLink = tCPBaseRequestContext.getTCPConnLink();
        long l = 0L;
        WsByteBuffer[] wsByteBufferArray = tCPBaseRequestContext.getBuffers();
        if (wsByteBufferArray.length == 1) {
            if (tCPConnLink.getConfig().getBlockingChannel() == 0) {
                if (!wsByteBufferArray[0].isDirect() && wsByteBufferArray[0].hasArray()) {
                    WsByteBufferImpl wsByteBufferImpl = null;
                    try {
                        wsByteBufferImpl = (WsByteBufferImpl)wsByteBufferArray[0];
                        wsByteBufferImpl.copyToDirectBuffer();
                        l = this.write(wsByteBufferImpl.oWsBBDirect);
                        wsByteBufferImpl.setParmsFromDirectBuffer();
                    }
                    catch (ClassCastException classCastException) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"Writing with a buffer which is not a WsByteBufferImpl, may hurt performance");
                        }
                        l = this.write(wsByteBufferArray[0].getWrappedByteBuffer());
                    }
                } else {
                    l = this.write(wsByteBufferArray[0].getWrappedByteBuffer());
                }
            } else {
                int n2 = (int)tCPBaseRequestContext.getIOAmount();
                l = this.writeStream(wsByteBufferArray[0].getWrappedByteBuffer(), n2);
            }
        } else if (tCPConnLink.getConfig().getBlockingChannel() == 0) {
            int n3;
            boolean bl = false;
            for (n3 = 0; n3 < wsByteBufferArray.length && wsByteBufferArray[n3] != null; ++n3) {
                if (wsByteBufferArray[n3].isDirect() || !wsByteBufferArray[n3].hasArray()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                l = this.write(tCPBaseRequestContext.getByteBufferArray());
            } else {
                try {
                    for (n3 = 0; n3 < wsByteBufferArray.length && wsByteBufferArray[n3] != null; ++n3) {
                        ((WsByteBufferImpl)wsByteBufferArray[n3]).copyToDirectBuffer();
                    }
                    tCPBaseRequestContext.setBuffersToDirect(wsByteBufferArray);
                    l = this.write(tCPBaseRequestContext.getByteBufferArrayDirect());
                    for (n3 = 0; n3 < wsByteBufferArray.length && wsByteBufferArray[n3] != null; ++n3) {
                        ((WsByteBufferImpl)wsByteBufferArray[n3]).setParmsFromDirectBuffer();
                    }
                }
                catch (ClassCastException classCastException) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Writing with Buffers which are not WsByteBufferImpl, may hurt performance");
                    }
                    l = this.write(tCPBaseRequestContext.getByteBufferArray());
                }
            }
        } else {
            l = this.writeStream(tCPBaseRequestContext.getByteBufferArray(), (int)tCPBaseRequestContext.getIOAmount());
        }
        tCPBaseRequestContext.setLastIOAmt(l);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Wrote " + l + " bytes, " + tCPBaseRequestContext.getIOAmount() + " requested on local: " + this.getSocket().getLocalSocketAddress() + " remote: " + this.getSocket().getRemoteSocketAddress()));
        }
        if (l < 0L) {
            if (tc.isEventEnabled() && !tCPConnLink.getConfig().isInbound()) {
                Tr.event((TraceComponent)tc, (String)("invalid value returned for bytes written.  Close connection. Local port: " + this.getSocket().getLocalPort()));
            }
            return -1;
        }
        if (tCPBaseRequestContext.getIOAmount() == -1L) {
            ByteBuffer[] byteBufferArray = tCPBaseRequestContext.getByteBufferArray();
            n = 1;
            for (int i = 0; i < byteBufferArray.length && n == 1; ++i) {
                if (!byteBufferArray[i].hasRemaining()) continue;
                n = 0;
            }
            tCPBaseRequestContext.setIODoneAmount(tCPBaseRequestContext.getIODoneAmount() + l);
        } else {
            tCPBaseRequestContext.setIODoneAmount(tCPBaseRequestContext.getIODoneAmount() + l);
            if (tCPBaseRequestContext.getIODoneAmount() >= tCPBaseRequestContext.getIOAmount()) {
                n = 1;
            }
        }
        if (n == 1) {
            tCPBaseRequestContext.setIOCompleteAmount(tCPBaseRequestContext.getIODoneAmount());
            tCPBaseRequestContext.setIODoneAmount(0L);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("attemptWriteToSocket, returning " + n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block33: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"close");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SocketChannel close starting, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()));
            }
            Object object = this;
            synchronized (object) {
                if (this.closed) {
                    this.processClose = false;
                }
                this.closed = true;
            }
            if (this.processClose) {
                if (this.checkCancel && this.cc.isDispatchWorkToThreads()) {
                    Object object2;
                    CancelRequest cancelRequest;
                    Object object3;
                    if (this.selectorRead != null && (object = this.channel.keyFor(this.selectorRead)) != null) {
                        object3 = new Object();
                        cancelRequest = new CancelRequest((SelectionKey)object, object3);
                        object2 = object3;
                        synchronized (object2) {
                            block31: {
                                this.channelSelectorRead.addCancelRequest(cancelRequest);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("waiting for key to be canceled, key is " + object));
                                }
                                try {
                                    object3.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!tc.isDebugEnabled()) break block31;
                                    Tr.debug((TraceComponent)tc, (String)"Interrupted while waiting for read cancel request to complete...InterruptedException caught");
                                }
                            }
                        }
                    }
                    if (this.selectorWrite != null && (object = this.channel.keyFor(this.selectorWrite)) != null) {
                        object3 = new Object();
                        cancelRequest = new CancelRequest((SelectionKey)object, object3);
                        object2 = object3;
                        synchronized (object2) {
                            block32: {
                                this.channelSelectorWrite.addCancelRequest(cancelRequest);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("waiting for key to be canceled, key is " + object));
                                }
                                try {
                                    object3.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!tc.isDebugEnabled()) break block32;
                                    Tr.debug((TraceComponent)tc, (String)"Interrupted while waiting for read cancel request to complete...InterruptedException caught");
                                }
                            }
                        }
                    }
                }
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("SocketChannel close, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()));
                    }
                    if (!this.blockingChannel) {
                        this.channel.close();
                        if (this.selectorRead != null) {
                            this.selectorRead.wakeup();
                        }
                        if (this.selectorWrite != null) {
                            this.selectorWrite.wakeup();
                        }
                        break block33;
                    }
                    this.socket.close();
                    this.output.close();
                    this.input.close();
                }
                catch (IOException iOException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"IOException while closing channel");
                    }
                    break block33;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close called on channel already closed, local: " + this.socket.getLocalSocketAddress() + " remote: " + this.socket.getRemoteSocketAddress()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected SocketChannel getChannel() {
        return this.channel;
    }

    protected void setSelectorRead(Selector selector) {
        this.selectorRead = selector;
    }

    protected void setSelectorWrite(Selector selector) {
        this.selectorWrite = selector;
    }

    protected void setChannelSelectorRead(ChannelSelector channelSelector) {
        this.channelSelectorRead = channelSelector;
    }

    protected void setChannelSelectorWrite(ChannelSelector channelSelector) {
        this.channelSelectorWrite = channelSelector;
    }

    protected Object[] buildDumpList() {
        Object[] objectArray = new Object[2];
        if (this.channelSelectorRead != null) {
            objectArray[0] = this.channelSelectorRead;
        } else if (this.channelSelectorWrite != null) {
            objectArray[0] = this.channelSelectorWrite;
        }
        return objectArray;
    }

    protected String getFFDCDumpData() {
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer("SocketIOChannel Data");
            stringBuffer.append("\nSocket: " + this.getSocket().toString());
            stringBuffer.append("\nSocketChannel: " + this.getChannel().toString());
            stringBuffer.append("\nRemote InetAddress: " + this.getSocket().getInetAddress());
            stringBuffer.append("\nRemote Port: " + this.getSocket().getPort());
            stringBuffer.append("\nLocal InetAddress: " + this.getSocket().getLocalAddress());
            stringBuffer.append("\nLocal Port: " + this.getSocket().getLocalPort());
        }
        catch (Exception exception) {
            stringBuffer.append("\nException Occurred Gathering Dump Data: " + exception);
        }
        return stringBuffer.toString();
    }

    protected ChannelSelector getChannelSelectorRead() {
        return this.channelSelectorRead;
    }

    protected ChannelSelector getChannelSelectorWrite() {
        return this.channelSelectorWrite;
    }
}

