/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class NewConnectionInitialReadCallback
implements TCPReadCompletedCallback {
    TCPChannel tcpChannel;
    private static final TraceComponent tc = Tr.register((Class)NewConnectionInitialReadCallback.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public NewConnectionInitialReadCallback(TCPChannel tCPChannel) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"NewConnectionInitialReadCallback");
        }
        this.tcpChannel = tCPChannel;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NewConnectionInitialReadCallback");
        }
    }

    private boolean requestFull(TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"requestFull");
        }
        WsByteBuffer[] wsByteBufferArray = tCPReadRequestContext.getBuffers();
        WsByteBuffer wsByteBuffer = wsByteBufferArray[wsByteBufferArray.length - 1];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("b.hasRemaining: " + wsByteBuffer.hasRemaining()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"requestFull");
        }
        return !wsByteBuffer.hasRemaining();
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete");
        }
        this.sendToDiscriminaters(virtualConnection, tCPReadRequestContext, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete");
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        WsByteBuffer[] wsByteBufferArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"error");
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Error occurred during initial read of request from client: " + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort() + " : " + iOException));
        }
        if ((wsByteBufferArray = tCPReadRequestContext.getBuffers()) != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].release();
            }
        }
        tCPReadRequestContext.setBuffers(null);
        if (iOException != null && iOException instanceof SocketTimeoutException) {
            this.sendToDiscriminaters(virtualConnection, tCPReadRequestContext, true);
        } else {
            ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"error");
        }
    }

    private void sendToDiscriminaters(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, boolean bl) {
        boolean bl2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendToDiscriminaters");
        }
        tCPReadRequestContext.setJITAllocateSize(0);
        TCPConnLink tCPConnLink = ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink();
        do {
            int n;
            bl2 = false;
            try {
                n = this.tcpChannel.getDiscriminationProcess().discriminate(virtualConnection, (Object)tCPReadRequestContext.getBuffers(), (ConnectionLink)tCPConnLink);
            }
            catch (DiscriminationProcessException discriminationProcessException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Exception occurred while discriminating data received from client " + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort()));
                }
                ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, new IOException("Discrimination failed " + discriminationProcessException.getMessage()));
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Discrimination returned " + n));
            }
            if (n == 1) {
                ConnectionReadyCallback connectionReadyCallback = tCPConnLink.getApplicationCallback();
                if (connectionReadyCallback != null) {
                    connectionReadyCallback.ready(virtualConnection);
                    continue;
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No application callback found, closing connection");
                }
                ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
                continue;
            }
            if (n == 2) {
                if (bl) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("First read timed out, and more than one discriminator asked for more data" + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort()));
                    }
                    ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
                    continue;
                }
                if (this.requestFull(tCPReadRequestContext)) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Discrimination failed, no one claimed data even after 1 complete buffer presented - probably garbage passed in" + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort()));
                    }
                    ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
                    continue;
                }
                virtualConnection = tCPReadRequestContext.read(1L, this, false, 0);
                if (virtualConnection == null) continue;
                bl2 = true;
                continue;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error occurred while discriminating data received from client " + tCPReadRequestContext.getInterface().getRemoteAddress() + " " + tCPReadRequestContext.getInterface().getRemotePort()));
            }
            ((TCPReadRequestContextImpl)tCPReadRequestContext).getTCPConnLink().close(virtualConnection, null);
        } while (bl2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendToDiscriminaters");
        }
    }
}

