/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.NBAccept;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPChannelMessageConstants;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPPort;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class NBAcceptChannelSelector
extends ChannelSelector
implements TCPConfigConstants,
TCPChannelMessageConstants {
    static final TraceComponent tc = Tr.register((Class)NBAcceptChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    int usageCount = 0;
    private int maxSocketsToUse;
    private int selectorTimeout = TCPFactoryConfiguration.getChannelSelectorIdleTimeout();

    public NBAcceptChannelSelector(boolean bl) throws IOException {
        super(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWork(Object object) {
        TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
        synchronized (tCPChannelLinkedList) {
            this.ourWorkQueue.add(object);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelector() {
        boolean bl = true;
        NBAccept.EndPointActionInfo endPointActionInfo = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateSelector - processing " + this.ourWorkQueue.size() + " items"));
        }
        while (bl) {
            Object object;
            block23: {
                object = this.ourWorkQueue;
                synchronized (object) {
                    if (this.ourWorkQueue.isEmpty()) {
                        break;
                    }
                    endPointActionInfo = (NBAccept.EndPointActionInfo)this.ourWorkQueue.removeFirst();
                }
                if (endPointActionInfo.action == 1) {
                    block22: {
                        try {
                            object = endPointActionInfo.endPoint.getServerSocket();
                            ((ServerSocket)object).getChannel().configureBlocking(false);
                            try {
                                ((ServerSocket)object).getChannel().register(this.selector, 16, endPointActionInfo.endPoint);
                                ++this.usageCount;
                            }
                            catch (ClosedChannelException closedChannelException) {
                                FFDCFilter.processException((Throwable)closedChannelException, (String)"com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", (String)"100", (Object)this);
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Caught ClosedChannelException while registering a TCPPort, port number: " + endPointActionInfo.endPoint.getListenPort()));
                                }
                            }
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", (String)"101", (Object)this);
                            if (!tc.isEventEnabled()) break block22;
                            Tr.event((TraceComponent)tc, (String)"Caught IOException while registering a TCPPort.");
                        }
                    }
                    object = endPointActionInfo.syncObject;
                    synchronized (object) {
                        endPointActionInfo.syncObject.notify();
                        continue;
                    }
                }
                if (endPointActionInfo.action != 0) continue;
                try {
                    object = endPointActionInfo.endPoint.getServerSocket();
                    ((ServerSocket)object).getChannel().keyFor(this.selector).cancel();
                    this.selector.selectNow();
                    --this.usageCount;
                    if (this.usageCount <= 0) {
                        this.shutDown();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", (String)"102", (Object)this);
                    if (!tc.isEventEnabled()) break block23;
                    Tr.event((TraceComponent)tc, (String)"Caught IOException while removing a TCPPort.");
                }
            }
            object = endPointActionInfo.syncObject;
            synchronized (object) {
                endPointActionInfo.syncObject.notify();
            }
        }
        if (endPointActionInfo != null) {
            this.selector.wakeup();
        }
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    protected void channelSelectorClose() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean performRequest() {
        SocketChannel socketChannel = null;
        TCPChannel.AccessLists accessLists = null;
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("performRequest - processing " + set.size() + " items"));
        }
        if (!set.isEmpty()) {
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                try {
                    iterator.remove();
                    TCPPort tCPPort = (TCPPort)selectionKey.attachment();
                    TCPChannel tCPChannel = tCPPort.getTCPChannel();
                    TCPChannelConfiguration tCPChannelConfiguration = tCPChannel.getConfig();
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                    try {
                        socketChannel = serverSocketChannel.accept();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.tcp.channel.impl.NBAcceptChannelSelector", (String)"103", (Object)this);
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("TCP Channel: " + tCPChannel.getExternalName() + " caught IOException doing accept: " + iOException));
                        }
                        Tr.audit((TraceComponent)tc, (String)"PORT_NOT_ACCEPTING", (Object)new Object[]{tCPChannel.getExternalName(), tCPChannel.getDisplayableHostName(), String.valueOf(tCPPort.getListenPort())});
                        continue;
                    }
                    if (socketChannel == null) {
                        if (!tc.isEventEnabled()) continue;
                        Tr.event((TraceComponent)tc, (String)"SocketChannel tried to accept connection, but got null ");
                        continue;
                    }
                    Socket socket = socketChannel.socket();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("SocketChannel accepted, local: " + socket.getLocalSocketAddress() + " remote: " + socket.getRemoteSocketAddress()));
                    }
                    if ((accessLists = tCPChannel.getAccessLists()) != null) {
                        if (accessLists.includeAccess.getActive() || accessLists.includeAccessNames.getActive()) {
                            boolean bl = true;
                            if (accessLists.includeAccess.getActive()) {
                                if (socket.getInetAddress() instanceof Inet6Address) {
                                    if (accessLists.includeAccess.findInList6(socket.getInetAddress().getAddress())) {
                                        bl = false;
                                    }
                                } else if (accessLists.includeAccess.findInList(socket.getInetAddress().getAddress())) {
                                    bl = false;
                                }
                            }
                            if (bl && accessLists.includeAccessNames.getActive() && accessLists.includeAccessNames.findInList(socket.getInetAddress().getHostName())) {
                                bl = false;
                            }
                            if (bl) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Address and host name not in include list, address: " + socket.getInetAddress().getHostAddress() + " host name: " + socket.getInetAddress().getHostName()));
                                }
                                this.closeSocketChannel(socketChannel);
                                continue;
                            }
                        }
                        if (accessLists.excludeAccess.getActive() || accessLists.excludeAccessNames.getActive()) {
                            if (accessLists.excludeAccess.getActive()) {
                                if (socket.getInetAddress() instanceof Inet6Address) {
                                    if (accessLists.excludeAccess.findInList6(socket.getInetAddress().getAddress())) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)("Address (IPv6) in exclude list, address: " + socket.getInetAddress().getHostAddress()));
                                        }
                                        this.closeSocketChannel(socketChannel);
                                        continue;
                                    }
                                } else if (accessLists.excludeAccess.findInList(socket.getInetAddress().getAddress())) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)("Address in exclude list, address: " + socket.getInetAddress().getHostAddress()));
                                    }
                                    this.closeSocketChannel(socketChannel);
                                    continue;
                                }
                            }
                            if (accessLists.excludeAccessNames.getActive() && accessLists.excludeAccessNames.findInList(socket.getInetAddress().getHostName())) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Host name in exclude list, host name: " + socket.getInetAddress().getHostName()));
                                }
                                this.closeSocketChannel(socketChannel);
                                continue;
                            }
                        }
                    }
                    this.maxSocketsToUse = tCPChannelConfiguration.getMaxOpenConnections();
                    if (tCPChannel.getInboundConnectionCount() >= this.maxSocketsToUse) {
                        long l = QuickApproxTime.getRef().getApproxTime();
                        if (l > tCPChannel.getLastConnExceededTime() + 600000L) {
                            Tr.warning((TraceComponent)tc, (String)"MAX_CONNS_EXCEEDED", (Object)new Object[]{tCPChannel.getExternalName(), new Integer(this.maxSocketsToUse)});
                            tCPChannel.setLastConnExceededTime(l);
                        }
                        this.closeSocketChannel(socketChannel);
                        continue;
                    }
                    try {
                        if (tCPChannelConfiguration.getTcpNoDelay() == 0) {
                            socket.setTcpNoDelay(false);
                        } else {
                            socket.setTcpNoDelay(true);
                        }
                        if (tCPChannelConfiguration.getSoLinger() >= 0) {
                            socket.setSoLinger(true, tCPChannelConfiguration.getSoLinger());
                        } else {
                            socket.setSoLinger(false, 0);
                        }
                        if (tCPChannelConfiguration.getKeepAlive() == 0) {
                            socket.setKeepAlive(false);
                        } else {
                            socket.setKeepAlive(true);
                        }
                        if (tCPChannelConfiguration.getSendBufferSize() >= 4 && tCPChannelConfiguration.getSendBufferSize() <= 0x1000000) {
                            socket.setSendBufferSize(tCPChannelConfiguration.getSendBufferSize());
                        }
                        socketChannel.configureBlocking(false);
                    }
                    catch (IOException iOException) {
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("IOException caught while configuring socket: " + iOException));
                        }
                        this.closeSocketChannel(socketChannel);
                        continue;
                    }
                    try {
                        SocketIOChannel socketIOChannel = SocketIOChannel.createIOChannel(socket, tCPChannel);
                        tCPPort.processNewConnection(socketIOChannel);
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {}
            }
        }
        return false;
    }

    private void closeSocketChannel(SocketChannel socketChannel) {
        block3: {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Closing connection, local: " + socketChannel.socket().getLocalSocketAddress() + " remote: " + socketChannel.socket().getRemoteSocketAddress()));
            }
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                if (!tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)("IOException caught while closing connection " + iOException));
            }
        }
    }

    protected void checkForTimeouts() {
        this.nextTimeoutTime = this.currentTime + (long)this.selectorTimeout;
    }

    void updateCount() {
    }
}

