/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.tcp.channel.impl.ChannelSelector;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.TCPChannelLinkedList;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Set;

public class ConnectChannelSelector
extends ChannelSelector {
    static final TraceComponent tc = Tr.register((Class)ConnectChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    protected WorkQueueManager wqm;
    int countIndex;
    int channelType;

    public ConnectChannelSelector(boolean bl, WorkQueueManager workQueueManager, int n, int n2) throws IOException {
        super(bl, false);
        this.wqm = workQueueManager;
        this.countIndex = n;
        this.channelType = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWork(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addWork");
        }
        TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
        synchronized (tCPChannelLinkedList) {
            this.ourWorkQueue.add(object);
        }
        this.wakeup();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelector() {
        boolean bl = true;
        ConnectionManager.ConnectInfo connectInfo = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateSelector - processing " + this.ourWorkQueue.size() + " items"));
        }
        while (bl) {
            TCPChannelLinkedList tCPChannelLinkedList = this.ourWorkQueue;
            synchronized (tCPChannelLinkedList) {
                if (this.ourWorkQueue.isEmpty()) {
                    break;
                }
                connectInfo = (ConnectionManager.ConnectInfo)this.ourWorkQueue.removeFirst();
            }
            try {
                connectInfo.channel.register(this.selector, 8, connectInfo);
                if (connectInfo.timeout != -1) {
                    this.nextTimeoutTime = connectInfo.nextTimeoutTime = System.currentTimeMillis() + (long)connectInfo.timeout;
                }
                this.updateCount();
            }
            catch (ClosedChannelException closedChannelException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("SocketChannel connect failed, local: " + connectInfo.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + connectInfo.ioSocket.getSocket().getRemoteSocketAddress()));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SocketChannel.register ClosedChannelException caught " + closedChannelException));
                }
                connectInfo.setError(closedChannelException);
                this.wqm.connectDispatcher(connectInfo);
            }
        }
        if (connectInfo != null) {
            this.waitingToQuit = false;
            this.quit = false;
        }
    }

    protected void updateCount() {
        int n = this.selector.keys().size();
        if (n == 0 && this.countIndex != 0) {
            this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_DELETE_IN_PROGRESS, this.channelType);
        } else {
            this.waitingToQuit = false;
            this.wqm.updateCount(this.countIndex, this.selector.keys().size(), this.channelType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelSelectorClose() {
        Object object = this.wqm.shutdownSync;
        synchronized (object) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_NULL, this.channelType);
        }
    }

    protected boolean performRequest() {
        boolean bl = false;
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("performRequest - processing " + set.size() + " items"));
        }
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"calling selectorIterator.remove()");
            }
            iterator.remove();
            ConnectionManager.ConnectInfo connectInfo = (ConnectionManager.ConnectInfo)selectionKey.attachment();
            selectionKey.cancel();
            bl = true;
            connectInfo.setFinish();
            this.wqm.connectDispatcher(connectInfo);
        }
        return bl;
    }

    protected void checkForTimeouts() {
        if (this.currentTime >= this.nextTimeoutTime) {
            Set<SelectionKey> set = this.selector.keys();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkForTimeouts - checking " + set.size() + " keys for timeouts"));
            }
            if (set.isEmpty()) {
                if (this.countIndex != 0) {
                    if (this.waitingToQuit) {
                        this.quit = true;
                    } else {
                        this.wqm.updateCount(this.countIndex, WorkQueueManager.CS_DELETE_IN_PROGRESS, this.channelType);
                        this.waitingToQuit = true;
                        this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorWaitToTerminate();
                    }
                } else {
                    this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
                }
            } else {
                this.waitingToQuit = false;
                Iterator<SelectionKey> iterator = set.iterator();
                this.nextTimeoutTime = this.currentTime + (long)TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
                SelectionKey selectionKey = null;
                while (iterator.hasNext()) {
                    selectionKey = iterator.next();
                    try {
                        int n = selectionKey.interestOps();
                        if (n <= 0) continue;
                        ConnectionManager.ConnectInfo connectInfo = (ConnectionManager.ConnectInfo)selectionKey.attachment();
                        if (connectInfo.timeout == -1) continue;
                        if (connectInfo.nextTimeoutTime <= this.currentTime) {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("Inactivity timeout on connect operation for channel" + connectInfo.ioSocket.getChannel()));
                            }
                            selectionKey.cancel();
                            connectInfo.ioSocket.close();
                            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("Socket operation timed out before it could be completed");
                            connectInfo.setError(socketTimeoutException);
                            this.wqm.connectDispatcher(connectInfo);
                            continue;
                        }
                        if (connectInfo.nextTimeoutTime >= this.nextTimeoutTime) continue;
                        this.nextTimeoutTime = connectInfo.nextTimeoutTime;
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            }
        }
    }
}

