/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.commands;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.channel.commands.CFCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class ListTCPThreadPoolsCommand
extends CFCommand {
    public ListTCPThreadPoolsCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public ListTCPThreadPoolsCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate() throws CommandValidationException {
        super.validate();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        boolean bl = false;
        try {
            try {
                bl = this.checkType(objectName, new String[]{"TCPInboundChannel", "TCPOutboundChannel"}, false);
            }
            catch (Exception exception) {
                bl = false;
                Object var5_4 = null;
                if (bl) return;
                throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
            }
            Object var5_3 = null;
            if (bl) return;
            throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) throw throwable;
            throw new InvalidParameterValueException(this.getName(), "target", (Object)objectName);
        }
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            commandResultImpl.setResult((Object)this.getThreadPools((ObjectName)this.getTargetObject()));
        }
        catch (Exception exception) {
            commandResultImpl.setException((Throwable)exception);
        }
        this.setCommandResult((CommandResult)commandResultImpl);
    }

    protected List getThreadPools(ObjectName objectName) throws Exception {
        Properties properties = ConfigServiceHelper.getObjectLocation((ObjectName)objectName);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cells/");
        stringBuffer.append(properties.getProperty("cell"));
        stringBuffer.append("/nodes/");
        stringBuffer.append(properties.getProperty("node"));
        stringBuffer.append("/servers/");
        stringBuffer.append(properties.getProperty("server"));
        ConfigService configService = this.getConfigService();
        Session session = this.getConfigSession();
        ConfigDataId configDataId = new ConfigDataId(stringBuffer.toString(), "server.xml");
        ObjectName objectName2 = ConfigServiceHelper.createObjectName((ConfigDataId)configDataId);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"ThreadPoolManager");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        if (objectNameArray != null && objectNameArray.length > 0) {
            List list = (List)configService.getAttribute(session, objectNameArray[0], "threadPools", false);
            for (int i = 0; list != null && i < list.size(); ++i) {
                ObjectName objectName4 = (ObjectName)list.get(i);
                String string = (String)configService.getAttribute(session, objectName4, "name");
                if (string == null || string.trim().length() <= 0) continue;
                arrayList.add(objectName4);
            }
        }
        return arrayList;
    }
}

