/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import sun.tools.javazic.Main;
import sun.tools.javazic.ZoneRec;
import sun.tools.javazic.Zoneinfo;

class Zone {
    private String name;
    private ArrayList list;
    private static HashSet targetZones;

    Zone(String string) {
        this.name = string;
        this.list = new ArrayList();
    }

    static void readZoneNames(String string) {
        Object object;
        if (string == null) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            object = new FileReader(string);
            bufferedReader = new BufferedReader((Reader)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.panic("can't open file: " + string);
        }
        targetZones = new HashSet();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)(object = ((String)object).trim())).length() == 0 || ((String)object).charAt(0) == '#' || targetZones.add(object)) continue;
                Main.warning("duplicated target zone name: " + (String)object);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Main.panic("IO error: " + iOException.getMessage());
        }
    }

    static boolean isTargetZone(String string) {
        if (targetZones == null) {
            return true;
        }
        return targetZones.contains(string);
    }

    static void addMET() {
        if (targetZones != null) {
            targetZones.add("MET");
        }
    }

    String getName() {
        return this.name;
    }

    void add(ZoneRec zoneRec) {
        this.list.add(zoneRec);
    }

    ZoneRec get(int n) {
        return (ZoneRec)this.list.get(n);
    }

    int size() {
        return this.list.size();
    }

    void resolve(Zoneinfo zoneinfo) {
        for (int i = 0; i < this.list.size(); ++i) {
            ZoneRec zoneRec = (ZoneRec)this.list.get(i);
            zoneRec.resolve(zoneinfo);
        }
    }
}

