/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sun.tools.javazic.BackEnd;
import sun.tools.javazic.Main;
import sun.tools.javazic.Mappings;
import sun.tools.javazic.Month;
import sun.tools.javazic.RuleRec;
import sun.tools.javazic.Time;
import sun.tools.javazic.Timezone;
import sun.tools.javazic.ZoneRec;
import sun.util.calendar.Gregorian;
import sun.util.calendar.ZoneInfoFile;

class GenSrc
extends BackEnd {
    private static final String docDir = "text";
    private static final String m_PackageName = "package sun.util.calendar.zoneinfo;\n\n";
    private static final String m_ImportClasses = "import java.util.TimeZone;\nimport java.util.Calendar;\n";
    private static final String m_ImportSTZClass = "import java.util.SimpleTimeZone;\n";
    private static final String m_additionalImportClass = "import sun.util.calendar.ZoneInfo;\n\n";
    private static final String m_header = "/*\n * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.\n *\n * This software is the proprietary information of Sun Microsystems, Inc.\n * Use is subject to license terms.\n *\n */\n\n";
    private static final String m_warning = " // THIS FILE HAS BEEN GENERATED BY A TOOL. DO NOT EDIT THIS FILE MANUALLY.\n";
    private static final String m_rule_zone_Begin = "/**\n * ZoneInfo definitions for \"";
    private static final String m_rule_zone_Mid = ".\" The following have been derived\n * from the Olson public zone information.\n * <pre><code>\n";
    private static final String m_rule = " * Rule NAME    FROM    TO      TYPE    IN      ON      AT      SAVE    LETTER/S\n";
    private static final String m_zone = " * Zone                 GMTOFF  RULES   FORMAT  [UNTIL]\n";
    private static final String m_rule_zone_End = " * </code></pre>\n *\n */\n\n";
    private static final String m_return = "\n";
    private static final String m_comment_null_line = " //\n";
    private static final String m_comment_blank_line = " * \n";
    private static final String m_array_End = "    };\n\n";
    private static final String m_method_End = "    }\n\n";
    private static final String m_class_End = "}\n";

    GenSrc() {
    }

    int processZoneinfo(Timezone timezone) {
        try {
            Object object;
            Object object2;
            ArrayList arrayList;
            int n;
            String string = Main.getOutputDir();
            String string2 = timezone.getName();
            String string3 = ZoneInfoFile.getFileName((String)string2) + ".java";
            if (!string.endsWith(File.separator)) {
                string = string + File.separatorChar;
            }
            string = string + docDir + File.separatorChar;
            int n2 = string3.lastIndexOf(File.separatorChar);
            if (n2 != -1) {
                string = string + string3.substring(0, n2 + 1);
            }
            File file = new File(string);
            file.mkdirs();
            FileWriter fileWriter = new FileWriter(string + string3.substring(n2 + 1));
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(m_header);
            bufferedWriter.write(" //\n // THIS FILE HAS BEEN GENERATED BY A TOOL. DO NOT EDIT THIS FILE MANUALLY.\n //\n\n");
            bufferedWriter.write("package sun.util.calendar.zoneinfo;\n\nimport java.util.TimeZone;\nimport java.util.Calendar;\n");
            ArrayList arrayList2 = timezone.getLastRules();
            if (arrayList2 != null) {
                bufferedWriter.write(m_ImportSTZClass);
            }
            bufferedWriter.write(m_additionalImportClass);
            bufferedWriter.write(m_rule_zone_Begin + string2 + m_rule_zone_Mid);
            ArrayList arrayList3 = timezone.getRules();
            if (arrayList3 != null) {
                n = arrayList3.size();
                bufferedWriter.write(m_rule);
                for (int i = 0; i < n; ++i) {
                    bufferedWriter.write(" * " + ((RuleRec)arrayList3.get(i)).getLine() + m_return);
                }
                bufferedWriter.write(m_comment_blank_line);
            }
            if ((arrayList = timezone.getZones()) != null) {
                n = arrayList.size();
                bufferedWriter.write(m_zone);
                for (int i = 0; i < n; ++i) {
                    bufferedWriter.write(" * " + ((ZoneRec)arrayList.get(i)).getLine() + m_return);
                }
            }
            bufferedWriter.write(m_rule_zone_End);
            bufferedWriter.write("public class " + string3 + " extends ZoneInfo {\n");
            ArrayList arrayList4 = timezone.getTransitions();
            if (arrayList4 != null) {
                int n3;
                object2 = timezone.getDstOffsets();
                object = timezone.getOffsets();
                if (object2 == null && object != null || object2 != null && object == null) {
                    Main.panic("Data not exist. (dstOffsets or offsets)");
                    return 1;
                }
                bufferedWriter.write("    private static final long[] pTransitions = {\n\t");
                n = arrayList4.size();
                long l = 0L;
                for (int i = 0; i < n; ++i) {
                    l = (Long)arrayList4.get(i);
                    n3 = (Integer)((ArrayList)object2).get(i);
                    if (n3 == -1) {
                        n3 = 0;
                    }
                    bufferedWriter.write(l + "L<<12|" + n3 + "<<4|" + (Integer)((ArrayList)object).get(i) + ", " + " // " + Gregorian.getCalendarDate(l) + "\n\t");
                }
                bufferedWriter.write("\n    };\n\n");
                ArrayList arrayList5 = timezone.getGmtOffsets();
                if (arrayList5 != null) {
                    bufferedWriter.write("    private static final int[] pOffsets = {\n\t");
                    n3 = arrayList5.size();
                    for (int i = 0; i < n3; ++i) {
                        bufferedWriter.write((Integer)arrayList5.get(i) + ", ");
                    }
                    bufferedWriter.write("\n    };\n\n");
                }
            }
            if (arrayList2 != null) {
                object2 = (RuleRec)arrayList2.get(0);
                object = (RuleRec)arrayList2.get(1);
                boolean bl = ((RuleRec)object2).getTime().isWall() && ((RuleRec)object).getTime().isWall();
                bufferedWriter.write("    private static final int[] pSimpleTimeZoneParams = {\n\t" + Month.toString(((RuleRec)object2).getMonthNum()) + ", " + ((RuleRec)object2).getDay().getDayForSimpleTimeZone() + ", " + ((RuleRec)object2).getDay().getDayOfWeekForSimpleTimeZone() + ", " + Time.toFormedString((int)((RuleRec)object2).getTime().getTime()) + ", " + (bl ? m_return : ((RuleRec)object2).getTime().getTypeForSimpleTimeZone() + ",\n") + "\t" + Month.toString(((RuleRec)object).getMonthNum()) + ", " + ((RuleRec)object).getDay().getDayForSimpleTimeZone() + ", " + ((RuleRec)object).getDay().getDayOfWeekForSimpleTimeZone() + ", " + Time.toFormedString((int)((RuleRec)object).getTime().getTime()) + ", " + (bl ? "" : ((RuleRec)object).getTime().getTypeForSimpleTimeZone()) + m_return + m_array_End);
            }
            bufferedWriter.write("    public " + string3 + "() {\n" + "\tsuper(\"" + string2 + "\", " + Time.toFormedString(timezone.getRawOffset()) + ", " + Time.toFormedString(timezone.getLastDSTSaving()) + ", " + "0x" + Integer.toHexString(timezone.getCRC32()) + ", \n\t    ");
            bufferedWriter.write(arrayList4 != null ? "pTransitions, pOffsets, " : "null, null, ");
            bufferedWriter.write(arrayList2 != null ? "pSimpleTimeZoneParams" : "null");
            bufferedWriter.write(");\n");
            bufferedWriter.write(m_method_End);
            bufferedWriter.write(m_class_End);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Main.panic("IO error: " + iOException.getMessage());
            return 1;
        }
        return 0;
    }

    int generateSrc(Mappings mappings) {
        try {
            int n;
            String string;
            Iterator<Object> iterator;
            int n2;
            String string2 = Main.getOutputDir();
            LinkedList linkedList = mappings.getRawOffsetsIndex();
            if (linkedList == null) {
                Main.panic("Data not exist. (rawOffsetsIndex)");
                return 1;
            }
            int n3 = linkedList.size();
            LinkedList linkedList2 = mappings.getRawOffsetsIndexTable();
            if (linkedList2 == null || linkedList2.size() != n3) {
                Main.panic("Data not exist. (rawOffsetsIndexTable) Otherwise, Invalid size");
                return 1;
            }
            TreeMap treeMap = mappings.getAliases();
            if (treeMap == null) {
                Main.panic("Data not exist. (aliases)");
                return 1;
            }
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separatorChar;
            }
            string2 = string2 + docDir + File.separatorChar;
            File file = new File(string2);
            file.mkdirs();
            FileWriter fileWriter = new FileWriter(string2 + "ZoneInfoMappings.java", false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(m_header);
            bufferedWriter.write(" //\n // THIS FILE HAS BEEN GENERATED BY A TOOL. DO NOT EDIT THIS FILE MANUALLY.\n");
            bufferedWriter.write(" //   BASED ON : " + Main.getVersionName() + m_return + m_comment_null_line + m_return);
            bufferedWriter.write(m_PackageName);
            bufferedWriter.write("public class ZoneInfoMappings {\n\n");
            bufferedWriter.write("    public static final String[] IDs = {\n");
            for (n2 = 0; n2 < n3; ++n2) {
                TreeSet treeSet = (TreeSet)linkedList2.get(n2);
                iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    n = string.length();
                    n = n > 20 ? 1 : 21 - n;
                    bufferedWriter.write("\t\"" + string + "\",");
                    while (n-- > 0) {
                        bufferedWriter.write(" ");
                    }
                    bufferedWriter.write("\t// " + Time.toGMTFormat(linkedList.get(n2).toString()) + m_return);
                }
            }
            bufferedWriter.write(m_array_End);
            bufferedWriter.write("    public static final int[] rawOffsets = {\n");
            for (n2 = 0; n2 < n3; ++n2) {
                bufferedWriter.write("\t" + linkedList.get(n2) + ",\t// " + n2 + m_return);
            }
            bufferedWriter.write(m_array_End);
            bufferedWriter.write("    public static final byte[] rawOffsetIndices = {");
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                int n4 = ((TreeSet)linkedList2.get(i)).size();
                for (int j = 0; j < n4; ++j) {
                    if (n2++ % 10 == 0) {
                        bufferedWriter.write("\n\t");
                    }
                    if (i < 10) {
                        bufferedWriter.write(" ");
                    }
                    bufferedWriter.write(i + ", ");
                }
            }
            bufferedWriter.write("\n    };\n\n");
            bufferedWriter.write("    public static final String[] aliases = {\n");
            Set set = treeMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                n = string.length();
                n = n > 20 ? 1 : 21 - n;
                bufferedWriter.write("\t\"" + string + "\",");
                while (n-- > 0) {
                    bufferedWriter.write(" ");
                }
                bufferedWriter.write("\"" + treeMap.get(string) + "\",\n");
            }
            bufferedWriter.write("    };\n\n}\n");
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Main.panic("IO error: " + iOException.getMessage());
            return 1;
        }
        return 0;
    }
}

