/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap.oldjavap;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import sun.tools.java.BinaryAttribute;
import sun.tools.java.BinaryCode;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.BinaryExceptionHandler;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.MethodType;
import sun.tools.javap.oldjavap.ConstantPrinter;
import sun.tools.javap.oldjavap.JavaPEnvironment;

class JavaPBinaryCode
extends BinaryCode
implements Constants {
    private JavaPEnvironment env;
    private PrintWriter output;
    private byte[] codeBytes;
    private BinaryConstantPool cpool;
    private ConstantPrinter constPrint;
    private MemberDefinition fieldDef;
    private String methodName;
    private int offset;

    JavaPBinaryCode(byte[] byArray, BinaryConstantPool binaryConstantPool, JavaPEnvironment javaPEnvironment, MemberDefinition memberDefinition) {
        super(byArray, binaryConstantPool, javaPEnvironment);
        this.output = javaPEnvironment.output;
        this.codeBytes = this.getCode();
        this.cpool = binaryConstantPool;
        this.constPrint = new ConstantPrinter(binaryConstantPool, javaPEnvironment, this.output, !javaPEnvironment.showBackwardCompatible);
        this.fieldDef = memberDefinition;
        this.methodName = memberDefinition.toString();
    }

    MemberDefinition fieldDefinition() {
        return this.fieldDef;
    }

    private final int at(int n) {
        return this.codeBytes[this.offset + n] & 0xFF;
    }

    private final int shortAt(int n) {
        int n2 = this.offset + n;
        return (this.codeBytes[n2] & 0xFF) << 8 | this.codeBytes[n2 + 1] & 0xFF;
    }

    private final long intAt(int n, int n2) {
        int n3 = n + (n2 << 2);
        return this.codeBytes[n3] << 24 | (this.codeBytes[n3 + 1] & 0xFF) << 16 | (this.codeBytes[n3 + 2] & 0xFF) << 8 | this.codeBytes[n3 + 3] & 0xFF;
    }

    private void printFixedWidthInt(long l, int n) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.print(l);
        String string = charArrayWriter.toString();
        for (int i = n - string.length(); i > 0; --i) {
            this.output.print(' ');
        }
        this.output.print(string);
    }

    void printCodeSequence() throws IOException {
        this.output.println();
        this.output.println("Method " + this.methodName);
        this.offset = 0;
        while (this.offset < this.codeBytes.length) {
            int n = this.at(0);
            this.printFixedWidthInt(this.offset, 4);
            this.output.print(" ");
            if (n == 196) {
                n = this.at(1);
                this.output.print(opcNames[n] + "_w ");
                int n2 = this.shortAt(2);
                switch (n) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        this.output.print(n2);
                        this.offset += 4;
                        break;
                    }
                    case 132: {
                        this.output.print(n2 + " " + (short)this.shortAt(4));
                        this.offset += 6;
                        break;
                    }
                    default: {
                        this.output.print("Invalid opcode");
                        ++this.offset;
                        break;
                    }
                }
            } else {
                this.output.print(opcNames[n]);
                switch (n) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        this.output.print(" " + this.at(1));
                        this.offset += 2;
                        break;
                    }
                    case 132: {
                        this.output.print(" " + this.at(1) + " " + (byte)this.at(2));
                        this.offset += 3;
                        break;
                    }
                    case 170: {
                        int n3 = this.offset + 1 + 3 & 0xFFFFFFFC;
                        long l = this.intAt(n3, 0);
                        long l2 = this.intAt(n3, 1);
                        long l3 = this.intAt(n3, 2);
                        this.output.print(" " + l2 + " to " + l3 + ": default=");
                        this.output.print((long)this.offset + l);
                        n3 += 12;
                        for (long i = l2; i <= l3; ++i) {
                            this.output.println("");
                            this.output.print('\t');
                            this.printFixedWidthInt(i, 5);
                            this.output.print(": " + ((long)this.offset + this.intAt(n3, (int)(i - l2))));
                        }
                        this.offset = n3 + (int)(l3 - l2 + 1L << 2);
                        break;
                    }
                    case 171: {
                        int n4 = this.offset + 1 + 3 & 0xFFFFFFFC;
                        long l = this.intAt(n4, 0);
                        int n5 = (int)this.intAt(n4, 1);
                        int n6 = n5 * 2;
                        this.output.print(" " + n5);
                        this.output.print(": default=" + ((long)this.offset + l));
                        n4 += 8;
                        for (int i = 0; i < n6; i += 2) {
                            this.output.println("");
                            this.output.print('\t');
                            this.printFixedWidthInt(this.intAt(n4, i), 5);
                            this.output.print(": " + ((long)this.offset + this.intAt(n4, i + 1)));
                        }
                        this.offset = n4 + (n6 << 2);
                        break;
                    }
                    case 188: {
                        switch (this.at(1)) {
                            case 10: {
                                this.output.print(" int");
                                break;
                            }
                            case 11: {
                                this.output.print(" long");
                                break;
                            }
                            case 6: {
                                this.output.print(" float");
                                break;
                            }
                            case 7: {
                                this.output.print(" double");
                                break;
                            }
                            case 5: {
                                this.output.print(" char");
                                break;
                            }
                            case 9: {
                                this.output.print(" short");
                                break;
                            }
                            case 8: {
                                this.output.print(" byte");
                                break;
                            }
                            case 4: {
                                this.output.print(" boolean");
                                break;
                            }
                            default: {
                                this.output.print(" BOGUS TYPE");
                            }
                        }
                        this.offset += 2;
                        break;
                    }
                    case 189: {
                        int n7 = this.shortAt(1);
                        this.output.print(" class #" + n7 + " ");
                        this.constPrint.printConstant(n7);
                        this.offset += 3;
                        break;
                    }
                    case 17: {
                        this.output.print(" " + (short)this.shortAt(1));
                        this.offset += 3;
                        break;
                    }
                    case 16: {
                        this.output.print(" " + (byte)this.at(1));
                        this.offset += 2;
                        break;
                    }
                    case 18: {
                        int n8 = this.at(1);
                        this.output.print(" #" + n8 + " ");
                        this.constPrint.printConstant(n8);
                        this.offset += 2;
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 187: 
                    case 192: 
                    case 193: {
                        int n9 = this.shortAt(1);
                        this.output.print(" #" + n9 + " ");
                        this.constPrint.printConstant(n9);
                        this.offset += 3;
                        break;
                    }
                    case 185: {
                        int n10 = this.shortAt(1);
                        this.output.print(" (args " + this.at(3) + ") #" + n10 + " ");
                        this.constPrint.printConstant(n10);
                        this.offset += 5;
                        break;
                    }
                    case 197: {
                        int n11 = this.shortAt(1);
                        this.output.print(" #" + n11 + " dim #" + this.at(3) + " ");
                        this.constPrint.printConstant(n11);
                        this.offset += 4;
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 198: 
                    case 199: {
                        int n12 = this.offset + (short)this.shortAt(1);
                        this.output.print(" " + n12);
                        this.offset += 3;
                        break;
                    }
                    case 200: 
                    case 201: {
                        long l = (long)this.offset + this.intAt(this.offset + 1, 0);
                        this.output.print(" " + l);
                        this.offset += 5;
                        break;
                    }
                    default: {
                        ++this.offset;
                    }
                }
            }
            this.output.println();
        }
    }

    void printExceptionTable() throws IOException {
        BinaryExceptionHandler[] binaryExceptionHandlerArray = this.getExceptionHandlers();
        if (binaryExceptionHandlerArray.length > 0) {
            this.output.println("Exception table:");
            this.output.println("   from   to  target type");
            for (int i = 0; i < binaryExceptionHandlerArray.length; ++i) {
                BinaryExceptionHandler binaryExceptionHandler = binaryExceptionHandlerArray[i];
                this.printFixedWidthInt(binaryExceptionHandler.startPC, 6);
                this.printFixedWidthInt(binaryExceptionHandler.endPC, 6);
                this.printFixedWidthInt(binaryExceptionHandler.handlerPC, 6);
                this.output.print("   ");
                ClassDeclaration classDeclaration = binaryExceptionHandler.exceptionClass;
                if (classDeclaration == null) {
                    this.output.println("any");
                    continue;
                }
                this.constPrint.printClassDeclaration(classDeclaration);
                this.output.println("");
            }
        }
    }

    private DataInputStream findAttribute(Identifier identifier) {
        for (BinaryAttribute binaryAttribute = this.getAttributes(); binaryAttribute != null; binaryAttribute = binaryAttribute.getNextAttribute()) {
            if (!binaryAttribute.getName().equals(identifier)) continue;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(binaryAttribute.getData());
            return new DataInputStream(byteArrayInputStream);
        }
        return null;
    }

    void printLineNumberTable() throws IOException {
        int n;
        DataInputStream dataInputStream = this.findAttribute(idLineNumberTable);
        if (dataInputStream != null && (n = dataInputStream.readShort()) > 0) {
            this.output.println("");
            this.output.println("Line numbers for method " + this.methodName);
            for (int i = n; i > 0; --i) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                this.output.println("   line " + s2 + ": " + s);
            }
        }
    }

    void printLocalVariableTable() throws IOException {
        int n;
        DataInputStream dataInputStream = this.findAttribute(idLocalVariableTable);
        if (dataInputStream != null && (n = dataInputStream.readShort()) > 0) {
            this.output.println("");
            this.output.println("Local variables for method " + this.methodName);
            for (int i = n; i > 0; --i) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                short s4 = dataInputStream.readShort();
                short s5 = dataInputStream.readShort();
                this.output.print("   ");
                this.output.print(this.cpool.getType(s4));
                this.output.print(" ");
                this.output.print(this.cpool.getString(s3));
                this.output.println("  pc=" + s + ", length=" + s2 + ", slot=" + s5);
            }
        }
    }

    void printVerboseHeader() {
        MethodType methodType = (MethodType)this.fieldDef.getType();
        int n = methodType.getArgumentTypes().length;
        if (!this.fieldDef.isStatic()) {
            ++n;
        }
        this.output.println("\t/* Stack=" + this.getMaxStack() + ", Locals=" + this.getMaxLocals() + ", Args_size=" + n + " */");
    }
}

