/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Vector;
import sun.tools.javap.AttrData;
import sun.tools.javap.CPX;
import sun.tools.javap.CPX2;
import sun.tools.javap.ClassData;
import sun.tools.javap.FieldData;
import sun.tools.javap.InnerClassData;
import sun.tools.javap.JavapEnvironment;
import sun.tools.javap.LineNumData;
import sun.tools.javap.LocVarData;
import sun.tools.javap.MethodData;
import sun.tools.javap.RuntimeConstants;
import sun.tools.javap.Tables;
import sun.tools.javap.TrapData;

public class JavapPrinter
implements RuntimeConstants {
    JavapEnvironment env;
    ClassData cls;
    byte[] code;
    String lP = "";
    PrintWriter out;

    public JavapPrinter(InputStream inputStream, PrintWriter printWriter, JavapEnvironment javapEnvironment) {
        this.out = printWriter;
        this.cls = new ClassData(inputStream);
        this.env = javapEnvironment;
    }

    public void print() {
        if (this.env.showBackwardCompatible) {
            System.out.println("Sorry! We no longer support backward compatibility.");
            System.exit(0);
        }
        this.printclassHeader();
        this.printfields();
        this.printMethods();
        this.printend();
    }

    public void printclassHeader() {
        String[] stringArray;
        this.out.println("Compiled from " + this.javaclassname(this.cls.getSourceName()));
        if (this.cls.isInterface()) {
            this.out.print("interface " + this.javaclassname(this.cls.getClassName()));
        } else if (this.cls.isClass()) {
            stringArray = this.cls.getAccess();
            this.printAccess(stringArray);
            this.out.print("class " + this.javaclassname(this.cls.getClassName()));
            if (this.cls.getSuperClassName() != null) {
                this.out.print(" extends " + this.javaclassname(this.cls.getSuperClassName()));
            }
        }
        stringArray = this.cls.getSuperInterfaces();
        if (stringArray.length > 0) {
            if (this.cls.isClass()) {
                this.out.print(" implements ");
            } else if (this.cls.isInterface()) {
                this.out.print(" extends ");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.out.print(this.javaclassname(stringArray[i]));
                if (i + 1 >= stringArray.length) continue;
                this.out.print(",");
            }
        }
        if (this.env.showallAttr || this.env.showVerbose) {
            this.printClassAttributes();
        }
        if (this.env.showVerbose) {
            this.printverbosecls();
        }
        this.out.println("{");
    }

    public void printverbosecls() {
        this.out.println("  minor version: " + this.cls.getMinor_version());
        this.out.println("  major version: " + this.cls.getMajor_version());
        this.out.println("  Constant pool:");
        this.printcp();
        this.env.showallAttr = true;
    }

    public void printClassAttributes() {
        this.out.println();
        AttrData[] attrDataArray = this.cls.getAttributes();
        for (int i = 0; i < attrDataArray.length; ++i) {
            String string = attrDataArray[i].getAttrName();
            if (string.equals("SourceFile")) {
                this.out.println("  SourceFile: " + this.cls.getSourceName());
                continue;
            }
            if (string.equals("InnerClasses")) {
                this.printInnerClasses();
                continue;
            }
            this.printAttrData(attrDataArray[i]);
        }
    }

    public void printfields() {
        FieldData[] fieldDataArray = this.cls.getFields();
        for (int i = 0; i < fieldDataArray.length; ++i) {
            String[] stringArray = fieldDataArray[i].getAccess();
            if (!this.checkAccess(stringArray)) continue;
            if (!(this.env.showLineAndLocal || this.env.showDisassembled || this.env.showVerbose || this.env.showInternalSigs || this.env.showallAttr)) {
                this.out.print("    ");
            }
            this.printAccess(stringArray);
            this.out.println(fieldDataArray[i].getType() + " " + fieldDataArray[i].getName() + ";");
            if (this.env.showInternalSigs) {
                this.out.println("  Signature: " + fieldDataArray[i].getInternalSig());
            }
            if (this.env.showallAttr) {
                this.printFieldAttributes(fieldDataArray[i]);
            }
            if (!this.env.showDisassembled && !this.env.showLineAndLocal) continue;
            this.out.println();
        }
    }

    public void printFieldAttributes(FieldData fieldData) {
        Vector vector = fieldData.getAttributes();
        for (int i = 0; i < vector.size(); ++i) {
            String string = ((AttrData)vector.elementAt(i)).getAttrName();
            if (string.equals("ConstantValue")) {
                this.printConstantValue(fieldData);
                continue;
            }
            if (string.equals("  Deprecated")) {
                this.out.println("Deprecated: " + fieldData.isDeprecated());
                continue;
            }
            if (string.equals("Synthetic")) {
                this.out.println("  Synthetic: " + fieldData.isSynthetic());
                continue;
            }
            this.printAttrData((AttrData)vector.elementAt(i));
        }
        this.out.println();
    }

    public void printMethods() {
        MethodData[] methodDataArray = this.cls.getMethods();
        for (int i = 0; i < methodDataArray.length; ++i) {
            String[] stringArray = methodDataArray[i].getAccess();
            if (!this.checkAccess(stringArray)) continue;
            if (!(this.env.showLineAndLocal || this.env.showDisassembled || this.env.showVerbose || this.env.showInternalSigs || this.env.showallAttr)) {
                this.out.print("    ");
            }
            this.printMethodSignature(methodDataArray[i], stringArray);
            this.printExceptions(methodDataArray[i]);
            if (this.env.showInternalSigs) {
                this.out.println("  Signature: " + methodDataArray[i].getInternalSig());
            }
            if (this.env.showDisassembled) {
                this.printcodeSequence(methodDataArray[i]);
                this.printExceptionTable(methodDataArray[i]);
                this.out.println();
            }
            if (this.env.showLineAndLocal) {
                this.printLineNumTable(methodDataArray[i]);
                this.printLocVarTable(methodDataArray[i]);
                this.out.println();
            }
            if (!this.env.showallAttr) continue;
            this.printMethodAttributes(methodDataArray[i]);
        }
    }

    public void printMethodSignature(MethodData methodData, String[] stringArray) {
        this.printAccess(stringArray);
        if (methodData.getName().equals("<init>")) {
            this.out.print(this.javaclassname(this.cls.getClassName()));
            this.out.print(methodData.getParameters());
        } else if (methodData.getName().equals("<clinit>")) {
            this.out.print("{}");
        } else {
            this.out.print(methodData.getReturnType() + " ");
            this.out.print(methodData.getName());
            this.out.print(methodData.getParameters());
        }
        this.out.println(";");
    }

    public void printMethodAttributes(MethodData methodData) {
        Vector vector = methodData.getAttributes();
        Vector vector2 = methodData.getCodeAttributes();
        for (int i = 0; i < vector.size(); ++i) {
            String string = ((AttrData)vector.elementAt(i)).getAttrName();
            if (string.equals("Code")) {
                this.printcodeSequence(methodData);
                this.printExceptionTable(methodData);
                for (int j = 0; j < vector2.size(); ++j) {
                    String string2 = ((AttrData)vector2.elementAt(j)).getAttrName();
                    if (string2.equals("LineNumberTable")) {
                        this.printLineNumTable(methodData);
                        continue;
                    }
                    if (string2.equals("LocalVariableTable")) {
                        this.printLocVarTable(methodData);
                        continue;
                    }
                    this.printAttrData((AttrData)vector2.elementAt(j));
                }
                continue;
            }
            if (string.equals("Exceptions")) {
                this.out.println("  Exceptions: ");
                this.printExceptions(methodData);
                continue;
            }
            if (string.equals("Deprecated")) {
                this.out.println("  Deprecated: " + methodData.isDeprecated());
                continue;
            }
            if (string.equals("Synthetic")) {
                this.out.println("  Synthetic: " + methodData.isSynthetic());
                continue;
            }
            this.printAttrData((AttrData)vector.elementAt(i));
        }
        this.out.println();
    }

    public void printExceptions(MethodData methodData) {
        int[] nArray = methodData.get_exc_index_table();
        if (nArray != null) {
            if (!(this.env.showLineAndLocal || this.env.showDisassembled || this.env.showVerbose || this.env.showInternalSigs || this.env.showallAttr)) {
                this.out.print("    ");
            }
            this.out.print("   throws ");
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                this.out.print(this.cls.getClassName(nArray[i]));
                if (i >= n - 1) continue;
                this.out.print(", ");
            }
            this.out.println();
        }
    }

    public void printcodeSequence(MethodData methodData) {
        this.code = methodData.getCode();
        if (this.code != null) {
            this.out.println("  Code:");
            if (this.env.showVerbose) {
                this.printVerboseHeader(methodData);
            }
            for (int i = 0; i < this.code.length; i += this.printInstr(i)) {
                this.out.print("   " + i + ":\t");
                this.out.println();
            }
        }
    }

    public int printInstr(int n) {
        int n2 = this.getUbyte(n);
        switch (n2) {
            case 254: 
            case 255: {
                int n3 = this.getUbyte(n + 1);
                String string = Tables.opcName((n2 << 8) + n3);
                if (string == null) {
                    string = Tables.opcName(n2) + " " + n3;
                }
                this.out.print(string);
                return 2;
            }
            case 196: {
                int n4 = this.getUbyte(n + 1);
                String string = Tables.opcName((n2 << 8) + n4);
                if (string == null) {
                    this.out.print("bytecode " + n2);
                    return 1;
                }
                this.out.print(string + " " + this.getUShort(n + 2));
                if (n4 == 132) {
                    this.out.print(", " + this.getShort(n + 4));
                    return 6;
                }
                return 4;
            }
        }
        String string = Tables.opcName(n2);
        if (string == null) {
            this.out.print("bytecode " + n2);
            return 1;
        }
        if (n2 > 201) {
            this.out.print("bytecode " + n2);
            return 1;
        }
        this.out.print(Tables.opcName(n2));
        switch (n2) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                this.out.print("\t" + this.getUbyte(n + 1));
                return 2;
            }
            case 132: {
                this.out.print("\t" + this.getUbyte(n + 1) + ", " + this.getbyte(n + 2));
                return 3;
            }
            case 170: {
                int n5 = JavapPrinter.align(n + 1);
                int n6 = this.getInt(n5);
                int n7 = this.getInt(n5 + 4);
                int n8 = this.getInt(n5 + 8);
                int n9 = n8 - n7;
                this.out.print("{ //" + n7 + " to " + n8);
                for (int i = 0; i <= n9; ++i) {
                    this.out.print("\n\t\t" + (i + n7) + ": " + this.lP + (n + this.getInt(n5 + 12 + 4 * i)) + ";");
                }
                this.out.print("\n\t\tdefault: " + this.lP + (n6 + n) + " }");
                return n5 - n + 16 + n9 * 4;
            }
            case 171: {
                int n10 = JavapPrinter.align(n + 1);
                int n11 = this.getInt(n10);
                int n12 = this.getInt(n10 + 4);
                this.out.print("{ //" + n12);
                for (int i = 1; i <= n12; ++i) {
                    this.out.print("\n\t\t" + this.getInt(n10 + i * 8) + ": " + this.lP + (n + this.getInt(n10 + 4 + i * 8)) + ";");
                }
                this.out.print("\n\t\tdefault: " + this.lP + (n11 + n) + " }");
                return n10 - n + (n12 + 1) * 8;
            }
            case 188: {
                int n13 = this.getUbyte(n + 1);
                switch (n13) {
                    case 4: {
                        this.out.print(" boolean");
                        break;
                    }
                    case 8: {
                        this.out.print(" byte");
                        break;
                    }
                    case 5: {
                        this.out.print(" char");
                        break;
                    }
                    case 9: {
                        this.out.print(" short");
                        break;
                    }
                    case 10: {
                        this.out.print(" int");
                        break;
                    }
                    case 11: {
                        this.out.print(" long");
                        break;
                    }
                    case 6: {
                        this.out.print(" float");
                        break;
                    }
                    case 7: {
                        this.out.print(" double");
                        break;
                    }
                    case 2: {
                        this.out.print(" class");
                        break;
                    }
                    default: {
                        this.out.print(" BOGUS TYPE:" + n13);
                    }
                }
                return 2;
            }
            case 189: {
                int n14 = this.getUShort(n + 1);
                this.out.print("\t#" + n14 + "; //");
                this.PrintConstant(n14);
                return 3;
            }
            case 17: {
                this.out.print("\t" + this.getShort(n + 1));
                return 3;
            }
            case 16: {
                this.out.print("\t" + this.getbyte(n + 1));
                return 2;
            }
            case 18: {
                int n15 = this.getUbyte(n + 1);
                this.out.print("\t#" + n15 + "; //");
                this.PrintConstant(n15);
                return 2;
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 192: 
            case 193: {
                int n16 = this.getUShort(n + 1);
                this.out.print("\t#" + n16 + "; //");
                this.PrintConstant(n16);
                return 3;
            }
            case 185: {
                int n17 = this.getUShort(n + 1);
                int n18 = this.getUbyte(n + 3);
                this.out.print("\t#" + n17 + ",  " + n18 + "; //");
                this.PrintConstant(n17);
                return 5;
            }
            case 197: {
                int n19 = this.getUShort(n + 1);
                int n20 = this.getUbyte(n + 3);
                this.out.print("\t#" + n19 + ",  " + n20 + "; //");
                this.PrintConstant(n19);
                return 4;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.out.print("\t" + this.lP + (n + this.getShort(n + 1)));
                return 3;
            }
            case 200: 
            case 201: {
                this.out.print("\t" + this.lP + (n + this.getInt(n + 1)));
                return 5;
            }
        }
        return 1;
    }

    public void printVerboseHeader(MethodData methodData) {
        int n = methodData.getArgumentlength();
        if (!methodData.isStatic()) {
            ++n;
        }
        this.out.println("   Stack=" + methodData.getMaxStack() + ", Locals=" + methodData.getMaxLocals() + ", Args_size=" + n);
    }

    void printExceptionTable(MethodData methodData) {
        Vector vector = methodData.getexception_table();
        if (vector.size() > 0) {
            this.out.print("  Exception table:\n   from   to  target type\n");
            for (int i = 0; i < vector.size(); ++i) {
                TrapData trapData = (TrapData)vector.elementAt(i);
                this.printFixedWidthInt(trapData.start_pc, 6);
                this.printFixedWidthInt(trapData.end_pc, 6);
                this.printFixedWidthInt(trapData.handler_pc, 6);
                this.out.print("   ");
                short s = trapData.catch_cpx;
                if (s == 0) {
                    this.out.println("any");
                    continue;
                }
                this.out.print("Class ");
                this.out.println(this.cls.getClassName(s));
                this.out.println("");
            }
        }
    }

    public void printLineNumTable(MethodData methodData) {
        int n = methodData.getnumlines();
        Vector vector = methodData.getlin_num_tb();
        if (vector.size() > 0) {
            this.out.println("  LineNumberTable: ");
            for (int i = 0; i < n; ++i) {
                LineNumData lineNumData = (LineNumData)vector.elementAt(i);
                this.out.println("   line " + lineNumData.line_number + ": " + lineNumData.start_pc);
            }
        }
    }

    public void printLocVarTable(MethodData methodData) {
        int n = methodData.getloc_var_tbsize();
        if (n > 0) {
            this.out.println("  LocalVariableTable: ");
            this.out.print("   ");
            this.out.println("Start  Length  Slot  Name   Signature");
        }
        Vector vector = methodData.getloc_var_tb();
        for (int i = 0; i < n; ++i) {
            LocVarData locVarData = (LocVarData)vector.elementAt(i);
            this.out.println("   " + locVarData.start_pc + "      " + locVarData.length + "      " + locVarData.slot + "    " + this.cls.StringValue(locVarData.name_cpx) + "       " + this.cls.StringValue(locVarData.sig_cpx));
        }
    }

    public void printConstantValue(FieldData fieldData) {
        this.out.print("  Constant value: ");
        int n = fieldData.getConstantValueIndex();
        byte by = 0;
        try {
            by = this.cls.getTag(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.out.print("Error:");
            return;
        }
        switch (by) {
            case 9: 
            case 10: 
            case 11: {
                CPX2 cPX2 = this.cls.getCpoolEntry(n);
                if (cPX2.cpx1 != this.cls.getthis_cpx()) break;
                n = cPX2.cpx2;
            }
        }
        this.out.print(this.cls.TagString(by) + " " + this.cls.StringValue(n));
    }

    public void printInnerClasses() {
        InnerClassData[] innerClassDataArray = this.cls.getInnerClasses();
        if (innerClassDataArray != null && innerClassDataArray.length > 0) {
            this.out.print("  ");
            this.out.println("InnerClass: ");
            for (int i = 0; i < innerClassDataArray.length; ++i) {
                this.out.print("   ");
                String[] stringArray = innerClassDataArray[i].getAccess();
                if (!this.checkAccess(stringArray)) continue;
                this.printAccess(stringArray);
                if (innerClassDataArray[i].inner_name_index != 0) {
                    this.out.print("#" + innerClassDataArray[i].inner_name_index + "= ");
                }
                this.out.print("#" + innerClassDataArray[i].inner_class_info_index);
                if (innerClassDataArray[i].outer_class_info_index != 0) {
                    this.out.print(" of #" + innerClassDataArray[i].outer_class_info_index);
                }
                this.out.print("; //");
                if (innerClassDataArray[i].inner_name_index != 0) {
                    this.out.print(this.cls.getName(innerClassDataArray[i].inner_name_index) + "=");
                }
                this.PrintConstant(innerClassDataArray[i].inner_class_info_index);
                if (innerClassDataArray[i].outer_class_info_index != 0) {
                    this.out.print(" of ");
                    this.PrintConstant(innerClassDataArray[i].outer_class_info_index);
                }
                this.out.println();
            }
        }
    }

    public void printcp() {
        for (int i = 1; i < this.cls.getCpoolCount(); i += this.PrintlnConstantEntry(i)) {
            this.out.print("const #" + i + " = ");
        }
        this.out.println();
    }

    public int PrintlnConstantEntry(int n) {
        int n2 = 1;
        byte by = 0;
        try {
            by = this.cls.getTag(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.out.println("  <Incorrect CP index>");
            return 1;
        }
        this.out.print(this.cls.StringTag(n) + "\t");
        Object object = this.cls.getCpoolEntryobj(n);
        if (object == null) {
            switch (by) {
                case 5: 
                case 6: {
                    n2 = 2;
                }
            }
            this.out.println("null;");
            return n2;
        }
        String string = this.cls.StringValue(n);
        switch (by) {
            case 7: 
            case 8: {
                this.out.println("#" + ((CPX)object).cpx + ";\t//  " + string);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.out.println("#" + ((CPX2)object).cpx1 + ".#" + ((CPX2)object).cpx2 + ";\t//  " + string);
                break;
            }
            case 12: {
                this.out.println("#" + ((CPX2)object).cpx1 + ":#" + ((CPX2)object).cpx2 + ";//  " + string);
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
            }
            default: {
                this.out.println(string + ";");
            }
        }
        return n2;
    }

    public boolean checkAccess(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("public")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("protected")) {
                bl2 = true;
                continue;
            }
            if (!stringArray[i].equals("private")) continue;
            bl3 = true;
        }
        if (!(bl || bl2 || bl3)) {
            bl4 = true;
        }
        if (this.env.showAccess == 3 && (bl2 || bl3 || bl4)) {
            return false;
        }
        if (this.env.showAccess == 1 && (bl3 || bl4)) {
            return false;
        }
        return this.env.showAccess != 2 || !bl3;
    }

    public void printAccess(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.print(stringArray[i] + " ");
        }
    }

    public void printFixedWidthInt(long l, int n) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.print(l);
        String string = charArrayWriter.toString();
        for (int i = n - string.length(); i > 0; --i) {
            this.out.print(' ');
        }
        this.out.print(string);
    }

    protected int getbyte(int n) {
        return this.code[n];
    }

    protected int getUbyte(int n) {
        return this.code[n] & 0xFF;
    }

    int getShort(int n) {
        return this.code[n] << 8 | this.code[n + 1] & 0xFF;
    }

    int getUShort(int n) {
        return (this.code[n] << 8 | this.code[n + 1] & 0xFF) & 0xFFFF;
    }

    protected int getInt(int n) {
        return this.getShort(n) << 16 | this.getShort(n + 2) & 0xFFFF;
    }

    void PrintConstant(int n) {
        if (n == 0) {
            this.out.print("#0");
            return;
        }
        byte by = 0;
        try {
            by = this.cls.getTag(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.out.print("#" + n);
            return;
        }
        switch (by) {
            case 9: 
            case 10: 
            case 11: {
                CPX2 cPX2 = this.cls.getCpoolEntry(n);
                if (cPX2.cpx1 != this.cls.getthis_cpx()) break;
                n = cPX2.cpx2;
            }
        }
        this.out.print(this.cls.TagString(by) + " " + this.cls.StringValue(n));
    }

    protected static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public void printend() {
        this.out.println("}");
        this.out.println();
    }

    public String javaclassname(String string) {
        return string.replace('/', '.');
    }

    public void printAttrData(AttrData attrData) {
        byte[] byArray = attrData.getData();
        int n = 0;
        this.out.print("  " + attrData.getAttrName() + ": ");
        this.out.println("length = " + ClassData.toHex(attrData.datalen));
        this.out.print("   ");
        for (int i = 0; i < byArray.length; ++i) {
            String string = ClassData.toHex(byArray[i]);
            if (string.equals("0x")) {
                this.out.print("00");
            } else if (string.substring(2).length() == 1) {
                this.out.print("0" + string.substring(2));
            } else {
                this.out.print(string.substring(2));
            }
            if (++n == 16) {
                this.out.println();
                this.out.print("   ");
                n = 0;
                continue;
            }
            this.out.print(" ");
        }
        this.out.println();
    }
}

