/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.crunch.Attribute;
import sun.tools.crunch.ClassFile;
import sun.tools.crunch.CodeAttribute;
import sun.tools.crunch.GlobalTables;

public class Field {
    protected ClassFile cfile;
    short flags;
    protected short nameIndex;
    protected short typeIndex;
    protected Attribute[] attributes;
    private static int totalCount;
    private static int totalPrivates;
    private static int totalAttributes;
    private static int writtenLength;

    public static Field read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        return new Field(classFile, dataInputStream);
    }

    protected Field() {
    }

    private Field(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        this.cfile = classFile;
        ++totalCount;
        this.flags = dataInputStream.readShort();
        if ((this.flags & 2) != 0) {
            ++totalPrivates;
        }
        this.nameIndex = dataInputStream.readShort();
        this.typeIndex = dataInputStream.readShort();
        this.attributes = Attribute.readAttributes(classFile, dataInputStream);
        totalAttributes += this.attributes.length;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        String string = this.cfile.getClassName();
        String string2 = this.cfile.constants[this.nameIndex].utf;
        String string3 = this.cfile.constants[this.typeIndex].utf;
        CodeAttribute codeAttribute = null;
        if ((this.flags & 0xF000) != 0) {
            throw new Error("Unexpected flag bits: " + this.cfile.getName() + "." + string2 + "  0x" + Integer.toString(this.flags, 16));
        }
        int n2 = 0;
        for (n = 0; n < this.attributes.length; ++n) {
            CodeAttribute codeAttribute2;
            if (this.attributes[n] instanceof CodeAttribute && (codeAttribute2 = (CodeAttribute)this.attributes[n]).isSmall()) {
                codeAttribute = codeAttribute2;
                this.flags = (short)(this.flags | 0x2000);
                continue;
            }
            ++n2;
        }
        if (n2 > 0) {
            this.flags = (short)(this.flags | 0x8000);
        }
        if ((this.flags & 1) == 0) {
            this.flags = (short)(this.flags | 0x4000);
        } else if (GlobalTables.existsRef(string, string2, string3)) {
            this.flags = (short)(this.flags | 0x4000);
        }
        dataOutputStream.writeShort(this.flags);
        writtenLength += 2;
        if ((this.flags & 0x4000) != 0) {
            dataOutputStream.writeShort(GlobalTables.findRef(string, string2, string3));
            writtenLength += 2;
        } else {
            dataOutputStream.writeShort(GlobalTables.findUtf(string2));
            dataOutputStream.writeShort(GlobalTables.findType(string3));
            writtenLength += 4;
        }
        if (n2 > 0) {
            dataOutputStream.writeByte(n2);
            ++writtenLength;
            for (n = 0; n < this.attributes.length; ++n) {
                if (this.attributes[n] == codeAttribute) continue;
                this.attributes[n].write(dataOutputStream);
            }
        }
        if (codeAttribute != null) {
            codeAttribute.writeSmall(dataOutputStream);
        }
    }

    public static void summarize() {
        System.out.print("    Total number of field definitions = " + totalCount);
        System.out.println(" (" + totalPrivates + " private)");
        System.out.println("        Total number of field attributes = " + totalAttributes);
        System.out.println("    Written length of field/method defs = " + writtenLength);
    }
}

