/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.crunch.Attribute;
import sun.tools.crunch.ClassFile;
import sun.tools.crunch.Constant;
import sun.tools.crunch.GlobalTables;
import sun.tools.java.RuntimeConstants;

public class CodeAttribute
extends Attribute
implements RuntimeConstants {
    private static int count;
    private static int totalExceptionBytes;
    private static int totalCodeLength;
    private static int expandedBytecodes;
    private static int skippedPadding;
    private static int mungedReturns;
    private static int fullWrites;
    private static int smallWrites;
    private ClassFile cfile;
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private short[] exStart;
    private short[] exEnd;
    private short[] exHandler;
    private short[] exClass;

    public static Attribute read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        return new CodeAttribute(classFile, dataInputStream);
    }

    private CodeAttribute(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        int n;
        ++count;
        this.cfile = classFile;
        dataInputStream.readInt();
        this.maxStack = dataInputStream.readShort();
        this.maxLocals = dataInputStream.readShort();
        int n2 = dataInputStream.readInt();
        if (n2 >= 65536) {
            throw new Error("Code block too long in " + this.cfile.getName());
        }
        totalCodeLength += n2;
        this.code = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = dataInputStream.read(this.code, i, n2 - i);
            if (n > 0) continue;
            throw new IOException("Couldn't read code");
        }
        n = dataInputStream.readShort();
        this.exStart = new short[n];
        this.exEnd = new short[n];
        this.exHandler = new short[n];
        this.exClass = new short[n];
        for (int i = 0; i < n; ++i) {
            this.exStart[i] = dataInputStream.readShort();
            this.exEnd[i] = dataInputStream.readShort();
            this.exHandler[i] = dataInputStream.readShort();
            this.exClass[i] = dataInputStream.readShort();
        }
        totalExceptionBytes += 8 * n;
        Attribute[] attributeArray = Attribute.readAttributes(classFile, dataInputStream);
        if (attributeArray.length != 0) {
            throw new Error("Unexpected code sub-attribute");
        }
    }

    public boolean isSmall() {
        return this.maxStack <= 15 && this.maxLocals <= 15 && this.exStart.length == 0;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        ++fullWrites;
        dataOutputStream.writeByte(1);
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        this.writeCode(dataOutputStream);
        this.writeExceptions(dataOutputStream);
    }

    public void writeSmall(DataOutputStream dataOutputStream) throws IOException {
        ++smallWrites;
        int n = this.maxStack << 4 | this.maxLocals;
        dataOutputStream.writeByte(n);
        this.writeCode(dataOutputStream);
    }

    private short shortAt(byte[] byArray, int n) {
        return (short)(this.code[n] << 8 | this.code[n + 1] & 0xFF);
    }

    private int intAt(byte[] byArray, int n) {
        return this.code[n] << 24 | this.code[n + 1] << 16 & 0xFF0000 | this.code[n + 2] << 8 & 0xFF00 | this.code[n + 3] & 0xFF;
    }

    private void writeCode(DataOutputStream dataOutputStream) throws IOException {
        int n = this.code.length;
        int n2 = 0;
        int n3 = 0;
        block21: while (n2 < n) {
            n3 = this.code[n2++] & 0xFF;
            if (n2 == n) {
                switch (n3) {
                    case 177: {
                        ++mungedReturns;
                        dataOutputStream.writeByte(254);
                        return;
                    }
                    case 176: {
                        ++mungedReturns;
                        dataOutputStream.writeByte(253);
                        return;
                    }
                    case 172: {
                        ++mungedReturns;
                        dataOutputStream.writeByte(252);
                        return;
                    }
                }
            }
            dataOutputStream.writeByte(n3);
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    continue block21;
                }
                case 16: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 17: 
                case 132: {
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 196: {
                    n3 = this.code[n2] & 0xFF;
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    if (n3 != 132) continue block21;
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 200: 
                case 201: {
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    short s = this.shortAt(this.code, n2);
                    n2 += 2;
                    s = this.cfile.mapRef(s);
                    dataOutputStream.writeShort(s);
                    continue block21;
                }
                case 185: {
                    short s = this.shortAt(this.code, n2);
                    n2 += 2;
                    s = this.cfile.mapRef(s);
                    dataOutputStream.writeShort(s);
                    dataOutputStream.writeByte(this.code[n2++]);
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    short s = this.shortAt(this.code, n2);
                    n2 += 2;
                    s = this.cfile.mapClass(s);
                    dataOutputStream.writeShort(s);
                    continue block21;
                }
                case 197: {
                    short s = this.shortAt(this.code, n2);
                    n2 += 2;
                    s = this.cfile.mapClass(s);
                    dataOutputStream.writeShort(s);
                    dataOutputStream.writeByte(this.code[n2++]);
                    continue block21;
                }
                case 18: {
                    short s = (short)(this.code[n2++] & 0xFF);
                    Constant constant = this.cfile.constants[s];
                    Object object = constant.getValue();
                    s = GlobalTables.findValue(object);
                    dataOutputStream.writeShort(s);
                    ++expandedBytecodes;
                    continue block21;
                }
                case 19: 
                case 20: {
                    short s = this.shortAt(this.code, n2);
                    n2 += 2;
                    Constant constant = this.cfile.constants[s];
                    Object object = constant.getValue();
                    s = GlobalTables.findValue(object);
                    dataOutputStream.writeShort(s);
                    continue block21;
                }
                case 170: {
                    int n4;
                    while ((n2 & 3) != 0) {
                        ++skippedPadding;
                        ++n2;
                    }
                    int n5 = this.intAt(this.code, n2);
                    int n6 = this.intAt(this.code, n2 + 4);
                    int n7 = this.intAt(this.code, n2 + 8);
                    for (n4 = 0; n4 < 12; ++n4) {
                        dataOutputStream.writeByte(this.code[n2++]);
                    }
                    int n8 = n7 - n6 + 1;
                    for (n4 = 0; n4 < 4 * n8; ++n4) {
                        dataOutputStream.writeByte(this.code[n2++]);
                    }
                    continue block21;
                }
                case 171: {
                    int n4;
                    while ((n2 & 3) != 0) {
                        ++skippedPadding;
                        ++n2;
                    }
                    int n5 = this.intAt(this.code, n2);
                    int n8 = this.intAt(this.code, n2 + 4);
                    for (n4 = 0; n4 < 8; ++n4) {
                        dataOutputStream.writeByte(this.code[n2++]);
                    }
                    for (n4 = 0; n4 < 8 * n8; ++n4) {
                        dataOutputStream.writeByte(this.code[n2++]);
                    }
                    continue block21;
                }
            }
            throw new Error("Unexpected opcode " + n3);
        }
        dataOutputStream.writeByte(255);
    }

    private void writeExceptions(DataOutputStream dataOutputStream) throws IOException {
        int n = this.exStart.length;
        dataOutputStream.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeShort(this.exStart[i]);
            dataOutputStream.writeShort(this.exEnd[i]);
            dataOutputStream.writeShort(this.exHandler[i]);
            short s = this.exClass[i];
            if (s != 0) {
                s = this.cfile.mapClass(s);
            }
            dataOutputStream.writeShort(s);
        }
    }

    public static void summarize() {
        System.out.println("    " + totalExceptionBytes / 8 + " exception handlers, total length = " + totalExceptionBytes + " bytes");
        System.out.println("    " + count + " code attributes, total bytecode length = " + totalCodeLength + " bytes");
        System.out.println("    total expanded ldc bytecodes = " + expandedBytecodes);
        System.out.println("    total skipped padding = " + -skippedPadding);
        System.out.println("    total munged returns = " + mungedReturns);
        System.out.println("    code writes => " + fullWrites + " full, " + smallWrites + " small");
    }
}

