/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.RawCommandLineLauncher;
import com.sun.tools.jdi.SharedMemoryAttachingConnector;
import com.sun.tools.jdi.SharedMemoryListeningConnector;
import com.sun.tools.jdi.SharedMemoryTransport;
import com.sun.tools.jdi.SocketAttachingConnector;
import com.sun.tools.jdi.SocketListeningConnector;
import com.sun.tools.jdi.SocketTransport;
import com.sun.tools.jdi.SunCommandLineLauncher;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineImpl;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class VirtualMachineManagerImpl
implements VirtualMachineManagerService {
    private List connectors = new ArrayList();
    private LaunchingConnector defaultConnector = null;
    private List targets = new ArrayList();
    private List connectionListeners = new ArrayList();
    private final ThreadGroup mainGroupForJDI;
    private ResourceBundle messages = null;
    private int vmSequenceNumber = 0;
    private static final int majorVersion = 1;
    private static final int minorVersion = 4;
    private static final String[] SAConnectorStrings = new String[]{"sun.jvm.hotspot.jdi.SACoreAttachingConnector", "sun.jvm.hotspot.jdi.SADebugServerAttachingConnector", "sun.jvm.hotspot.jdi.SAPIDAttachingConnector"};
    private static final String handshakeString = "JDWP-Handshake";
    static /* synthetic */ Class class$com$sun$tools$jdi$VirtualMachineManagerService;

    private void addSAConnectors() {
        for (int i = 0; i < SAConnectorStrings.length; ++i) {
            try {
                Class<?> clazz = Class.forName(SAConnectorStrings[i]);
                try {
                    Class[] classArray = new Class[]{class$com$sun$tools$jdi$VirtualMachineManagerService == null ? VirtualMachineManagerImpl.class$("com.sun.tools.jdi.VirtualMachineManagerService") : class$com$sun$tools$jdi$VirtualMachineManagerService};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{this};
                    this.addConnector((Connector)constructor.newInstance(objectArray));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("NoSuchMethodException while loading: " + SAConnectorStrings[i]);
                    noSuchMethodException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public VirtualMachineManagerImpl() {
        TransportService transportService;
        boolean bl = false;
        this.mainGroupForJDI = new ThreadGroup("JDI main");
        try {
            transportService = new SharedMemoryTransport();
            this.addConnector(new SunCommandLineLauncher(this, transportService));
            this.addConnector(new RawCommandLineLauncher(this, transportService));
            bl = true;
            this.addConnector(new SharedMemoryAttachingConnector(this));
            this.addConnector(new SharedMemoryListeningConnector(this));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        transportService = new SocketTransport();
        if (!bl) {
            this.addConnector(new SunCommandLineLauncher(this, transportService));
            this.addConnector(new RawCommandLineLauncher(this, transportService));
        }
        this.addConnector(new SocketAttachingConnector(this));
        this.addConnector(new SocketListeningConnector(this));
        this.addSAConnectors();
        LaunchingConnector launchingConnector = (LaunchingConnector)this.launchingConnectors().get(0);
        this.setDefaultConnector(launchingConnector);
    }

    public LaunchingConnector defaultConnector() {
        return this.defaultConnector;
    }

    public void setDefaultConnector(LaunchingConnector launchingConnector) {
        this.defaultConnector = launchingConnector;
    }

    public List launchingConnectors() {
        ArrayList arrayList = new ArrayList(this.connectors.size());
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof LaunchingConnector)) continue;
            arrayList.add(e);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List attachingConnectors() {
        ArrayList arrayList = new ArrayList(this.connectors.size());
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AttachingConnector)) continue;
            arrayList.add(e);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List listeningConnectors() {
        ArrayList arrayList = new ArrayList(this.connectors.size());
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ListeningConnector)) continue;
            arrayList.add(e);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List allConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public List connectedVirtualMachines() {
        return Collections.unmodifiableList(this.targets);
    }

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    void handshake(ConnectionService connectionService) throws IOException {
        int n;
        int n2 = handshakeString.length();
        for (n = 0; n < n2; ++n) {
            connectionService.sendByte((byte)handshakeString.charAt(n));
        }
        for (n = 0; n < n2; ++n) {
            byte by = connectionService.receiveByte();
            if (by == (byte)handshakeString.charAt(n)) continue;
            throw new IOException("Target failed to handshake.");
        }
    }

    public synchronized VirtualMachine createVirtualMachine(ConnectionService connectionService, Process process) throws IOException {
        this.handshake(connectionService);
        VirtualMachineImpl virtualMachineImpl = new VirtualMachineImpl(this, connectionService, process, ++this.vmSequenceNumber);
        this.targets.add(virtualMachineImpl);
        return virtualMachineImpl;
    }

    public VirtualMachine createVirtualMachine(ConnectionService connectionService) throws IOException {
        return this.createVirtualMachine(connectionService, null);
    }

    public void addVirtualMachine(VirtualMachine virtualMachine) {
        this.targets.add(virtualMachine);
    }

    void disposeVirtualMachine(VirtualMachine virtualMachine) {
        this.targets.remove(virtualMachine);
    }

    public int majorInterfaceVersion() {
        return 1;
    }

    public int minorInterfaceVersion() {
        return 4;
    }

    ThreadGroup mainGroupForJDI() {
        return this.mainGroupForJDI;
    }

    String getString(String string) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi");
        }
        return this.messages.getString(string);
    }
}

