/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.util;

import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.LayoutCharacters;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Options;
import com.sun.tools.javac.v8.util.Pair;
import com.sun.tools.javac.v8.util.Position;
import com.sun.tools.javac.v8.util.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Log
implements LayoutCharacters {
    private static final Context.Key logKey = new Context.Key();
    public static final Context.Key outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    private final int MaxErrors;
    private final int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    private Name sourcename;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set recorded = Set.make();
    private char[] buf = null;
    private int bp;
    private int lastLine;
    private static final String compilerRB = "com.sun.tools.javac.v8.resources.compiler";
    private static ResourceBundle messageRB;

    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        context.put(logKey, this);
        this.errWriter = printWriter;
        this.warnWriter = printWriter2;
        this.noticeWriter = printWriter3;
        Options options = Options.instance(context);
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-nowarn") == null;
        this.sourcename = Name.Table.instance((Context)context).__input;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
    }

    private int getIntOption(Options options, String string, int n) {
        String string2 = (String)options.get(string);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter printWriter = (PrintWriter)context.get(outKey);
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
            context.put(outKey, printWriter);
        }
        return printWriter;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, printWriter, printWriter, printWriter);
    }

    public static Log instance(Context context) {
        Log log = (Log)context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public Name useSource(Name name) {
        Name name2 = this.sourcename;
        this.sourcename = name;
        if (name2 != this.sourcename) {
            this.buf = null;
        }
        return name2;
    }

    public Name currentSource() {
        return this.sourcename;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort"));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrLine(int n, int n2, PrintWriter printWriter) {
        try {
            int n3;
            Object[] objectArray;
            if (this.buf == null) {
                int n4;
                int n5;
                File file = new File(this.sourcename.toString());
                objectArray = new char[(int)file.length()];
                InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
                for (n4 = 0; (n5 = inputStreamReader.read((char[])objectArray, n4, objectArray.length - n4)) != -1 && n4 != objectArray.length; n4 += n5) {
                }
                if (n4 == objectArray.length) {
                    this.buf = objectArray;
                } else {
                    this.buf = new char[n4];
                    System.arraycopy(objectArray, 0, this.buf, 0, this.buf.length);
                }
                inputStreamReader.close();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > n) {
                this.bp = 0;
                this.lastLine = 1;
            }
            block10: while (this.bp < this.buf.length && this.lastLine < n) {
                switch (this.buf[this.bp]) {
                    case '\r': {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == '\n') {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        continue block10;
                    }
                    case '\n': {
                        ++this.bp;
                        ++this.lastLine;
                        continue block10;
                    }
                }
                ++this.bp;
            }
            for (n3 = this.bp; n3 < this.buf.length && this.buf[n3] != '\r' && this.buf[n3] != '\n'; ++n3) {
            }
            Log.printLines(printWriter, new String(this.buf, this.bp, n3 - this.bp));
            if (n2 == 0) {
                n2 = 1;
            }
            objectArray = new byte[n2];
            for (int i = 0; i < n2 - 1; ++i) {
                objectArray[i] = 32;
            }
            objectArray[n2 - 1] = 94;
            Log.printLines(printWriter, new String((byte[])objectArray, 0, n2, "UTF-8"));
        }
        catch (IOException iOException) {
            Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable"));
        }
        finally {
            this.errWriter.flush();
        }
    }

    public static void printLines(PrintWriter printWriter, String string) {
        int n;
        while ((n = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    private void printError(int n, String string, PrintWriter printWriter) {
        if (n == 0) {
            printWriter.print(Log.getText("compiler.err.error", null, null, null, null, null, null, null));
            Log.printLines(printWriter, string);
        } else {
            int n2 = Position.line(n);
            int n3 = Position.column(n);
            Log.printLines(printWriter, this.sourcename + ":" + n2 + ": " + string);
            this.printErrLine(n2, n3, printWriter);
        }
        printWriter.flush();
    }

    public void error(int n, String string) {
        this.error(n, string, null, null, null, null, null, null, null);
    }

    public void error(int n, String string, String string2) {
        this.error(n, string, string2, null, null, null, null, null, null);
    }

    public void error(int n, String string, String string2, String string3) {
        this.error(n, string, string2, string3, null, null, null, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4) {
        this.error(n, string, string2, string3, string4, null, null, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5) {
        this.error(n, string, string2, string3, string4, string5, null, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        this.error(n, string, string2, string3, string4, string5, string6, null, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.error(n, string, string2, string3, string4, string5, string6, string7, null);
    }

    public void error(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Pair pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair(this.sourcename, new Integer(n)))) {
            this.recorded.put(pair);
            String string9 = Log.getText("compiler.err." + string, string2, string3, string4, string5, string6, string7, string8);
            this.printError(n, string9, this.errWriter);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int n, String string) {
        this.warning(n, string, null, null, null, null);
    }

    public void warning(int n, String string, String string2) {
        this.warning(n, string, string2, null, null, null);
    }

    public void warning(int n, String string, String string2, String string3) {
        this.warning(n, string, string2, string3, null, null);
    }

    public void warning(int n, String string, String string2, String string3, String string4) {
        this.warning(n, string, string2, string3, string4, null);
    }

    public void warning(int n, String string, String string2, String string3, String string4, String string5) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            String string6 = Log.getText("compiler.warn." + string, string2, string3, string4, string5, null, null, null);
            this.printError(n, Log.getText("compiler.warn.warning", null, null, null, null, null, null, null) + string6, this.warnWriter);
        }
        ++this.nwarnings;
    }

    public void note(String string) {
        this.note(string, null);
    }

    public void note(String string, String string2) {
        if (this.emitWarnings) {
            this.noticeWriter.print(Log.getText("compiler.note.note", null, null, null, null, null, null, null));
            String string3 = Log.getText("compiler.note." + string, string2, null, null, null, null, null, null);
            Log.printLines(this.noticeWriter, string3);
            this.noticeWriter.flush();
        }
    }

    public static String getLocalizedString(String string) {
        return Log.getText("compiler.misc." + string, null, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2) {
        return Log.getText("compiler.misc." + string, string2, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3) {
        return Log.getText("compiler.misc." + string, string2, string3, null, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3, String string4) {
        return Log.getText("compiler.misc." + string, string2, string3, string4, null, null, null, null);
    }

    public static String getLocalizedString(String string, String string2, String string3, String string4, String string5) {
        return Log.getText("compiler.misc." + string, string2, string3, string4, string5, null, null, null);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public static String getText(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (messageRB == null) {
            Log.initResource();
        }
        try {
            Object[] objectArray = new String[]{string2, string3, string4, string5, string6, string7, string8};
            return MessageFormat.format(messageRB.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                string2 = "null";
            }
            if (string3 == null) {
                string3 = "null";
            }
            if (string4 == null) {
                string4 = "null";
            }
            if (string5 == null) {
                string5 = "null";
            }
            if (string6 == null) {
                string6 = "null";
            }
            if (string7 == null) {
                string7 = "null";
            }
            if (string8 == null) {
                string8 = "null";
            }
            Object[] objectArray = new String[]{string, string2, string3, string4, string5, string6, string7, string8};
            String string9 = "compiler message file broken: key={0} arguments={1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(string9, objectArray);
        }
    }

    private void printRawError(int n, String string) {
        if (n == 0) {
            Log.printLines(this.errWriter, "error: " + string);
        } else {
            int n2 = Position.line(n);
            int n3 = Position.column(n);
            Log.printLines(this.errWriter, this.sourcename + ":" + n2 + ": " + string);
            this.printErrLine(n2, n3, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int n, String string) {
        Pair pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair(this.sourcename, new Integer(n)))) {
            this.recorded.put(pair);
            this.printRawError(n, string);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int n, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(n, "warning: " + string);
        }
        ++this.nwarnings;
        this.errWriter.flush();
    }
}

