/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.code.CRTFlags;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.util.ByteBuffer;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;

public class CRTable
implements CRTFlags {
    private final boolean crtDebug = false;
    private ListBuffer entries = new ListBuffer();
    private Hashtable positions = Hashtable.make();
    private Hashtable endPositions;
    Tree.MethodDef methodTree;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CRTable(Tree.MethodDef methodDef, Hashtable hashtable) {
        this.methodTree = methodDef;
        this.endPositions = hashtable;
    }

    public void put(Object object, int n, int n2, int n3) {
        this.entries.append(new CRTEntry(object, n, n2, n3));
    }

    public int writeCRT(ByteBuffer byteBuffer) {
        int n = 0;
        new SourceComputer().csp(this.methodTree);
        List list = this.entries.toList();
        while (list.nonEmpty()) {
            CRTEntry cRTEntry = (CRTEntry)list.head;
            if (cRTEntry.startPc != cRTEntry.endPc) {
                SourceRange sourceRange = (SourceRange)this.positions.get(cRTEntry.tree);
                if (!$assertionsDisabled && sourceRange == null) {
                    throw new AssertionError((Object)"CRT: tree source positions are undefined");
                }
                if (sourceRange.startPos != 0 && sourceRange.endPos != 0) {
                    byteBuffer.appendChar(cRTEntry.startPc);
                    byteBuffer.appendChar(cRTEntry.endPc - 1);
                    byteBuffer.appendInt(sourceRange.startPos);
                    byteBuffer.appendInt(sourceRange.endPos);
                    byteBuffer.appendChar(cRTEntry.flags);
                    ++n;
                }
            }
            list = list.tail;
        }
        return n;
    }

    public int length() {
        return this.entries.length();
    }

    private String getTypes(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = string + " CRT_STATEMENT";
        }
        if ((n & 2) != 0) {
            string = string + " CRT_BLOCK";
        }
        if ((n & 4) != 0) {
            string = string + " CRT_ASSIGNMENT";
        }
        if ((n & 8) != 0) {
            string = string + " CRT_FLOW_CONTROLLER";
        }
        if ((n & 0x10) != 0) {
            string = string + " CRT_FLOW_TARGET";
        }
        if ((n & 0x20) != 0) {
            string = string + " CRT_INVOKE";
        }
        if ((n & 0x40) != 0) {
            string = string + " CRT_CREATE";
        }
        if ((n & 0x80) != 0) {
            string = string + " CRT_BRANCH_TRUE";
        }
        if ((n & 0x100) != 0) {
            string = string + " CRT_BRANCH_FALSE";
        }
        return string;
    }

    static {
        $assertionsDisabled = !CRTable.class.desiredAssertionStatus();
    }

    class SourceRange {
        int startPos;
        int endPos;

        SourceRange() {
            this.startPos = 0;
            this.endPos = 0;
        }

        SourceRange(int n, int n2) {
            this.startPos = n;
            this.endPos = n2;
        }

        SourceRange mergeWith(SourceRange sourceRange) {
            if (sourceRange == null) {
                return this;
            }
            if (this.startPos == 0) {
                this.startPos = sourceRange.startPos;
            } else if (sourceRange.startPos != 0) {
                int n = this.startPos = this.startPos < sourceRange.startPos ? this.startPos : sourceRange.startPos;
            }
            if (this.endPos == 0) {
                this.endPos = sourceRange.endPos;
            } else if (sourceRange.endPos != 0) {
                this.endPos = this.endPos > sourceRange.endPos ? this.endPos : sourceRange.endPos;
            }
            return this;
        }
    }

    class CRTEntry {
        Object tree;
        int flags;
        int startPc;
        int endPc;

        CRTEntry(Object object, int n, int n2, int n3) {
            this.tree = object;
            this.flags = n;
            this.startPc = n2;
            this.endPc = n3;
        }
    }

    class SourceComputer
    extends Tree.Visitor {
        SourceRange result;
        static final /* synthetic */ boolean $assertionsDisabled;

        SourceComputer() {
        }

        public SourceRange csp(Tree tree) {
            if (tree == null) {
                return null;
            }
            tree.accept(this);
            if (this.result != null) {
                CRTable.this.positions.put(tree, this.result);
            }
            return this.result;
        }

        public SourceRange csp(List list) {
            if (list == null || !list.nonEmpty()) {
                return null;
            }
            SourceRange sourceRange = new SourceRange();
            List list2 = list;
            while (list2.nonEmpty()) {
                sourceRange.mergeWith(this.csp((Tree)list2.head));
                list2 = list2.tail;
            }
            CRTable.this.positions.put(list, sourceRange);
            return sourceRange;
        }

        public SourceRange cspCases(List list) {
            if (list == null || !list.nonEmpty()) {
                return null;
            }
            SourceRange sourceRange = new SourceRange();
            List list2 = list;
            while (list2.nonEmpty()) {
                sourceRange.mergeWith(this.csp((Tree)list2.head));
                list2 = list2.tail;
            }
            CRTable.this.positions.put(list, sourceRange);
            return sourceRange;
        }

        public SourceRange cspCatchers(List list) {
            if (list == null || !list.nonEmpty()) {
                return null;
            }
            SourceRange sourceRange = new SourceRange();
            List list2 = list;
            while (list2.nonEmpty()) {
                sourceRange.mergeWith(this.csp((Tree)list2.head));
                list2 = list2.tail;
            }
            CRTable.this.positions.put(list, sourceRange);
            return sourceRange;
        }

        public void visitMethodDef(Tree.MethodDef methodDef) {
            SourceRange sourceRange = new SourceRange(this.startPos(methodDef), this.endPos(methodDef));
            sourceRange.mergeWith(this.csp(methodDef.body));
            this.result = sourceRange;
        }

        public void visitVarDef(Tree.VarDef varDef) {
            SourceRange sourceRange = new SourceRange(this.startPos(varDef), this.endPos(varDef));
            this.csp(varDef.vartype);
            sourceRange.mergeWith(this.csp(varDef.init));
            this.result = sourceRange;
        }

        public void visitSkip(Tree.Skip skip) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(skip), this.startPos(skip));
        }

        public void visitBlock(Tree.Block block) {
            SourceRange sourceRange = new SourceRange(this.startPos(block), this.endPos(block));
            this.csp(block.stats);
            this.result = sourceRange;
        }

        public void visitDoLoop(Tree.DoLoop doLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(doLoop), this.endPos(doLoop));
            sourceRange.mergeWith(this.csp(doLoop.body));
            sourceRange.mergeWith(this.csp(doLoop.cond));
            this.result = sourceRange;
        }

        public void visitWhileLoop(Tree.WhileLoop whileLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(whileLoop), this.endPos(whileLoop));
            sourceRange.mergeWith(this.csp(whileLoop.cond));
            sourceRange.mergeWith(this.csp(whileLoop.body));
            this.result = sourceRange;
        }

        public void visitForLoop(Tree.ForLoop forLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(forLoop), this.endPos(forLoop));
            sourceRange.mergeWith(this.csp(forLoop.init));
            sourceRange.mergeWith(this.csp(forLoop.cond));
            sourceRange.mergeWith(this.csp(forLoop.step));
            sourceRange.mergeWith(this.csp(forLoop.body));
            this.result = sourceRange;
        }

        public void visitLabelled(Tree.Labelled labelled) {
            SourceRange sourceRange = new SourceRange(this.startPos(labelled), this.endPos(labelled));
            sourceRange.mergeWith(this.csp(labelled.body));
            this.result = sourceRange;
        }

        public void visitSwitch(Tree.Switch switch_) {
            SourceRange sourceRange = new SourceRange(this.startPos(switch_), this.endPos(switch_));
            sourceRange.mergeWith(this.csp(switch_.selector));
            sourceRange.mergeWith(this.cspCases(switch_.cases));
            this.result = sourceRange;
        }

        public void visitCase(Tree.Case case_) {
            SourceRange sourceRange = new SourceRange(this.startPos(case_), this.endPos(case_));
            sourceRange.mergeWith(this.csp(case_.pat));
            sourceRange.mergeWith(this.csp(case_.stats));
            this.result = sourceRange;
        }

        public void visitSynchronized(Tree.Synchronized synchronized_) {
            SourceRange sourceRange = new SourceRange(this.startPos(synchronized_), this.endPos(synchronized_));
            sourceRange.mergeWith(this.csp(synchronized_.lock));
            sourceRange.mergeWith(this.csp(synchronized_.body));
            this.result = sourceRange;
        }

        public void visitTry(Tree.Try try_) {
            SourceRange sourceRange = new SourceRange(this.startPos(try_), this.endPos(try_));
            sourceRange.mergeWith(this.csp(try_.body));
            sourceRange.mergeWith(this.cspCatchers(try_.catchers));
            sourceRange.mergeWith(this.csp(try_.finalizer));
            this.result = sourceRange;
        }

        public void visitCatch(Tree.Catch catch_) {
            SourceRange sourceRange = new SourceRange(this.startPos(catch_), this.endPos(catch_));
            sourceRange.mergeWith(this.csp(catch_.param));
            sourceRange.mergeWith(this.csp(catch_.body));
            this.result = sourceRange;
        }

        public void visitConditional(Tree.Conditional conditional) {
            SourceRange sourceRange = new SourceRange(this.startPos(conditional), this.endPos(conditional));
            sourceRange.mergeWith(this.csp(conditional.cond));
            sourceRange.mergeWith(this.csp(conditional.truepart));
            sourceRange.mergeWith(this.csp(conditional.falsepart));
            this.result = sourceRange;
        }

        public void visitIf(Tree.If if_) {
            SourceRange sourceRange = new SourceRange(this.startPos(if_), this.endPos(if_));
            sourceRange.mergeWith(this.csp(if_.cond));
            sourceRange.mergeWith(this.csp(if_.thenpart));
            sourceRange.mergeWith(this.csp(if_.elsepart));
            this.result = sourceRange;
        }

        public void visitExec(Tree.Exec exec) {
            SourceRange sourceRange = new SourceRange(this.startPos(exec), this.endPos(exec));
            sourceRange.mergeWith(this.csp(exec.expr));
            this.result = sourceRange;
        }

        public void visitBreak(Tree.Break break_) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(break_), this.endPos(break_));
        }

        public void visitContinue(Tree.Continue continue_) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(continue_), this.endPos(continue_));
        }

        public void visitReturn(Tree.Return return_) {
            SourceRange sourceRange = new SourceRange(this.startPos(return_), this.endPos(return_));
            sourceRange.mergeWith(this.csp(return_.expr));
            this.result = sourceRange;
        }

        public void visitThrow(Tree.Throw throw_) {
            SourceRange sourceRange = new SourceRange(this.startPos(throw_), this.endPos(throw_));
            sourceRange.mergeWith(this.csp(throw_.expr));
            this.result = sourceRange;
        }

        public void visitAssert(Tree.Assert assert_) {
            SourceRange sourceRange = new SourceRange(this.startPos(assert_), this.endPos(assert_));
            sourceRange.mergeWith(this.csp(assert_.cond));
            sourceRange.mergeWith(this.csp(assert_.detail));
            this.result = sourceRange;
        }

        public void visitApply(Tree.Apply apply) {
            SourceRange sourceRange = new SourceRange(this.startPos(apply), this.endPos(apply));
            sourceRange.mergeWith(this.csp(apply.meth));
            sourceRange.mergeWith(this.csp(apply.args));
            this.result = sourceRange;
        }

        public void visitNewClass(Tree.NewClass newClass) {
            SourceRange sourceRange = new SourceRange(this.startPos(newClass), this.endPos(newClass));
            sourceRange.mergeWith(this.csp(newClass.encl));
            sourceRange.mergeWith(this.csp(newClass.clazz));
            sourceRange.mergeWith(this.csp(newClass.args));
            sourceRange.mergeWith(this.csp(newClass.def));
            this.result = sourceRange;
        }

        public void visitNewArray(Tree.NewArray newArray) {
            SourceRange sourceRange = new SourceRange(this.startPos(newArray), this.endPos(newArray));
            sourceRange.mergeWith(this.csp(newArray.elemtype));
            sourceRange.mergeWith(this.csp(newArray.dims));
            sourceRange.mergeWith(this.csp(newArray.elems));
            this.result = sourceRange;
        }

        public void visitParens(Tree.Parens parens) {
            SourceRange sourceRange = new SourceRange(this.startPos(parens), this.endPos(parens));
            sourceRange.mergeWith(this.csp(parens.expr));
            this.result = sourceRange;
        }

        public void visitAssign(Tree.Assign assign) {
            SourceRange sourceRange = new SourceRange(this.startPos(assign), this.endPos(assign));
            sourceRange.mergeWith(this.csp(assign.lhs));
            sourceRange.mergeWith(this.csp(assign.rhs));
            this.result = sourceRange;
        }

        public void visitAssignop(Tree.Assignop assignop) {
            SourceRange sourceRange = new SourceRange(this.startPos(assignop), this.endPos(assignop));
            sourceRange.mergeWith(this.csp(assignop.lhs));
            sourceRange.mergeWith(this.csp(assignop.rhs));
            this.result = sourceRange;
        }

        public void visitUnary(Tree.Unary unary) {
            SourceRange sourceRange = new SourceRange(this.startPos(unary), this.endPos(unary));
            sourceRange.mergeWith(this.csp(unary.arg));
            this.result = sourceRange;
        }

        public void visitBinary(Tree.Binary binary) {
            SourceRange sourceRange = new SourceRange(this.startPos(binary), this.endPos(binary));
            sourceRange.mergeWith(this.csp(binary.lhs));
            sourceRange.mergeWith(this.csp(binary.rhs));
            this.result = sourceRange;
        }

        public void visitTypeCast(Tree.TypeCast typeCast) {
            SourceRange sourceRange = new SourceRange(this.startPos(typeCast), this.endPos(typeCast));
            sourceRange.mergeWith(this.csp(typeCast.clazz));
            sourceRange.mergeWith(this.csp(typeCast.expr));
            this.result = sourceRange;
        }

        public void visitTypeTest(Tree.TypeTest typeTest) {
            SourceRange sourceRange = new SourceRange(this.startPos(typeTest), this.endPos(typeTest));
            sourceRange.mergeWith(this.csp(typeTest.expr));
            sourceRange.mergeWith(this.csp(typeTest.clazz));
            this.result = sourceRange;
        }

        public void visitIndexed(Tree.Indexed indexed) {
            SourceRange sourceRange = new SourceRange(this.startPos(indexed), this.endPos(indexed));
            sourceRange.mergeWith(this.csp(indexed.indexed));
            sourceRange.mergeWith(this.csp(indexed.index));
            this.result = sourceRange;
        }

        public void visitSelect(Tree.Select select) {
            SourceRange sourceRange = new SourceRange(this.startPos(select), this.endPos(select));
            sourceRange.mergeWith(this.csp(select.selected));
            this.result = sourceRange;
        }

        public void visitIdent(Tree.Ident ident) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(ident), this.endPos(ident));
        }

        public void visitLiteral(Tree.Literal literal) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(literal), this.endPos(literal));
        }

        public void visitTypeIdent(Tree.TypeIdent typeIdent) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(typeIdent), this.endPos(typeIdent));
        }

        public void visitTypeArray(Tree.TypeArray typeArray) {
            SourceRange sourceRange = new SourceRange(this.startPos(typeArray), this.endPos(typeArray));
            sourceRange.mergeWith(this.csp(typeArray.elemtype));
            this.result = sourceRange;
        }

        public void visitErroneous(Tree.Erroneous erroneous) {
            this.result = null;
        }

        public void visitTree(Tree tree) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public int startPos(Tree tree) {
            if (tree == null) {
                return 0;
            }
            return tree.pos;
        }

        public int endPos(Tree tree) {
            if (tree == null) {
                return 0;
            }
            if (tree.tag == 7) {
                return ((Tree.Block)tree).endpos;
            }
            Integer n = (Integer)CRTable.this.endPositions.get(tree);
            if (n != null) {
                return n;
            }
            return 0;
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$v8$code$CRTable == null ? (class$com$sun$tools$javac$v8$code$CRTable = CRTable.class$("com.sun.tools.javac.v8.code.CRTable")) : class$com$sun$tools$javac$v8$code$CRTable).desiredAssertionStatus();
        }
    }
}

