/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.zwlmclassifier;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sib.zwlmclassifier.Rule;
import com.ibm.ws.sib.zwlmclassifier.RuleStore;
import com.ibm.ws.sib.zwlmclassifier.RuleType;
import com.ibm.wsspi.sib.core.SIBusMessage;
import java.util.Iterator;
import java.util.List;

public class WlmClassifier {
    private static final String MY_CLASS_NAME = WlmClassifier.class.getName();
    private static final TraceComponent TC = SibTr.register((Class)WlmClassifier.class, (String)"SIBWlmClassifier", (String)"com.ibm.ws.sib.zwlmclassifier.CWSJWMessages");
    private static final WlmClassifier INSTANCE;

    WlmClassifier() {
    }

    public String classify(RuleType ruleType, SIBusMessage sIBusMessage, String string, String string2) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"classify", (Object)new Object[]{"ruleType=" + ruleType, "busName=" + string, "destinationName=" + string2});
        }
        List list = this.getRuleStore().getRules(ruleType, string, string2);
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"classify", (Object)("Rule store returned " + list.size() + " rule(s) matching on bus " + string + " and destination " + string2));
        }
        Rule rule = null;
        if (!list.isEmpty() && null != sIBusMessage) {
            rule = this.findMatchingRule(list, sIBusMessage);
        }
        String string3 = null;
        if (null != rule) {
            string3 = rule.getTransactionClass();
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"classify", (Object)"Using transaction class from matching rule");
            }
        } else {
            string3 = this.getRuleStore().getDefaultClass(ruleType);
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"classify", (Object)"No matching rule was found - using default transaction class");
            }
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"classify", (Object)("transactionClass=" + string3));
        }
        return string3;
    }

    private Rule findMatchingRule(List list, SIBusMessage sIBusMessage) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"findMatchingRule");
        }
        Rule rule = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule2 = (Rule)iterator.next();
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"findMatchingRule", (Object)("Testing message against rule " + rule2));
            }
            Selector selector = rule2.getSelectorAsObject();
            Selector selector2 = rule2.getDiscriminatorAsObject();
            if (null == selector && null == selector2) {
                rule = rule2;
                if (!TC.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)TC, (String)"findMatchingRule", (Object)"Rule matches because its selector and discriminator expressions are null");
                break;
            }
            if (this.matchMessageOnSelectorAndDiscriminator(sIBusMessage, selector, selector2)) {
                rule = rule2;
                if (!TC.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)TC, (String)"findMatchingRule", (Object)"Rule matches because its selector and discriminator expressions match the message");
                break;
            }
            if (!TC.isDebugEnabled()) continue;
            SibTr.debug((TraceComponent)TC, (String)"findMatchingRule", (Object)"Rule does not match on selector and discriminator");
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"findMatchingRule", (Object)("matching rule=" + rule));
        }
        return rule;
    }

    private boolean matchMessageOnSelectorAndDiscriminator(SIBusMessage sIBusMessage, Selector selector, Selector selector2) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"matchMessageOnSelectorAndDiscriminator", (Object)new Object[]{"selector=" + selector, "discriminator=" + selector2});
        }
        boolean bl = this.getRuleStore().getSelectorEvaluator().evaluateMessage(selector, selector2, sIBusMessage);
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"matchMessageOnSelectorAndDiscriminator", (Object)("matched=" + Boolean.toString(bl)));
        }
        return bl;
    }

    RuleStore getRuleStore() {
        return RuleStore.getInstance();
    }

    public static WlmClassifier getInstance() {
        return INSTANCE;
    }

    static {
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"Source info: @(#)SIB/ws/code/sib.zwlmclassifier.impl/src/com/ibm/ws/sib/zwlmclassifier/WlmClassifier.java, SIB.zwlmclassifier, WAS602.SIB, o0610.11 1.9");
        }
        INSTANCE = new WlmClassifier();
    }
}

