/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.zwlmclassifier;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.processor.MPSelectorEvaluator;
import com.ibm.ws.sib.processor.MPSelectorEvaluatorFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sib.zwlmclassifier.Rule;
import com.ibm.ws.sib.zwlmclassifier.RuleType;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RuleStore {
    private static final String MY_CLASS_NAME = RuleStore.class.getName();
    private static final TraceComponent TC = SibTr.register((Class)RuleStore.class, (String)"SIBWlmClassifier", (String)"com.ibm.ws.sib.zwlmclassifier.CWSJWMessages");
    private static String parserClassName;
    private final HashMap defaultClassMap = new HashMap();
    private final HashMap rulesMap = new HashMap();
    private boolean loaded = false;
    private MPSelectorEvaluator selectorEvaluator = null;
    private final HashMap selectorCache = new HashMap();
    private final HashMap discriminatorCache = new HashMap();
    private static final RuleStore INSTANCE;

    RuleStore() {
    }

    private HashMap getDefaultClassMap() {
        return this.defaultClassMap;
    }

    public String getDefaultClass(RuleType ruleType) {
        String string;
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"getDefaultClass", (Object)("ruleType=" + ruleType));
        }
        this.load();
        String string2 = string = null == ruleType ? "SIBUS" : (String)this.getDefaultClassMap().get(ruleType);
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"getDefaultClass", (Object)string);
        }
        return string;
    }

    private void setDefaultClass(RuleType ruleType, String string) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"setDefaultClass", (Object)new Object[]{"ruleType=" + ruleType, "transactionClass=" + string});
        }
        this.getDefaultClassMap().put(ruleType, string);
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"setDefaultClass");
        }
    }

    private HashMap getRulesMap() {
        return this.rulesMap;
    }

    private List getRules(RuleType ruleType) {
        return (List)this.getRulesMap().get(ruleType);
    }

    public List getRules(RuleType ruleType, String string, String string2) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"getRules", (Object)new Object[]{"ruleType=" + ruleType, "busName=" + string, "destinationName=" + string2});
        }
        this.load();
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        if (null != ruleType) {
            Iterator iterator = this.getRules(ruleType).iterator();
            while (iterator.hasNext()) {
                Rule rule = (Rule)iterator.next();
                if (!rule.matchesBusAndDestination(string, string2)) continue;
                if (TC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TC, (String)"getRules", (Object)("Rule matches on bus and destination (match on selector/discriminator is pending):  " + rule));
                }
                arrayList.add(rule);
            }
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"getRules", (Object)arrayList.toArray());
        }
        return arrayList;
    }

    private void addRules(List list) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"addRules(List)");
        }
        if (null != list) {
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"addRules(List)", (Object)("Retrieving " + list.size() + " SibClassification element(s) from the classification XML parser class"));
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addRules((Element)iterator.next());
            }
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"addRules(List)");
        }
    }

    private void addRules(Element element) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"addRules(Element)");
        }
        String string = element.getAttribute("type");
        String string2 = element.getAttribute("default_transaction_class");
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"addRules(Element)", (Object)new Object[]{"type=" + string, "default_transaction_class=" + string2, "schema_version=" + element.getAttribute("schema_version")});
        }
        RuleType ruleType = null;
        if (string.equals("jmsra")) {
            ruleType = RuleType.JMS_RA;
        } else if (string.equals("destinationmediation")) {
            ruleType = RuleType.DESTINATION_MEDIATION;
        }
        if (null != ruleType) {
            this.setDefaultClass(ruleType, string2);
            NodeList nodeList = element.getElementsByTagName("sib_classification_info");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.addRule(ruleType, (Element)nodeList.item(i));
            }
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"addRules(Element)");
        }
    }

    private void addRule(RuleType ruleType, Element element) {
        block9: {
            if (TC.isEntryEnabled()) {
                SibTr.entry((TraceComponent)TC, (String)"addRule", (Object)("ruleType=" + ruleType));
            }
            String string = element.getAttribute("transaction_class");
            String string2 = element.getAttribute("selector");
            String string3 = element.getAttribute("bus");
            String string4 = element.getAttribute("destination");
            String string5 = element.getAttribute("discriminator");
            String string6 = element.getAttribute("description");
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"addRule", (Object)new Object[]{"transaction_class=" + string, "selector=" + string2, "bus=" + string3, "destination=" + string4, "discriminator=" + string5, "description=" + string6});
            }
            Rule rule = new Rule(string, string2, string3, string4, string5, string6);
            try {
                if (null != rule.getSelectorAsString()) {
                    rule.setSelectorAsObject(this.getSelectorFromCache(rule.getSelectorAsString()));
                }
                if (null != rule.getDiscriminatorAsString()) {
                    rule.setDiscriminatorAsObject(this.getDiscriminatorFromCache(rule.getDiscriminatorAsString()));
                }
                this.getRules(ruleType).add(rule);
            }
            catch (SISelectorSyntaxException sISelectorSyntaxException) {
                FFDCFilter.processException((Throwable)sISelectorSyntaxException, (String)(MY_CLASS_NAME + "." + "addRule"), (String)"3", (Object)this);
                SibTr.warning((TraceComponent)TC, (String)"SELECTOR_SYNTAX_ERROR_CWSJW0003", (Object)new Object[]{ruleType, rule});
                if (TC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TC, (String)"addRule", (Object)("Ignoring rule with invalid selector expression:  " + rule));
                }
            }
            catch (SIDiscriminatorSyntaxException sIDiscriminatorSyntaxException) {
                FFDCFilter.processException((Throwable)sIDiscriminatorSyntaxException, (String)(MY_CLASS_NAME + "." + "addRule"), (String)"4", (Object)this);
                SibTr.warning((TraceComponent)TC, (String)"DISCRIMINATOR_SYNTAX_ERROR_CWSJW0004", (Object)new Object[]{ruleType, rule});
                if (!TC.isDebugEnabled()) break block9;
                SibTr.debug((TraceComponent)TC, (String)"addRule", (Object)("Ignoring rule with invalid discriminator expression:  " + rule));
            }
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"addRule");
        }
    }

    private synchronized void load() {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"load");
        }
        if (!this.isLoaded()) {
            this.initialiseStore();
            Class clazz = this.getParserClass();
            if (null != clazz) {
                this.addRules(this.extractSibClassificationElements(clazz));
            }
            this.setLoaded(true);
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"load");
        }
    }

    private boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"setLoaded", (Object)("loaded=" + Boolean.toString(bl)));
        }
        this.loaded = bl;
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"setLoaded");
        }
    }

    private void initialiseStore() {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"initialiseStore");
        }
        HashMap hashMap = this.getDefaultClassMap();
        HashMap hashMap2 = this.getRulesMap();
        hashMap.clear();
        hashMap2.clear();
        RuleType[] ruleTypeArray = RuleType.getRuleTypes();
        for (int i = 0; i < ruleTypeArray.length; ++i) {
            hashMap.put(ruleTypeArray[i], "SIBUS");
            hashMap2.put(ruleTypeArray[i], new ArrayList());
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"initialiseStore");
        }
    }

    String getParserClassName() {
        return parserClassName;
    }

    private Class getParserClass() {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"getParserClass");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getParserClassName());
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"getParserClass", (Object)("Classification XML parser class=" + this.getParserClassName()));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)(MY_CLASS_NAME + "." + "getParserClass"), (String)"1", (Object)this);
            SibTr.info((TraceComponent)TC, (String)"PARSER_CLASS_NOT_FOUND_CWSJW0001", (Object)new Object[]{this.getParserClassName(), "SIBUS"});
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"getParserClass");
        }
        return clazz;
    }

    private List extractSibClassificationElements(Class clazz) {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"extractSibClassificationElements");
        }
        List list = null;
        try {
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            method = clazz.getMethod("getElements", new Class[0]);
            list = (List)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(MY_CLASS_NAME + "." + "extractSibClassificationElements"), (String)"2", (Object)this);
            SibTr.exception((TraceComponent)TC, (Exception)exception);
            SibTr.warning((TraceComponent)TC, (String)"PARSER_CLASS_INVOKE_ERROR_CWSJW0002", (Object)new Object[]{this.getParserClassName(), "SIBUS", exception});
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"extractSibClassificationElements");
        }
        return list;
    }

    public MPSelectorEvaluator getSelectorEvaluator() {
        if (null == this.selectorEvaluator) {
            this.selectorEvaluator = MPSelectorEvaluatorFactory.getInstance().createMPSelectorEvaluator();
        }
        return this.selectorEvaluator;
    }

    private HashMap getSelectorCache() {
        return this.selectorCache;
    }

    private Selector getSelectorFromCache(String string) throws SISelectorSyntaxException {
        Selector selector;
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"getSelectorFromCache", (Object)("selector=" + string));
        }
        if (null == (selector = (Selector)this.getSelectorCache().get(string))) {
            selector = this.convertSelector(string);
            this.getSelectorCache().put(string, selector);
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"getSelectorFromCache");
        }
        return selector;
    }

    private Selector convertSelector(String string) throws SISelectorSyntaxException {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"convertSelector", (Object)("selector=" + string));
        }
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"convertSelector", (Object)"Invoking matching engine to convert selector to Selector object");
        }
        Selector selector = null;
        try {
            selector = this.getSelectorEvaluator().parseSelector(string, SelectorDomain.SIMESSAGE);
        }
        catch (SISelectorSyntaxException sISelectorSyntaxException) {
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"convertSelector", (Object)(((Object)((Object)sISelectorSyntaxException)).getClass().getName() + " " + sISelectorSyntaxException.getMessage()));
            }
            throw sISelectorSyntaxException;
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"convertSelector");
        }
        return selector;
    }

    private HashMap getDiscriminatorCache() {
        return this.discriminatorCache;
    }

    private Selector getDiscriminatorFromCache(String string) throws SIDiscriminatorSyntaxException {
        Selector selector;
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"getDiscriminatorFromCache", (Object)("discriminator=" + string));
        }
        if (null == (selector = (Selector)this.getDiscriminatorCache().get(string))) {
            selector = this.convertDiscriminator(string);
            this.getDiscriminatorCache().put(string, selector);
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"getDiscriminatorFromCache");
        }
        return selector;
    }

    private Selector convertDiscriminator(String string) throws SIDiscriminatorSyntaxException {
        if (TC.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TC, (String)"convertDiscriminator", (Object)("discriminator=" + string));
        }
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"convertDiscriminator", (Object)"Invoking matching engine to convert discriminator to Selector object");
        }
        Selector selector = null;
        try {
            selector = this.getSelectorEvaluator().parseDiscriminator(string);
        }
        catch (SIDiscriminatorSyntaxException sIDiscriminatorSyntaxException) {
            if (TC.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TC, (String)"convertDiscriminator", (Object)(((Object)((Object)sIDiscriminatorSyntaxException)).getClass().getName() + " " + sIDiscriminatorSyntaxException.getMessage()));
            }
            throw sIDiscriminatorSyntaxException;
        }
        if (TC.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TC, (String)"convertDiscriminator");
        }
        return selector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        if (!this.isLoaded()) {
            stringBuffer.append("not loaded");
        } else {
            String string = System.getProperty("line.separator");
            Iterator iterator = this.getRulesMap().keySet().iterator();
            while (iterator.hasNext()) {
                RuleType ruleType = (RuleType)iterator.next();
                stringBuffer.append("ruleType=");
                stringBuffer.append(ruleType.toString());
                stringBuffer.append(", default class=");
                stringBuffer.append(this.getDefaultClass(ruleType));
                List list = this.getRules(ruleType);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append(string);
                    stringBuffer.append("    ");
                    Rule rule = (Rule)iterator2.next();
                    stringBuffer.append(rule.toString());
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static RuleStore getInstance() {
        return INSTANCE;
    }

    static {
        if (TC.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TC, (String)"Source info: @(#)SIB/ws/code/sib.zwlmclassifier.impl/src/com/ibm/ws/sib/zwlmclassifier/RuleStore.java, SIB.zwlmclassifier, WAS602.SIB, o0610.11 1.10");
        }
        parserClassName = "com.ibm.ws390.orb.SibClassificationParser";
        INSTANCE = new RuleStore();
    }
}

