/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.wlm.server;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.trm.wlm.server.Join;
import com.ibm.ws.sib.trm.wlm.server.Leave;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class DestEventQueue {
    public static final String $ssccid = "@(#) 1.3 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/wlm/server/DestEventQueue.java, SIB.trm, WAS602.SIB, o0610.11 05/06/07 04:59:11 [3/13/06 13:48:21]";
    private static final TraceComponent tc = SibTr.register((Class)DestEventQueue.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    public static final int QUEUING = 1;
    public static final int DEQUEUING = 2;
    public static final int PASS_THRU = 3;
    private final Object stateLock = new Object();
    private int queueState;
    private List eventQueue;
    private final Join join;
    private final Leave leave;

    protected DestEventQueue(Join join, Leave leave) {
        if (tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestEventQueue");
        }
        this.join = join;
        this.leave = leave;
        this.initializeQueuing();
        if (tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestEventQueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeQueuing() {
        if (tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeQueuing");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.eventQueue = new ArrayList(10);
            this.queueState = 1;
        }
        if (tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeQueuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDestination(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destUuid=" + sIBUuid12));
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    this.debugOutput_QueueStatus();
                }
                switch (this.queueState) {
                    case 1: {
                        DestByUUID destByUUID = new DestByUUID(sIBUuid12, true);
                        this.eventQueue.add(destByUUID);
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)"Event QUEUED for later replay");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.join.toDestination(sIBUuid12);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EventQueue was null - calling WLM directly.");
            }
            this.join.toDestination(sIBUuid12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterDestination(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destUuid=" + sIBUuid12));
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    this.debugOutput_QueueStatus();
                }
                switch (this.queueState) {
                    case 1: {
                        DestByUUID destByUUID = new DestByUUID(sIBUuid12, false);
                        this.eventQueue.add(destByUUID);
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)"Event QUEUED for later replay");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.leave.fromDestination(sIBUuid12);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EventQueue was null - calling WLM directly.");
            }
            this.leave.fromDestination(sIBUuid12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDestination(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destination=" + string));
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    this.debugOutput_QueueStatus();
                }
                switch (this.queueState) {
                    case 1: {
                        DestByName destByName = new DestByName(string, true);
                        this.eventQueue.add(destByName);
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)"Event QUEUED for later replay");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.join.toDestination(string);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EventQueue was null - calling WLM directly.");
            }
            this.join.toDestination(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterDestination(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destination=" + string));
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    this.debugOutput_QueueStatus();
                }
                switch (this.queueState) {
                    case 1: {
                        DestByName destByName = new DestByName(string, false);
                        this.eventQueue.add(destByName);
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)"Event QUEUED for later replay");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.leave.fromDestination(string);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EventQueue was null - calling WLM directly.");
            }
            this.leave.fromDestination(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDestinationCapability(SIBUuid12 sIBUuid12, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerDestinationCapability");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("uuid=" + sIBUuid12 + ",capability=" + capability));
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    this.debugOutput_QueueStatus();
                }
                switch (this.queueState) {
                    case 1: {
                        DestByCapability destByCapability = new DestByCapability(sIBUuid12, capability, true);
                        this.eventQueue.add(destByCapability);
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)"Event QUEUED for later replay");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.join.toDestination(sIBUuid12, capability);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EventQueue was null - calling WLM directly.");
            }
            this.join.toDestination(sIBUuid12, capability);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestinationCapability");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterDestinationCapability(SIBUuid12 sIBUuid12, Capability capability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterDestinationCapability");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("uuid=" + sIBUuid12 + ",capability=" + capability));
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    this.debugOutput_QueueStatus();
                }
                switch (this.queueState) {
                    case 1: {
                        DestByCapability destByCapability = new DestByCapability(sIBUuid12, capability, false);
                        this.eventQueue.add(destByCapability);
                        if (!tc.isDebugEnabled()) break;
                        SibTr.debug((TraceComponent)tc, (String)"Event QUEUED for later replay");
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.leave.fromDestination(sIBUuid12, capability);
                    }
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"EventQueue was null - calling WLM directly.");
            }
            this.leave.fromDestination(sIBUuid12, capability);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestinationCapability");
        }
    }

    private void debugOutput_QueueStatus() {
        if (tc.isDebugEnabled()) {
            switch (this.queueState) {
                case 1: {
                    SibTr.debug((TraceComponent)tc, (String)"eventQueue state: QUEUEING");
                    break;
                }
                case 2: {
                    SibTr.debug((TraceComponent)tc, (String)"eventQueue state: DEQUEUEING");
                    break;
                }
                case 3: {
                    SibTr.debug((TraceComponent)tc, (String)"eventQueue state: PASS_THRU");
                    break;
                }
                default: {
                    SibTr.debug((TraceComponent)tc, (String)("eventQueue state: UNKNOWN (" + this.queueState + ")"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deQueueDestinationEvents() {
        if (tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deQueueDestinationEvents");
        }
        if (this.eventQueue != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Obtained state lock for DEQUEUE operation");
                }
                this.queueState = 2;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Iterating " + this.eventQueue.size() + " queued events."));
                }
                while (this.eventQueue.size() > 0) {
                    HolderParent holderParent = (HolderParent)this.eventQueue.remove(0);
                    if (holderParent == null) continue;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Replay: " + holderParent));
                    }
                    if (holderParent.isRegisterRequest()) {
                        if (holderParent instanceof DestByUUID) {
                            this.registerDestination(((DestByUUID)holderParent).getDestUUID());
                            continue;
                        }
                        if (holderParent instanceof DestByName) {
                            this.registerDestination(((DestByName)holderParent).getDestName());
                            continue;
                        }
                        if (!(holderParent instanceof DestByCapability)) continue;
                        this.registerDestinationCapability(((DestByCapability)holderParent).getDestUUID(), ((DestByCapability)holderParent).getCapability());
                        continue;
                    }
                    if (holderParent instanceof DestByUUID) {
                        this.deregisterDestination(((DestByUUID)holderParent).getDestUUID());
                        continue;
                    }
                    if (holderParent instanceof DestByName) {
                        this.deregisterDestination(((DestByName)holderParent).getDestName());
                        continue;
                    }
                    if (!(holderParent instanceof DestByCapability)) continue;
                    this.deregisterDestinationCapability(((DestByCapability)holderParent).getDestUUID(), ((DestByCapability)holderParent).getCapability());
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Queued event iteration complete - set state to PASS_THRU");
                }
                this.queueState = 3;
                this.eventQueue = null;
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"eventQueue was null - repeated invocation?");
        }
        if (tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deQueueDestinationEvents");
        }
    }

    private class DestByCapability
    extends HolderParent {
        private SIBUuid12 destUuid;
        private Capability destCapability;

        public DestByCapability(SIBUuid12 sIBUuid12, Capability capability, boolean bl) {
            super(bl);
            this.destUuid = sIBUuid12;
            this.destCapability = capability;
        }

        public SIBUuid12 getDestUUID() {
            return this.destUuid;
        }

        public Capability getCapability() {
            return this.destCapability;
        }

        public String toString() {
            return super.toString() + this.getDestUUID() + ", " + this.getCapability() + " (dest by capability)";
        }
    }

    private class DestByName
    extends HolderParent {
        private String destName;

        public DestByName(String string, boolean bl) {
            super(bl);
            this.destName = string;
        }

        public String getDestName() {
            return this.destName;
        }

        public String toString() {
            return super.toString() + this.getDestName() + " (dest by Name)";
        }
    }

    private class DestByUUID
    extends HolderParent {
        private SIBUuid12 destUuid;

        public DestByUUID(SIBUuid12 sIBUuid12, boolean bl) {
            super(bl);
            this.destUuid = sIBUuid12;
        }

        public SIBUuid12 getDestUUID() {
            return this.destUuid;
        }

        public String toString() {
            return super.toString() + this.getDestUUID() + " (dest by UUID)";
        }
    }

    private abstract class HolderParent {
        private boolean isRegisterRequest;

        public HolderParent(boolean bl) {
            this.isRegisterRequest = bl;
        }

        public boolean isRegisterRequest() {
            return this.isRegisterRequest;
        }

        public String toString() {
            return "QueuedDestinationEvent: " + (this.isRegisterRequest ? "register, " : "deregister, ");
        }
    }
}

