/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.topology;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.mfp.trm.TrmRouteData;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.contact.BridgeNeighbour;
import com.ibm.ws.sib.trm.contact.ConnectNeighbour;
import com.ibm.ws.sib.trm.contact.LinkNeighbour;
import com.ibm.ws.sib.trm.contact.Neighbour;
import com.ibm.ws.sib.trm.general.CommsType;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.CelluleRouteMap;
import com.ibm.ws.sib.trm.topology.LinkCellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.trm.topology.Sender;
import com.ibm.ws.sib.trm.topology.TopologyListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public final class TopologyManager {
    public static final String $ssccid = "@(#) 1.80 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/topology/TopologyManager.java, SIB.trm, WAS602.SIB, o0610.11 05/04/08 02:45:20 [3/13/06 13:39:09]";
    private static final String className = TopologyManager.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TopologyListener listener = null;
    private TrmMeMainImpl meMain;
    private RuntimeEventListener runtimeEventListener = null;
    private Set oldBusReachable = new HashSet();
    private Sender sender;
    private TrmMessageFactory tmf;

    public TopologyManager(TrmMeMainImpl trmMeMainImpl) {
        this.meMain = trmMeMainImpl;
    }

    public void setListener(TopologyListener topologyListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setListener");
        }
        this.listener = topologyListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setListener");
        }
    }

    public void activate(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activate");
        }
        if (this.listener != null) {
            this.listener.changeConnection(null, neighbour.getMEConnection());
        }
        CelluleRouteMap celluleRouteMap = new CelluleRouteMap(this.meMain);
        celluleRouteMap.put(neighbour.getMessagingEngine(), new Integer(1));
        neighbour.setRecvRouteMap(celluleRouteMap);
        if (neighbour.getType() == CommsType.CONNECTION) {
            Object[] objectArray = new Object[]{this.meMain.getName(), this.meMain.getBus(), ((ConnectNeighbour)neighbour).getName()};
            SibTr.info((TraceComponent)tc, (String)"INFO_CWSIT0028", (Object)objectArray);
            if (this.runtimeEventListener == null) {
                this.runtimeEventListener = this.meMain.getRuntimeEventListener();
            }
            if (this.meMain.getMessagingEngine().isEventNotificationEnabled() && this.runtimeEventListener != null) {
                String string = nls.getFormattedMessage("INFO_CWSIT0028", objectArray, null);
                Properties properties = new Properties();
                properties.put("remote.messaging.engine.name", ((ConnectNeighbour)neighbour).getName());
                properties.put("remote.messaging.engine.UUID", ((ConnectNeighbour)neighbour).getMessagingEngine().getUuid().toString());
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Issuing event notification: SIB.communications.connection.start");
                }
                this.runtimeEventListener.runtimeEventOccurred(this.meMain.getMessagingEngine(), "SIB.communications.connection.start", string, properties);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Not issuing an event notification");
            }
        } else if (neighbour.getType() == CommsType.LINK) {
            SibTr.info((TraceComponent)tc, (String)"INFO_CWSIT0030", (Object)new Object[]{this.meMain.getName(), this.meMain.getSubnet(), this.meMain.getBus(), ((LinkNeighbour)neighbour).getName(), ((LinkNeighbour)neighbour).getSubnet()});
        } else if (neighbour.getType() == CommsType.BRIDGE) {
            Object[] objectArray = new Object[]{((BridgeNeighbour)neighbour).getLink(), this.meMain.getName(), this.meMain.getBus(), ((BridgeNeighbour)neighbour).getName(), ((BridgeNeighbour)neighbour).getBus()};
            SibTr.info((TraceComponent)tc, (String)"INFO_CWSIT0032", (Object)objectArray);
            RuntimeEventListener runtimeEventListener = ((BridgeNeighbour)neighbour).getRuntimeEventListener();
            if (this.meMain.getMessagingEngine().isEventNotificationEnabled() && runtimeEventListener != null) {
                String string = nls.getFormattedMessage("INFO_CWSIT0032", objectArray, null);
                Properties properties = new Properties();
                properties.put("foreign.bus.name", ((BridgeNeighbour)neighbour).getBus());
                properties.put("remote.messaging.engine.name", ((BridgeNeighbour)neighbour).getName());
                properties.put("remote.messaging.engine.UUID", ((BridgeNeighbour)neighbour).getMessagingEngine().getUuid().toString());
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Issuing event notification: SIB.link.start");
                }
                runtimeEventListener.runtimeEventOccurred(this.meMain.getMessagingEngine(), "SIB.link.start", string, properties);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Not issuing an event notification");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    public void deactivate(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deactivate");
        }
        neighbour.setRecvRouteMap(new CelluleRouteMap(this.meMain));
        neighbour.setSentRouteMap(new CelluleRouteMap(this.meMain));
        neighbour.setSendMagicNumber(0L);
        neighbour.setRecvMagicNumber(0L);
        if (this.listener != null) {
            this.listener.changeConnection(neighbour.getMEConnection(), null);
        }
        if (neighbour.getType() == CommsType.CONNECTION) {
            Object[] objectArray = new Object[]{this.meMain.getName(), this.meMain.getBus(), ((ConnectNeighbour)neighbour).getName()};
            SibTr.info((TraceComponent)tc, (String)"INFO_CWSIT0029", (Object)objectArray);
            if (this.runtimeEventListener == null) {
                this.runtimeEventListener = this.meMain.getRuntimeEventListener();
            }
            if (this.meMain.getMessagingEngine().isEventNotificationEnabled() && this.runtimeEventListener != null) {
                String string = nls.getFormattedMessage("INFO_CWSIT0029", objectArray, null);
                Properties properties = new Properties();
                properties.put("remote.messaging.engine.name", ((ConnectNeighbour)neighbour).getName());
                properties.put("remote.messaging.engine.UUID", ((ConnectNeighbour)neighbour).getMessagingEngine().getUuid().toString());
                if (this.meMain.isStarted()) {
                    properties.put("stop.reason", "communications.terminated");
                } else {
                    properties.put("stop.reason", "local.me.shutdown");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Issuing event notification: SIB.communications.connection.stop");
                }
                this.runtimeEventListener.runtimeEventOccurred(this.meMain.getMessagingEngine(), "SIB.communications.connection.stop", string, properties);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Not issuing an event notification");
            }
        } else if (neighbour.getType() == CommsType.LINK) {
            SibTr.info((TraceComponent)tc, (String)"INFO_CWSIT0031", (Object)new Object[]{this.meMain.getName(), this.meMain.getSubnet(), this.meMain.getBus(), ((LinkNeighbour)neighbour).getName(), ((LinkNeighbour)neighbour).getSubnet()});
        } else if (neighbour.getType() == CommsType.BRIDGE) {
            Object[] objectArray = new Object[]{((BridgeNeighbour)neighbour).getLink(), this.meMain.getName(), this.meMain.getBus(), ((BridgeNeighbour)neighbour).getName(), ((BridgeNeighbour)neighbour).getBus()};
            SibTr.info((TraceComponent)tc, (String)"INFO_CWSIT0033", (Object)objectArray);
            RuntimeEventListener runtimeEventListener = ((BridgeNeighbour)neighbour).getRuntimeEventListener();
            if (this.meMain.getMessagingEngine().isEventNotificationEnabled() && runtimeEventListener != null) {
                String string = nls.getFormattedMessage("INFO_CWSIT0033", objectArray, null);
                Properties properties = new Properties();
                properties.put("foreign.bus.name", ((BridgeNeighbour)neighbour).getBus());
                properties.put("remote.messaging.engine.name", ((BridgeNeighbour)neighbour).getName());
                properties.put("remote.messaging.engine.UUID", ((BridgeNeighbour)neighbour).getMessagingEngine().getUuid().toString());
                if (this.meMain.isStarted()) {
                    if (neighbour.isStarted()) {
                        properties.put("stop.reason", "communications.terminated");
                    } else {
                        properties.put("stop.reason", "stop.reason.administrator.command");
                    }
                } else {
                    properties.put("stop.reason", "local.me.shutdown");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Issuing event notification: SIB.link.stop");
                }
                runtimeEventListener.runtimeEventOccurred(this.meMain.getMessagingEngine(), "SIB.link.stop", string, properties);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Not issuing an event notification");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deactivate");
        }
    }

    private String toString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Cellule cellule;
            Cellule cellule2 = (Cellule)iterator.next();
            if (!bl) {
                stringBuffer.append(",");
            }
            if (cellule2.isMessagingEngine()) {
                cellule = (MessagingEngine)cellule2;
                if (this.meMain.getUuid().equals((Object)((MessagingEngine)cellule).getUuid())) {
                    stringBuffer.append(this.meMain.toShortString());
                } else {
                    Neighbour neighbour = this.meMain.getNeighbourhood().getNeighbour((MessagingEngine)cellule);
                    if (neighbour != null) {
                        stringBuffer.append(neighbour.toShortString());
                    } else {
                        stringBuffer.append(cellule);
                    }
                }
            } else {
                cellule = (LinkCellule)cellule2;
                stringBuffer.append(cellule);
            }
            bl = false;
        }
        return "[" + stringBuffer.toString() + "]";
    }

    public void checkReachability(Neighbour neighbour, MEConnection mEConnection) {
        LinkCellule[] linkCelluleArray;
        Object object;
        Object object2;
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkReachability");
        }
        HashSet hashSet = new HashSet(neighbour.getRecvRouteMap().keySet());
        HashSet hashSet2 = new HashSet(hashSet);
        hashSet2.removeAll(this.oldBusReachable);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Increase in reachability=" + this.toString(hashSet2)));
        }
        if (this.listener != null) {
            int n2 = 0;
            n = 0;
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                object2 = (Cellule)iterator.next();
                if (((Cellule)object2).isMessagingEngine()) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            object2 = new MessagingEngine[n2];
            object = new LinkCellule[n];
            n2 = 0;
            n = 0;
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                linkCelluleArray = (LinkCellule[])iterator.next();
                if (linkCelluleArray.isMessagingEngine()) {
                    object2[n2++] = (MessagingEngine)linkCelluleArray;
                    continue;
                }
                object[n++] = (LinkCellule)linkCelluleArray;
            }
            if (((LinkCellule[])object).length > 0 || ((Object)object2).length > 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Calling listener");
                }
                this.listener.increaseInReachability((LinkCellule[])object, (MessagingEngine[])object2);
            }
        }
        HashSet hashSet3 = new HashSet(neighbour.getOldReachable());
        hashSet3.removeAll(hashSet);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Decrease in reachability=" + this.toString(hashSet3)));
        }
        if (this.listener != null) {
            n = 0;
            int n3 = 0;
            object2 = hashSet3.iterator();
            while (object2.hasNext()) {
                object = (Cellule)object2.next();
                if (((Cellule)object).isMessagingEngine()) {
                    ++n;
                    continue;
                }
                ++n3;
            }
            object = new MessagingEngine[n];
            linkCelluleArray = new LinkCellule[n3];
            n = 0;
            n3 = 0;
            object2 = hashSet3.iterator();
            while (object2.hasNext()) {
                Cellule cellule = (Cellule)object2.next();
                if (cellule.isMessagingEngine()) {
                    object[n++] = (MessagingEngine)cellule;
                    continue;
                }
                linkCelluleArray[n3++] = (LinkCellule)cellule;
            }
            if (linkCelluleArray.length > 0 || ((Object)object).length > 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Calling listener");
                }
                this.listener.decreaseInReachability(mEConnection, linkCelluleArray, (MessagingEngine[])object);
            }
        }
        neighbour.setOldReachable(hashSet);
        this.oldBusReachable.clear();
        Set set = this.meMain.getNeighbourhood().getNeighbours();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (Neighbour)iterator.next();
            if (!((Neighbour)object2).isActive()) continue;
            this.oldBusReachable.addAll(((Neighbour)object2).getRecvRouteMap().keySet());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkReachability");
        }
    }

    MEConnection[] listConns(Cellule cellule) {
        CelluleRouteMap celluleRouteMap;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listConns");
        }
        HashSet<MEConnection> hashSet = new HashSet<MEConnection>();
        int n = Integer.MAX_VALUE;
        Set set = this.meMain.getNeighbourhood().getNeighbours();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (Neighbour)iterator.next();
            if (!((Neighbour)object2).isActive() || (object = (celluleRouteMap = ((Neighbour)object2).getRecvRouteMap()).get(cellule)) == null) continue;
            if ((Integer)object < n) {
                hashSet.clear();
                n = (Integer)object;
            }
            if ((Integer)object != n) continue;
            hashSet.add(((Neighbour)object2).getMEConnection());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (MEConnection)iterator.next();
            if (object2.isReady()) continue;
            iterator.remove();
        }
        if (tc.isDebugEnabled()) {
            object2 = new StringBuffer();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                celluleRouteMap = (MEConnection)iterator.next();
                object = this.meMain.getNeighbourhood().getNeighbour((MEConnection)celluleRouteMap);
                ((StringBuffer)object2).append(" " + ((Neighbour)object).toShortString());
            }
            SibTr.debug((TraceComponent)tc, (String)("Lowest cost routes=" + ((StringBuffer)object2).toString().trim()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listConns");
        }
        return hashSet.toArray(new MEConnection[0]);
    }

    public void topologyChange(Neighbour neighbour) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topologyChange");
        }
        boolean bl2 = bl = neighbour.getType() == CommsType.LINK;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Topology change from a communications: " + neighbour.getType()));
        }
        if (tc.isDebugEnabled()) {
            if (bl) {
                SibTr.debug((TraceComponent)tc, (String)"Topology change is significant external");
            } else {
                SibTr.debug((TraceComponent)tc, (String)"Topology change is not significant external");
            }
        }
        TrmRouteData trmRouteData = null;
        if (this.tmf == null) {
            try {
                this.tmf = TrmMessageFactory.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".topologyChange"), (String)"5", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to obtain a TrmMessageFactory instance");
                }
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (this.tmf != null) {
            try {
                trmRouteData = this.tmf.createTrmRouteData();
            }
            catch (MessageCreateFailedException messageCreateFailedException) {
                FFDCFilter.processException((Throwable)messageCreateFailedException, (String)(className + ".topologyChange"), (String)"6", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to create a TrmRouteData message");
                }
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
            }
        }
        if (trmRouteData != null) {
            trmRouteData.setPriority(9);
            trmRouteData.setOriginator(this.meMain.getUuid());
            if (this.sender == null) {
                this.sender = new Sender(this.meMain);
            }
            Iterator iterator = this.meMain.getNeighbourhood().getNeighbours().iterator();
            while (iterator.hasNext()) {
                Neighbour neighbour2 = (Neighbour)iterator.next();
                if (!neighbour2.isActive()) continue;
                if (neighbour2.getMEConnection().isReady()) {
                    if (neighbour2.getType() == CommsType.LINK || neighbour2.getType() == CommsType.BRIDGE || neighbour2.getType() == CommsType.CONNECTION && bl || neighbour2.getType() == CommsType.CONNECTION && neighbour2.getSentRouteMap().isEmpty() && !this.meMain.getNeighbourhood().getLinked().isEmpty()) {
                        Object object;
                        CelluleRouteMap celluleRouteMap = this.bestRoutesFor(neighbour2);
                        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                        Iterator iterator2 = celluleRouteMap.keySet().iterator();
                        while (iterator2.hasNext()) {
                            object = (Cellule)iterator2.next();
                            arrayList.add(((Cellule)object).getBytes());
                            arrayList2.add(celluleRouteMap.get((Cellule)object));
                        }
                        trmRouteData.setCellules(arrayList);
                        trmRouteData.setCosts(arrayList2);
                        if (!celluleRouteMap.equals(neighbour2.getSentRouteMap())) {
                            trmRouteData.setMagicNumber(neighbour2.getSendMagicNumber());
                            object = this.meMain.getBus();
                            if (neighbour2.getType() == CommsType.BRIDGE) {
                                object = ((BridgeNeighbour)neighbour2).getBus();
                            }
                            this.sender.send((JsMessage)trmRouteData, neighbour2.getMessagingEngine().getUuid(), (String)object);
                            neighbour2.setSentRouteMap(celluleRouteMap);
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("No new topology change info for " + neighbour2.getName()));
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("MEConnection to neighbour " + neighbour2.toShortString() + " not yet ready"));
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.meMain.getNeighbourhood().topologyChange(neighbour2);
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)(neighbour2.toShortString() + " received routing costs = " + neighbour2.getRecvRouteMap()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topologyChange");
        }
    }

    private CelluleRouteMap bestRoutesFor(Neighbour neighbour) {
        Serializable serializable;
        Object object;
        CelluleRouteMap celluleRouteMap = new CelluleRouteMap(this.meMain);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"bestRoutesFor");
        }
        Set set = this.meMain.getNeighbourhood().getNeighbours();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Neighbour)iterator.next();
            if (object == neighbour || !((Neighbour)object).isActive()) continue;
            serializable = ((Neighbour)object).getRecvRouteMap();
            Iterator iterator2 = ((HashMap)serializable).keySet().iterator();
            while (iterator2.hasNext()) {
                Cellule cellule = (Cellule)iterator2.next();
                Integer n = ((CelluleRouteMap)serializable).get(cellule);
                Integer n2 = celluleRouteMap.get(cellule);
                if (n2 != null && n >= n2) continue;
                celluleRouteMap.put(cellule, n);
            }
        }
        iterator = celluleRouteMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (Cellule)iterator.next();
            serializable = celluleRouteMap.get((Cellule)object);
            celluleRouteMap.put(object, new Integer((Integer)serializable + 1));
        }
        celluleRouteMap.put(new MessagingEngine(this.meMain.getUuid()), new Integer(1));
        set = this.meMain.getNeighbourhood().getNeighbours();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Neighbour)iterator.next();
            if (!((Neighbour)object).isActive() || ((Neighbour)object).getType() != CommsType.LINK) continue;
            celluleRouteMap.put(new LinkCellule(this.meMain.getSubnet(), ((LinkNeighbour)object).getSubnet()), new Integer(1));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Best routes for " + neighbour.toShortString() + " = " + celluleRouteMap));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"bestRoutesFor");
        }
        return celluleRouteMap;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.80 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/topology/TopologyManager.java, SIB.trm, WAS602.SIB, o0610.11 05/04/08 02:45:20 [3/13/06 13:39:09]");
        }
    }
}

