/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.topology;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.InvalidBytesException;
import java.io.UnsupportedEncodingException;

public final class LinkCellule
extends Cellule {
    private static final String className = LinkCellule.class.getName();
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private final String DELIM = ":";
    private final String subnet1;
    private final String subnet2;
    private int hashcode;

    public LinkCellule(String string, String string2) {
        if (string == null) {
            throw new NullPointerException(nls.getFormattedMessage("NULL_USED_TO_CREATE_CWSIT0012", new Object[]{"String (subnet1)", "LinkCellule"}, null));
        }
        if (string2 == null) {
            throw new NullPointerException(nls.getFormattedMessage("NULL_USED_TO_CREATE_CWSIT0012", new Object[]{"String (subnet2)", "LinkCellule"}, null));
        }
        this.subnet1 = string;
        this.subnet2 = string2;
    }

    public LinkCellule(byte[] byArray) throws InvalidBytesException {
        if (byArray[0] == 1) {
            String string = null;
            try {
                string = new String(byArray, 1, byArray.length - 1, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)(className + ".<init>"), (String)"1", (Object)this);
            }
            int n = string.indexOf(":");
            if (n > 0) {
                this.subnet1 = string.substring(0, n);
                this.subnet2 = string.substring(n + 1);
            } else if (n == 0) {
                this.subnet1 = "";
                this.subnet2 = string.substring(n + 1);
            } else {
                this.subnet1 = string;
                this.subnet2 = "";
            }
        } else {
            throw new InvalidBytesException(nls.getFormattedMessage("INVALID_BYTE_VALUE_CWSIT0053", new Object[]{new Byte(1), new Byte(byArray[0])}, null));
        }
    }

    public byte[] getBytes() {
        byte[] byArray = null;
        try {
            byArray = this.string().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)(className + ".getBytes"), (String)"2", (Object)this);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 1;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[i];
        }
        return byArray2;
    }

    public String getSubnet1() {
        return this.subnet1;
    }

    public String getSubnet2() {
        return this.subnet2;
    }

    private String string() {
        return this.subnet1 + ":" + this.subnet2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LinkCellule) {
            LinkCellule linkCellule = (LinkCellule)object;
            bl = this.subnet1.equals(linkCellule.subnet1) && this.subnet2.equals(linkCellule.subnet2);
        }
        return bl;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.string().hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        return "[" + this.string() + "]";
    }
}

