/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.contact;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.general.CommsType;
import com.ibm.ws.sib.trm.topology.CelluleRouteMap;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;
import java.util.Set;

public abstract class Neighbour {
    public static final String $ssccid = "@(#) 1.43 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Neighbour.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:10:45 [3/13/06 13:39:06]";
    private static final TraceComponent tc = SibTr.register((Class)Neighbour.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    protected TrmMeMainImpl meMain;
    private String name;
    private MEConnection mec;
    private long lastAttemptTime;
    private MessagingEngine me;
    private CelluleRouteMap recvRouteMap;
    private CelluleRouteMap sentRouteMap;
    private Set oldReachable = new HashSet();
    private long sendMagicNumber;
    private long recvMagicNumber;
    private boolean started;
    private long timeStarted = System.currentTimeMillis();
    private long timeStopped;
    private long timeFailed;

    public Neighbour(TrmMeMainImpl trmMeMainImpl, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"Neighbour");
        }
        this.meMain = trmMeMainImpl;
        this.name = string;
        this.recvRouteMap = new CelluleRouteMap(this.meMain);
        this.sentRouteMap = new CelluleRouteMap(this.meMain);
        this.start();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"Neighbour");
        }
    }

    public synchronized boolean testAndSetActive(MEConnection mEConnection) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"testAndSetActive");
        }
        boolean bl2 = bl = !this.isActive();
        if (bl) {
            this.mec = mEConnection;
            this.lastAttemptTime = 0L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"testAndSetActive", (Object)("rc=" + bl));
        }
        return bl;
    }

    public void setInactive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInactive");
        }
        this.mec = null;
        this.lastAttemptTime = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInactive");
        }
    }

    public void setMessagingEngine(MessagingEngine messagingEngine) {
        this.me = messagingEngine;
    }

    public void setRecvRouteMap(CelluleRouteMap celluleRouteMap) {
        if (this.recvRouteMap.update(celluleRouteMap)) {
            this.meMain.getNeighbourhood().checkReachability(this, this.mec);
            this.meMain.getNeighbourhood().topologyChange(this);
        }
    }

    public void setSentRouteMap(CelluleRouteMap celluleRouteMap) {
        this.sentRouteMap = celluleRouteMap;
    }

    public void setOldReachable(Set set) {
        this.oldReachable = set;
    }

    public void setSendMagicNumber(long l) {
        this.sendMagicNumber = l;
    }

    public void setRecvMagicNumber(long l) {
        this.recvMagicNumber = l;
    }

    public void start() {
        this.started = true;
        this.timeStarted = System.currentTimeMillis();
    }

    public void stop() {
        this.started = false;
        this.timeStopped = System.currentTimeMillis();
    }

    public void failed() {
        this.timeFailed = System.currentTimeMillis();
    }

    public String getBus() {
        return this.meMain.getBus();
    }

    public String getSubnet() {
        return this.meMain.getSubnet();
    }

    public String getName() {
        return this.name;
    }

    public abstract CommsType getType();

    public boolean isActive() {
        return this.mec != null;
    }

    public long getLastAttemptTime() {
        return this.lastAttemptTime;
    }

    public MEConnection getMEConnection() {
        return this.mec;
    }

    public MessagingEngine getMessagingEngine() {
        return this.me;
    }

    public CelluleRouteMap getRecvRouteMap() {
        return this.recvRouteMap;
    }

    public CelluleRouteMap getSentRouteMap() {
        return this.sentRouteMap;
    }

    public Set getOldReachable() {
        return this.oldReachable;
    }

    public long getSendMagicNumber() {
        return this.sendMagicNumber;
    }

    public long getRecvMagicNumber() {
        return this.recvMagicNumber;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public long getTimeStopped() {
        return this.timeStopped;
    }

    public long getTimeFailed() {
        return this.timeFailed;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String toShortString() {
        return this.getBus() + ":" + this.getName();
    }

    public String toString() {
        return "name=" + this.name + ",active=" + this.isActive() + ",lastAttemptTime=" + this.lastAttemptTime + ",uuid=" + this.me + ",MEConnection=" + this.mec + ",Recv Route Map=" + this.recvRouteMap + ",Sent Route Map=" + this.sentRouteMap + ",sendMagicNumber=" + this.sendMagicNumber + ",recvMagicNumer=" + this.recvMagicNumber + ",started=" + this.started + ",timeStarted=" + this.timeStarted + ",timeStopped=" + this.timeStopped + ",timeFailed=" + this.timeFailed;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.43 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Neighbour.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:10:45 [3/13/06 13:39:06]");
        }
    }
}

