/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.contact;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMeConnectRequest;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.contact.ConnectNeighbour;
import com.ibm.ws.sib.trm.contact.MeHandler;
import com.ibm.ws.sib.trm.general.MagicNumber;
import com.ibm.ws.sib.utils.ras.SibTr;

final class MeConnectHandler
extends MeHandler {
    public static final String $ssccid = "@(#) 1.28 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/MeConnectHandler.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:10:03 [3/13/06 13:39:15]";

    public MeConnectHandler(TrmMeMainImpl trmMeMainImpl, ConnectNeighbour connectNeighbour) {
        super(trmMeMainImpl, connectNeighbour);
    }

    public boolean connect(MEConnection mEConnection) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connect");
        }
        try {
            TrmMessageFactory trmMessageFactory = TrmMessageFactory.getInstance();
            this.neighbour.setSendMagicNumber(MagicNumber.generate());
            TrmMeConnectRequest trmMeConnectRequest = trmMessageFactory.createNewTrmMeConnectRequest();
            trmMeConnectRequest.setRequiredBusName(this.meMain.getBus());
            trmMeConnectRequest.setUserid(this.meMain.getUserid());
            trmMeConnectRequest.setPassword(this.meMain.getPassword());
            trmMeConnectRequest.setRequiredSubnetName(this.meMain.getSubnet());
            trmMeConnectRequest.setRequiredMeName(this.neighbour.getName());
            trmMeConnectRequest.setRequestingMeName(this.meMain.getName());
            trmMeConnectRequest.setRequestingMeUuid(this.meMain.getUuid());
            trmMeConnectRequest.setMagicNumber(this.neighbour.getSendMagicNumber());
            trmMeConnectRequest.setSubnetMessagingEngines(this.meMain.getNeighbourhood().getConnected());
            byte[] byArray = trmMeConnectRequest.encode((Object)mEConnection);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)Utils.outBound((String)"messaging engine connect request"));
            }
            byte[] byArray2 = mEConnection.trmHandshakeExchange(byArray);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)Utils.inBound((String)"messaging engine connect reply"));
            }
            this.fcm = trmMessageFactory.createInboundTrmFirstContactMessage(byArray2, 0, byArray2.length);
            if (this.fcm.getMessageType() != TrmFirstContactMessageType.ME_CONNECT_REPLY) {
                SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_CWSIT0042", (Object)new Object[]{this.neighbour.getName(), this.meMain.getBus(), this.fcm.getMessageType().toString(), TrmFirstContactMessageType.ME_CONNECT_REPLY.toString()});
                bl = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(className + ".connect"), (String)"1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connect");
        }
        return bl;
    }

    static {
        className = MeConnectHandler.class.getName();
        tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.28 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/MeConnectHandler.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:10:03 [3/13/06 13:39:15]");
        }
    }
}

