/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.contact;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.EndPoint;
import com.ibm.ws.sib.comms.MEComponentHandshake;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionFactory;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessage;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMeLinkReply;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.contact.LinkNeighbour;
import com.ibm.ws.sib.trm.contact.MeLinkHandler;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

final class Link {
    public static final String $ssccid = "@(#) 1.40 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Link.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:09:04 [3/13/06 13:39:15]";
    private static final TraceComponent tc = SibTr.register((Class)Link.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;

    public Link(TrmMeMainImpl trmMeMainImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Link");
        }
        this.meMain = trmMeMainImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Link");
        }
    }

    public void contact(LinkNeighbour linkNeighbour) {
        block22: {
            MEConnectionFactory mEConnectionFactory;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"contact");
            }
            boolean bl = true;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Making link request to " + linkNeighbour.getName() + " in subnet " + linkNeighbour.getSubnet() + " using chain " + linkNeighbour.getChain() + " at " + linkNeighbour.getHost() + ":" + linkNeighbour.getPort()));
            }
            if ((mEConnectionFactory = MEConnectionFactory.getReference()) == null) {
                SibTr.error((TraceComponent)tc, (String)"NO_MCF_CWSIT0046");
                bl = false;
            }
            if (bl) {
                MEConnection mEConnection = mEConnectionFactory.createMEConnection();
                if (mEConnection != null) {
                    mEConnection.setMessagingEngine(this.meMain.getMessagingEngine());
                    if (!linkNeighbour.testAndSetActive(mEConnection)) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Neighbour entry already active");
                        }
                        bl = false;
                    }
                    if (bl) {
                        ConnectionProperties connectionProperties = new ConnectionProperties(new EndPoint(linkNeighbour.getHost(), linkNeighbour.getPort()), linkNeighbour.getChain());
                        try {
                            MeLinkHandler meLinkHandler = new MeLinkHandler(this.meMain, linkNeighbour);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)Utils.outBound((String)"connection"));
                            }
                            mEConnection.connect(connectionProperties, (MEComponentHandshake)meLinkHandler);
                            TrmFirstContactMessage trmFirstContactMessage = meLinkHandler.getReply();
                            if (trmFirstContactMessage != null) {
                                TrmMeLinkReply trmMeLinkReply = trmFirstContactMessage.makeInboundTrmMeLinkReply();
                                if (trmMeLinkReply.getReturnCode() == 0) {
                                    linkNeighbour.setMessagingEngine(new MessagingEngine(trmMeLinkReply.getReplyingMeUuid()));
                                    linkNeighbour.setRecvMagicNumber(trmMeLinkReply.getMagicNumber());
                                    this.meMain.getTopologyManager().activate(linkNeighbour);
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)"Link established");
                                    }
                                } else {
                                    if (trmMeLinkReply.getReturnCode() == 2) {
                                        if (tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)"Link clash detected by other messaging engine");
                                        }
                                    } else {
                                        SibTr.error((TraceComponent)tc, (String)"MIRRORED_FAILURE_CWSIT0014", (Object)new Object[]{linkNeighbour.getName(), this.meMain.getBus(), linkNeighbour.getHost() + ":" + linkNeighbour.getPort() + ":" + linkNeighbour.getChain(), Utils.getFailureMessage((List)trmMeLinkReply.getFailureReason())});
                                    }
                                    linkNeighbour.setInactive();
                                    mEConnection.close();
                                }
                                break block22;
                            }
                            SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_CWSIT0040", (Object)new Object[]{linkNeighbour.getName(), this.meMain.getBus(), "null", TrmFirstContactMessageType.ME_LINK_REPLY.toString()});
                            linkNeighbour.setInactive();
                            mEConnection.close();
                        }
                        catch (Exception exception) {
                            SibTr.exception((TraceComponent)tc, (Exception)exception);
                            SibTr.warning((TraceComponent)tc, (String)"LINK_FAILED_CWSIT0017", (Object)new Object[]{linkNeighbour.getName(), this.meMain.getBus(), linkNeighbour.getHost(), linkNeighbour.getPort(), linkNeighbour.getChain()});
                            linkNeighbour.setInactive();
                            try {
                                mEConnection.close();
                            }
                            catch (Exception exception2) {}
                        }
                    }
                } else {
                    SibTr.error((TraceComponent)tc, (String)"NO_MC_CWSIT0049");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"contact");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.40 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Link.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:09:04 [3/13/06 13:39:15]");
        }
    }
}

