/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.contact;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.MEComponentHandshake;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionFactory;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessage;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMeConnectReply;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.contact.ConnectNeighbour;
import com.ibm.ws.sib.trm.contact.MeConnectHandler;
import com.ibm.ws.sib.trm.contact.Neighbourhood;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import java.util.Iterator;
import java.util.List;

final class Connect {
    public static final String $ssccid = "@(#) 1.62 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Connect.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:08:35 [3/13/06 13:39:15]";
    private static final TraceComponent tc = SibTr.register((Class)Connect.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;
    private static final int MAX_ATTEMPTS = 2;

    public Connect(TrmMeMainImpl trmMeMainImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Connect");
        }
        this.meMain = trmMeMainImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Connect");
        }
    }

    public void contact(ConnectNeighbour connectNeighbour) {
        block28: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"contact");
            }
            boolean bl = true;
            CFEndPoint cFEndPoint = this.meMain.getWlmManager().resolve(this.meMain.getBus(), this.meMain.getSubnet(), connectNeighbour.getName(), this.meMain.getTransportChain());
            if (cFEndPoint == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Unable to resolve end point");
                }
                bl = false;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Making connection request to " + connectNeighbour.getName()));
            }
            MEConnectionFactory mEConnectionFactory = MEConnectionFactory.getReference();
            if (mEConnectionFactory == null) {
                SibTr.error((TraceComponent)tc, (String)"NO_MCF_CWSIT0045");
                bl = false;
            }
            if (bl) {
                MEConnection mEConnection = mEConnectionFactory.createMEConnection();
                if (mEConnection != null) {
                    mEConnection.setMessagingEngine(this.meMain.getMessagingEngine());
                    if (!connectNeighbour.testAndSetActive(mEConnection)) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Neighbour entry already active");
                        }
                        bl = false;
                    }
                    if (bl) {
                        ConnectionProperties connectionProperties = new ConnectionProperties(cFEndPoint);
                        try {
                            MeConnectHandler meConnectHandler = new MeConnectHandler(this.meMain, connectNeighbour);
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)Utils.outBound((String)"connection"));
                            }
                            mEConnection.connect(connectionProperties, (MEComponentHandshake)meConnectHandler);
                            TrmFirstContactMessage trmFirstContactMessage = meConnectHandler.getReply();
                            if (trmFirstContactMessage != null) {
                                TrmMeConnectReply trmMeConnectReply = trmFirstContactMessage.makeInboundTrmMeConnectReply();
                                if (trmMeConnectReply.getReturnCode() == 0) {
                                    connectNeighbour.setMessagingEngine(new MessagingEngine(trmMeConnectReply.getReplyingMeUuid()));
                                    connectNeighbour.setRecvMagicNumber(trmMeConnectReply.getMagicNumber());
                                    Neighbourhood neighbourhood = this.meMain.getNeighbourhood();
                                    List list = trmMeConnectReply.getSubnetMessagingEngines();
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("Known subnet engines = " + list));
                                    }
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        String string = (String)iterator.next();
                                        if (this.meMain.getName().equals(string) || neighbourhood.getConnect(string) != null) continue;
                                        if (tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)("Discovered new engine: " + string));
                                        }
                                        ConnectNeighbour connectNeighbour2 = new ConnectNeighbour(this.meMain, string);
                                        neighbourhood.addNeighbour(connectNeighbour2);
                                    }
                                    this.meMain.getTopologyManager().activate(connectNeighbour);
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)"Connection established");
                                    }
                                } else {
                                    if (trmMeConnectReply.getReturnCode() == 2) {
                                        if (tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)"Connection clash detected by other messaging engine");
                                        }
                                    } else {
                                        SibTr.error((TraceComponent)tc, (String)"MIRRORED_FAILURE_CWSIT0034", (Object)new Object[]{connectNeighbour.getName(), this.meMain.getBus(), Utils.getFailureMessage((List)trmMeConnectReply.getFailureReason())});
                                    }
                                    connectNeighbour.setInactive();
                                    mEConnection.close();
                                }
                                break block28;
                            }
                            SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_CWSIT0039", (Object)new Object[]{connectNeighbour.getName(), this.meMain.getBus(), "null", TrmFirstContactMessageType.ME_CONNECT_REPLY.toString()});
                            connectNeighbour.setInactive();
                            mEConnection.close();
                        }
                        catch (Exception exception) {
                            SibTr.exception((TraceComponent)tc, (Exception)exception);
                            SibTr.warning((TraceComponent)tc, (String)"CONNECT_FAILED_CWSIT0015", (Object)new Object[]{connectNeighbour.getName(), this.meMain.getBus()});
                            connectNeighbour.setInactive();
                            try {
                                mEConnection.close();
                            }
                            catch (Exception exception2) {}
                        }
                    }
                } else {
                    SibTr.error((TraceComponent)tc, (String)"NO_MC_CWSIT0048");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"contact");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.62 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Connect.java, SIB.trm, WAS602.SIB, o0610.11 05/02/23 09:08:35 [3/13/06 13:39:15]");
        }
    }
}

