/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.contact;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.EndPoint;
import com.ibm.ws.sib.comms.MEComponentHandshake;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionFactory;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessage;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMeBridgeBootstrapReply;
import com.ibm.ws.sib.mfp.trm.TrmMeBridgeReply;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.trm.client.ClientAttachProperties;
import com.ibm.ws.sib.trm.client.TrmEndPoint;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.trm.contact.BridgeNeighbour;
import com.ibm.ws.sib.trm.contact.MeBridgeBootstrapHandler;
import com.ibm.ws.sib.trm.contact.MeBridgeHandler;
import com.ibm.ws.sib.trm.contact.MeHandler;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

final class Bridge {
    public static final String $ssccid = "@(#) 1.44 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Bridge.java, SIB.trm, WAS602.SIB, o0610.11 05/05/09 08:04:51 [3/13/06 13:39:14]";
    private static final String className = Bridge.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private TrmMeMainImpl meMain;

    public Bridge(TrmMeMainImpl trmMeMainImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Bridge");
        }
        this.meMain = trmMeMainImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Bridge");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contact(BridgeNeighbour bridgeNeighbour) {
        block50: {
            Object object;
            Object object2;
            CFEndPoint cFEndPoint;
            String string;
            Object object3;
            Object object4;
            Object object5;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"contact");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Making bridge request for link " + bridgeNeighbour.getLink() + " to engine " + bridgeNeighbour.getName() + " in bus " + bridgeNeighbour.getBus() + " using " + bridgeNeighbour.getTransportChain() + " bootstrap " + bridgeNeighbour.getBootstrapEPs()));
            }
            MEConnection mEConnection = null;
            TrmMeBridgeBootstrapReply trmMeBridgeBootstrapReply = null;
            int n = -1;
            boolean bl = false;
            MEConnectionFactory mEConnectionFactory = MEConnectionFactory.getReference();
            if (mEConnectionFactory == null) {
                SibTr.error((TraceComponent)tc, (String)"NO_MCF_CWSIT0044");
            } else {
                object5 = bridgeNeighbour.getBootstrapEPs();
                if (object5 == null || ((String)object5).equals("")) {
                    object5 = "localhost";
                }
                object4 = new ArrayList(3);
                try {
                    ClientAttachProperties.parseProviderEndpoints((String)object5, (List)object4);
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    FFDCFilter.processException((Throwable)sIIncorrectCallException, (String)(className + ".contact"), (String)"2", (Object)this);
                }
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    string = (TrmEndPoint)object3.next();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Using endpoint: " + string));
                    }
                    if ((mEConnection = mEConnectionFactory.createMEConnection()) != null) {
                        if (bridgeNeighbour.testAndSetActive(mEConnection)) {
                            mEConnection.setMessagingEngine(this.meMain.getMessagingEngine());
                            cFEndPoint = new ConnectionProperties(new EndPoint(string.getHost(), string.getPort()), string.getChain());
                            object2 = new MeBridgeBootstrapHandler(this.meMain, bridgeNeighbour);
                            try {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)Utils.outBound((String)"connection"));
                                }
                                mEConnection.connect((ConnectionProperties)cFEndPoint, (MEComponentHandshake)object2);
                                object = ((MeHandler)object2).getReply();
                                if (object != null) {
                                    trmMeBridgeBootstrapReply = object.makeInboundTrmMeBridgeBootstrapReply();
                                    bl = true;
                                    n = trmMeBridgeBootstrapReply.getReturnCode();
                                    if (n == 1) break;
                                    SibTr.error((TraceComponent)tc, (String)"MIRRORED_FAILURE_CWSIT0057", (Object)new Object[]{bridgeNeighbour.getLink(), string.getHost(), Utils.getFailureMessage((List)trmMeBridgeBootstrapReply.getFailureReason())});
                                    continue;
                                }
                                SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_CWSIT0061", (Object)new Object[]{bridgeNeighbour.getName(), bridgeNeighbour.getBus(), "null", TrmFirstContactMessageType.ME_BRIDGE_BOOTSTRAP_REPLY.toString()});
                                continue;
                            }
                            catch (Exception exception) {
                                SibTr.exception((TraceComponent)tc, (Exception)exception);
                                SibTr.warning((TraceComponent)tc, (String)"BRIDGE_FAILED_CWSIT0018", (Object)new Object[]{bridgeNeighbour.getLink(), bridgeNeighbour.getName(), bridgeNeighbour.getBus(), string.getHost(), string.getPort(), string.getChain()});
                                continue;
                            }
                            finally {
                                try {
                                    mEConnection.close();
                                }
                                catch (Exception exception) {}
                                bridgeNeighbour.setInactive();
                                continue;
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)"Clash detected");
                        continue;
                    }
                    SibTr.error((TraceComponent)tc, (String)"NO_MC_CWSIT0047");
                }
            }
            if (bl && n == 1) {
                object5 = trmMeBridgeBootstrapReply.getEndPointData();
                object4 = trmMeBridgeBootstrapReply.getBusName();
                object3 = trmMeBridgeBootstrapReply.getSubnetName();
                string = trmMeBridgeBootstrapReply.getMessagingEngineName();
                if (bridgeNeighbour.getName().equals(string)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Redirecting to bus=" + (String)object4 + " subnet=" + (String)object3 + " engine=" + string));
                    }
                    if ((mEConnection = mEConnectionFactory.createMEConnection()) != null) {
                        if (bridgeNeighbour.testAndSetActive(mEConnection)) {
                            mEConnection.setMessagingEngine(this.meMain.getMessagingEngine());
                            try {
                                object2 = new ByteArrayInputStream((byte[])object5);
                                object = new ObjectInputStream((InputStream)object2);
                                cFEndPoint = (CFEndPoint)((ObjectInputStream)object).readObject();
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)(className + ".contact"), (String)"1", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)exception);
                                cFEndPoint = null;
                            }
                            if (cFEndPoint != null) {
                                object2 = new ConnectionProperties(cFEndPoint);
                                object = new MeBridgeHandler(this.meMain, bridgeNeighbour);
                                try {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)Utils.outBound((String)"onnection"));
                                    }
                                    mEConnection.connect((ConnectionProperties)object2, (MEComponentHandshake)object);
                                    TrmFirstContactMessage trmFirstContactMessage = ((MeHandler)object).getReply();
                                    TrmMeBridgeReply trmMeBridgeReply = trmFirstContactMessage.makeInboundTrmMeBridgeReply();
                                    if (trmMeBridgeReply.getReturnCode() == 0) {
                                        bridgeNeighbour.setMessagingEngine(new MessagingEngine(trmMeBridgeReply.getReplyingMeUuid()));
                                        bridgeNeighbour.setRecvMagicNumber(trmMeBridgeReply.getMagicNumber());
                                        bridgeNeighbour.setConnected();
                                        this.meMain.getTopologyManager().activate(bridgeNeighbour);
                                        if (tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)"Bridge established");
                                        }
                                        break block50;
                                    }
                                    if (trmMeBridgeReply.getReturnCode() == 2) {
                                        if (tc.isDebugEnabled()) {
                                            SibTr.debug((TraceComponent)tc, (String)"Bridge clash detected by other messaging engine");
                                        }
                                    } else {
                                        SibTr.error((TraceComponent)tc, (String)"MIRRORED_FAILURE_CWSIT0057", (Object)new Object[]{bridgeNeighbour.getLink(), bridgeNeighbour.getBus(), Utils.getFailureMessage((List)trmMeBridgeReply.getFailureReason())});
                                    }
                                    bridgeNeighbour.setInactive();
                                    mEConnection.close();
                                }
                                catch (Exception exception) {
                                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                                    SibTr.warning((TraceComponent)tc, (String)"BRIDGE_FAILED_CWSIT0059", (Object)new Object[]{bridgeNeighbour.getLink(), bridgeNeighbour.getName(), bridgeNeighbour.getBus()});
                                    bridgeNeighbour.setInactive();
                                    try {
                                        mEConnection.close();
                                    }
                                    catch (Exception exception2) {}
                                }
                            }
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Clash detected");
                        }
                    } else {
                        SibTr.error((TraceComponent)tc, (String)"NO_MC_CWSIT0047");
                    }
                } else {
                    SibTr.error((TraceComponent)tc, (String)"BRIDGE_FAILED_CWSIT0058", (Object)new Object[]{bridgeNeighbour.getLink(), bridgeNeighbour.getName(), bridgeNeighbour.getBus(), string});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"contact");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.44 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/contact/Bridge.java, SIB.trm, WAS602.SIB, o0610.11 05/05/09 08:04:51 [3/13/06 13:39:14]");
        }
    }
}

