/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.attach;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.comms.DirectConnection;
import com.ibm.ws.sib.security.auth.SibLogin;
import com.ibm.ws.sib.security.auth.SibLoginFactory;
import com.ibm.ws.sib.trm.TrmMeMainImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import java.util.Enumeration;
import java.util.Properties;
import javax.security.auth.Subject;

public final class DirectConnect {
    public static final String $ssccid = "@(#) 1.21 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/attach/DirectConnect.java, SIB.trm, WAS602.SIB, o0610.11 05/07/15 10:29:33 [3/13/06 13:39:05]";
    private static final String className = DirectConnect.class.getName();
    private static final TraceComponent tc = SibTr.register((String)className, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static SibLogin sibLogin = SibLoginFactory.getInstance().createNewSibLogin();

    public boolean connect(DirectConnection directConnection, String string, String string2) throws SIAuthenticationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connect");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("userid=" + string + ",password=" + string2));
        }
        boolean bl = false;
        Subject subject = sibLogin.login(directConnection.getBus(), string, string2);
        if (subject == null) {
            JsMessagingEngine jsMessagingEngine = this.findMessagingEngine(directConnection);
            if (jsMessagingEngine != null) {
                RuntimeEventListener runtimeEventListener = ((JsEngineComponentWithEventListener)jsMessagingEngine.getMessageProcessor()).getRuntimeEventListener();
                if (jsMessagingEngine.isEventNotificationEnabled() && runtimeEventListener != null) {
                    String string3 = nls.getFormattedMessage("FAILED_AUTHENTICATION_CWSIT0089", new Object[]{string, directConnection.getBus()}, null);
                    Properties properties = new Properties();
                    properties.put("operation", "operation.connect");
                    if (string != null) {
                        properties.put("security.userid", string);
                        properties.put("security.reason", "security.reason.not.authenticated");
                    } else {
                        properties.put("security.reason", "security.reason.no.userid");
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Issuing event notification: SIB.security.not.authenticated");
                    }
                    runtimeEventListener.runtimeEventOccurred(jsMessagingEngine, "SIB.security.not.authenticated", string3, properties);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Not issuing an event notification");
                }
            }
            throw new SIAuthenticationException(null);
        }
        bl = this.connect(directConnection, subject);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connect");
        }
        return bl;
    }

    boolean connect(DirectConnection directConnection, Subject subject) {
        JsMessagingEngine jsMessagingEngine;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connect");
        }
        boolean bl = true;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Direct connection to bus=" + directConnection.getBus() + " messaging engine=" + directConnection.getName()));
        }
        if ((jsMessagingEngine = this.findMessagingEngine(directConnection)) != null) {
            SibTr.push((Object)jsMessagingEngine);
            JsEngineComponent jsEngineComponent = jsMessagingEngine.getMessageProcessor();
            SICoreConnectionFactory sICoreConnectionFactory = (SICoreConnectionFactory)jsEngineComponent;
            SICoreConnection sICoreConnection = null;
            try {
                sICoreConnection = sICoreConnectionFactory.createConnection(subject, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(className + ".connect"), (String)"1", (Object)this);
                sICoreConnection = null;
            }
            if (sICoreConnection != null) {
                directConnection.setSICoreConnection(sICoreConnection);
            } else {
                bl = false;
            }
            SibTr.pop();
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connect");
        }
        return bl;
    }

    private JsMessagingEngine findMessagingEngine(DirectConnection directConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findMessagingEngine");
        }
        String string = directConnection.getBus();
        String string2 = directConnection.getName();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("bus=" + string + ",name=" + string2));
        }
        JsMessagingEngine jsMessagingEngine = null;
        Enumeration enumeration = JsAdminService.getInstance().listMessagingEngines(string);
        while (enumeration.hasMoreElements() && jsMessagingEngine == null) {
            JsMessagingEngine jsMessagingEngine2 = (JsMessagingEngine)enumeration.nextElement();
            TrmMeMainImpl trmMeMainImpl = (TrmMeMainImpl)jsMessagingEngine2.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl");
            if (!trmMeMainImpl.isStarted() || !trmMeMainImpl.getName().equals(string2)) continue;
            jsMessagingEngine = jsMessagingEngine2;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("rc=" + jsMessagingEngine));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findMessagingEngine");
        }
        return jsMessagingEngine;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.21 SIB/ws/code/sib.trm.impl/src/com/ibm/ws/sib/trm/attach/DirectConnect.java, SIB.trm, WAS602.SIB, o0610.11 05/07/15 10:29:33 [3/13/06 13:39:05]");
        }
    }
}

