/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.auth;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.sib.security.auth.AuditLogger;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsImpl;
import com.ibm.ws.sib.security.auth.SIBPrincipal;
import com.ibm.ws.sib.security.auth.SibLogin;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.Subject;

public class SibLoginImpl
implements SibLogin {
    private static final TraceComponent _tc = SibTr.register((Class)SibLoginImpl.class, (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
    private static AuthUtils _authUtils = new AuthUtilsImpl();
    static /* synthetic */ Class class$com$ibm$ws$sib$security$auth$SibLoginImpl$LoginAction;
    static /* synthetic */ Class class$com$ibm$websphere$security$cred$WSCredential;

    public Subject login(String string, String string2) {
        Subject subject = null;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"login", (Object)new Object[]{string, "password not traced"});
        }
        if (SecurityContext.isSecurityEnabled()) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"Server security is enabled, checking the username and pwd");
            }
            subject = (Subject)AccessController.doPrivileged(new LoginAction(true, string, string2, true));
        } else {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"Server security is disabled so allow the authentication to pass");
            }
            subject = new Subject();
        }
        if (subject != null) {
            SibLoginImpl.setReadOnly(subject);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)SibLoginImpl.getTraceString(subject));
        }
        return subject;
    }

    public Subject login(String string, Subject subject) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"login", (Object)new Object[]{string, SibLoginImpl.getTraceString(subject)});
        }
        LoginAction loginAction = new LoginAction(_authUtils.isBusSecure(string), subject);
        Subject subject2 = this.login(string, loginAction);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)SibLoginImpl.getTraceString(subject2));
        }
        return subject2;
    }

    public Subject login(String string, String string2, String string3) {
        Subject subject = null;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"login", (Object)new Object[]{string, string2, "password not traced"});
        }
        boolean bl = _authUtils.isBusSecure(string);
        if (_tc.isDebugEnabled()) {
            if (bl) {
                SibTr.debug((TraceComponent)_tc, (String)"Bus security is enabled, checking the username");
            } else {
                SibTr.debug((TraceComponent)_tc, (String)"Bus security is disabled so allow the validation to pass");
            }
        }
        LoginAction loginAction = new LoginAction(bl, string2, string3, false);
        subject = this.login(string, loginAction);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)SibLoginImpl.getTraceString(subject));
        }
        return subject;
    }

    public Subject validateUsername(String string, String string2) {
        Subject subject = null;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"validateUsername", (Object)new Object[]{string, string2});
        }
        boolean bl = _authUtils.isBusSecure(string);
        if (_tc.isDebugEnabled()) {
            if (bl) {
                SibTr.debug((TraceComponent)_tc, (String)"Bus security is enabled, checking the username");
            } else {
                SibTr.debug((TraceComponent)_tc, (String)"Bus security is disabled so allow the validation to pass");
            }
        }
        LoginAction loginAction = new LoginAction(bl, string2);
        subject = this.login(string, loginAction);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"validateUsername", (Object)SibLoginImpl.getTraceString(subject));
        }
        return subject;
    }

    private Subject login(String string, LoginAction loginAction) {
        Subject subject;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"login", (Object)new Object[]{string, loginAction});
        }
        if (this.isAuthenticated(subject = (Subject)AccessController.doPrivileged(loginAction))) {
            AuditLogger.authenticationSucceeded(string, loginAction.getUserName());
        }
        if (subject == null) {
            AuditLogger.authenticationFailed(string, loginAction.getUserName());
        } else {
            SibLoginImpl.setReadOnly(subject);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"login", (Object)SibLoginImpl.getTraceString(subject));
        }
        return subject;
    }

    private boolean isAuthenticated(Subject subject) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"isAuthenticated", (Object)SibLoginImpl.getTraceString(subject));
        }
        boolean bl = false;
        if (subject != null) {
            SIBPrincipal sIBPrincipal = (SIBPrincipal)subject.getPrincipals(SIBPrincipal.class).iterator().next();
            bl = sIBPrincipal.isAuthenticated();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"isAuthenticated", (Object)new Boolean(bl));
        }
        return bl;
    }

    private static void setReadOnly(final Subject subject) {
        if (!subject.isReadOnly()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    subject.setReadOnly();
                    return null;
                }
            });
        }
    }

    private static String getTraceString(Subject subject) {
        String string = "<null>";
        if (subject != null) {
            string = "Subject hashcode=0x" + Integer.toHexString(subject.hashCode());
        }
        return string;
    }

    private static class LoginAction
    implements PrivilegedAction {
        private String _username;
        private String _password;
        private boolean _passwordProvided;
        private boolean _serverLogin;
        private Subject _subject;
        private boolean _busSecure;
        private boolean _doingSubjectAuthentication;
        private static final ContextManager _contextMgr;
        private static final String _realm;
        private static final Map _subjectCache;
        private static final TraceComponent _tc2;

        public LoginAction(boolean bl, String string, String string2, boolean bl2) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"LoginAction", (Object)new Object[]{new Boolean(bl), string, "password not traced", new Boolean(bl2)});
            }
            this._busSecure = bl;
            this._username = string;
            this._password = string2;
            this._passwordProvided = true;
            this._serverLogin = bl2;
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"LoginAction", (Object)this);
            }
        }

        public LoginAction(boolean bl, String string) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"LoginAction", (Object)string);
            }
            this._username = string;
            this._passwordProvided = false;
            this._busSecure = bl;
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"LoginAction", (Object)this);
            }
        }

        public LoginAction(boolean bl, Subject subject) {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"LoginAction", (Object)new Object[]{new Boolean(bl), SibLoginImpl.getTraceString(subject)});
            }
            this._subject = subject;
            this._busSecure = bl;
            this._doingSubjectAuthentication = true;
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"LoginAction", (Object)this);
            }
        }

        public Object run() {
            Subject subject;
            block9: {
                if (_tc2.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"run");
                }
                subject = null;
                if (this._doingSubjectAuthentication) {
                    subject = this.doSubjectLogin();
                } else {
                    if (this._busSecure || this._serverLogin) {
                        try {
                            if (this._passwordProvided) {
                                subject = this._username != null && !"".equals(this._username) || this._password != null && !"".equals(this._password) ? this.doUserNamePasswordLogin() : this.doAnonymousLogin();
                                break block9;
                            }
                            subject = this.doUserNameLogin();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.security.auth.SibLoginImpl.LoginAction.run", (String)"228", (Object)this);
                            if (_tc2.isEventEnabled()) {
                                SibTr.event((TraceComponent)_tc2, (String)"absorbing", (Object)exception);
                            }
                            break block9;
                        }
                    }
                    subject = this.doUnauthenticatedLogin();
                }
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"run", (Object)SibLoginImpl.getTraceString(subject));
            }
            return subject;
        }

        private Subject doUnauthenticatedLogin() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"doUnauthenticatedLogin");
            }
            HashSet<SIBPrincipal> hashSet = new HashSet<SIBPrincipal>();
            hashSet.add(new SIBPrincipal(this._username));
            HashSet hashSet2 = new HashSet();
            Subject subject = new Subject(false, hashSet, hashSet2, hashSet2);
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"doUnauthenticatedLogin", (Object)SibLoginImpl.getTraceString(subject));
            }
            return subject;
        }

        private Subject convertSubject(Subject subject, SIBPrincipal sIBPrincipal) {
            Subject subject2;
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"convertSubject", (Object)new Object[]{SibLoginImpl.getTraceString(subject), sIBPrincipal});
            }
            if (this._serverLogin) {
                subject2 = subject;
            } else if (subject != null) {
                subject2 = (Subject)_subjectCache.get(subject);
                if (subject2 == null) {
                    subject2 = new Subject();
                    subject2.getPrincipals().addAll(subject.getPrincipals());
                    subject2.getPublicCredentials().addAll(subject.getPublicCredentials());
                    subject2.getPrivateCredentials().addAll(subject.getPrivateCredentials());
                    subject2.getPrincipals().add(sIBPrincipal);
                    _subjectCache.put(subject, subject2);
                }
            } else {
                subject2 = null;
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"convertSubject", (Object)SibLoginImpl.getTraceString(subject2));
            }
            return subject2;
        }

        private Subject doSubjectLogin() {
            Subject subject;
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"doSubjectLogin");
            }
            if (this._subject != null && this._subject.getPrincipals(class$com$ibm$ws$sib$security$auth$SIBPrincipal == null ? (class$com$ibm$ws$sib$security$auth$SIBPrincipal = SibLoginImpl.class$("com.ibm.ws.sib.security.auth.SIBPrincipal")) : class$com$ibm$ws$sib$security$auth$SIBPrincipal).size() == 0) {
                if (!this._serverLogin) {
                    Set set = this._subject.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = SibLoginImpl.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential);
                    if (set.size() != 0) {
                        SIBPrincipal sIBPrincipal = null;
                        WSCredential wSCredential = (WSCredential)set.iterator().next();
                        sIBPrincipal = wSCredential.isUnauthenticated() ? new SIBPrincipal("") : new SIBPrincipal(_authUtils.getUserName(this._subject), false, this._busSecure);
                        subject = this.convertSubject(this._subject, sIBPrincipal);
                    } else {
                        subject = this._busSecure ? null : this.doAnonymousLogin();
                    }
                } else {
                    subject = this.convertSubject(this._subject, null);
                }
            } else {
                subject = this._subject == null ? null : this._subject;
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"doSubjectLogin", (Object)SibLoginImpl.getTraceString(subject));
            }
            return subject;
        }

        private Subject doAnonymousLogin() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"doAnonymousLogin");
            }
            Subject subject = null;
            try {
                subject = _contextMgr.createUnauthenticatedSubject();
                subject = this.convertSubject(subject, new SIBPrincipal(this._username));
            }
            catch (WSSecurityException wSSecurityException) {
                // empty catch block
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"doAnonymousLogin", (Object)SibLoginImpl.getTraceString(subject));
            }
            return subject;
        }

        private Subject doUserNameLogin() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"doUserNameLogin");
            }
            Subject subject = null;
            if (this._busSecure) {
                try {
                    subject = _contextMgr.login(_realm, this._username);
                    subject = this.convertSubject(subject, new SIBPrincipal(this._username, true, true));
                }
                catch (WSLoginFailedException wSLoginFailedException) {}
            } else {
                subject = this.doUnauthenticatedLogin();
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"doUserNameLogin", (Object)SibLoginImpl.getTraceString(subject));
            }
            return subject;
        }

        private Subject doUserNamePasswordLogin() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"doUserNamePasswordLogin");
            }
            Subject subject = null;
            try {
                subject = _contextMgr.login(_realm, this._username, this._password);
                subject = this.convertSubject(subject, new SIBPrincipal(this._username, true, true));
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                // empty catch block
            }
            if (_tc2.isEntryEnabled()) {
                String string = SibLoginImpl.getTraceString(subject);
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"doUserNamePasswordLogin", (Object)string);
            }
            return subject;
        }

        public String getUserName() {
            if (_tc2.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_tc2, (String)"getUserName");
            }
            Object object = null;
            object = this._doingSubjectAuthentication ? (this._subject == null ? null : _authUtils.getUserName(this._subject)) : this._username;
            if (object == null) {
                object = "";
            }
            if (_tc2.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc2, (String)"getUserName", (Object)object);
            }
            return object;
        }

        static {
            _subjectCache = new WeakHashMap();
            _tc2 = SibTr.register((Class)(class$com$ibm$ws$sib$security$auth$SibLoginImpl$LoginAction == null ? (class$com$ibm$ws$sib$security$auth$SibLoginImpl$LoginAction = SibLoginImpl.class$("com.ibm.ws.sib.security.auth.SibLoginImpl$LoginAction")) : class$com$ibm$ws$sib$security$auth$SibLoginImpl$LoginAction), (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
            _contextMgr = ContextManagerFactory.getInstance();
            _realm = _contextMgr.getDefaultRealm();
        }
    }
}

