/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.security.auth;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.sibresources.SIBAuthAlias;
import com.ibm.websphere.models.config.sibresources.SIBAuthBrowser;
import com.ibm.websphere.models.config.sibresources.SIBAuthBusConnect;
import com.ibm.websphere.models.config.sibresources.SIBAuthCreator;
import com.ibm.websphere.models.config.sibresources.SIBAuthDefault;
import com.ibm.websphere.models.config.sibresources.SIBAuthForeignBus;
import com.ibm.websphere.models.config.sibresources.SIBAuthForeignDestination;
import com.ibm.websphere.models.config.sibresources.SIBAuthGroup;
import com.ibm.websphere.models.config.sibresources.SIBAuthIdentityAdopter;
import com.ibm.websphere.models.config.sibresources.SIBAuthQueue;
import com.ibm.websphere.models.config.sibresources.SIBAuthReceiver;
import com.ibm.websphere.models.config.sibresources.SIBAuthSender;
import com.ibm.websphere.models.config.sibresources.SIBAuthSpace;
import com.ibm.websphere.models.config.sibresources.SIBAuthTopic;
import com.ibm.websphere.models.config.sibresources.SIBAuthTopicSpace;
import com.ibm.websphere.models.config.sibresources.SIBAuthTopicSpaceBase;
import com.ibm.websphere.models.config.sibresources.SIBAuthTopicSpaceRoot;
import com.ibm.websphere.models.config.sibresources.SIBAuthUser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.dynconfig.DynamicConfigManager;
import com.ibm.ws.sib.security.auth.AuthUtilsImpl;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.security.auth.SIBAccessControlException;
import com.ibm.ws.sib.security.auth.TopicAuthorisations;
import com.ibm.ws.sib.security.impl.TimedMap;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class LocalAccessControl
implements ConfigChangeListener {
    private static long _timeout = -1L;
    private String _localBusName = null;
    private static TraceComponent _tc = SibTr.register((Class)LocalAccessControl.class, (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
    private AuthUtilsImpl _authUtils = new AuthUtilsImpl();
    private SIBAuthSpace _authSpace = null;
    private TopicAuthorisations _topicAuthorisations = null;
    private AuthorizationData _data = new AuthorizationData();
    private static final int USERS = 0;
    private static final int GROUPS = 1;
    private Map _userGroups;
    private static final String SEC_URI1 = "buses/";
    private static final String SEC_URI2 = "/sib-authorisations.xml";
    private Repository _repository;
    static /* synthetic */ Class class$com$ibm$ws$sib$security$auth$LocalAccessControl$AuthorizationData;

    LocalAccessControl(String string) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"LocalAccessControl", (Object)string);
        }
        this._localBusName = string;
        this._repository = (Repository)JsAdminService.getInstance().getService(Repository.class);
        this._userGroups = new TimedMap(this.getLTPATimeout());
        this.initAuthData();
        DynamicConfigManager dynamicConfigManager = DynamicConfigManager.getManager();
        URI uRI = URI.createURI((String)(SEC_URI1 + this._localBusName + SEC_URI2));
        dynamicConfigManager.registerSecurity(uRI, this);
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("Registered security listener for dynamic updates, URI='" + uRI.toString() + "'"));
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"LocalAccessControl", (Object)this);
        }
    }

    public boolean localCheckBusAccess(String string) throws SIBAccessControlException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"localCheckBusAccess", (Object)new Object[]{string});
        }
        boolean bl = false;
        AuthorizationData authorizationData = this._data;
        bl = authorizationData.connectorGroups.contains("everyone");
        if (_tc.isDebugEnabled() && bl) {
            SibTr.debug((TraceComponent)_tc, (String)("Everyone is allowed access to bus " + this._localBusName));
        }
        if (!bl && string != null && string.length() > 0) {
            String string2;
            bl = this.checkUserName(string, authorizationData.connectorUsers);
            if (bl && _tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)("User " + string + " is allowed access to bus " + this._localBusName));
            }
            if (!bl && (string2 = this.checkGroupNames(string, authorizationData.connectorGroups)) != null) {
                bl = true;
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)(string + " is allowed access to bus " + this._localBusName + " via group " + string2));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"localCheckBusAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean localCheckDestinationAccess(String string, String string2, String string3, OperationType operationType) throws SIBAccessControlException {
        Object object;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"localCheckDestinationAccess", (Object)new Object[]{string, string2, string3, operationType});
        }
        if ((string2 == null || string2.length() == 0) && string3 == null) {
            SIBAccessControlException sIBAccessControlException = new SIBAccessControlException("busname and/or destination must be specified");
            if (_tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_tc, (String)"localCheckDestinationAccess", (Object)sIBAccessControlException);
            }
            throw sIBAccessControlException;
        }
        boolean bl = false;
        Set set = null;
        Set set2 = null;
        boolean bl2 = string2 == null || "".equals(string2) || string2.equals(this._localBusName);
        AuthorizationData authorizationData = this._data;
        Map map = bl2 ? authorizationData.localBus : (Map)authorizationData.foreignBuses.get(string2);
        DestinationPermissions destinationPermissions = null;
        if (map != null) {
            if (string3 == null) {
                string3 = "";
            }
            destinationPermissions = (DestinationPermissions)map.get(string3);
        }
        if (destinationPermissions != null) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)("Permissions have been set for destination " + this.displayDestination(string2, string3)));
            }
            object = this.getPermissionsFromDestination(destinationPermissions, operationType);
            set = object[0];
            set2 = object[1];
        }
        if (bl2 && destinationPermissions == null) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)("Default permissions apply to destination " + this.displayDestination(string2, string3)));
            }
            object = this.getPermissionsFromDestination(authorizationData.defaultPermissions, operationType);
            set = object[0];
            set2 = object[1];
        }
        if (set2 != null) {
            bl = set2.contains("everyone");
        }
        if (bl && _tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("Everyone has " + operationType + " access to destination " + this.displayDestination(string2, string3)));
        }
        if (!bl && string != null && string.length() > 0) {
            if (set != null && (bl = this.checkUserName(string, set)) && _tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)(string + " has " + operationType + " access to destination " + this.displayDestination(string2, string3)));
            }
            if (!bl && set2 != null && (object = this.checkGroupNames(string, set2)) != null) {
                bl = true;
                if (_tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)(string + " has " + operationType + " access to destination " + this.displayDestination(string2, string3) + " via group " + (String)object));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"localCheckDestinationAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void localListTopicAuthorisations(TopicAuthorisations topicAuthorisations) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"localListTopicAuthorisations", (Object)new Object[]{topicAuthorisations});
        }
        if (topicAuthorisations == null) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"null parameter pased to localListTopicAuthorisations()");
            }
            if (_tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)_tc, (String)"localListTopicAuthorisations");
            }
            return;
        }
        AuthorizationData authorizationData = this._data;
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"calling authoriseTopic() for the default permissions");
        }
        topicAuthorisations.authoriseTopic(null, "", this.toStringArray(authorizationData.defaultPermissions.receiverUsers), this.toStringArray(authorizationData.defaultPermissions.receiverGroups), false, this.toStringArray(authorizationData.defaultPermissions.senderUsers), this.toStringArray(authorizationData.defaultPermissions.senderGroups), false);
        Iterator iterator = authorizationData.topicSpaces.keySet().iterator();
        while (iterator.hasNext()) {
            TopicPermissions topicPermissions;
            String string = (String)iterator.next();
            Map map = (Map)authorizationData.topicSpaces.get(string);
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)("calling authoriseTopic() for topicspace " + string));
            }
            if ((topicPermissions = (TopicPermissions)map.get("")) != null) {
                topicAuthorisations.authoriseTopic(string, "", this.toStringArray(topicPermissions.receiverUsers), this.toStringArray(topicPermissions.receiverGroups), topicPermissions.inheritDefaults, this.toStringArray(topicPermissions.senderUsers), this.toStringArray(topicPermissions.senderGroups), topicPermissions.inheritDefaults);
            }
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2.length() <= 0) continue;
                TopicPermissions topicPermissions2 = (TopicPermissions)map.get(string2);
                topicAuthorisations.authoriseTopic(string, string2, this.toStringArray(topicPermissions2.receiverUsers), this.toStringArray(topicPermissions2.receiverGroups), topicPermissions2.inheritReceiver, this.toStringArray(topicPermissions2.senderUsers), this.toStringArray(topicPermissions2.senderGroups), topicPermissions2.inheritSender);
            }
        }
        this._topicAuthorisations = topicAuthorisations;
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"localListTopicAuthorisations");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"configChanged", (Object)new Object[]{configRepositoryEvent});
        }
        this.initAuthDataPrivileged();
        SibTr.audit((TraceComponent)_tc, (String)"AUTH_DATA_UPDATED_CWSII0125", (Object)this._localBusName);
        if (this._topicAuthorisations != null) {
            if (_tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)_tc, (String)"calling topicAuthorisations.update()");
            }
            this._topicAuthorisations.update();
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"configChanged");
        }
    }

    private void initAuthData() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"initAuthData");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (_tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)_tc, (String)"run");
                }
                LocalAccessControl.this.initAuthDataPrivileged();
                if (_tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)_tc, (String)"run", null);
                }
                return null;
            }
        });
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"initAuthData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAuthDataPrivileged() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"initAuthDataPrivileged");
        }
        try {
            Class clazz = LocalAccessControl.class;
            synchronized (clazz) {
                ConfigRoot configRoot = this._repository.getConfigRoot();
                Resource resource = configRoot.getResource(0, SEC_URI1 + this._localBusName + SEC_URI2);
                this._authSpace = (SIBAuthSpace)resource.getContents().get(0);
                if (this._authSpace != null) {
                    this.loadAllPermissions();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.security.auth.LocalAccessControl.initAuthDataPrivileged", (String)"699", (Object)this);
            SibTr.error((TraceComponent)_tc, (String)"EXCP_IN_AUTH_DATA_CWSII0115", (Object)new Object[]{this._localBusName, exception});
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"initAuthDataPrivileged");
        }
    }

    private void loadAllPermissions() {
        AuthorizationData authorizationData;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadAllPermissions");
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        DestinationPermissions destinationPermissions = new DestinationPermissions();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.loadBusConnectorPermissions(hashSet, hashSet2);
        this.loadDefaultPermissions(destinationPermissions);
        this.loadQueuePermissions(hashMap, destinationPermissions);
        this.loadTopicSpacePermissions(hashMap, hashMap3, destinationPermissions);
        this.loadAliasesPermissions(hashMap, hashMap2, destinationPermissions);
        this.loadForeignBusPermissions(hashMap2);
        this.loadForeignDestinationPermissions(hashMap2);
        this._data = authorizationData = new AuthorizationData(hashSet, hashSet2, destinationPermissions, hashMap, hashMap2, hashMap3);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadAllPermissions");
        }
    }

    private void loadBusConnectorPermissions(HashSet hashSet, HashSet hashSet2) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadBusConnectorPermissions", (Object)new Object[]{hashSet, hashSet2});
        }
        SIBAuthBusConnect sIBAuthBusConnect = this._authSpace.getBusConnect();
        hashSet.addAll(this.getUserNames((List)sIBAuthBusConnect.getUser()));
        hashSet2.addAll(this.getGroupNames((List)sIBAuthBusConnect.getGroup()));
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadBusConnectorPermissions");
        }
    }

    private void loadDefaultPermissions(DestinationPermissions destinationPermissions) {
        SIBAuthDefault sIBAuthDefault;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadDefaultPermissions", (Object)new Object[]{destinationPermissions});
        }
        if ((sIBAuthDefault = this._authSpace.getDefault()) != null) {
            List list;
            List list2;
            SIBAuthBrowser sIBAuthBrowser = sIBAuthDefault.getBrowser();
            SIBAuthCreator sIBAuthCreator = sIBAuthDefault.getCreator();
            SIBAuthSender sIBAuthSender = sIBAuthDefault.getSender();
            SIBAuthReceiver sIBAuthReceiver = sIBAuthDefault.getReceiver();
            SIBAuthIdentityAdopter sIBAuthIdentityAdopter = sIBAuthDefault.getIdentityAdopter();
            if (sIBAuthBrowser != null) {
                list2 = this.getUserNames((List)sIBAuthBrowser.getUser());
                list = this.getGroupNames((List)sIBAuthBrowser.getGroup());
                destinationPermissions.browserUsers.addAll(list2);
                destinationPermissions.browserGroups.addAll(list);
                destinationPermissions.inquireUsers.addAll(list2);
                destinationPermissions.inquireGroups.addAll(list);
            }
            if (sIBAuthCreator != null) {
                destinationPermissions.creatorUsers.addAll(this.getUserNames((List)sIBAuthCreator.getUser()));
                destinationPermissions.creatorGroups.addAll(this.getGroupNames((List)sIBAuthCreator.getGroup()));
            }
            if (sIBAuthSender != null) {
                list2 = this.getUserNames((List)sIBAuthSender.getUser());
                list = this.getGroupNames((List)sIBAuthSender.getGroup());
                destinationPermissions.senderUsers.addAll(list2);
                destinationPermissions.senderGroups.addAll(list);
                destinationPermissions.inquireUsers.addAll(list2);
                destinationPermissions.inquireGroups.addAll(list);
            }
            if (sIBAuthReceiver != null) {
                list2 = this.getUserNames((List)sIBAuthReceiver.getUser());
                list = this.getGroupNames((List)sIBAuthReceiver.getGroup());
                destinationPermissions.receiverUsers.addAll(list2);
                destinationPermissions.receiverGroups.addAll(list);
                destinationPermissions.inquireUsers.addAll(list2);
                destinationPermissions.inquireGroups.addAll(list);
            }
            if (sIBAuthIdentityAdopter != null) {
                destinationPermissions.identityAdopterUsers.addAll(this.getUserNames((List)sIBAuthIdentityAdopter.getUser()));
                destinationPermissions.identityAdopterGroups.addAll(this.getGroupNames((List)sIBAuthIdentityAdopter.getGroup()));
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadDefaultPermissions");
        }
    }

    private void loadQueuePermissions(Map map, DestinationPermissions destinationPermissions) {
        EList eList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadQueuePermissions", (Object)new Object[]{map, destinationPermissions});
        }
        if ((eList = this._authSpace.getQueue()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SIBAuthQueue sIBAuthQueue = (SIBAuthQueue)iterator.next();
                DestinationPermissions destinationPermissions2 = this.getDestinationPermissions(sIBAuthQueue, destinationPermissions);
                map.put(destinationPermissions2.destinationName, destinationPermissions2);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadQueuePermissions");
        }
    }

    private void loadTopicSpacePermissions(Map map, Map map2, DestinationPermissions destinationPermissions) {
        EList eList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadTopicSpacePermissions", (Object)new Object[]{map, map2, destinationPermissions});
        }
        if ((eList = this._authSpace.getTopicSpace()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SIBAuthTopicSpace sIBAuthTopicSpace = (SIBAuthTopicSpace)iterator.next();
                DestinationPermissions destinationPermissions2 = this.getDestinationPermissions(sIBAuthTopicSpace, destinationPermissions);
                map.put(destinationPermissions2.destinationName, destinationPermissions2);
                this.loadTopicRootPermissions(map2, sIBAuthTopicSpace);
                this.loadAllTopicsPermissions(map2, sIBAuthTopicSpace);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadTopicSpacePermissions");
        }
    }

    private void loadTopicRootPermissions(Map map, SIBAuthTopicSpace sIBAuthTopicSpace) {
        Object object;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadTopicRootPermissions", (Object)new Object[]{map, sIBAuthTopicSpace});
        }
        TopicPermissions topicPermissions = new TopicPermissions();
        topicPermissions.inheritDefaults = sIBAuthTopicSpace.isInheritDefaults();
        SIBAuthTopicSpaceRoot sIBAuthTopicSpaceRoot = sIBAuthTopicSpace.getTopicSpaceRoot();
        if (sIBAuthTopicSpaceRoot != null) {
            object = sIBAuthTopicSpaceRoot.getSender();
            SIBAuthReceiver sIBAuthReceiver = sIBAuthTopicSpaceRoot.getReceiver();
            if (object != null) {
                topicPermissions.senderUsers.addAll(this.getUserNames((List)object.getUser()));
                topicPermissions.senderGroups.addAll(this.getGroupNames((List)object.getGroup()));
            }
            if (sIBAuthReceiver != null) {
                topicPermissions.receiverUsers.addAll(this.getUserNames((List)sIBAuthReceiver.getUser()));
                topicPermissions.receiverGroups.addAll(this.getGroupNames((List)sIBAuthReceiver.getGroup()));
            }
        }
        if ((object = (Map)map.get(sIBAuthTopicSpace.getIdentifier())) == null) {
            object = new HashMap();
            map.put(sIBAuthTopicSpace.getIdentifier(), object);
        }
        object.put("", topicPermissions);
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadTopicRootPermissions");
        }
    }

    private void loadAllTopicsPermissions(Map map, SIBAuthTopicSpace sIBAuthTopicSpace) {
        EList eList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadAllTopicsPermissions", (Object)new Object[]{map, sIBAuthTopicSpace});
        }
        if ((eList = sIBAuthTopicSpace.getTopic()) != null) {
            HashMap<String, TopicPermissions> hashMap = (HashMap<String, TopicPermissions>)map.get(sIBAuthTopicSpace.getIdentifier());
            if (sIBAuthTopicSpace == null) {
                hashMap = new HashMap<String, TopicPermissions>();
                map.put(sIBAuthTopicSpace.getIdentifier(), hashMap);
            }
            Iterator iterator = sIBAuthTopicSpace.getTopic().iterator();
            while (iterator.hasNext()) {
                SIBAuthTopic sIBAuthTopic = (SIBAuthTopic)iterator.next();
                TopicPermissions topicPermissions = this.getTopicPermissions(sIBAuthTopic);
                hashMap.put(topicPermissions.topicName, topicPermissions);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadAllTopicsPermissions");
        }
    }

    private void loadAliasesPermissions(Map map, Map map2, DestinationPermissions destinationPermissions) {
        EList eList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadAliasesPermissions", (Object)new Object[]{map, map2, destinationPermissions});
        }
        if ((eList = this._authSpace.getAlias()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SIBAuthAlias sIBAuthAlias = (SIBAuthAlias)iterator.next();
                DestinationPermissions destinationPermissions2 = this.getDestinationPermissions(sIBAuthAlias, destinationPermissions);
                if (destinationPermissions2.busName == null || destinationPermissions2.busName.length() == 0 || destinationPermissions2.busName.equals(this._localBusName)) {
                    map.put(destinationPermissions2.destinationName, destinationPermissions2);
                    continue;
                }
                HashMap<String, DestinationPermissions> hashMap = (HashMap<String, DestinationPermissions>)map2.get(destinationPermissions2.busName);
                if (hashMap == null) {
                    hashMap = new HashMap<String, DestinationPermissions>();
                    map2.put(destinationPermissions2.busName, hashMap);
                }
                hashMap.put(destinationPermissions2.destinationName, destinationPermissions2);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadAliasesPermissions");
        }
    }

    private void loadForeignBusPermissions(Map map) {
        EList eList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadForeignBusPermissions", (Object)new Object[]{map});
        }
        if ((eList = this._authSpace.getForeignBus()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                HashMap<String, DestinationPermissions> hashMap;
                SIBAuthForeignBus sIBAuthForeignBus = (SIBAuthForeignBus)iterator.next();
                DestinationPermissions destinationPermissions = new DestinationPermissions();
                destinationPermissions.busName = sIBAuthForeignBus.getBusName();
                SIBAuthSender sIBAuthSender = sIBAuthForeignBus.getSender();
                SIBAuthIdentityAdopter sIBAuthIdentityAdopter = sIBAuthForeignBus.getIdentityAdopter();
                if (sIBAuthSender != null) {
                    hashMap = this.getUserNames((List)sIBAuthSender.getUser());
                    List list = this.getGroupNames((List)sIBAuthSender.getGroup());
                    destinationPermissions.senderUsers.addAll(hashMap);
                    destinationPermissions.senderGroups.addAll(list);
                    destinationPermissions.inquireUsers.addAll(hashMap);
                    destinationPermissions.inquireGroups.addAll(list);
                }
                if (sIBAuthIdentityAdopter != null) {
                    destinationPermissions.identityAdopterUsers.addAll(this.getUserNames((List)sIBAuthIdentityAdopter.getUser()));
                    destinationPermissions.identityAdopterGroups.addAll(this.getGroupNames((List)sIBAuthIdentityAdopter.getGroup()));
                }
                if ((hashMap = (Map)map.get(destinationPermissions.busName)) == null) {
                    hashMap = new HashMap<String, DestinationPermissions>();
                    map.put(destinationPermissions.busName, hashMap);
                }
                hashMap.put("", destinationPermissions);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadForeignBusPermissions");
        }
    }

    private void loadForeignDestinationPermissions(Map map) {
        EList eList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"loadForeignDestinationPermissions", (Object)new Object[]{map});
        }
        if ((eList = this._authSpace.getForeignDestination()) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                HashMap<String, DestinationPermissions> hashMap;
                SIBAuthForeignDestination sIBAuthForeignDestination = (SIBAuthForeignDestination)iterator.next();
                DestinationPermissions destinationPermissions = new DestinationPermissions();
                destinationPermissions.destinationName = sIBAuthForeignDestination.getDestinationName();
                destinationPermissions.busName = sIBAuthForeignDestination.getBusName();
                SIBAuthSender sIBAuthSender = sIBAuthForeignDestination.getSender();
                SIBAuthIdentityAdopter sIBAuthIdentityAdopter = sIBAuthForeignDestination.getIdentityAdopter();
                if (sIBAuthSender != null) {
                    hashMap = this.getUserNames((List)sIBAuthSender.getUser());
                    List list = this.getGroupNames((List)sIBAuthSender.getGroup());
                    destinationPermissions.senderUsers.addAll(hashMap);
                    destinationPermissions.senderGroups.addAll(list);
                    destinationPermissions.inquireUsers.addAll(hashMap);
                    destinationPermissions.inquireGroups.addAll(list);
                }
                if (sIBAuthIdentityAdopter != null) {
                    destinationPermissions.identityAdopterUsers.addAll(this.getUserNames((List)sIBAuthIdentityAdopter.getUser()));
                    destinationPermissions.identityAdopterGroups.addAll(this.getGroupNames((List)sIBAuthIdentityAdopter.getGroup()));
                }
                if ((hashMap = (Map)map.get(destinationPermissions.busName)) == null) {
                    hashMap = new HashMap<String, DestinationPermissions>();
                    map.put(destinationPermissions.busName, hashMap);
                }
                hashMap.put(destinationPermissions.destinationName, destinationPermissions);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"loadForeignDestinationPermissions");
        }
    }

    private boolean checkUserName(String string, Set set) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"checkUserName", (Object)new Object[]{string, set});
        }
        boolean bl = false;
        if (set != null && set.size() > 0) {
            String string2 = string.toLowerCase();
            bl = set.contains(string2);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"checkUserName", (Object)new Boolean(bl));
        }
        return bl;
    }

    private String checkGroupNames(String string, Set set) throws SIBAccessControlException {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"checkGroupNames", (Object)new Object[]{string, set});
        }
        String string2 = null;
        if (set.size() > 0) {
            if (set.contains("allauthenticated")) {
                string2 = "allauthenticated";
            }
            if (string2 == null) {
                String[] stringArray = (String[])this._userGroups.get(string.toLowerCase());
                if (stringArray == null) {
                    try {
                        stringArray = this._authUtils.getGroupsForUser(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.security.auth.LocalAccessControl.checkGroupNames", (String)"3");
                        SibTr.error((TraceComponent)_tc, (String)"EXCP_IN_USER_REG_CWSII0120", (Object)exception);
                        SIBAccessControlException sIBAccessControlException = new SIBAccessControlException("Exception thrown trying to access the User Registry", exception);
                        if (_tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"checkGroupNames", (Object)sIBAccessControlException);
                        }
                        throw sIBAccessControlException;
                    }
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    this._userGroups.put(string.toLowerCase(), stringArray);
                }
                if (stringArray.length == 0 && _tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)_tc, (String)(string + " does not belong to any groups"));
                }
                for (int i = 0; i < stringArray.length && string2 == null; ++i) {
                    if (!set.contains(stringArray[i].toLowerCase())) continue;
                    string2 = stringArray[i];
                }
            }
        } else if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)"no groups have been authorised for this operation");
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"checkGroupNames", (Object)string2);
        }
        return string2;
    }

    private Set[] getPermissionsFromDestination(DestinationPermissions destinationPermissions, OperationType operationType) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getPermissionsFromDestination", (Object)new Object[]{destinationPermissions, operationType});
        }
        Set[] setArray = new HashSet[2];
        if (destinationPermissions != null) {
            if (operationType == OperationType.CREATE) {
                setArray[0] = destinationPermissions.creatorUsers;
                setArray[1] = destinationPermissions.creatorGroups;
            } else if (operationType == OperationType.SEND) {
                setArray[0] = destinationPermissions.senderUsers;
                setArray[1] = destinationPermissions.senderGroups;
            } else if (operationType == OperationType.RECEIVE) {
                setArray[0] = destinationPermissions.receiverUsers;
                setArray[1] = destinationPermissions.receiverGroups;
            } else if (operationType == OperationType.BROWSE) {
                setArray[0] = destinationPermissions.browserUsers;
                setArray[1] = destinationPermissions.browserGroups;
            } else if (operationType == OperationType.IDENTITY_ADOPTER) {
                setArray[0] = destinationPermissions.identityAdopterUsers;
                setArray[1] = destinationPermissions.identityAdopterGroups;
            } else if (operationType == OperationType.INQUIRE) {
                setArray[0] = destinationPermissions.inquireUsers;
                setArray[1] = destinationPermissions.inquireGroups;
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getPermissionsFromDestination", (Object)setArray);
        }
        return setArray;
    }

    private DestinationPermissions getDestinationPermissions(SIBAuthQueue sIBAuthQueue, DestinationPermissions destinationPermissions) {
        List list;
        List list2;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationPermissions", (Object)new Object[]{sIBAuthQueue, destinationPermissions});
        }
        DestinationPermissions destinationPermissions2 = new DestinationPermissions();
        boolean bl = sIBAuthQueue.isInheritDefaults();
        destinationPermissions2.destinationName = sIBAuthQueue.getIdentifier();
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("inheritDefaults for '" + destinationPermissions2.destinationName + "' is " + bl));
        }
        SIBAuthBrowser sIBAuthBrowser = sIBAuthQueue.getBrowser();
        SIBAuthCreator sIBAuthCreator = sIBAuthQueue.getCreator();
        SIBAuthSender sIBAuthSender = sIBAuthQueue.getSender();
        SIBAuthReceiver sIBAuthReceiver = sIBAuthQueue.getReceiver();
        SIBAuthIdentityAdopter sIBAuthIdentityAdopter = sIBAuthQueue.getIdentityAdopter();
        if (bl) {
            destinationPermissions2.browserUsers.addAll(destinationPermissions.browserUsers);
            destinationPermissions2.browserGroups.addAll(destinationPermissions.browserGroups);
            destinationPermissions2.senderUsers.addAll(destinationPermissions.senderUsers);
            destinationPermissions2.senderGroups.addAll(destinationPermissions.senderGroups);
            destinationPermissions2.receiverUsers.addAll(destinationPermissions.receiverUsers);
            destinationPermissions2.receiverGroups.addAll(destinationPermissions.receiverGroups);
            destinationPermissions2.identityAdopterUsers.addAll(destinationPermissions.identityAdopterUsers);
            destinationPermissions2.identityAdopterGroups.addAll(destinationPermissions.identityAdopterGroups);
            destinationPermissions2.inquireUsers.addAll(destinationPermissions.inquireUsers);
            destinationPermissions2.inquireGroups.addAll(destinationPermissions.inquireGroups);
            destinationPermissions2.creatorUsers.addAll(destinationPermissions.creatorUsers);
            destinationPermissions2.creatorGroups.addAll(destinationPermissions.creatorGroups);
        }
        if (sIBAuthBrowser != null) {
            list2 = this.getUserNames((List)sIBAuthBrowser.getUser());
            list = this.getGroupNames((List)sIBAuthBrowser.getGroup());
            destinationPermissions2.browserUsers.addAll(list2);
            destinationPermissions2.browserGroups.addAll(list);
            destinationPermissions2.inquireUsers.addAll(list2);
            destinationPermissions2.inquireGroups.addAll(list);
        }
        if (sIBAuthCreator != null) {
            list2 = this.getUserNames((List)sIBAuthCreator.getUser());
            list = this.getGroupNames((List)sIBAuthCreator.getGroup());
            destinationPermissions2.creatorUsers.addAll(list2);
            destinationPermissions2.creatorGroups.addAll(list);
        }
        if (sIBAuthSender != null) {
            list2 = this.getUserNames((List)sIBAuthSender.getUser());
            list = this.getGroupNames((List)sIBAuthSender.getGroup());
            destinationPermissions2.senderUsers.addAll(list2);
            destinationPermissions2.senderGroups.addAll(list);
            destinationPermissions2.inquireUsers.addAll(list2);
            destinationPermissions2.inquireGroups.addAll(list);
        }
        if (sIBAuthReceiver != null) {
            list2 = this.getUserNames((List)sIBAuthReceiver.getUser());
            list = this.getGroupNames((List)sIBAuthReceiver.getGroup());
            destinationPermissions2.receiverUsers.addAll(list2);
            destinationPermissions2.receiverGroups.addAll(list);
            destinationPermissions2.inquireUsers.addAll(list2);
            destinationPermissions2.inquireGroups.addAll(list);
        }
        if (sIBAuthIdentityAdopter != null) {
            list2 = this.getUserNames((List)sIBAuthIdentityAdopter.getUser());
            list = this.getGroupNames((List)sIBAuthIdentityAdopter.getGroup());
            destinationPermissions2.identityAdopterUsers.addAll(list2);
            destinationPermissions2.identityAdopterGroups.addAll(list);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationPermissions", (Object)destinationPermissions2);
        }
        return destinationPermissions2;
    }

    private DestinationPermissions getDestinationPermissions(SIBAuthTopicSpace sIBAuthTopicSpace, DestinationPermissions destinationPermissions) {
        SIBAuthTopicSpaceBase sIBAuthTopicSpaceBase;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationPermissions", (Object)new Object[]{sIBAuthTopicSpace, destinationPermissions});
        }
        DestinationPermissions destinationPermissions2 = new DestinationPermissions();
        boolean bl = sIBAuthTopicSpace.isInheritDefaults();
        destinationPermissions2.destinationName = sIBAuthTopicSpace.getIdentifier();
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("inheritDefaults for '" + destinationPermissions2.destinationName + "' is " + bl));
        }
        if (bl) {
            destinationPermissions2.senderUsers.addAll(destinationPermissions.senderUsers);
            destinationPermissions2.senderGroups.addAll(destinationPermissions.senderGroups);
            destinationPermissions2.receiverUsers.addAll(destinationPermissions.receiverUsers);
            destinationPermissions2.receiverGroups.addAll(destinationPermissions.receiverGroups);
            destinationPermissions2.identityAdopterUsers.addAll(destinationPermissions.identityAdopterUsers);
            destinationPermissions2.identityAdopterGroups.addAll(destinationPermissions.identityAdopterGroups);
            destinationPermissions2.inquireUsers.addAll(destinationPermissions.inquireUsers);
            destinationPermissions2.inquireGroups.addAll(destinationPermissions.inquireGroups);
            destinationPermissions2.inquireUsers.removeAll(destinationPermissions.browserUsers);
            destinationPermissions2.inquireGroups.removeAll(destinationPermissions.browserGroups);
        }
        if ((sIBAuthTopicSpaceBase = sIBAuthTopicSpace.getTopicSpaceBase()) != null) {
            List list;
            List list2;
            SIBAuthSender sIBAuthSender = sIBAuthTopicSpaceBase.getSender();
            SIBAuthReceiver sIBAuthReceiver = sIBAuthTopicSpaceBase.getReceiver();
            SIBAuthIdentityAdopter sIBAuthIdentityAdopter = sIBAuthTopicSpaceBase.getIdentityAdopter();
            if (sIBAuthSender != null) {
                list2 = this.getUserNames((List)sIBAuthSender.getUser());
                list = this.getGroupNames((List)sIBAuthSender.getGroup());
                destinationPermissions2.senderUsers.addAll(list2);
                destinationPermissions2.senderGroups.addAll(list);
                destinationPermissions2.inquireUsers.addAll(list2);
                destinationPermissions2.inquireGroups.addAll(list);
            }
            if (sIBAuthReceiver != null) {
                list2 = this.getUserNames((List)sIBAuthReceiver.getUser());
                list = this.getGroupNames((List)sIBAuthReceiver.getGroup());
                destinationPermissions2.receiverUsers.addAll(list2);
                destinationPermissions2.receiverGroups.addAll(list);
                destinationPermissions2.inquireUsers.addAll(list2);
                destinationPermissions2.inquireGroups.addAll(list);
            }
            if (sIBAuthIdentityAdopter != null) {
                list2 = this.getUserNames((List)sIBAuthIdentityAdopter.getUser());
                list = this.getGroupNames((List)sIBAuthIdentityAdopter.getGroup());
                destinationPermissions2.identityAdopterUsers.addAll(list2);
                destinationPermissions2.identityAdopterGroups.addAll(list);
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationPermissions", (Object)destinationPermissions2);
        }
        return destinationPermissions2;
    }

    private TopicPermissions getTopicPermissions(SIBAuthTopic sIBAuthTopic) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getTopicPermissions", (Object)new Object[]{sIBAuthTopic});
        }
        TopicPermissions topicPermissions = new TopicPermissions();
        topicPermissions.topicName = sIBAuthTopic.getIdentifier();
        topicPermissions.inheritSender = sIBAuthTopic.isInheritSender();
        topicPermissions.inheritReceiver = sIBAuthTopic.isInheritReceiver();
        SIBAuthSender sIBAuthSender = sIBAuthTopic.getSender();
        SIBAuthReceiver sIBAuthReceiver = sIBAuthTopic.getReceiver();
        if (sIBAuthSender != null) {
            topicPermissions.senderUsers.addAll(this.getUserNames((List)sIBAuthSender.getUser()));
            topicPermissions.senderGroups.addAll(this.getGroupNames((List)sIBAuthSender.getGroup()));
        }
        if (sIBAuthReceiver != null) {
            topicPermissions.receiverUsers.addAll(this.getUserNames((List)sIBAuthReceiver.getUser()));
            topicPermissions.receiverGroups.addAll(this.getGroupNames((List)sIBAuthReceiver.getGroup()));
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getTopicPermissions", (Object)topicPermissions);
        }
        return topicPermissions;
    }

    private DestinationPermissions getDestinationPermissions(SIBAuthAlias sIBAuthAlias, DestinationPermissions destinationPermissions) {
        List list;
        List list2;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getDestinationPermissions", (Object)new Object[]{sIBAuthAlias, destinationPermissions});
        }
        DestinationPermissions destinationPermissions2 = new DestinationPermissions();
        destinationPermissions2.destinationName = sIBAuthAlias.getIdentifier();
        destinationPermissions2.busName = sIBAuthAlias.getBusName();
        boolean bl = false;
        boolean bl2 = false;
        if (destinationPermissions2.busName == null || destinationPermissions2.busName.length() == 0 || destinationPermissions2.busName.equals(this._localBusName)) {
            bl = sIBAuthAlias.isInheritDefaults();
            bl2 = true;
        }
        if (_tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)_tc, (String)("inheritDefaults for '" + destinationPermissions2.destinationName + "' is " + bl));
        }
        SIBAuthSender sIBAuthSender = sIBAuthAlias.getSender();
        SIBAuthIdentityAdopter sIBAuthIdentityAdopter = sIBAuthAlias.getIdentityAdopter();
        SIBAuthBrowser sIBAuthBrowser = null;
        SIBAuthReceiver sIBAuthReceiver = null;
        if (bl) {
            destinationPermissions2.browserUsers.addAll(destinationPermissions.browserUsers);
            destinationPermissions2.browserGroups.addAll(destinationPermissions.browserGroups);
            destinationPermissions2.senderUsers.addAll(destinationPermissions.senderUsers);
            destinationPermissions2.senderGroups.addAll(destinationPermissions.senderGroups);
            destinationPermissions2.receiverUsers.addAll(destinationPermissions.receiverUsers);
            destinationPermissions2.receiverGroups.addAll(destinationPermissions.receiverGroups);
            destinationPermissions2.identityAdopterUsers.addAll(destinationPermissions.identityAdopterUsers);
            destinationPermissions2.identityAdopterGroups.addAll(destinationPermissions.identityAdopterGroups);
            destinationPermissions2.inquireUsers.addAll(destinationPermissions.inquireUsers);
            destinationPermissions2.inquireGroups.addAll(destinationPermissions.inquireGroups);
            destinationPermissions2.creatorUsers.addAll(destinationPermissions.creatorUsers);
            destinationPermissions2.creatorGroups.addAll(destinationPermissions.creatorGroups);
        }
        if (bl2) {
            sIBAuthBrowser = sIBAuthAlias.getBrowser();
            sIBAuthReceiver = sIBAuthAlias.getReceiver();
        }
        if (sIBAuthBrowser != null) {
            list2 = this.getUserNames((List)sIBAuthBrowser.getUser());
            list = this.getGroupNames((List)sIBAuthBrowser.getGroup());
            destinationPermissions2.browserUsers.addAll(list2);
            destinationPermissions2.browserGroups.addAll(list);
            destinationPermissions2.inquireUsers.addAll(list2);
            destinationPermissions2.inquireGroups.addAll(list);
        }
        if (sIBAuthSender != null) {
            list2 = this.getUserNames((List)sIBAuthSender.getUser());
            list = this.getGroupNames((List)sIBAuthSender.getGroup());
            destinationPermissions2.senderUsers.addAll(list2);
            destinationPermissions2.senderGroups.addAll(list);
            destinationPermissions2.inquireUsers.addAll(list2);
            destinationPermissions2.inquireGroups.addAll(list);
        }
        if (sIBAuthReceiver != null) {
            list2 = this.getUserNames((List)sIBAuthReceiver.getUser());
            list = this.getGroupNames((List)sIBAuthReceiver.getGroup());
            destinationPermissions2.receiverUsers.addAll(list2);
            destinationPermissions2.receiverGroups.addAll(list);
            destinationPermissions2.inquireUsers.addAll(list2);
            destinationPermissions2.inquireGroups.addAll(list);
        }
        if (sIBAuthIdentityAdopter != null) {
            list2 = this.getUserNames((List)sIBAuthIdentityAdopter.getUser());
            list = this.getGroupNames((List)sIBAuthIdentityAdopter.getGroup());
            destinationPermissions2.identityAdopterUsers.addAll(list2);
            destinationPermissions2.identityAdopterGroups.addAll(list);
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getDestinationPermissions", (Object)destinationPermissions2);
        }
        return destinationPermissions2;
    }

    private String[] toStringArray(Set set) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"toStringArray", (Object)new Object[]{set});
        }
        int n = set == null ? 0 : set.size();
        String[] stringArray = new String[n];
        if (set != null) {
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                stringArray[n2++] = (String)iterator.next();
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"toStringArray", (Object)stringArray);
        }
        return stringArray;
    }

    private String displayDestination(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"displayDestination", (Object)new Object[]{string, string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (string == null || string.length() == 0) {
            stringBuffer.append('\"');
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append(", ");
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append('\"');
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append('}');
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"displayDestination", (Object)stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private List getUserNames(List list) {
        ArrayList<String> arrayList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getUserNames", (Object)new Object[]{list});
        }
        if (list == null) {
            arrayList = new ArrayList<String>(0);
        } else {
            arrayList = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SIBAuthUser sIBAuthUser = (SIBAuthUser)iterator.next();
                arrayList.add(sIBAuthUser.getIdentifier().toLowerCase());
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getUserNames", arrayList);
        }
        return arrayList;
    }

    private List getGroupNames(List list) {
        ArrayList<String> arrayList;
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getGroupNames", (Object)new Object[]{list});
        }
        if (list == null) {
            arrayList = new ArrayList<String>(0);
        } else {
            arrayList = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SIBAuthGroup sIBAuthGroup = (SIBAuthGroup)iterator.next();
                arrayList.add(sIBAuthGroup.getIdentifier().toLowerCase());
            }
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getGroupNames", arrayList);
        }
        return arrayList;
    }

    private long getLTPATimeout() {
        if (_tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)_tc, (String)"getLTPATimeout");
        }
        if (_timeout == -1L) {
            ConfigRoot configRoot = this._repository.getConfigRoot();
            long l = 120L;
            try {
                Resource resource = configRoot.getResource(0, "security.xml");
                Security security = (Security)resource.getContents().get(0);
                Iterator iterator = security.getAuthMechanisms().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof LTPA)) continue;
                    LTPA lTPA = (LTPA)e;
                    l = lTPA.getTimeout();
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.security.auth.LocalAccessControl.getLTPATimeout", (String)"261", (Object)this);
            }
            _timeout = l * 60L * 1000L;
        }
        if (_tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)_tc, (String)"getLTPATimeout", (Object)new Long(_timeout));
        }
        return _timeout;
    }

    private static final class AuthorizationData {
        private static final TraceComponent _authDataTc = SibTr.register((Class)(class$com$ibm$ws$sib$security$auth$LocalAccessControl$AuthorizationData == null ? (class$com$ibm$ws$sib$security$auth$LocalAccessControl$AuthorizationData = LocalAccessControl.class$("com.ibm.ws.sib.security.auth.LocalAccessControl$AuthorizationData")) : class$com$ibm$ws$sib$security$auth$LocalAccessControl$AuthorizationData), (String)"SIBSecurity", (String)"com.ibm.ws.sib.security.CWSIIMessages");
        public final Set connectorUsers;
        public final Set connectorGroups;
        public final DestinationPermissions defaultPermissions;
        public final Map localBus;
        public final Map foreignBuses;
        public final Map topicSpaces;

        public AuthorizationData() {
            if (_authDataTc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_authDataTc, (String)"AuthorizationData");
            }
            this.connectorUsers = new HashSet();
            this.connectorGroups = new HashSet();
            this.defaultPermissions = new DestinationPermissions();
            this.localBus = new HashMap();
            this.foreignBuses = new HashMap();
            this.topicSpaces = new HashMap();
            if (_authDataTc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_authDataTc, (String)"AuthorizationData", (Object)this);
            }
        }

        public AuthorizationData(Set set, Set set2, DestinationPermissions destinationPermissions, Map map, Map map2, Map map3) {
            if (_authDataTc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)_authDataTc, (String)"AuthorizationData", (Object)new Object[]{set, set2, destinationPermissions, map, map2, map3});
            }
            this.connectorUsers = set;
            this.connectorGroups = set2;
            this.defaultPermissions = destinationPermissions;
            this.localBus = map;
            this.foreignBuses = map2;
            this.topicSpaces = map3;
            if (_authDataTc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)_authDataTc, (String)"AuthorizationData", (Object)this);
            }
        }
    }

    private static final class TopicPermissions {
        String topicName = null;
        boolean inheritDefaults = true;
        boolean inheritSender = true;
        boolean inheritReceiver = true;
        Set senderUsers = new HashSet();
        Set senderGroups = new HashSet();
        Set receiverUsers = new HashSet();
        Set receiverGroups = new HashSet();

        private TopicPermissions() {
        }
    }

    private static final class DestinationPermissions {
        String busName = null;
        String destinationName = null;
        Set creatorUsers = new HashSet();
        Set creatorGroups = new HashSet();
        Set senderUsers = new HashSet();
        Set senderGroups = new HashSet();
        Set receiverUsers = new HashSet();
        Set receiverGroups = new HashSet();
        Set browserUsers = new HashSet();
        Set browserGroups = new HashSet();
        Set identityAdopterUsers = new HashSet();
        Set identityAdopterGroups = new HashSet();
        Set inquireUsers = new HashSet();
        Set inquireGroups = new HashSet();

        private DestinationPermissions() {
        }
    }
}

