/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.recovery.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.sib.ra.recovery.impl.SibRaRecoveryXaResource;
import com.ibm.ws.sib.ra.recovery.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.selector.FactoryType;
import com.ibm.wsspi.sib.core.selector.SICoreConnectionFactorySelector;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAResource;

final class SibRaXaResourceInfo
implements XAResourceInfo {
    private static final long serialVersionUID = 5953223105754363388L;
    private final String _busName;
    private final String _meName;
    private final String _meUuid;
    private final String _xaRecoveryAlias;
    private final String _userName;
    private final String _encodedPassword;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaXaResourceInfo.class);

    SibRaXaResourceInfo(String string, String string2, String string3, String string4) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResourceInfo", (Object)new Object[]{string, string2, string3, string4});
        }
        this._busName = string;
        this._meName = string2;
        this._meUuid = string3;
        this._xaRecoveryAlias = string4;
        this._userName = null;
        this._encodedPassword = null;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResourceInfo");
        }
    }

    SibRaXaResourceInfo(String string, String string2, String string3, String string4, String string5) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResourceInfo", (Object)new Object[]{string, string2, string3, string4, string5 == null ? null : "*****"});
        }
        this._busName = string;
        this._meName = string2;
        this._meUuid = string3;
        this._xaRecoveryAlias = null;
        this._userName = string4;
        this._encodedPassword = PasswordUtil.passwordEncode((String)string5);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResourceInfo");
        }
    }

    XAResource createXaResource() throws SIException, LoginException, SecurityException, CredentialDestroyedException, CredentialExpiredException, SIErrorException {
        String string;
        String string2;
        Object object;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createXaResource");
        }
        if (this._xaRecoveryAlias != null) {
            object = WSDefaultPrincipalMapping.getAuthData((String)this._xaRecoveryAlias);
            if (object != null && 0 == object.getStatus()) {
                string2 = object.getUserName();
                string = object.getPassword();
            } else {
                SibTr.warning((TraceComponent)TRACE, (String)"RECOVERY_ALIAS_NOT_RESOLVED_CWSIV0001", (Object)new Object[]{this._xaRecoveryAlias});
                string2 = null;
                string = null;
            }
        } else {
            string2 = this._userName;
            string = PasswordUtil.passwordDecode((String)this._encodedPassword);
        }
        object = new HashMap();
        object.put("busName", this._busName);
        object.put("targetType", "MEUuid");
        object.put("targetGroup", this._meUuid);
        object.put("targetSignificance", "Required");
        object.put("connectionMode", "Recovery");
        SICoreConnectionFactory sICoreConnectionFactory = SICoreConnectionFactorySelector.getSICoreConnectionFactory((FactoryType)FactoryType.TRM_CONNECTION);
        SICoreConnection sICoreConnection = sICoreConnectionFactory.createConnection(string2, string, (Map)object);
        SibRaRecoveryXaResource sibRaRecoveryXaResource = new SibRaRecoveryXaResource(sICoreConnection);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createXaResource", (Object)sibRaRecoveryXaResource);
        }
        return sibRaRecoveryXaResource;
    }

    public String getRMName() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getRMName");
        }
        StringBuffer stringBuffer = new StringBuffer("SIBus:");
        stringBuffer.append(this._busName);
        stringBuffer.append(':');
        stringBuffer.append(this._meName);
        String string = stringBuffer.toString();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getRMName", (Object)string);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SibRaXaResourceInfo) {
            SibRaXaResourceInfo sibRaXaResourceInfo = (SibRaXaResourceInfo)object;
            if (SibRaUtils.objectsNotEqual(this._busName, sibRaXaResourceInfo._busName)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._meName, sibRaXaResourceInfo._meName)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._meUuid, sibRaXaResourceInfo._meUuid)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._xaRecoveryAlias, sibRaXaResourceInfo._xaRecoveryAlias)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._userName, sibRaXaResourceInfo._userName)) {
                return false;
            }
            return !SibRaUtils.objectsNotEqual(this._encodedPassword, sibRaXaResourceInfo._encodedPassword);
        }
        return false;
    }

    public int hashCode() {
        int n = SibRaUtils.objectHashCode(this._busName);
        n = SibRaUtils.addObjectToHashCode(n, this._meUuid);
        n = SibRaUtils.addObjectToHashCode(n, this._xaRecoveryAlias);
        n = SibRaUtils.addObjectToHashCode(n, this._userName);
        n = SibRaUtils.addObjectToHashCode(n, this._encodedPassword);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "busName", this._busName);
        SibRaUtils.addFieldToString(stringBuffer, "meName", this._meName);
        SibRaUtils.addFieldToString(stringBuffer, "meUuid", this._meUuid);
        if (this._xaRecoveryAlias == null) {
            SibRaUtils.addFieldToString(stringBuffer, "userName", this._userName);
            SibRaUtils.addPasswordFieldToString(stringBuffer, "password", this._encodedPassword);
        } else {
            SibRaUtils.addFieldToString(stringBuffer, "xaRecoveryAlias", this._xaRecoveryAlias);
        }
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/recovery/impl/SibRaXaResourceInfo.java, SIB.ra, WAS602.SIB, o0610.11 1.17");
        }
    }
}

