/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.recovery.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.ra.recovery.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

final class SibRaRecoveryXaResource
implements XAResource {
    private XAResource _delegateXaResource;
    private SICoreConnection _connection;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaRecoveryXaResource.class);

    SibRaRecoveryXaResource(SICoreConnection sICoreConnection) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"SibRaRecoveryXaResource", (Object)sICoreConnection);
        }
        this._connection = sICoreConnection;
        this._delegateXaResource = this._connection.getSIXAResource();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"SibRaRecoveryXaResource");
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this._delegateXaResource.commit(xid, bl);
    }

    public void end(Xid xid, int n) throws XAException {
        this._delegateXaResource.end(xid, n);
    }

    public void forget(Xid xid) throws XAException {
        this._delegateXaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this._delegateXaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = xAResource instanceof SibRaRecoveryXaResource ? this._delegateXaResource.isSameRM(((SibRaRecoveryXaResource)xAResource)._delegateXaResource) : this._delegateXaResource.isSameRM(xAResource);
        return bl;
    }

    public int prepare(Xid xid) throws XAException {
        return this._delegateXaResource.prepare(xid);
    }

    public Xid[] recover(int n) throws XAException {
        return this._delegateXaResource.recover(n);
    }

    public void rollback(Xid xid) throws XAException {
        this._delegateXaResource.rollback(xid);
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return this._delegateXaResource.setTransactionTimeout(n);
    }

    public void start(Xid xid, int n) throws XAException {
        this._delegateXaResource.start(xid, n);
    }

    void destroy() throws SIException, SIErrorException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"destroy");
        }
        this._connection.close();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((TraceComponent)TRACE, (String)"destroy");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "connection", this._connection);
        SibRaUtils.addFieldToString(stringBuffer, "delegateXaResource", this._delegateXaResource);
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/recovery/impl/SibRaRecoveryXaResource.java, SIB.ra, WAS602.SIB, o0610.11 1.8");
        }
    }
}

