/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaRecoverableSiXaResource;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.ra.inbound.impl.SibRaXaResource;
import com.ibm.ws.sib.ra.recovery.SibRaRecoveryManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

class SibRaTransactionalDispatcher
extends SibRaDispatcher {
    private SIXAResource _xaResource;
    private SibRaXaResource _sibXaResource;
    private final String _busName;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaTransactionalDispatcher.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaTransactionalDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";

    protected SibRaTransactionalDispatcher(SICoreConnection sICoreConnection, AbstractConsumerSession abstractConsumerSession, SibRaEndpointActivation sibRaEndpointActivation, String string) throws ResourceException {
        super(sICoreConnection, abstractConsumerSession, sibRaEndpointActivation);
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaTransactionalDispatcher", (Object)new Object[]{sICoreConnection, abstractConsumerSession, sibRaEndpointActivation, string});
        }
        this._busName = string;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaTransactionalDispatcher");
        }
    }

    protected SITransaction getTransaction() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransaction");
        }
        SIXAResource sIXAResource = this.getXaResource();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransaction", (Object)sIXAResource);
        }
        return sIXAResource;
    }

    private SIXAResource getXaResource() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXaResource");
        }
        if (this._xaResource == null) {
            try {
                this._xaResource = this._connection.getSIXAResource();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)(CLASS_NAME + "." + "getXaResource"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_EXCEPTION_CWSIV0650", new Object[]{sIException, this._connection}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)(CLASS_NAME + "." + "getXaResource"), (String)FFDC_PROBE_3, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_EXCEPTION_CWSIV0650", new Object[]{sIErrorException, this._connection}, null), (Throwable)sIErrorException);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getXaResource", (Object)this._xaResource);
        }
        return this._xaResource;
    }

    protected MessageEndpoint createEndpoint() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createEndpoint");
        }
        this._sibXaResource = SibRaRecoveryManager.isAvailable() ? new SibRaRecoverableSiXaResource(this.getXaResource(), this._busName, this._connection.getMeName(), this._connection.getMeUuid(), this._endpointConfiguration.getXaRecoveryAlias(), this._endpointConfiguration.getUserName(), this._endpointConfiguration.getPassword()) : new SibRaXaResource(this.getXaResource());
        MessageEndpoint messageEndpoint = this._endpointFactory.createEndpoint((XAResource)((Object)this._sibXaResource));
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createEndpoint", (Object)messageEndpoint);
        }
        return messageEndpoint;
    }

    protected void beforeDelivery(SIBusMessage sIBusMessage, MessageEndpoint messageEndpoint) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)sIBusMessage);
        }
        try {
            messageEndpoint.beforeDelivery(this._invoker.getEndpointMethod());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)noSuchMethodException);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("BEFORE_DELIVERY_CWSIV0651", new Object[]{noSuchMethodException, messageEndpoint}, null), (Throwable)noSuchMethodException);
        }
        try {
            if (this._xaResource != null && this._xaResource.isEnlisted()) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Deleting the message under the xa transaction (Message=" + sIBusMessage + ") (xaResource=" + this._xaResource));
                }
                this.deleteMessage(sIBusMessage, (SITransaction)this._xaResource);
            } else {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("xaResource is either null or is not enlisted so deleting the message non transactional (auto commit) (Message=" + sIBusMessage + ")"));
                }
                this.deleteMessage(sIBusMessage, null);
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_4, (Object)this);
            messageEndpoint.afterDelivery();
            throw resourceException;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    protected void afterDelivery(SIBusMessage sIBusMessage, MessageEndpoint messageEndpoint, boolean bl) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{sIBusMessage, bl});
        }
        messageEndpoint.afterDelivery();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    protected void cleanup() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator sibRaStringGenerator = super.getStringGenerator();
        sibRaStringGenerator.addField("sibXaResource", this._sibXaResource);
        sibRaStringGenerator.addField("xaResource", this._xaResource);
        return sibRaStringGenerator;
    }

    protected boolean isTransactionRolledBack() {
        return this._sibXaResource.isTransactionRolledBack();
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/inbound/impl/SibRaTransactionalDispatcher.java, SIB.ra, WAS602.SIB, o0610.11 1.21");
        }
    }
}

